/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.destroystokyo.paper.event.entity.PlayerNaturallySpawnCreaturesEvent;
import com.destroystokyo.paper.util.maplist.ReferenceList;
import com.destroystokyo.paper.util.misc.PlayerAreaMap;
import com.destroystokyo.paper.util.misc.PooledLinkedHashSets;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Queues;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.papermc.paper.chunk.SingleThreadChunkRegionManager;
import io.papermc.paper.chunk.system.ChunkSystem;
import io.papermc.paper.chunk.system.io.RegionFileIOThread;
import io.papermc.paper.chunk.system.scheduling.NewChunkHolder;
import io.papermc.paper.configuration.WorldConfiguration;
import io.papermc.paper.event.player.PlayerTrackEntityEvent;
import io.papermc.paper.util.MCUtil;
import io.papermc.paper.util.player.NearbyPlayers;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.Util;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtException;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundChunksBiomesPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.ChunkResult;
import net.minecraft.server.level.ChunkTrackingView;
import net.minecraft.server.level.DistanceManager;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.PlayerMap;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.ThreadedLevelLightEngine;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.entity.npc.Npc;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LightChunkGetter;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.UpgradeData;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.status.ChunkType;
import net.minecraft.world.level.chunk.status.WorldGenContext;
import net.minecraft.world.level.chunk.storage.ChunkSerializer;
import net.minecraft.world.level.chunk.storage.ChunkStorage;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.entity.ChunkStatusUpdateListener;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraft.world.level.storage.LevelStorageSource;
import org.bukkit.craftbukkit.generator.CustomChunkGenerator;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.leavesmc.leaves.LeavesConfig;
import org.leavesmc.leaves.bot.ServerBot;
import org.leavesmc.leaves.region.AbstractRegionFile;
import org.slf4j.Logger;
import org.spigotmc.AsyncCatcher;
import org.spigotmc.SpigotWorldConfig;
import org.spigotmc.TrackingRange;

public class ChunkMap
extends ChunkStorage
implements ChunkHolder.PlayerProvider {
    private static final byte CHUNK_TYPE_REPLACEABLE = -1;
    private static final byte CHUNK_TYPE_UNKNOWN = 0;
    private static final byte CHUNK_TYPE_FULL = 1;
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int CHUNK_SAVED_PER_TICK = 200;
    private static final int CHUNK_SAVED_EAGERLY_PER_TICK = 20;
    private static final int EAGER_CHUNK_SAVE_COOLDOWN_IN_MILLIS = 10000;
    public static final int MIN_VIEW_DISTANCE = 2;
    public static final int MAX_VIEW_DISTANCE = 32;
    public static final int FORCED_TICKET_LEVEL = ChunkLevel.byStatus(FullChunkStatus.ENTITY_TICKING);
    public final ServerLevel level;
    private final ThreadedLevelLightEngine lightEngine;
    public final BlockableEventLoop<Runnable> mainThreadExecutor;
    public ChunkGenerator generator;
    private final RandomState randomState;
    private final ChunkGeneratorStructureState chunkGeneratorState;
    public final Supplier<DimensionDataStorage> overworldDataStorage;
    private final PoiManager poiManager;
    private boolean modified;
    public final ChunkProgressListener progressListener;
    private final ChunkStatusUpdateListener chunkStatusListener;
    public final ChunkDistanceManager distanceManager;
    public final AtomicInteger tickingGenerated;
    private final String storageName;
    private final PlayerMap playerMap;
    public final Int2ObjectMap<TrackedEntity> entityMap;
    private final Long2ByteMap chunkTypeCache;
    private final Long2LongMap chunkSaveCooldowns;
    private final Queue<Runnable> unloadQueue;
    public int serverViewDistance;
    private WorldGenContext worldGenContext;
    private final PooledLinkedHashSets<ServerPlayer> pooledLinkedPlayerHashSets = new PooledLinkedHashSets();
    static final TrackingRange.TrackingRangeType[] TRACKING_RANGE_TYPES = TrackingRange.TrackingRangeType.values();
    public final PlayerAreaMap[] playerEntityTrackerTrackMaps;
    final int[] entityTrackerTrackRanges;
    public final List<SingleThreadChunkRegionManager> regionManagers = new ArrayList<SingleThreadChunkRegionManager>();
    public final SingleThreadChunkRegionManager dataRegionManager;
    public final NearbyPlayers nearbyPlayers;
    public final ReferenceOpenHashSet<ChunkHolder> needsChangeBroadcasting = new ReferenceOpenHashSet();
    public final PlayerAreaMap playerMobSpawnMap = new PlayerAreaMap(this.pooledLinkedPlayerHashSets);

    public final WorldGenContext getWorldGenContext() {
        return this.worldGenContext;
    }

    public static boolean isLegacyTrackingEntity(net.minecraft.world.entity.Entity entity) {
        return entity.isLegacyTrackingEntity;
    }

    public final int getEntityTrackerRange(int ordinal) {
        return this.entityTrackerTrackRanges[ordinal];
    }

    private int convertSpigotRangeToVanilla(int vanilla) {
        return MinecraftServer.getServer().getScaledTrackingDistance(vanilla);
    }

    public void addPlayerToDistanceMaps(ServerPlayer player) {
        int chunkX = MCUtil.getChunkCoordinate(player.getX());
        int chunkZ = MCUtil.getChunkCoordinate(player.getZ());
        this.nearbyPlayers.addPlayer(player);
        this.level.playerChunkLoader.addPlayer(player);
        int len = TRACKING_RANGE_TYPES.length;
        for (int i = 0; i < len; ++i) {
            PlayerAreaMap trackMap = this.playerEntityTrackerTrackMaps[i];
            int trackRange = this.entityTrackerTrackRanges[i];
            trackMap.add(player, chunkX, chunkZ, Math.min(trackRange, ChunkSystem.getSendViewDistance(player)));
        }
    }

    public void removePlayerFromDistanceMaps(ServerPlayer player) {
        int chunkX = MCUtil.getChunkCoordinate(player.getX());
        int chunkZ = MCUtil.getChunkCoordinate(player.getZ());
        this.nearbyPlayers.removePlayer(player);
        this.level.playerChunkLoader.removePlayer(player);
        int len = TRACKING_RANGE_TYPES.length;
        for (int i = 0; i < len; ++i) {
            this.playerEntityTrackerTrackMaps[i].remove(player);
        }
        this.playerMobSpawnMap.remove(player);
    }

    void updateMaps(ServerPlayer player) {
        int chunkX = MCUtil.getChunkCoordinate(player.getX());
        int chunkZ = MCUtil.getChunkCoordinate(player.getZ());
        this.nearbyPlayers.tickPlayer(player);
        this.level.playerChunkLoader.updatePlayer(player);
        int len = TRACKING_RANGE_TYPES.length;
        for (int i = 0; i < len; ++i) {
            PlayerAreaMap trackMap = this.playerEntityTrackerTrackMaps[i];
            int trackRange = this.entityTrackerTrackRanges[i];
            trackMap.update(player, chunkX, chunkZ, Math.min(trackRange, ChunkSystem.getSendViewDistance(player)));
        }
    }

    public final ChunkHolder getUnloadingChunkHolder(int chunkX, int chunkZ) {
        return null;
    }

    public ChunkMap(ServerLevel world, LevelStorageSource.LevelStorageAccess session, DataFixer dataFixer, StructureTemplateManager structureTemplateManager, Executor executor, BlockableEventLoop<Runnable> mainThreadExecutor, LightChunkGetter chunkProvider, ChunkGenerator chunkGenerator, ChunkProgressListener worldGenerationProgressListener, ChunkStatusUpdateListener chunkStatusChangeListener, Supplier<DimensionDataStorage> persistentStateManagerFactory, int viewDistance, boolean dsync) {
        super(new RegionStorageInfo(session.getLevelId(), world.dimension(), "chunk"), session.getDimensionPath(world.dimension()).resolve("region"), dataFixer, dsync);
        this.tickingGenerated = new AtomicInteger();
        this.playerMap = new PlayerMap();
        this.entityMap = new Int2ObjectOpenHashMap();
        this.chunkTypeCache = new Long2ByteOpenHashMap();
        this.chunkSaveCooldowns = new Long2LongOpenHashMap();
        this.unloadQueue = Queues.newConcurrentLinkedQueue();
        Path path = session.getDimensionPath(world.dimension());
        this.storageName = path.getFileName().toString();
        this.level = world;
        this.generator = chunkGenerator;
        RegistryAccess iregistrycustom = world.registryAccess();
        long j = world.getSeed();
        ChunkGenerator randomGenerator = chunkGenerator;
        if (randomGenerator instanceof CustomChunkGenerator) {
            CustomChunkGenerator customChunkGenerator = (CustomChunkGenerator)randomGenerator;
            randomGenerator = customChunkGenerator.getDelegate();
        }
        if (randomGenerator instanceof NoiseBasedChunkGenerator) {
            NoiseBasedChunkGenerator chunkgeneratorabstract = (NoiseBasedChunkGenerator)randomGenerator;
            this.randomState = RandomState.create(chunkgeneratorabstract.generatorSettings().value(), iregistrycustom.lookupOrThrow(Registries.NOISE), j);
        } else {
            this.randomState = RandomState.create(NoiseGeneratorSettings.dummy(), iregistrycustom.lookupOrThrow(Registries.NOISE), j);
        }
        this.chunkGeneratorState = chunkGenerator.createState(iregistrycustom.lookupOrThrow(Registries.STRUCTURE_SET), this.randomState, j, world.spigotConfig);
        this.mainThreadExecutor = mainThreadExecutor;
        Objects.requireNonNull(mainThreadExecutor);
        this.progressListener = worldGenerationProgressListener;
        this.chunkStatusListener = chunkStatusChangeListener;
        this.lightEngine = new ThreadedLevelLightEngine(chunkProvider, this, this.level.dimensionType().hasSkyLight(), null, null);
        this.distanceManager = new ChunkDistanceManager(executor, mainThreadExecutor);
        this.overworldDataStorage = persistentStateManagerFactory;
        this.poiManager = new PoiManager(new RegionStorageInfo(session.getLevelId(), world.dimension(), "poi"), path.resolve("poi"), dataFixer, dsync, iregistrycustom, world);
        this.setServerViewDistance(viewDistance);
        this.worldGenContext = new WorldGenContext(world, chunkGenerator, structureTemplateManager, this.lightEngine);
        this.dataRegionManager = new SingleThreadChunkRegionManager(this.level, 2, 0.3333333333333333, 1, 6, "Data", DataRegionData::new, DataRegionSectionData::new);
        this.regionManagers.add(this.dataRegionManager);
        this.nearbyPlayers = new NearbyPlayers(this.level);
        this.playerEntityTrackerTrackMaps = new PlayerAreaMap[TRACKING_RANGE_TYPES.length];
        this.entityTrackerTrackRanges = new int[TRACKING_RANGE_TYPES.length];
        SpigotWorldConfig spigotWorldConfig = this.level.spigotConfig;
        for (TrackingRange.TrackingRangeType trackingRangeType : TRACKING_RANGE_TYPES) {
            int trackRange;
            int configuredSpigotValue = switch (trackingRangeType) {
                case TrackingRange.TrackingRangeType.PLAYER -> spigotWorldConfig.playerTrackingRange;
                case TrackingRange.TrackingRangeType.ANIMAL -> spigotWorldConfig.animalTrackingRange;
                case TrackingRange.TrackingRangeType.MONSTER -> spigotWorldConfig.monsterTrackingRange;
                case TrackingRange.TrackingRangeType.MISC -> spigotWorldConfig.miscTrackingRange;
                case TrackingRange.TrackingRangeType.OTHER -> spigotWorldConfig.otherTrackingRange;
                case TrackingRange.TrackingRangeType.ENDERDRAGON -> EntityType.ENDER_DRAGON.clientTrackingRange() * 16;
                case TrackingRange.TrackingRangeType.DISPLAY -> spigotWorldConfig.displayTrackingRange;
                default -> throw new IllegalStateException("Missing case for enum " + String.valueOf((Object)trackingRangeType));
            };
            configuredSpigotValue = this.convertSpigotRangeToVanilla(configuredSpigotValue);
            this.entityTrackerTrackRanges[ordinal] = trackRange = (configuredSpigotValue >>> 4) + ((configuredSpigotValue & 0xF) != 0 ? 1 : 0);
            this.playerEntityTrackerTrackMaps[ordinal] = new PlayerAreaMap(this.pooledLinkedPlayerHashSets);
        }
    }

    public final NearbyPlayers getNearbyPlayers() {
        return this.nearbyPlayers;
    }

    protected ChunkGenerator generator() {
        return this.generator;
    }

    protected ChunkGeneratorStructureState generatorState() {
        return this.chunkGeneratorState;
    }

    protected RandomState randomState() {
        return this.randomState;
    }

    public void debugReloadGenerator() {
        DataResult dataresult = ChunkGenerator.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this.generator);
        DataResult dataresult1 = dataresult.flatMap(jsonelement -> ChunkGenerator.CODEC.parse((DynamicOps)JsonOps.INSTANCE, jsonelement));
        dataresult1.ifSuccess(chunkgenerator -> {
            this.generator = chunkgenerator;
            this.worldGenContext = new WorldGenContext(this.worldGenContext.level(), (ChunkGenerator)chunkgenerator, this.worldGenContext.structureManager(), this.worldGenContext.lightEngine());
        });
    }

    public void updatePlayerMobTypeMap(net.minecraft.world.entity.Entity entity) {
        if (!this.level.paperConfig().entities.spawning.perPlayerMobSpawns) {
            return;
        }
        int index = entity.getType().getCategory().ordinal();
        ReferenceList<ServerPlayer> inRange = this.getNearbyPlayers().getPlayers(entity.chunkPosition(), NearbyPlayers.NearbyMapType.TICK_VIEW_DISTANCE);
        if (inRange == null) {
            return;
        }
        Object[] backingSet = inRange.getRawData();
        int len = inRange.size();
        for (int i = 0; i < len; ++i) {
            int n = index;
            ((ServerPlayer)backingSet[i]).mobCounts[n] = ((ServerPlayer)backingSet[i]).mobCounts[n] + 1;
        }
    }

    public void updateFailurePlayerMobTypeMap(int chunkX, int chunkZ, MobCategory mobCategory) {
        if (!this.level.paperConfig().entities.spawning.perPlayerMobSpawns) {
            return;
        }
        int idx = mobCategory.ordinal();
        ReferenceList<ServerPlayer> inRange = this.getNearbyPlayers().getPlayersByChunk(chunkX, chunkZ, NearbyPlayers.NearbyMapType.TICK_VIEW_DISTANCE);
        if (inRange == null) {
            return;
        }
        Object[] backingSet = inRange.getRawData();
        int len = inRange.size();
        for (int i = 0; i < len; ++i) {
            int n = idx;
            ((ServerPlayer)backingSet[i]).mobBackoffCounts[n] = ((ServerPlayer)backingSet[i]).mobBackoffCounts[n] + 1;
        }
    }

    public int getMobCountNear(ServerPlayer player, MobCategory mobCategory) {
        return player.mobCounts[mobCategory.ordinal()] + player.mobBackoffCounts[mobCategory.ordinal()];
    }

    public static double euclideanDistanceSquared(ChunkPos pos, net.minecraft.world.entity.Entity entity) {
        double d0 = SectionPos.sectionToBlockCoord(pos.x, 8);
        double d1 = SectionPos.sectionToBlockCoord(pos.z, 8);
        double d2 = d0 - entity.getX();
        double d3 = d1 - entity.getZ();
        return d2 * d2 + d3 * d3;
    }

    boolean isChunkTracked(ServerPlayer player, int chunkX, int chunkZ) {
        return this.level.playerChunkLoader.isChunkSent(player, chunkX, chunkZ);
    }

    private boolean isChunkOnTrackedBorder(ServerPlayer player, int chunkX, int chunkZ) {
        return this.level.playerChunkLoader.isChunkSent(player, chunkX, chunkZ, true);
    }

    protected ThreadedLevelLightEngine getLightEngine() {
        return this.lightEngine;
    }

    @Nullable
    protected ChunkHolder getUpdatingChunkIfPresent(long pos) {
        NewChunkHolder holder = this.level.chunkTaskScheduler.chunkHolderManager.getChunkHolder(pos);
        return holder == null ? null : holder.vanillaChunkHolder;
    }

    @Nullable
    public ChunkHolder getVisibleChunkIfPresent(long pos) {
        NewChunkHolder holder = this.level.chunkTaskScheduler.chunkHolderManager.getChunkHolder(pos);
        return holder == null ? null : holder.vanillaChunkHolder;
    }

    protected IntSupplier getChunkQueueLevel(long pos) {
        throw new UnsupportedOperationException();
    }

    public String getChunkDebugData(ChunkPos chunkPos) {
        ChunkHolder playerchunk = this.getVisibleChunkIfPresent(chunkPos.toLong());
        if (playerchunk == null) {
            return "null";
        }
        String s = playerchunk.getTicketLevel() + "\n";
        ChunkStatus chunkstatus = playerchunk.getLastAvailableStatus();
        ChunkAccess ichunkaccess = playerchunk.getLastAvailable();
        if (chunkstatus != null) {
            s = s + "St: \u00a7" + chunkstatus.getIndex() + String.valueOf(chunkstatus) + "\u00a7r\n";
        }
        if (ichunkaccess != null) {
            s = s + "Ch: \u00a7" + ichunkaccess.getStatus().getIndex() + String.valueOf(ichunkaccess.getStatus()) + "\u00a7r\n";
        }
        FullChunkStatus fullchunkstatus = playerchunk.getFullStatus();
        s = s + String.valueOf('\u00a7') + fullchunkstatus.ordinal() + String.valueOf((Object)fullchunkstatus);
        return s + "\u00a7r";
    }

    private CompletableFuture<ChunkResult<List<ChunkAccess>>> getChunkRangeFuture(ChunkHolder centerChunk, int margin, IntFunction<ChunkStatus> distanceToStatus) {
        throw new UnsupportedOperationException();
    }

    public ReportedException debugFuturesAndCreateReportedException(IllegalStateException exception, String details) {
        StringBuilder stringbuilder = new StringBuilder();
        Consumer<ChunkHolder> consumer = playerchunk -> playerchunk.getAllFutures().forEach(pair -> {
            ChunkStatus chunkstatus = (ChunkStatus)pair.getFirst();
            CompletableFuture completablefuture = (CompletableFuture)pair.getSecond();
            if (completablefuture != null && completablefuture.isDone() && completablefuture.join() == null) {
                stringbuilder.append(playerchunk.getPos()).append(" - status: ").append(chunkstatus).append(" future: ").append(completablefuture).append(System.lineSeparator());
            }
        });
        stringbuilder.append("Updating:").append(System.lineSeparator());
        ChunkSystem.getUpdatingChunkHolders(this.level).forEach(consumer);
        stringbuilder.append("Visible:").append(System.lineSeparator());
        ChunkSystem.getVisibleChunkHolders(this.level).forEach(consumer);
        CrashReport crashreport = CrashReport.forThrowable(exception, "Chunk loading");
        CrashReportCategory crashreportsystemdetails = crashreport.addCategory("Chunk loading");
        crashreportsystemdetails.setDetail("Details", details);
        crashreportsystemdetails.setDetail("Futures", stringbuilder);
        return new ReportedException(crashreport);
    }

    public CompletableFuture<ChunkResult<LevelChunk>> prepareEntityTickingChunk(ChunkHolder chunk) {
        throw new UnsupportedOperationException();
    }

    @Nullable
    ChunkHolder updateChunkScheduling(long pos, int level, @Nullable ChunkHolder holder, int k) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws IOException {
        throw new UnsupportedOperationException("Use ServerChunkCache#close");
    }

    protected void saveIncrementally() {
        this.level.chunkTaskScheduler.chunkHolderManager.autoSave();
    }

    protected void saveAllChunks(boolean flush) {
        this.level.chunkTaskScheduler.chunkHolderManager.saveAllChunks(flush, false, false);
    }

    protected void tick(BooleanSupplier shouldKeepTicking) {
        ProfilerFiller gameprofilerfiller = this.level.getProfiler();
        gameprofilerfiller.push("poi");
        this.poiManager.tick(shouldKeepTicking);
        gameprofilerfiller.popPush("chunk_unload");
        if (!this.level.noSave()) {
            this.processUnloads(shouldKeepTicking);
        }
        gameprofilerfiller.pop();
    }

    public boolean hasWork() {
        throw new UnsupportedOperationException();
    }

    private void processUnloads(BooleanSupplier shouldKeepTicking) {
        this.level.chunkTaskScheduler.chunkHolderManager.processUnloads();
    }

    private void scheduleUnload(long pos, ChunkHolder holder) {
        throw new UnsupportedOperationException();
    }

    protected boolean promoteChunkMap() {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<ChunkResult<ChunkAccess>> schedule(ChunkHolder holder, ChunkStatus requiredStatus) {
        throw new UnsupportedOperationException();
    }

    private CompletableFuture<ChunkAccess> scheduleChunkLoad(ChunkPos pos) {
        throw new UnsupportedOperationException();
    }

    public static boolean isChunkDataValid(CompoundTag nbt) {
        return nbt.contains("Status", 8);
    }

    private ChunkAccess handleChunkLoadFailure(Throwable throwable, ChunkPos chunkPos) {
        boolean flag1;
        Throwable throwable1;
        if (throwable instanceof CompletionException) {
            CompletionException completionexception = (CompletionException)throwable;
            throwable1 = completionexception.getCause();
        } else {
            throwable1 = throwable;
        }
        Throwable throwable2 = throwable1;
        if (throwable2 instanceof ReportedException) {
            ReportedException reportedexception = (ReportedException)throwable2;
            throwable1 = reportedexception.getCause();
        } else {
            throwable1 = throwable2;
        }
        Throwable throwable3 = throwable1;
        boolean flag = throwable3 instanceof Error;
        boolean bl = flag1 = throwable3 instanceof IOException || throwable3 instanceof NbtException;
        if (!flag) {
            if (!flag1) {
                // empty if block
            }
            LOGGER.error("Couldn't load chunk {}", (Object)chunkPos, (Object)throwable3);
            this.level.getServer().reportChunkLoadFailure(chunkPos);
            return this.createEmptyChunk(chunkPos);
        }
        CrashReport crashreport = CrashReport.forThrowable(throwable, "Exception loading chunk");
        CrashReportCategory crashreportsystemdetails = crashreport.addCategory("Chunk being loaded");
        crashreportsystemdetails.setDetail("pos", chunkPos);
        this.markPositionReplaceable(chunkPos);
        throw new ReportedException(crashreport);
    }

    private ChunkAccess createEmptyChunk(ChunkPos chunkPos) {
        this.markPositionReplaceable(chunkPos);
        return new ProtoChunk(chunkPos, UpgradeData.EMPTY, this.level, this.level.registryAccess().registryOrThrow(Registries.BIOME), null);
    }

    private void markPositionReplaceable(ChunkPos pos) {
        this.chunkTypeCache.put(pos.toLong(), (byte)-1);
    }

    private byte markPosition(ChunkPos pos, ChunkType type) {
        return this.chunkTypeCache.put(pos.toLong(), (byte)(type == ChunkType.PROTOCHUNK ? -1 : 1));
    }

    private CompletableFuture<ChunkResult<ChunkAccess>> scheduleChunkGeneration(ChunkHolder holder, ChunkStatus requiredStatus) {
        throw new UnsupportedOperationException();
    }

    protected void releaseLightTicket(ChunkPos pos) {
        this.mainThreadExecutor.tell(Util.name(() -> this.distanceManager.removeTicket(TicketType.LIGHT, pos, ChunkLevel.byStatus(ChunkStatus.LIGHT), pos), () -> "release light ticket " + String.valueOf(pos)));
    }

    public static ChunkStatus getDependencyStatus(ChunkStatus centerChunkTargetStatus, int distance) {
        ChunkStatus chunkstatus1 = distance == 0 ? centerChunkTargetStatus.getParent() : ChunkStatus.getStatusAroundFullChunk(ChunkStatus.getDistance(centerChunkTargetStatus) + distance);
        return chunkstatus1;
    }

    public static void postLoadProtoChunk(ServerLevel world, List<CompoundTag> nbt, ChunkPos position) {
        if (!nbt.isEmpty()) {
            world.addWorldGenChunkEntities(EntityType.loadEntitiesRecursive(nbt, world).filter(entity -> {
                boolean needsRemoval = false;
                DedicatedServer server = world.getCraftServer().getServer();
                if (!server.areNpcsEnabled() && entity instanceof Npc) {
                    entity.discard(null);
                    needsRemoval = true;
                }
                if (!server.isSpawningAnimals() && (entity instanceof Animal || entity instanceof WaterAnimal)) {
                    entity.discard(null);
                    needsRemoval = true;
                }
                ChunkMap.checkDupeUUID(world, entity);
                return !needsRemoval;
            }), position);
        }
    }

    private CompletableFuture<ChunkAccess> protoChunkToFullChunk(ChunkHolder playerchunk, ChunkAccess ichunkaccess) {
        throw new UnsupportedOperationException();
    }

    public static boolean checkDupeUUID(ServerLevel level, net.minecraft.world.entity.Entity entity) {
        WorldConfiguration.Entities.Spawning.DuplicateUUID.DuplicateUUIDMode mode = level.paperConfig().entities.spawning.duplicateUuid.mode;
        if (mode != WorldConfiguration.Entities.Spawning.DuplicateUUID.DuplicateUUIDMode.WARN && mode != WorldConfiguration.Entities.Spawning.DuplicateUUID.DuplicateUUIDMode.DELETE && mode != WorldConfiguration.Entities.Spawning.DuplicateUUID.DuplicateUUIDMode.SAFE_REGEN) {
            return false;
        }
        net.minecraft.world.entity.Entity other = level.getEntity(entity.getUUID());
        if (other == null || other == entity) {
            return false;
        }
        if (mode == WorldConfiguration.Entities.Spawning.DuplicateUUID.DuplicateUUIDMode.SAFE_REGEN && other != null && !other.isRemoved() && Objects.equals(other.getEncodeId(), entity.getEncodeId()) && entity.getBukkitEntity().getLocation().distance(other.getBukkitEntity().getLocation()) < (double)level.paperConfig().entities.spawning.duplicateUuid.safeRegenDeleteRange) {
            entity.discard(null);
            return true;
        }
        if (!other.isRemoved()) {
            switch (mode) {
                case SAFE_REGEN: {
                    entity.setUUID(UUID.randomUUID());
                    break;
                }
                case DELETE: {
                    entity.discard(EntityRemoveEvent.Cause.DISCARD);
                    return true;
                }
            }
        }
        return false;
    }

    public CompletableFuture<ChunkResult<LevelChunk>> prepareTickingChunk(ChunkHolder holder) {
        throw new UnsupportedOperationException();
    }

    private void onChunkReadyToSend(LevelChunk chunk) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<ChunkResult<LevelChunk>> prepareAccessibleChunk(ChunkHolder holder) {
        throw new UnsupportedOperationException();
    }

    public int getTickingGenerated() {
        return this.tickingGenerated.get();
    }

    private boolean saveChunkIfNeeded(ChunkHolder chunkHolder) {
        throw new UnsupportedOperationException();
    }

    public boolean save(ChunkAccess chunk) {
        throw new UnsupportedOperationException();
    }

    private boolean isExistingChunkFull(ChunkPos pos) {
        throw new UnsupportedOperationException();
    }

    public void setServerViewDistance(int watchDistance) {
        int j = Mth.clamp(watchDistance, 2, 32);
        if (j != this.serverViewDistance) {
            this.serverViewDistance = j;
            this.level.playerChunkLoader.setLoadDistance(this.serverViewDistance + 1);
        }
    }

    public void setTickViewDistance(int distance) {
        this.level.playerChunkLoader.setTickDistance(distance);
    }

    public void setSendViewDistance(int distance) {
        this.level.playerChunkLoader.setSendDistance(distance);
    }

    public int getPlayerViewDistance(ServerPlayer player) {
        return ChunkSystem.getSendViewDistance(player);
    }

    private void markChunkPendingToSend(ServerPlayer player, ChunkPos pos) {
        throw new UnsupportedOperationException();
    }

    private static void markChunkPendingToSend(ServerPlayer player, LevelChunk chunk) {
        throw new UnsupportedOperationException();
    }

    private static void dropChunk(ServerPlayer player, ChunkPos pos) {
    }

    @Nullable
    public LevelChunk getChunkToSend(long pos) {
        ChunkHolder playerchunk = this.getVisibleChunkIfPresent(pos);
        return playerchunk == null ? null : playerchunk.getChunkToSend();
    }

    public int size() {
        return ChunkSystem.getVisibleChunkHolderCount(this.level);
    }

    public DistanceManager getDistanceManager() {
        return this.distanceManager;
    }

    protected Iterable<ChunkHolder> getChunks() {
        return Iterables.unmodifiableIterable(ChunkSystem.getVisibleChunkHolders(this.level));
    }

    void dumpChunks(Writer writer) throws IOException {
        throw new UnsupportedOperationException();
    }

    private static String printFuture(CompletableFuture<ChunkResult<LevelChunk>> future) {
        try {
            ChunkResult chunkresult = future.getNow(null);
            return chunkresult != null ? (chunkresult.isSuccess() ? "done" : "unloaded") : "not completed";
        }
        catch (CompletionException completionexception) {
            return "failed " + completionexception.getCause().getMessage();
        }
        catch (CancellationException cancellationexception) {
            return "cancelled";
        }
    }

    @Override
    @Nullable
    public CompoundTag readSync(ChunkPos chunkcoordintpair) throws IOException {
        if (!RegionFileIOThread.isRegionFileThread()) {
            return RegionFileIOThread.loadData(this.level, chunkcoordintpair.x, chunkcoordintpair.z, RegionFileIOThread.RegionFileType.CHUNK_DATA, RegionFileIOThread.getIOBlockingPriorityForCurrentThread());
        }
        return super.readSync(chunkcoordintpair);
    }

    @Override
    public CompletableFuture<Void> write(ChunkPos chunkcoordintpair, CompoundTag nbttagcompound) throws IOException {
        if (!RegionFileIOThread.isRegionFileThread()) {
            RegionFileIOThread.scheduleSave(this.level, chunkcoordintpair.x, chunkcoordintpair.z, nbttagcompound, RegionFileIOThread.RegionFileType.CHUNK_DATA);
            return null;
        }
        super.write(chunkcoordintpair, nbttagcompound);
        return null;
    }

    private CompletableFuture<Optional<CompoundTag>> readChunk(ChunkPos chunkPos) {
        try {
            return CompletableFuture.completedFuture(Optional.ofNullable(this.readConvertChunkSync(chunkPos)));
        }
        catch (Throwable thr) {
            return CompletableFuture.failedFuture(thr);
        }
    }

    private CompoundTag upgradeChunkTag(CompoundTag nbttagcompound, ChunkPos chunkcoordintpair) {
        return this.upgradeChunkTag(this.level.getTypeKey(), this.overworldDataStorage, nbttagcompound, this.generator.getTypeNameForDataFixer(), chunkcoordintpair, this.level);
    }

    @Nullable
    public CompoundTag readConvertChunkSync(ChunkPos pos) throws IOException {
        CompoundTag nbttagcompound = this.readSync(pos);
        if (nbttagcompound == null) {
            return null;
        }
        if ((nbttagcompound = this.upgradeChunkTag(nbttagcompound, pos)) == null) {
            return null;
        }
        this.updateChunkStatusOnDisk(pos, nbttagcompound);
        return nbttagcompound;
    }

    public ChunkStatus getChunkStatusOnDiskIfCached(ChunkPos chunkPos) {
        AbstractRegionFile regionFile = this.regionFileCache.getRegionFileIfLoaded(chunkPos);
        return regionFile == null ? null : regionFile.getStatusIfCached(chunkPos.x, chunkPos.z);
    }

    public ChunkStatus getChunkStatusOnDisk(ChunkPos chunkPos) throws IOException {
        AbstractRegionFile regionFile = this.regionFileCache.getRegionFile(chunkPos, true);
        if (regionFile == null || !this.regionFileCache.chunkExists(chunkPos)) {
            return null;
        }
        ChunkStatus status = regionFile.getStatusIfCached(chunkPos.x, chunkPos.z);
        if (status != null) {
            return status;
        }
        this.readChunk(chunkPos);
        return regionFile.getStatusIfCached(chunkPos.x, chunkPos.z);
    }

    public void updateChunkStatusOnDisk(ChunkPos chunkPos, @Nullable CompoundTag compound) throws IOException {
        AbstractRegionFile regionFile = this.regionFileCache.getRegionFile(chunkPos, false);
        regionFile.setStatus(chunkPos.x, chunkPos.z, ChunkSerializer.getStatus(compound));
    }

    public ChunkAccess getUnloadingChunk(int chunkX, int chunkZ) {
        ChunkHolder chunkHolder = ChunkSystem.getUnloadingChunkHolder(this.level, chunkX, chunkZ);
        return chunkHolder == null ? null : chunkHolder.getAvailableChunkNow();
    }

    public boolean anyPlayerCloseEnoughForSpawning(ChunkPos pos) {
        return this.anyPlayerCloseEnoughForSpawning(pos, false);
    }

    boolean anyPlayerCloseEnoughForSpawning(ChunkPos chunkcoordintpair, boolean reducedRange) {
        ServerPlayer entityplayer;
        int chunkRange = this.level.spigotConfig.mobSpawnRange;
        chunkRange = chunkRange > this.level.spigotConfig.viewDistance ? (int)this.level.spigotConfig.viewDistance : chunkRange;
        int finalChunkRange = chunkRange = chunkRange > 8 ? 8 : (int)chunkRange;
        double blockRange = 16384.0;
        if (!this.distanceManager.hasPlayersNearby(chunkcoordintpair.toLong())) {
            return false;
        }
        Iterator<ServerPlayer> iterator = this.playerMap.getAllPlayers().iterator();
        do {
            if (!iterator.hasNext()) {
                return false;
            }
            entityplayer = iterator.next();
            blockRange = 16384.0;
            if (!reducedRange) continue;
            PlayerNaturallySpawnCreaturesEvent event = entityplayer.playerNaturallySpawnedEvent;
            if (event == null || event.isCancelled()) {
                return false;
            }
            blockRange = (event.getSpawnRadius() << 4) * (event.getSpawnRadius() << 4);
        } while (!this.playerIsCloseEnoughForSpawning(entityplayer, chunkcoordintpair, blockRange));
        return true;
    }

    public List<ServerPlayer> getPlayersCloseForSpawning(ChunkPos pos) {
        long i = pos.toLong();
        if (!this.distanceManager.hasPlayersNearby(i)) {
            return List.of();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ServerPlayer entityplayer : this.playerMap.getAllPlayers()) {
            if (!this.playerIsCloseEnoughForSpawning(entityplayer, pos, 16384.0)) continue;
            builder.add((Object)entityplayer);
        }
        return builder.build();
    }

    private boolean playerIsCloseEnoughForSpawning(ServerPlayer entityplayer, ChunkPos chunkcoordintpair, double range) {
        if (entityplayer.isSpectator()) {
            return false;
        }
        double d0 = ChunkMap.euclideanDistanceSquared(chunkcoordintpair, entityplayer);
        return d0 < range;
    }

    private boolean skipPlayer(ServerPlayer player) {
        return player.isSpectator() && !this.level.getGameRules().getBoolean(GameRules.RULE_SPECTATORSGENERATECHUNKS) || LeavesConfig.elytraAeronauticsNoChunk && player.elytraAeronauticsNoChunk;
    }

    void updatePlayerStatus(ServerPlayer player, boolean added) {
        boolean flag1 = this.skipPlayer(player);
        boolean flag2 = this.playerMap.ignoredOrUnknown(player);
        if (added) {
            this.playerMap.addPlayer(player, flag1);
            this.updatePlayerPos(player);
            if (!flag1) {
                this.distanceManager.addPlayer(SectionPos.of(player), player);
            }
            this.addPlayerToDistanceMaps(player);
        } else {
            SectionPos sectionposition = player.getLastSectionPos();
            this.playerMap.removePlayer(player);
            if (!flag2) {
                this.distanceManager.removePlayer(sectionposition, player);
            }
            this.removePlayerFromDistanceMaps(player);
        }
    }

    private void updatePlayerPos(ServerPlayer player) {
        SectionPos sectionposition = SectionPos.of(player);
        player.setLastSectionPos(sectionposition);
    }

    public void move(ServerPlayer player) {
        boolean flag2;
        if (player.elytraAeronauticsNoChunk) {
            return;
        }
        SectionPos sectionposition = player.getLastSectionPos();
        SectionPos sectionposition1 = SectionPos.of(player);
        boolean flag = this.playerMap.ignored(player);
        boolean flag1 = this.skipPlayer(player);
        boolean bl = flag2 = sectionposition.asLong() != sectionposition1.asLong();
        if (flag2 || flag != flag1) {
            this.updatePlayerPos(player);
            if (!flag) {
                this.distanceManager.removePlayer(sectionposition, player);
            }
            if (!flag1) {
                this.distanceManager.addPlayer(sectionposition1, player);
            }
            if (!flag && flag1) {
                this.playerMap.ignorePlayer(player);
            }
            if (flag && !flag1) {
                this.playerMap.unIgnorePlayer(player);
            }
        }
        this.updateMaps(player);
    }

    private void updateChunkTracking(ServerPlayer player) {
        throw new UnsupportedOperationException();
    }

    private void applyChunkTrackingView(ServerPlayer player, ChunkTrackingView chunkFilter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<ServerPlayer> getPlayers(ChunkPos chunkPos, boolean onlyOnWatchDistanceEdge) {
        ChunkHolder holder = this.getVisibleChunkIfPresent(chunkPos.toLong());
        if (holder == null) {
            return new ArrayList<ServerPlayer>();
        }
        return holder.getPlayers(onlyOnWatchDistanceEdge);
    }

    public void addEntity(net.minecraft.world.entity.Entity entity) {
        AsyncCatcher.catchOp("entity track");
        if (!entity.valid || entity.level() != this.level || this.entityMap.containsKey(entity.getId())) {
            LOGGER.error("Illegal ChunkMap::addEntity for world " + this.level.getWorld().getName() + ": " + String.valueOf(entity) + (this.entityMap.containsKey(entity.getId()) ? " ALREADY CONTAINED (This would have crashed your server)" : ""), new Throwable());
            return;
        }
        if (entity instanceof ServerPlayer && ((ServerPlayer)entity).supressTrackerForLogin) {
            return;
        }
        if (!(entity instanceof EnderDragonPart)) {
            EntityType<?> entitytypes = entity.getType();
            int i = entitytypes.clientTrackingRange() * 16;
            if ((i = TrackingRange.getEntityTrackingRange(entity, i)) != 0) {
                TrackedEntity playerchunkmap_entitytracker;
                int j = entitytypes.updateInterval();
                if (this.entityMap.containsKey(entity.getId())) {
                    throw Util.pauseInIde(new IllegalStateException("Entity is already tracked!"));
                }
                entity.tracker = playerchunkmap_entitytracker = new TrackedEntity(entity, i, j, entitytypes.trackDeltas());
                this.entityMap.put(entity.getId(), (Object)playerchunkmap_entitytracker);
                playerchunkmap_entitytracker.updatePlayers(entity.getPlayersInTrackRange());
                if (entity instanceof ServerPlayer) {
                    ServerPlayer entityplayer = (ServerPlayer)entity;
                    this.updatePlayerStatus(entityplayer, true);
                    for (TrackedEntity playerchunkmap_entitytracker1 : this.entityMap.values()) {
                        if (playerchunkmap_entitytracker1.entity == entityplayer) continue;
                        playerchunkmap_entitytracker1.updatePlayer(entityplayer);
                    }
                }
            }
        }
    }

    protected void removeEntity(net.minecraft.world.entity.Entity entity) {
        TrackedEntity playerchunkmap_entitytracker1;
        AsyncCatcher.catchOp("entity untrack");
        if (entity instanceof ServerPlayer) {
            ServerPlayer entityplayer = (ServerPlayer)entity;
            this.updatePlayerStatus(entityplayer, false);
            for (TrackedEntity playerchunkmap_entitytracker : this.entityMap.values()) {
                playerchunkmap_entitytracker.removePlayer(entityplayer);
            }
        }
        if ((playerchunkmap_entitytracker1 = (TrackedEntity)this.entityMap.remove(entity.getId())) != null) {
            playerchunkmap_entitytracker1.broadcastRemoved();
        }
        entity.tracker = null;
    }

    private final void processTrackQueue() {
        for (TrackedEntity tracker : this.entityMap.values()) {
            tracker.updatePlayers(tracker.entity.getPlayersInTrackRange());
        }
        for (TrackedEntity tracker : this.entityMap.values()) {
            tracker.serverEntity.sendChanges();
        }
    }

    protected void tick() {
        this.processTrackQueue();
    }

    public void broadcast(net.minecraft.world.entity.Entity entity, Packet<?> packet) {
        TrackedEntity playerchunkmap_entitytracker = (TrackedEntity)this.entityMap.get(entity.getId());
        if (playerchunkmap_entitytracker != null) {
            playerchunkmap_entitytracker.broadcast(packet);
        }
    }

    protected void broadcastAndSend(net.minecraft.world.entity.Entity entity, Packet<?> packet) {
        TrackedEntity playerchunkmap_entitytracker = (TrackedEntity)this.entityMap.get(entity.getId());
        if (playerchunkmap_entitytracker != null) {
            playerchunkmap_entitytracker.broadcastAndSend(packet);
        }
    }

    public void resendBiomesForChunks(List<ChunkAccess> chunks) {
        HashMap<ServerPlayer, List> map = new HashMap<ServerPlayer, List>();
        for (ChunkAccess ichunkaccess : chunks) {
            LevelChunk chunk1;
            ChunkPos chunkcoordintpair = ichunkaccess.getPos();
            LevelChunk chunk = ichunkaccess instanceof LevelChunk ? (chunk1 = (LevelChunk)ichunkaccess) : this.level.getChunk(chunkcoordintpair.x, chunkcoordintpair.z);
            for (ServerPlayer entityplayer : this.getPlayers(chunkcoordintpair, false)) {
                map.computeIfAbsent(entityplayer, entityplayer1 -> new ArrayList()).add(chunk);
            }
        }
        map.forEach((entityplayer1, list1) -> entityplayer1.connection.send(ClientboundChunksBiomesPacket.forChunks(list1)));
    }

    public PoiManager getPoiManager() {
        return this.poiManager;
    }

    public String getStorageName() {
        return this.storageName;
    }

    void onFullChunkStatusChange(ChunkPos chunkPos, FullChunkStatus levelType) {
        this.chunkStatusListener.onChunkStatusChange(chunkPos, levelType);
    }

    public void waitForLightBeforeSending(ChunkPos centerPos, int radius) {
    }

    public class ChunkDistanceManager
    extends DistanceManager {
        protected ChunkDistanceManager(Executor workerExecutor, Executor mainThreadExecutor) {
            super(workerExecutor, mainThreadExecutor, ChunkMap.this);
        }

        @Override
        protected boolean isChunkToRemove(long pos) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Nullable
        protected ChunkHolder getChunk(long pos) {
            return ChunkMap.this.getUpdatingChunkIfPresent(pos);
        }

        @Override
        @Nullable
        protected ChunkHolder updateChunkScheduling(long pos, int level, @Nullable ChunkHolder holder, int k) {
            return ChunkMap.this.updateChunkScheduling(pos, level, holder, k);
        }
    }

    public class TrackedEntity {
        public final ServerEntity serverEntity;
        final net.minecraft.world.entity.Entity entity;
        private final int range;
        SectionPos lastSectionPos;
        public final Set<ServerPlayerConnection> seenBy = new ReferenceOpenHashSet();
        PooledLinkedHashSets.PooledObjectLinkedOpenHashSet<ServerPlayer> lastTrackerCandidates;

        public TrackedEntity(net.minecraft.world.entity.Entity entity, int i, int j, boolean flag) {
            this.serverEntity = new ServerEntity(ChunkMap.this.level, entity, j, flag, this::broadcast, this.seenBy);
            this.entity = entity;
            this.range = i;
            this.lastSectionPos = SectionPos.of(entity);
        }

        final void updatePlayers(PooledLinkedHashSets.PooledObjectLinkedOpenHashSet<ServerPlayer> newTrackerCandidates) {
            PooledLinkedHashSets.PooledObjectLinkedOpenHashSet<ServerPlayer> oldTrackerCandidates = this.lastTrackerCandidates;
            this.lastTrackerCandidates = newTrackerCandidates;
            if (newTrackerCandidates != null) {
                for (ServerPlayer raw : newTrackerCandidates.getBackingSet()) {
                    if (!(raw instanceof ServerPlayer)) continue;
                    ServerPlayer player = raw;
                    this.updatePlayer(player);
                }
            }
            if (oldTrackerCandidates == newTrackerCandidates) {
                return;
            }
            for (ServerPlayerConnection conn : this.seenBy.toArray(new ServerPlayerConnection[0])) {
                if (newTrackerCandidates != null && newTrackerCandidates.contains(conn.getPlayer())) continue;
                this.updatePlayer(conn.getPlayer());
            }
        }

        public boolean equals(Object object) {
            return object instanceof TrackedEntity ? ((TrackedEntity)object).entity.getId() == this.entity.getId() : false;
        }

        public int hashCode() {
            return this.entity.getId();
        }

        public void broadcast(Packet<?> packet) {
            for (ServerPlayerConnection serverplayerconnection : this.seenBy) {
                serverplayerconnection.send(packet);
            }
        }

        public void broadcastAndSend(Packet<?> packet) {
            this.broadcast(packet);
            if (this.entity instanceof ServerPlayer) {
                ((ServerPlayer)this.entity).connection.send(packet);
            }
        }

        public void broadcastRemoved() {
            for (ServerPlayerConnection serverplayerconnection : this.seenBy) {
                this.serverEntity.removePairing(serverplayerconnection.getPlayer());
            }
        }

        public void removePlayer(ServerPlayer player) {
            AsyncCatcher.catchOp("player tracker clear");
            if (this.seenBy.remove(player.connection)) {
                this.serverEntity.removePairing(player);
            }
        }

        public void updatePlayer(ServerPlayer player) {
            AsyncCatcher.catchOp("player tracker update");
            if (player != this.entity) {
                double rangeY;
                boolean flag;
                double vec3d_dx = player.getX() - this.entity.getX();
                double vec3d_dz = player.getZ() - this.entity.getZ();
                int i = ChunkMap.this.getPlayerViewDistance(player);
                double d1 = vec3d_dx * vec3d_dx + vec3d_dz * vec3d_dz;
                double d0 = Math.min(this.getEffectiveRange(), i * 16);
                double d2 = d0 * d0;
                boolean bl = flag = d1 <= d2 && this.entity.broadcastToPlayer(player) && ChunkMap.this.isChunkTracked(player, this.entity.chunkPosition().x, this.entity.chunkPosition().z);
                if (flag && ChunkMap.this.level.paperConfig().entities.trackingRangeY.enabled && (rangeY = (double)ChunkMap.this.level.paperConfig().entities.trackingRangeY.get(this.entity, -1)) != -1.0) {
                    double vec3d_dy = player.getY() - this.entity.getY();
                    boolean bl2 = flag = vec3d_dy * vec3d_dy <= rangeY * rangeY;
                }
                if (flag && !player.getBukkitEntity().canSee(this.entity.getBukkitEntity())) {
                    flag = false;
                }
                if (flag) {
                    if (this.seenBy.add(player.connection)) {
                        if (PlayerTrackEntityEvent.getHandlerList().getRegisteredListeners().length == 0 || new PlayerTrackEntityEvent((Player)player.getBukkitEntity(), (Entity)this.entity.getBukkitEntity()).callEvent()) {
                            this.serverEntity.addPairing(player);
                        }
                        this.serverEntity.onPlayerAdd();
                    }
                } else if (this.seenBy.remove(player.connection)) {
                    this.serverEntity.removePairing(player);
                    net.minecraft.world.entity.Entity entity = this.entity;
                    if (entity instanceof ServerBot) {
                        ServerBot bot = (ServerBot)entity;
                        if (bot.alwaysSendData) {
                            bot.sendFakeData(player.connection, false);
                        }
                    }
                }
            }
        }

        private int scaledRange(int initialDistance) {
            return ChunkMap.this.level.getServer().getScaledTrackingDistance(initialDistance);
        }

        private static int getHighestRange(net.minecraft.world.entity.Entity parent, int highest) {
            List<net.minecraft.world.entity.Entity> passengers = parent.getPassengers();
            int size = passengers.size();
            for (int i = 0; i < size; ++i) {
                net.minecraft.world.entity.Entity entity = passengers.get(i);
                int range = entity.getType().clientTrackingRange() * 16;
                if ((range = TrackingRange.getEntityTrackingRange(entity, range)) > highest) {
                    highest = range;
                }
                highest = TrackedEntity.getHighestRange(entity, highest);
            }
            return highest;
        }

        private int getEffectiveRange() {
            int i = this.range;
            if (LeavesConfig.removeRangeCheckStreams) {
                i = TrackedEntity.getHighestRange(this.entity, i);
            } else {
                for (net.minecraft.world.entity.Entity entity : this.entity.getIndirectPassengers()) {
                    int j = entity.getType().clientTrackingRange() * 16;
                    if ((j = TrackingRange.getEntityTrackingRange(entity, j)) <= i) continue;
                    i = j;
                }
            }
            return this.scaledRange(i);
        }

        public void updatePlayers(List<ServerPlayer> players) {
            for (ServerPlayer entityplayer : players) {
                this.updatePlayer(entityplayer);
            }
        }
    }

    public static final class DataRegionSectionData
    implements SingleThreadChunkRegionManager.RegionSectionData {
        @Override
        public void removeFromRegion(SingleThreadChunkRegionManager.RegionSection section, SingleThreadChunkRegionManager.Region from) {
            DataRegionSectionData sectionData = (DataRegionSectionData)section.sectionData;
            DataRegionData fromData = (DataRegionData)from.regionData;
        }

        @Override
        public void addToRegion(SingleThreadChunkRegionManager.RegionSection section, SingleThreadChunkRegionManager.Region oldRegion, SingleThreadChunkRegionManager.Region newRegion) {
            DataRegionSectionData sectionData = (DataRegionSectionData)section.sectionData;
            DataRegionData oldRegionData = oldRegion == null ? null : (DataRegionData)oldRegion.regionData;
            DataRegionData newRegionData = (DataRegionData)newRegion.regionData;
        }
    }

    public static final class DataRegionData
    implements SingleThreadChunkRegionManager.RegionData {
    }
}

