/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import ca.spottedleaf.concurrentutil.executor.standard.PrioritisedExecutor;
import com.destroystokyo.paper.event.entity.PlayerNaturallySpawnCreaturesEvent;
import com.destroystokyo.paper.io.SyncLoadFinder;
import com.destroystokyo.paper.util.concurrent.WeakSeqLock;
import com.destroystokyo.paper.util.maplist.ReferenceList;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import io.papermc.paper.chunk.system.ChunkSystem;
import io.papermc.paper.chunk.system.scheduling.ChunkTaskScheduler;
import io.papermc.paper.chunk.system.scheduling.NewChunkHolder;
import io.papermc.paper.util.CoordinateUtils;
import io.papermc.paper.util.TickThread;
import io.papermc.paper.util.maplist.IteratorSafeOrderedReferenceSet;
import io.papermc.paper.util.player.NearbyPlayers;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ChunkResult;
import net.minecraft.server.level.DistanceManager;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.ThreadedLevelLightEngine;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.util.Mth;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.LocalMobCapCalculator;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LightChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.storage.ChunkScanAccess;
import net.minecraft.world.level.entity.ChunkStatusUpdateListener;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraft.world.level.storage.LevelStorageSource;
import org.bukkit.entity.Player;
import org.bukkit.entity.SpawnCategory;
import org.leavesmc.leaves.LeavesConfig;
import org.slf4j.Logger;

public class ServerChunkCache
extends ChunkSource {
    public static final Logger LOGGER = LogUtils.getLogger();
    private static final List<ChunkStatus> CHUNK_STATUSES = ChunkStatus.getStatusList();
    private final DistanceManager distanceManager;
    final ServerLevel level;
    public final Thread mainThread;
    final ThreadedLevelLightEngine lightEngine;
    public final MainThreadExecutor mainThreadProcessor;
    public final ChunkMap chunkMap;
    private final DimensionDataStorage dataStorage;
    private long lastInhabitedUpdate;
    public boolean spawnEnemies = true;
    public boolean spawnFriendlies = true;
    private static final int CACHE_SIZE = 4;
    private final long[] lastChunkPos = new long[4];
    private final ChunkStatus[] lastChunkStatus = new ChunkStatus[4];
    private final ChunkAccess[] lastChunk = new ChunkAccess[4];
    @Nullable
    @VisibleForDebug
    private NaturalSpawner.SpawnState lastSpawnState;
    public final IteratorSafeOrderedReferenceSet<LevelChunk> tickingChunks = new IteratorSafeOrderedReferenceSet(4096, 0.75f, 4096, 0.15, true);
    public final IteratorSafeOrderedReferenceSet<LevelChunk> entityTickingChunks = new IteratorSafeOrderedReferenceSet(4096, 0.75f, 4096, 0.15, true);
    final WeakSeqLock loadedChunkMapSeqLock = new WeakSeqLock();
    final Long2ObjectOpenHashMap<LevelChunk> loadedChunkMap = new Long2ObjectOpenHashMap(8192, 0.5f);
    final AtomicLong chunkFutureAwaitCounter = new AtomicLong();
    private final LevelChunk[] lastLoadedChunks = new LevelChunk[16];
    public int peacefulModeSwitchTick = LeavesConfig.forcePeacefulMode;
    public int peacefulModeSwitchCount = -1;
    private final List<Class<? extends Entity>> peacefulModeSwitchEntityTypes = List.of(WitherBoss.class, Shulker.class, Warden.class);

    public ServerChunkCache(ServerLevel world, LevelStorageSource.LevelStorageAccess session, DataFixer dataFixer, StructureTemplateManager structureTemplateManager, Executor workerExecutor, ChunkGenerator chunkGenerator, int viewDistance, int simulationDistance, boolean dsync, ChunkProgressListener worldGenerationProgressListener, ChunkStatusUpdateListener chunkStatusChangeListener, Supplier<DimensionDataStorage> persistentStateManagerFactory) {
        this.level = world;
        this.mainThreadProcessor = new MainThreadExecutor(world);
        this.mainThread = Thread.currentThread();
        File file = session.getDimensionPath(world.dimension()).resolve("data").toFile();
        file.mkdirs();
        this.dataStorage = new DimensionDataStorage(file, dataFixer, world.registryAccess());
        this.chunkMap = new ChunkMap(world, session, dataFixer, structureTemplateManager, workerExecutor, this.mainThreadProcessor, this, chunkGenerator, worldGenerationProgressListener, chunkStatusChangeListener, persistentStateManagerFactory, viewDistance, dsync);
        this.lightEngine = this.chunkMap.getLightEngine();
        this.distanceManager = this.chunkMap.getDistanceManager();
        this.distanceManager.updateSimulationDistance(simulationDistance);
        this.clearCache();
    }

    public boolean isChunkLoaded(int chunkX, int chunkZ) {
        ChunkHolder chunk = this.chunkMap.getUpdatingChunkIfPresent(ChunkPos.asLong(chunkX, chunkZ));
        if (chunk == null) {
            return false;
        }
        return chunk.getFullChunkNow() != null;
    }

    private static int getChunkCacheKey(int x, int z) {
        return x & 3 | (z & 3) << 2;
    }

    public void addLoadedChunk(LevelChunk chunk) {
        this.loadedChunkMapSeqLock.acquireWrite();
        try {
            this.loadedChunkMap.put(chunk.coordinateKey, (Object)chunk);
        }
        finally {
            this.loadedChunkMapSeqLock.releaseWrite();
        }
        int cacheKey = ServerChunkCache.getChunkCacheKey(chunk.locX, chunk.locZ);
        this.lastLoadedChunks[cacheKey] = chunk;
    }

    public void removeLoadedChunk(LevelChunk chunk) {
        this.loadedChunkMapSeqLock.acquireWrite();
        try {
            this.loadedChunkMap.remove(chunk.coordinateKey);
        }
        finally {
            this.loadedChunkMapSeqLock.releaseWrite();
        }
        int cacheKey = ServerChunkCache.getChunkCacheKey(chunk.locX, chunk.locZ);
        LevelChunk cachedChunk = this.lastLoadedChunks[cacheKey];
        if (cachedChunk != null && cachedChunk.coordinateKey == chunk.coordinateKey) {
            this.lastLoadedChunks[cacheKey] = null;
        }
    }

    public final LevelChunk getChunkAtIfLoadedMainThread(int x, int z) {
        int cacheKey = ServerChunkCache.getChunkCacheKey(x, z);
        LevelChunk cachedChunk = this.lastLoadedChunks[cacheKey];
        if (cachedChunk != null && cachedChunk.locX == x & cachedChunk.locZ == z) {
            return cachedChunk;
        }
        long chunkKey = ChunkPos.asLong(x, z);
        this.lastLoadedChunks[cacheKey] = cachedChunk = (LevelChunk)this.loadedChunkMap.get(chunkKey);
        return cachedChunk;
    }

    public final LevelChunk getChunkAtIfLoadedMainThreadNoCache(int x, int z) {
        return (LevelChunk)this.loadedChunkMap.get(ChunkPos.asLong(x, z));
    }

    @Nullable
    public ChunkAccess getChunkAtImmediately(int x, int z) {
        ChunkHolder holder = this.chunkMap.getVisibleChunkIfPresent(ChunkPos.asLong(x, z));
        if (holder == null) {
            return null;
        }
        return holder.getLastAvailable();
    }

    public <T> void addTicketAtLevel(TicketType<T> ticketType, ChunkPos chunkPos, int ticketLevel, T identifier) {
        this.distanceManager.addTicket(ticketType, chunkPos, ticketLevel, identifier);
    }

    public <T> void removeTicketAtLevel(TicketType<T> ticketType, ChunkPos chunkPos, int ticketLevel, T identifier) {
        this.distanceManager.removeTicket(ticketType, chunkPos, ticketLevel, identifier);
    }

    @Nullable
    public LevelChunk getChunkAtIfCachedImmediately(int x, int z) {
        long k = ChunkPos.asLong(x, z);
        ChunkHolder playerChunk = this.getVisibleChunkIfPresent(k);
        if (playerChunk == null) {
            return null;
        }
        return playerChunk.getFullChunkNowUnchecked();
    }

    @Nullable
    public LevelChunk getChunkAtIfLoadedImmediately(int x, int z) {
        long readlock;
        long k = ChunkPos.asLong(x, z);
        if (TickThread.isTickThread()) {
            return this.getChunkAtIfLoadedMainThread(x, z);
        }
        LevelChunk ret = null;
        do {
            readlock = this.loadedChunkMapSeqLock.acquireRead();
            try {
                ret = (LevelChunk)this.loadedChunkMap.get(k);
            }
            catch (Throwable thr) {
                if (!(thr instanceof ThreadDeath)) continue;
                throw (ThreadDeath)thr;
            }
        } while (!this.loadedChunkMapSeqLock.tryReleaseRead(readlock));
        return ret;
    }

    @Override
    public ThreadedLevelLightEngine getLightEngine() {
        return this.lightEngine;
    }

    @Nullable
    private ChunkHolder getVisibleChunkIfPresent(long pos) {
        return this.chunkMap.getVisibleChunkIfPresent(pos);
    }

    public int getTickingGenerated() {
        return this.chunkMap.getTickingGenerated();
    }

    private void storeInCache(long pos, @Nullable ChunkAccess chunk, ChunkStatus status) {
        for (int j = 3; j > 0; --j) {
            this.lastChunkPos[j] = this.lastChunkPos[j - 1];
            this.lastChunkStatus[j] = this.lastChunkStatus[j - 1];
            this.lastChunk[j] = this.lastChunk[j - 1];
        }
        this.lastChunkPos[0] = pos;
        this.lastChunkStatus[0] = status;
        this.lastChunk[0] = chunk;
    }

    @Override
    @Nullable
    public ChunkAccess getChunk(int x, int z, ChunkStatus leastStatus, boolean create) {
        ChunkResult<ChunkAccess> chunkresult;
        ChunkAccess ichunkaccess1;
        int x1 = x;
        int z1 = z;
        if (!TickThread.isTickThread()) {
            return CompletableFuture.supplyAsync(() -> this.getChunk(x, z, leastStatus, create), this.mainThreadProcessor).join();
        }
        LevelChunk ifLoaded = this.getChunkAtIfLoadedMainThread(x, z);
        if (ifLoaded != null) {
            return ifLoaded;
        }
        ProfilerFiller gameprofilerfiller = this.level.getProfiler();
        gameprofilerfiller.incrementCounter("getChunk");
        long k = ChunkPos.asLong(x, z);
        gameprofilerfiller.incrementCounter("getChunkCacheMiss");
        CompletableFuture<ChunkResult<ChunkAccess>> completablefuture = this.getChunkFutureMainThread(x, z, leastStatus, create);
        MainThreadExecutor chunkproviderserver_b = this.mainThreadProcessor;
        Objects.requireNonNull(completablefuture);
        if (!completablefuture.isDone()) {
            ChunkTaskScheduler.pushChunkWait(this.level, x1, z1);
            SyncLoadFinder.logSyncLoad(this.level, x, z);
            chunkproviderserver_b.managedBlock(completablefuture::isDone);
            ChunkTaskScheduler.popChunkWait();
        }
        if ((ichunkaccess1 = (ChunkAccess)(chunkresult = completablefuture.join()).orElse(null)) == null && create) {
            throw Util.pauseInIde(new IllegalStateException("Chunk not there when requested: " + chunkresult.getError()));
        }
        this.storeInCache(k, ichunkaccess1, leastStatus);
        return ichunkaccess1;
    }

    @Override
    @Nullable
    public LevelChunk getChunkNow(int chunkX, int chunkZ) {
        if (!TickThread.isTickThread()) {
            return null;
        }
        return this.getChunkAtIfLoadedMainThread(chunkX, chunkZ);
    }

    private void clearCache() {
        Arrays.fill(this.lastChunkPos, ChunkPos.INVALID_CHUNK_POS);
        Arrays.fill(this.lastChunkStatus, null);
        Arrays.fill(this.lastChunk, null);
    }

    public CompletableFuture<ChunkResult<ChunkAccess>> getChunkFuture(int chunkX, int chunkZ, ChunkStatus leastStatus, boolean create) {
        CompletionStage<ChunkResult<ChunkAccess>> completablefuture;
        boolean flag1 = TickThread.isTickThread();
        if (flag1) {
            completablefuture = this.getChunkFutureMainThread(chunkX, chunkZ, leastStatus, create);
            MainThreadExecutor chunkproviderserver_b = this.mainThreadProcessor;
            Objects.requireNonNull(completablefuture);
            chunkproviderserver_b.managedBlock(() -> completablefuture.isDone());
        } else {
            completablefuture = CompletableFuture.supplyAsync(() -> this.getChunkFutureMainThread(chunkX, chunkZ, leastStatus, create), this.mainThreadProcessor).thenCompose(completablefuture1 -> completablefuture1);
        }
        return completablefuture;
    }

    private CompletableFuture<ChunkResult<ChunkAccess>> getChunkFutureMainThread(int chunkX, int chunkZ, ChunkStatus leastStatus, boolean create) {
        return this.getChunkFutureMainThread(chunkX, chunkZ, leastStatus, create, false);
    }

    private CompletableFuture<ChunkResult<ChunkAccess>> getChunkFutureMainThread(int chunkX, int chunkZ, ChunkStatus leastStatus, boolean create, boolean isUrgent) {
        NewChunkHolder.ChunkCompletion chunkCompletion;
        boolean needsFullScheduling;
        TickThread.ensureTickThread(this.level, chunkX, chunkZ, "Scheduling chunk load off-main");
        int minLevel = ChunkLevel.byStatus(leastStatus);
        NewChunkHolder chunkHolder = this.level.chunkTaskScheduler.chunkHolderManager.getChunkHolder(chunkX, chunkZ);
        boolean bl = needsFullScheduling = leastStatus == ChunkStatus.FULL && (chunkHolder == null || !chunkHolder.getChunkStatus().isOrAfter(FullChunkStatus.FULL));
        if ((chunkHolder == null || chunkHolder.getTicketLevel() > minLevel || needsFullScheduling) && !create) {
            return ChunkHolder.UNLOADED_CHUNK_FUTURE;
        }
        NewChunkHolder.ChunkCompletion chunkCompletion2 = chunkCompletion = chunkHolder == null ? null : chunkHolder.getLastChunkCompletion();
        if (needsFullScheduling || chunkCompletion == null || !chunkCompletion.genStatus().isOrAfter(leastStatus)) {
            CompletableFuture<ChunkResult<ChunkAccess>> ret = new CompletableFuture<ChunkResult<ChunkAccess>>();
            Consumer<ChunkAccess> complete = chunk -> {
                if (chunk == null) {
                    ret.complete(ChunkResult.error("Unexpected chunk unload"));
                } else {
                    ret.complete(ChunkResult.of(chunk));
                }
            };
            this.level.chunkTaskScheduler.scheduleChunkLoad(chunkX, chunkZ, leastStatus, true, isUrgent ? PrioritisedExecutor.Priority.BLOCKING : PrioritisedExecutor.Priority.NORMAL, complete);
            return ret;
        }
        return CompletableFuture.completedFuture(ChunkResult.of(chunkCompletion.chunk()));
    }

    @Override
    public boolean hasChunk(int x, int z) {
        return this.getChunkAtIfLoadedImmediately(x, z) != null;
    }

    @Override
    @Nullable
    public LightChunk getChunkForLighting(int chunkX, int chunkZ) {
        long k = ChunkPos.asLong(chunkX, chunkZ);
        ChunkHolder playerchunk = this.getVisibleChunkIfPresent(k);
        if (playerchunk == null) {
            return null;
        }
        ChunkStatus status = playerchunk.getChunkHolderStatus();
        if (status != null && !status.isOrAfter(ChunkStatus.LIGHT.getParent())) {
            return null;
        }
        return playerchunk.getAvailableChunkNow();
    }

    @Override
    public Level getLevel() {
        return this.level;
    }

    public boolean pollTask() {
        return this.mainThreadProcessor.pollTask();
    }

    public boolean runDistanceManagerUpdates() {
        return this.level.chunkTaskScheduler.chunkHolderManager.processTicketUpdates();
    }

    public boolean isPositionTicking(Entity entity) {
        return this.isPositionTicking(ChunkPos.asLong(Mth.floor(entity.getX()) >> 4, Mth.floor(entity.getZ()) >> 4));
    }

    public boolean isPositionTicking(long pos) {
        ChunkHolder holder = this.chunkMap.getVisibleChunkIfPresent(pos);
        return holder != null && holder.isTickingReady();
    }

    public void save(boolean flush) {
        this.runDistanceManagerUpdates();
        this.chunkMap.saveAllChunks(flush);
    }

    public void saveIncrementally() {
        this.runDistanceManagerUpdates();
        this.chunkMap.saveIncrementally();
    }

    @Override
    public void close() throws IOException {
        this.close(true);
    }

    public void close(boolean save) {
        this.level.chunkTaskScheduler.chunkHolderManager.close(save, true);
        try {
            this.dataStorage.close();
        }
        catch (IOException exception) {
            LOGGER.error("Failed to close persistent world data", (Throwable)exception);
        }
    }

    public void purgeUnload() {
    }

    @Override
    public void tick(BooleanSupplier shouldKeepTicking, boolean tickChunks) {
        this.level.getProfiler().push("purge");
        if (this.level.tickRateManager().runsNormally() || !tickChunks || this.level.spigotConfig.unloadFrozenChunks) {
            this.distanceManager.purgeStaleTickets();
        }
        this.runDistanceManagerUpdates();
        this.level.getProfiler().popPush("chunks");
        if (tickChunks) {
            this.chunkMap.level.playerChunkLoader.tick();
            this.tickChunks();
            this.chunkMap.tick();
        }
        this.level.getProfiler().popPush("unload");
        this.chunkMap.tick(shouldKeepTicking);
        this.level.getProfiler().pop();
        this.clearCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tickChunks() {
        long i = this.level.getGameTime();
        long j = i - this.lastInhabitedUpdate;
        this.lastInhabitedUpdate = i;
        if (!this.level.isDebug()) {
            ProfilerFiller gameprofilerfiller = this.level.getProfiler();
            gameprofilerfiller.push("pollingChunks");
            if (LeavesConfig.optimizeChunkTicking) {
                this.level.resetIceAndSnowTick();
            }
            gameprofilerfiller.push("filteringLoadedChunks");
            if (this.peacefulModeSwitchTick > 0) {
                if (this.level.getLevelData().getGameTime() % (long)this.peacefulModeSwitchTick == 0L) {
                    this.peacefulModeSwitchCount = 0;
                    this.level.getAllEntities().forEach(entity -> {
                        if (this.peacefulModeSwitchEntityTypes.contains(entity.getClass())) {
                            ++this.peacefulModeSwitchCount;
                        }
                    });
                }
            } else {
                this.peacefulModeSwitchCount = -1;
            }
            if (this.level.tickRateManager().runsNormally()) {
                Iterator<LevelChunk> chunkIterator;
                NaturalSpawner.SpawnState spawnercreature_d;
                int k;
                gameprofilerfiller.popPush("naturalSpawnCount");
                int naturalSpawnChunkCount = k = this.distanceManager.getNaturalSpawnChunkCount();
                if ((this.spawnFriendlies || this.spawnEnemies) && this.level.paperConfig().entities.spawning.perPlayerMobSpawns) {
                    for (ServerPlayer player : this.level.players) {
                        for (int ii = 0; ii < ServerPlayer.MOBCATEGORY_TOTAL_ENUMS; ++ii) {
                            player.mobCounts[ii] = 0;
                            int newBackoff = player.mobBackoffCounts[ii] - 1;
                            if (newBackoff < 0) {
                                newBackoff = 0;
                            }
                            player.mobBackoffCounts[ii] = newBackoff;
                        }
                    }
                    spawnercreature_d = NaturalSpawner.createState(naturalSpawnChunkCount, this.level.getAllEntities(), this::getFullChunk, null, true);
                } else {
                    spawnercreature_d = NaturalSpawner.createState(naturalSpawnChunkCount, this.level.getAllEntities(), this::getFullChunk, !this.level.paperConfig().entities.spawning.perPlayerMobSpawns ? new LocalMobCapCalculator(this.chunkMap) : null, false);
                }
                this.lastSpawnState = spawnercreature_d;
                gameprofilerfiller.popPush("spawnAndTick");
                boolean flag = this.level.getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING) && !this.level.players().isEmpty();
                ChunkMap playerChunkMap = this.chunkMap;
                for (ServerPlayer player : this.level.players) {
                    if (!player.affectsSpawning || player.isSpectator()) {
                        playerChunkMap.playerMobSpawnMap.remove(player);
                        player.playerNaturallySpawnedEvent = null;
                        player.lastEntitySpawnRadiusSquared = -1.0;
                        continue;
                    }
                    int chunkRange = this.level.spigotConfig.mobSpawnRange;
                    int viewDistance = ChunkSystem.getTickViewDistance(player);
                    chunkRange = chunkRange > viewDistance ? viewDistance : (int)chunkRange;
                    chunkRange = chunkRange > 8 ? 8 : chunkRange;
                    PlayerNaturallySpawnCreaturesEvent event = new PlayerNaturallySpawnCreaturesEvent((Player)player.getBukkitEntity(), (byte)chunkRange);
                    event.callEvent();
                    if (event.isCancelled() || event.getSpawnRadius() < 0) {
                        playerChunkMap.playerMobSpawnMap.remove(player);
                        player.playerNaturallySpawnedEvent = null;
                        player.lastEntitySpawnRadiusSquared = -1.0;
                        continue;
                    }
                    int range = Math.min(event.getSpawnRadius(), 8);
                    int chunkX = CoordinateUtils.getChunkCoordinate(player.getX());
                    int chunkZ = CoordinateUtils.getChunkCoordinate(player.getZ());
                    playerChunkMap.playerMobSpawnMap.addOrUpdate(player, chunkX, chunkZ, range);
                    player.lastEntitySpawnRadiusSquared = (range << 4) * (range << 4);
                    player.playerNaturallySpawnedEvent = event;
                }
                int l = this.level.getGameRules().getInt(GameRules.RULE_RANDOMTICKING);
                boolean flag1 = this.level.ticksPerSpawnCategory.getLong((Object)SpawnCategory.ANIMAL) != 0L && this.level.getLevelData().getGameTime() % this.level.ticksPerSpawnCategory.getLong((Object)SpawnCategory.ANIMAL) == 0L;
                int chunksTicked = 0;
                NearbyPlayers nearbyPlayers = this.chunkMap.getNearbyPlayers();
                if (this.level.paperConfig().entities.spawning.perPlayerMobSpawns) {
                    chunkIterator = this.tickingChunks.iterator();
                } else {
                    chunkIterator = this.tickingChunks.unsafeIterator();
                    ArrayList shuffled = Lists.newArrayListWithCapacity((int)this.tickingChunks.size());
                    while (chunkIterator.hasNext()) {
                        shuffled.add(chunkIterator.next());
                    }
                    Util.shuffle(shuffled, this.level.random);
                    chunkIterator = shuffled.iterator();
                }
                boolean peacefulModeSwitch = false;
                if (this.lastSpawnState != null && this.peacefulModeSwitchCount != -1 && this.peacefulModeSwitchCount >= NaturalSpawner.globalLimitForCategory(this.level, MobCategory.MONSTER, this.lastSpawnState.getSpawnableChunkCount())) {
                    peacefulModeSwitch = true;
                }
                try {
                    while (chunkIterator.hasNext()) {
                        double distance;
                        ServerPlayer player;
                        LevelChunk chunk1 = chunkIterator.next();
                        ChunkPos chunkcoordintpair = chunk1.getPos();
                        ReferenceList<ServerPlayer> playersNearby = nearbyPlayers.getPlayers(chunkcoordintpair, NearbyPlayers.NearbyMapType.SPAWN_RANGE);
                        if (playersNearby == null) continue;
                        Object[] rawData = playersNearby.getRawData();
                        boolean spawn = false;
                        boolean tick = false;
                        int len = playersNearby.size();
                        for (int itr = 0; itr < len && ((player = (ServerPlayer)rawData[itr]).isSpectator() || !((spawn |= player.lastEntitySpawnRadiusSquared >= (distance = ChunkMap.euclideanDistanceSquared(chunkcoordintpair, player))) & (tick |= 16384.0 >= distance))); ++itr) {
                        }
                        if (!tick || !chunk1.chunkStatus.isOrAfter(FullChunkStatus.ENTITY_TICKING)) continue;
                        chunk1.incrementInhabitedTime(j);
                        if (spawn && flag && (this.spawnEnemies || this.spawnFriendlies) && this.level.getWorldBorder().isWithinBounds(chunkcoordintpair)) {
                            NaturalSpawner.spawnForChunk(this.level, chunk1, spawnercreature_d, this.spawnFriendlies, this.spawnEnemies, flag1, peacefulModeSwitch);
                        }
                        this.level.tickChunk(chunk1, l);
                        if ((chunksTicked++ & 1) != 0) continue;
                        MinecraftServer.getServer().executeMidTickTasks();
                    }
                }
                finally {
                    if (chunkIterator instanceof IteratorSafeOrderedReferenceSet.Iterator) {
                        IteratorSafeOrderedReferenceSet.Iterator safeIterator = chunkIterator;
                        safeIterator.finishedIterating();
                    }
                }
                gameprofilerfiller.popPush("customSpawners");
                if (flag) {
                    this.level.tickCustomSpawners(this.spawnEnemies, this.spawnFriendlies);
                }
            }
            gameprofilerfiller.popPush("broadcast");
            if (!this.chunkMap.needsChangeBroadcasting.isEmpty()) {
                ReferenceOpenHashSet copy = this.chunkMap.needsChangeBroadcasting.clone();
                this.chunkMap.needsChangeBroadcasting.clear();
                for (ChunkHolder holder : copy) {
                    holder.broadcastChanges(holder.getFullChunkNowUnchecked());
                    if (!holder.needsBroadcastChanges()) continue;
                    this.chunkMap.needsChangeBroadcasting.add((Object)holder);
                }
            }
            gameprofilerfiller.pop();
            gameprofilerfiller.pop();
        }
    }

    private void getFullChunk(long pos, Consumer<LevelChunk> chunkConsumer) {
        LevelChunk chunk;
        ChunkHolder playerchunk = this.getVisibleChunkIfPresent(pos);
        if (playerchunk != null && (chunk = playerchunk.getFullChunkNow()) != null) {
            chunkConsumer.accept(chunk);
        }
    }

    @Override
    public String gatherStats() {
        return Integer.toString(this.getLoadedChunksCount());
    }

    @VisibleForTesting
    public int getPendingTasksCount() {
        return this.mainThreadProcessor.getPendingTasksCount();
    }

    public ChunkGenerator getGenerator() {
        return this.chunkMap.generator();
    }

    public ChunkGeneratorStructureState getGeneratorState() {
        return this.chunkMap.generatorState();
    }

    public RandomState randomState() {
        return this.chunkMap.randomState();
    }

    @Override
    public int getLoadedChunksCount() {
        return this.chunkMap.size();
    }

    public void blockChanged(BlockPos pos) {
        int j;
        int i = SectionPos.blockToSectionCoord(pos.getX());
        ChunkHolder playerchunk = this.getVisibleChunkIfPresent(ChunkPos.asLong(i, j = SectionPos.blockToSectionCoord(pos.getZ())));
        if (playerchunk != null) {
            playerchunk.blockChanged(pos);
        }
    }

    @Override
    public void onLightUpdate(LightLayer type, SectionPos pos) {
        this.mainThreadProcessor.execute(() -> {
            ChunkHolder playerchunk = this.getVisibleChunkIfPresent(pos.chunk().toLong());
            if (playerchunk != null) {
                playerchunk.sectionLightChanged(type, pos.y());
            }
        });
    }

    public <T> void addRegionTicket(TicketType<T> ticketType, ChunkPos pos, int radius, T argument) {
        this.distanceManager.addRegionTicket(ticketType, pos, radius, argument);
    }

    public <T> void removeRegionTicket(TicketType<T> ticketType, ChunkPos pos, int radius, T argument) {
        this.distanceManager.removeRegionTicket(ticketType, pos, radius, argument);
    }

    @Override
    public void updateChunkForced(ChunkPos pos, boolean forced) {
        this.distanceManager.updateChunkForced(pos, forced);
    }

    public void move(ServerPlayer player) {
        if (!player.isRemoved()) {
            this.chunkMap.move(player);
        }
    }

    public void removeEntity(Entity entity) {
        this.chunkMap.removeEntity(entity);
    }

    public void addEntity(Entity entity) {
        this.chunkMap.addEntity(entity);
    }

    public void broadcastAndSend(Entity entity, Packet<?> packet) {
        this.chunkMap.broadcastAndSend(entity, packet);
    }

    public void broadcast(Entity entity, Packet<?> packet) {
        this.chunkMap.broadcast(entity, packet);
    }

    public void setViewDistance(int watchDistance) {
        this.chunkMap.setServerViewDistance(watchDistance);
    }

    public void setSimulationDistance(int simulationDistance) {
        this.distanceManager.updateSimulationDistance(simulationDistance);
    }

    @Override
    public void setSpawnSettings(boolean spawnMonsters, boolean spawnAnimals) {
        this.spawnEnemies = spawnMonsters;
        this.spawnFriendlies = spawnAnimals;
    }

    public String getChunkDebugData(ChunkPos pos) {
        return this.chunkMap.getChunkDebugData(pos);
    }

    public DimensionDataStorage getDataStorage() {
        return this.dataStorage;
    }

    public PoiManager getPoiManager() {
        return this.chunkMap.getPoiManager();
    }

    public ChunkScanAccess chunkScanner() {
        return this.chunkMap.chunkScanner();
    }

    @Nullable
    @VisibleForDebug
    public NaturalSpawner.SpawnState getLastSpawnState() {
        return this.lastSpawnState;
    }

    public void removeTicketsOnClosing() {
        this.distanceManager.removeTicketsOnClosing();
    }

    private static /* synthetic */ boolean lambda$purgeUnload$4() {
        return true;
    }

    public final class MainThreadExecutor
    extends BlockableEventLoop<Runnable> {
        MainThreadExecutor(Level world) {
            super("Chunk source main thread executor for " + String.valueOf(world.dimension().location()));
        }

        @Override
        protected Runnable wrapRunnable(Runnable runnable) {
            return runnable;
        }

        @Override
        protected boolean shouldRun(Runnable task) {
            return true;
        }

        @Override
        protected boolean scheduleExecutables() {
            return true;
        }

        @Override
        protected Thread getRunningThread() {
            return ServerChunkCache.this.mainThread;
        }

        @Override
        protected void doRunTask(Runnable task) {
            ServerChunkCache.this.level.getProfiler().incrementCounter("runTask");
            super.doRunTask(task);
        }

        @Override
        public boolean pollTask() {
            if (ServerChunkCache.this.runDistanceManagerUpdates()) {
                return true;
            }
            return super.pollTask() | ServerChunkCache.this.level.chunkTaskScheduler.executeMainThreadTask();
        }
    }

    private record ChunkAndHolder(LevelChunk chunk, ChunkHolder holder) {
    }
}

