/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import io.papermc.paper.configuration.GlobalConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBundlePacket;
import net.minecraft.network.protocol.game.ClientboundMoveEntityPacket;
import net.minecraft.network.protocol.game.ClientboundProjectilePowerPacket;
import net.minecraft.network.protocol.game.ClientboundRemoveEntitiesPacket;
import net.minecraft.network.protocol.game.ClientboundRotateHeadPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityDataPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityLinkPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.network.protocol.game.ClientboundSetEquipmentPacket;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.network.protocol.game.ClientboundTeleportEntityPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateAttributesPacket;
import net.minecraft.network.protocol.game.VecDeltaCodec;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.phys.Vec3;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerVelocityEvent;
import org.bukkit.util.Vector;
import org.leavesmc.leaves.LeavesConfig;
import org.slf4j.Logger;

public class ServerEntity {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int TOLERANCE_LEVEL_ROTATION = 1;
    private static final double TOLERANCE_LEVEL_POSITION = 7.62939453125E-6;
    public static final int FORCED_POS_UPDATE_PERIOD = 60;
    private static final int FORCED_TELEPORT_PERIOD = 400;
    private final ServerLevel level;
    private final Entity entity;
    private final int updateInterval;
    private final boolean trackDelta;
    private final Consumer<Packet<?>> broadcast;
    private final VecDeltaCodec positionCodec = new VecDeltaCodec();
    private int yRotp;
    private int xRotp;
    private int yHeadRotp;
    private Vec3 ap;
    private int tickCount;
    private int teleportDelay;
    private List<Entity> lastPassengers;
    private boolean wasRiding;
    private boolean wasOnGround;
    @Nullable
    private List<SynchedEntityData.DataValue<?>> trackedDataValues;
    private final Set<ServerPlayerConnection> trackedPlayers;
    private boolean forceStateResync;

    public ServerEntity(ServerLevel worldserver, Entity entity, int i, boolean flag, Consumer<Packet<?>> consumer, Set<ServerPlayerConnection> trackedPlayers) {
        this.trackedPlayers = trackedPlayers;
        this.ap = Vec3.ZERO;
        this.lastPassengers = ImmutableList.of();
        this.level = worldserver;
        this.broadcast = consumer;
        this.entity = entity;
        this.updateInterval = i;
        this.trackDelta = flag;
        this.positionCodec.setBase(entity.trackingPosition());
        this.yRotp = Mth.floor(entity.getYRot() * 256.0f / 360.0f);
        this.xRotp = Mth.floor(entity.getXRot() * 256.0f / 360.0f);
        this.yHeadRotp = Mth.floor(entity.getYHeadRot() * 256.0f / 360.0f);
        this.wasOnGround = entity.onGround();
        this.trackedDataValues = entity.getEntityData().getNonDefaultValues();
    }

    public void onPlayerAdd() {
        this.forceStateResync = true;
    }

    public void sendChanges() {
        List<Entity> list = this.entity.getPassengers();
        if (!list.equals(this.lastPassengers)) {
            this.broadcastAndSend(new ClientboundSetPassengersPacket(this.entity));
            ServerEntity.removedPassengers(list, this.lastPassengers).forEach(entity -> {
                if (entity instanceof ServerPlayer) {
                    ServerPlayer entityplayer = (ServerPlayer)entity;
                    entityplayer.connection.teleport(entityplayer.getX(), entityplayer.getY(), entityplayer.getZ(), entityplayer.getYRot(), entityplayer.getXRot());
                }
            });
            this.lastPassengers = list;
        }
        Entity entity2 = this.entity;
        if (!this.trackedPlayers.isEmpty() && entity2 instanceof ItemFrame) {
            MapId mapid;
            MapItemSavedData worldmap;
            ItemFrame entityitemframe = (ItemFrame)entity2;
            ItemStack itemstack = entityitemframe.getItem();
            if (this.level.paperConfig().maps.itemFrameCursorUpdateInterval > 0 && this.tickCount % this.level.paperConfig().maps.itemFrameCursorUpdateInterval == 0 && itemstack.getItem() instanceof MapItem && (worldmap = MapItem.getSavedData(mapid = entityitemframe.cachedMapId, (Level)this.level)) != null) {
                Iterator<ServerPlayerConnection> iterator = this.trackedPlayers.iterator();
                while (iterator.hasNext()) {
                    ServerPlayer entityplayer = iterator.next().getPlayer();
                    worldmap.tickCarriedBy(entityplayer, itemstack);
                    Packet<?> packet = worldmap.getUpdatePacket(mapid, entityplayer);
                    if (packet == null) continue;
                    entityplayer.connection.send(packet);
                }
            }
            this.sendDirtyEntityData();
        }
        if (this.forceStateResync || this.tickCount % this.updateInterval == 0 || this.entity.hasImpulse || this.entity.getEntityData().isDirty()) {
            int i;
            if (this.entity.isPassenger()) {
                boolean flag;
                i = Mth.floor(this.entity.getYRot() * 256.0f / 360.0f);
                j = Mth.floor(this.entity.getXRot() * 256.0f / 360.0f);
                boolean bl = flag = Math.abs(i - this.yRotp) >= 1 || Math.abs(j - this.xRotp) >= 1;
                if (flag) {
                    this.broadcast.accept(new ClientboundMoveEntityPacket.Rot(this.entity.getId(), (byte)i, (byte)j, this.entity.onGround()));
                    this.yRotp = i;
                    this.xRotp = j;
                }
                this.positionCodec.setBase(this.entity.trackingPosition());
                this.sendDirtyEntityData();
                this.wasRiding = true;
            } else {
                Vec3 vec3d1;
                double d0;
                ++this.teleportDelay;
                i = Mth.floor(this.entity.getYRot() * 256.0f / 360.0f);
                j = Mth.floor(this.entity.getXRot() * 256.0f / 360.0f);
                Vec3 vec3d = this.entity.trackingPosition();
                Vec3 base = this.positionCodec.base;
                double vec3d_dx = vec3d.x - base.x;
                double vec3d_dy = vec3d.y - base.y;
                double vec3d_dz = vec3d.z - base.z;
                boolean flag1 = vec3d_dx * vec3d_dx + vec3d_dy * vec3d_dy + vec3d_dz * vec3d_dz >= 7.62939453125E-6;
                Packet<ClientGamePacketListener> packet1 = null;
                boolean flag2 = flag1 || this.tickCount % 60 == 0;
                boolean flag3 = Math.abs(i - this.yRotp) >= 1 || Math.abs(j - this.xRotp) >= 1;
                boolean flag4 = false;
                boolean flag5 = false;
                if (this.forceStateResync || !(this.entity instanceof HangingEntity) || this.tickCount > 0 || this.entity instanceof AbstractArrow) {
                    boolean flag6;
                    long k = this.positionCodec.encodeX(vec3d);
                    long l = this.positionCodec.encodeY(vec3d);
                    long i1 = this.positionCodec.encodeZ(vec3d);
                    boolean bl = flag6 = k < -32768L || k > 32767L || l < -32768L || l > 32767L || i1 < -32768L || i1 > 32767L;
                    if (!(this.forceStateResync || flag6 || this.teleportDelay > 400 || this.wasRiding || this.wasOnGround != this.entity.onGround() || GlobalConfiguration.get().collisions.sendFullPosForHardCollidingEntities && this.entity.hardCollides())) {
                        if (!(flag2 && flag3 || this.entity instanceof AbstractArrow)) {
                            if (flag2) {
                                packet1 = new ClientboundMoveEntityPacket.Pos(this.entity.getId(), (short)k, (short)l, (short)i1, this.entity.onGround());
                                flag4 = true;
                            } else if (flag3) {
                                packet1 = new ClientboundMoveEntityPacket.Rot(this.entity.getId(), (byte)i, (byte)j, this.entity.onGround());
                                flag5 = true;
                            }
                        } else {
                            packet1 = new ClientboundMoveEntityPacket.PosRot(this.entity.getId(), (short)k, (short)l, (short)i1, (byte)i, (byte)j, this.entity.onGround());
                            flag4 = true;
                            flag5 = true;
                        }
                    } else {
                        this.wasOnGround = this.entity.onGround();
                        this.teleportDelay = 0;
                        packet1 = new ClientboundTeleportEntityPacket(this.entity);
                        flag4 = true;
                        flag5 = true;
                    }
                    if (LeavesConfig.dontSendUselessEntityPackets && this.isUselessPacket(packet1)) {
                        packet1 = null;
                    }
                }
                if ((this.trackDelta || this.entity.hasImpulse || this.entity instanceof LivingEntity && ((LivingEntity)this.entity).isFallFlying()) && this.tickCount > 0 && ((d0 = (vec3d1 = this.entity.getDeltaMovement()).distanceToSqr(this.ap)) > 1.0E-7 || d0 > 0.0 && vec3d1.lengthSqr() == 0.0)) {
                    this.ap = vec3d1;
                    this.broadcast.accept(new ClientboundSetEntityMotionPacket(this.entity.getId(), this.ap));
                }
                if (packet1 != null) {
                    this.broadcast.accept(packet1);
                }
                this.sendDirtyEntityData();
                if (flag4) {
                    this.positionCodec.setBase(vec3d);
                }
                if (flag5) {
                    this.yRotp = i;
                    this.xRotp = j;
                }
                this.wasRiding = false;
            }
            i = Mth.floor(this.entity.getYHeadRot() * 256.0f / 360.0f);
            if (Math.abs(i - this.yHeadRotp) >= 1) {
                this.broadcast.accept(new ClientboundRotateHeadPacket(this.entity, (byte)i));
                this.yHeadRotp = i;
            }
            this.entity.hasImpulse = false;
            this.forceStateResync = false;
        }
        ++this.tickCount;
        if (this.entity.hurtMarked) {
            boolean cancelled = false;
            if (this.entity instanceof ServerPlayer) {
                Player player = (Player)this.entity.getBukkitEntity();
                Vector velocity = player.getVelocity();
                PlayerVelocityEvent event = new PlayerVelocityEvent(player, velocity.clone());
                this.entity.level().getCraftServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    cancelled = true;
                } else if (!velocity.equals((Object)event.getVelocity())) {
                    player.setVelocity(event.getVelocity());
                }
            }
            if (!cancelled) {
                this.broadcastAndSend(new ClientboundSetEntityMotionPacket(this.entity));
            }
            if ((entity2 = this.entity) instanceof AbstractHurtingProjectile) {
                AbstractHurtingProjectile entityfireball = (AbstractHurtingProjectile)entity2;
                this.broadcastAndSend(new ClientboundProjectilePowerPacket(entityfireball.getId(), entityfireball.xPower, entityfireball.yPower, entityfireball.zPower));
            }
            this.entity.hurtMarked = false;
        }
    }

    private static Stream<Entity> removedPassengers(List<Entity> passengers, List<Entity> lastPassengers) {
        return lastPassengers.stream().filter(entity -> !passengers.contains(entity));
    }

    private boolean isUselessPacket(Packet<?> possibleUselessPacket) {
        if (possibleUselessPacket instanceof ClientboundMoveEntityPacket) {
            ClientboundMoveEntityPacket packet = (ClientboundMoveEntityPacket)possibleUselessPacket;
            if (possibleUselessPacket instanceof ClientboundMoveEntityPacket.Pos) {
                return packet.getXa() == 0 && packet.getYa() == 0 && packet.getZa() == 0;
            }
            if (possibleUselessPacket instanceof ClientboundMoveEntityPacket.PosRot) {
                return packet.getXa() == 0 && packet.getYa() == 0 && packet.getZa() == 0 && packet.getyRot() == 0 && packet.getxRot() == 0;
            }
            if (possibleUselessPacket instanceof ClientboundMoveEntityPacket.Rot) {
                return packet.getyRot() == 0 && packet.getxRot() == 0;
            }
        }
        return false;
    }

    public void removePairing(ServerPlayer player) {
        this.entity.stopSeenByPlayer(player);
        player.connection.send(new ClientboundRemoveEntitiesPacket(this.entity.getId()));
    }

    public void addPairing(ServerPlayer player) {
        ArrayList<Packet<? super ClientGamePacketListener>> list = new ArrayList<Packet<? super ClientGamePacketListener>>();
        Objects.requireNonNull(list);
        this.sendPairingData(player, list::add);
        player.connection.send(new ClientboundBundlePacket((Iterable<Packet<? super ClientGamePacketListener>>)list));
        this.entity.startSeenByPlayer(player);
    }

    public void sendPairingData(ServerPlayer player, Consumer<Packet<ClientGamePacketListener>> sender) {
        Mob entityinsentient;
        Entity entity;
        if (this.entity.isRemoved()) {
            return;
        }
        Packet<ClientGamePacketListener> packet = this.entity.getAddEntityPacket();
        this.yHeadRotp = Mth.floor(this.entity.getYHeadRot() * 256.0f / 360.0f);
        sender.accept(packet);
        if (this.trackedDataValues != null) {
            sender.accept(new ClientboundSetEntityDataPacket(this.entity.getId(), this.trackedDataValues));
        }
        boolean flag = this.trackDelta;
        if (this.entity instanceof LivingEntity) {
            Collection<AttributeInstance> collection = ((LivingEntity)this.entity).getAttributes().getSyncableAttributes();
            if (this.entity.getId() == player.getId()) {
                ((ServerPlayer)this.entity).getBukkitEntity().injectScaledMaxHealth(collection, false);
            }
            if (!collection.isEmpty()) {
                sender.accept(new ClientboundUpdateAttributesPacket(this.entity.getId(), collection));
            }
            if (((LivingEntity)this.entity).isFallFlying()) {
                flag = true;
            }
        }
        this.ap = this.entity.getDeltaMovement();
        if (flag && !(this.entity instanceof LivingEntity)) {
            sender.accept(new ClientboundSetEntityMotionPacket(this.entity.getId(), this.ap));
        }
        if (this.entity instanceof LivingEntity) {
            ArrayList list = Lists.newArrayList();
            for (EquipmentSlot enumitemslot : EquipmentSlot.VALUES) {
                ItemStack itemstack = ((LivingEntity)this.entity).getItemBySlot(enumitemslot);
                if (itemstack.isEmpty()) continue;
                list.add(Pair.of((Object)enumitemslot, (Object)itemstack.copy()));
            }
            if (!list.isEmpty()) {
                sender.accept(new ClientboundSetEquipmentPacket(this.entity.getId(), list, true));
            }
            ((LivingEntity)this.entity).detectEquipmentUpdatesPublic();
        }
        if (!this.entity.getPassengers().isEmpty()) {
            sender.accept(new ClientboundSetPassengersPacket(this.entity));
        }
        if (this.entity.isPassenger()) {
            sender.accept(new ClientboundSetPassengersPacket(this.entity.getVehicle()));
        }
        if ((entity = this.entity) instanceof Mob && (entityinsentient = (Mob)entity).isLeashed()) {
            sender.accept(new ClientboundSetEntityLinkPacket(entityinsentient, entityinsentient.getLeashHolder()));
        }
    }

    private void sendDirtyEntityData() {
        SynchedEntityData datawatcher = this.entity.getEntityData();
        List<SynchedEntityData.DataValue<?>> list = datawatcher.packDirty();
        if (list != null) {
            this.trackedDataValues = datawatcher.getNonDefaultValues();
            this.broadcastAndSend(new ClientboundSetEntityDataPacket(this.entity.getId(), list));
        }
        if (this.entity instanceof LivingEntity) {
            Set<AttributeInstance> set = ((LivingEntity)this.entity).getAttributes().getDirtyAttributes();
            if (!set.isEmpty()) {
                if (this.entity instanceof ServerPlayer) {
                    ((ServerPlayer)this.entity).getBukkitEntity().injectScaledMaxHealth(set, false);
                }
                this.broadcastAndSend(new ClientboundUpdateAttributesPacket(this.entity.getId(), set));
            }
            set.clear();
        }
    }

    private void broadcastAndSend(Packet<?> packet) {
        this.broadcast.accept(packet);
        if (this.entity instanceof ServerPlayer) {
            ((ServerPlayer)this.entity).connection.send(packet);
        }
    }
}

