/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.network.FilteredText;

public record Filterable<T>(T raw, Optional<T> filtered) {
    public static <T> Codec<Filterable<T>> codec(Codec<T> baseCodec) {
        Codec codec = RecordCodecBuilder.create(instance -> instance.group((App)baseCodec.fieldOf("raw").forGetter(Filterable::raw), (App)baseCodec.optionalFieldOf("filtered").forGetter(Filterable::filtered)).apply((Applicative)instance, Filterable::new));
        Codec codec2 = baseCodec.xmap(Filterable::passThrough, Filterable::raw);
        return Codec.withAlternative((Codec)codec, (Codec)codec2);
    }

    public static <B extends ByteBuf, T> StreamCodec<B, Filterable<T>> streamCodec(StreamCodec<B, T> basePacketCodec) {
        return StreamCodec.composite(basePacketCodec, Filterable::raw, basePacketCodec.apply(ByteBufCodecs::optional), Filterable::filtered, Filterable::new);
    }

    public static <T> Filterable<T> passThrough(T raw) {
        return new Filterable<T>(raw, Optional.empty());
    }

    public static Filterable<String> from(FilteredText message) {
        return new Filterable<String>(message.raw(), message.isFiltered() ? Optional.of(message.filteredOrEmpty()) : Optional.empty());
    }

    public T get(boolean shouldFilter) {
        if (shouldFilter) {
            return this.filtered.orElse(this.raw);
        }
        return this.raw;
    }

    public <U> Filterable<U> map(Function<T, U> mapper) {
        return new Filterable<U>(mapper.apply(this.raw), this.filtered.map(mapper));
    }

    public <U> Optional<Filterable<U>> resolve(Function<T, Optional<U>> resolver) {
        Optional<U> optional = resolver.apply(this.raw);
        if (optional.isEmpty()) {
            return Optional.empty();
        }
        if (this.filtered.isPresent()) {
            Optional<U> optional2 = resolver.apply(this.filtered.get());
            if (optional2.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(new Filterable<U>(optional.get(), optional2));
        }
        return Optional.of(new Filterable<U>(optional.get(), Optional.empty()));
    }
}

