/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.google.common.collect.Comparators;
import com.mojang.logging.LogUtils;
import io.papermc.paper.event.packet.PlayerChunkLoadEvent;
import io.papermc.paper.event.packet.PlayerChunkUnloadEvent;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.network.protocol.game.ClientboundForgetLevelChunkPacket;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.LevelChunk;
import org.bukkit.Chunk;
import org.bukkit.craftbukkit.CraftChunk;
import org.bukkit.entity.Player;
import org.slf4j.Logger;

public class PlayerChunkSender {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final float MIN_CHUNKS_PER_TICK = 0.01f;
    public static final float MAX_CHUNKS_PER_TICK = 64.0f;
    private static final float START_CHUNKS_PER_TICK = 9.0f;
    private static final int MAX_UNACKNOWLEDGED_BATCHES = 10;
    private final LongSet pendingChunks = new LongOpenHashSet();
    private final boolean memoryConnection;
    private float desiredChunksPerTick = 9.0f;
    private float batchQuota;
    private int unacknowledgedBatches;
    private int maxUnacknowledgedBatches = 1;

    public PlayerChunkSender(boolean local) {
        this.memoryConnection = local;
    }

    public void markChunkPendingToSend(LevelChunk chunk) {
        this.pendingChunks.add(chunk.getPos().toLong());
    }

    public void dropChunk(ServerPlayer player, ChunkPos pos) {
        if (!this.pendingChunks.remove(pos.toLong()) && player.isAlive()) {
            PlayerChunkSender.dropChunkStatic(player, pos);
        }
    }

    public static void dropChunkStatic(ServerPlayer player, ChunkPos pos) {
        player.serverLevel().chunkSource.chunkMap.getVisibleChunkIfPresent(pos.toLong()).removePlayer(player);
        player.connection.send(new ClientboundForgetLevelChunkPacket(pos));
        if (PlayerChunkUnloadEvent.getHandlerList().getRegisteredListeners().length > 0) {
            new PlayerChunkUnloadEvent(player.getBukkitEntity().getWorld().getChunkAt(pos.longKey), (Player)player.getBukkitEntity()).callEvent();
        }
    }

    public void sendNextChunks(ServerPlayer player) {
    }

    public static void sendChunk(ServerGamePacketListenerImpl handler, ServerLevel world, LevelChunk chunk) {
        handler.player.serverLevel().chunkSource.chunkMap.getVisibleChunkIfPresent(chunk.getPos().toLong()).addPlayer(handler.player);
        boolean shouldModify = world.chunkPacketBlockController.shouldModify(handler.player, chunk);
        handler.send(new ClientboundLevelChunkWithLightPacket(chunk, world.getLightEngine(), null, null, shouldModify));
        if (PlayerChunkLoadEvent.getHandlerList().getRegisteredListeners().length > 0) {
            new PlayerChunkLoadEvent((Chunk)new CraftChunk(chunk), (Player)handler.getPlayer().getBukkitEntity()).callEvent();
        }
        ChunkPos chunkPos = chunk.getPos();
        DebugPackets.sendPoiPacketsForChunk(world, chunkPos);
    }

    private List<LevelChunk> collectChunksToSend(ChunkMap chunkStorage, ChunkPos playerPos) {
        int i = Mth.floor(this.batchQuota);
        List<LevelChunk> list2 = !this.memoryConnection && this.pendingChunks.size() > i ? ((List)this.pendingChunks.stream().collect(Comparators.least((int)i, Comparator.comparingInt(playerPos::distanceSquared)))).stream().mapToLong(Long::longValue).mapToObj(chunkStorage::getChunkToSend).filter(Objects::nonNull).toList() : this.pendingChunks.longStream().mapToObj(chunkStorage::getChunkToSend).filter(Objects::nonNull).sorted(Comparator.comparingInt(chunk -> playerPos.distanceSquared(chunk.getPos()))).toList();
        for (LevelChunk levelChunk : list2) {
            this.pendingChunks.remove(levelChunk.getPos().toLong());
        }
        return list2;
    }

    public void onChunkBatchReceivedByClient(float desiredBatchSize) {
    }

    public boolean isPending(long chunkPos) {
        return this.pendingChunks.contains(chunkPos);
    }
}

