/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.destroystokyo.paper.network.StandardPaperServerListPingEventImpl;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.ping.ClientboundPongResponsePacket;
import net.minecraft.network.protocol.ping.ServerboundPingRequestPacket;
import net.minecraft.network.protocol.status.ServerStatus;
import net.minecraft.network.protocol.status.ServerStatusPacketListener;
import net.minecraft.network.protocol.status.ServerboundStatusRequestPacket;
import net.minecraft.server.MinecraftServer;
import org.leavesmc.leaves.LeavesConfig;

public class ServerStatusPacketListenerImpl
implements ServerStatusPacketListener {
    private static final Component DISCONNECT_REASON = Component.translatable("multiplayer.status.request_handled");
    private final ServerStatus status;
    private final Connection connection;
    private boolean hasRequestedStatus;

    public ServerStatusPacketListenerImpl(ServerStatus metadata, Connection connection) {
        this.status = metadata;
        this.connection = connection;
    }

    @Override
    public void onDisconnect(Component reason) {
    }

    @Override
    public boolean isAcceptingMessages() {
        return this.connection.isConnected();
    }

    @Override
    public void handleStatusRequest(ServerboundStatusRequestPacket packet) {
        if (this.hasRequestedStatus) {
            this.connection.disconnect(DISCONNECT_REASON);
        } else {
            this.hasRequestedStatus = true;
            ServerStatus status = MinecraftServer.getServer().getStatus();
            if (LeavesConfig.dontRespondPingBeforeStart && (status == null || status.version() == null || status.version().isEmpty())) {
                return;
            }
            StandardPaperServerListPingEventImpl.processRequest(MinecraftServer.getServer(), this.connection);
        }
    }

    @Override
    public void handlePingRequest(ServerboundPingRequestPacket packet) {
        this.connection.send(new ClientboundPongResponsePacket(packet.getTime()));
        this.connection.disconnect(DISCONNECT_REASON);
    }
}

