/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.util.GsonHelper;

public interface ResourceMetadata {
    public static final ResourceMetadata EMPTY = new ResourceMetadata(){

        @Override
        @Override
        public <T> Optional<T> getSection(MetadataSectionSerializer<T> reader) {
            return Optional.empty();
        }
    };
    public static final IoSupplier<ResourceMetadata> EMPTY_SUPPLIER = () -> EMPTY;

    public static ResourceMetadata fromJsonStream(InputStream stream) throws IOException {
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
            final JsonObject jsonObject = GsonHelper.parse(bufferedReader);
            ResourceMetadata resourceMetadata = new ResourceMetadata(){

                @Override
                @Override
                public <T> Optional<T> getSection(MetadataSectionSerializer<T> reader) {
                    String string = reader.getMetadataSectionName();
                    return jsonObject.has(string) ? Optional.of(reader.fromJson(GsonHelper.getAsJsonObject(jsonObject, string))) : Optional.empty();
                }
            };
            return resourceMetadata;
        }
    }

    public <T> Optional<T> getSection(MetadataSectionSerializer<T> var1);

    default public ResourceMetadata copySections(Collection<MetadataSectionSerializer<?>> readers) {
        Builder builder = new Builder();
        for (MetadataSectionSerializer<?> metadataSectionSerializer : readers) {
            this.copySection(builder, metadataSectionSerializer);
        }
        return builder.build();
    }

    private <T> void copySection(Builder builder, MetadataSectionSerializer<T> reader) {
        this.getSection(reader).ifPresent(value -> builder.put(reader, value));
    }

    public static class Builder {
        private final ImmutableMap.Builder<MetadataSectionSerializer<?>, Object> map = ImmutableMap.builder();

        public <T> Builder put(MetadataSectionSerializer<T> reader, T value) {
            this.map.put(reader, value);
            return this;
        }

        public ResourceMetadata build() {
            final ImmutableMap immutableMap = this.map.build();
            if (immutableMap.isEmpty()) {
                return EMPTY;
            }
            return new ResourceMetadata(){

                @Override
                @Override
                public <T> Optional<T> getSection(MetadataSectionSerializer<T> reader) {
                    return Optional.ofNullable(immutableMap.get(reader));
                }
            };
        }
    }
}

