/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.Util;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ProfiledReloadInstance;
import net.minecraft.server.packs.resources.ReloadInstance;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.Unit;
import net.minecraft.util.profiling.InactiveProfiler;

public class SimpleReloadInstance<S>
implements ReloadInstance {
    private static final int PREPARATION_PROGRESS_WEIGHT = 2;
    private static final int EXTRA_RELOAD_PROGRESS_WEIGHT = 2;
    private static final int LISTENER_PROGRESS_WEIGHT = 1;
    protected final CompletableFuture<Unit> allPreparations = new CompletableFuture();
    protected CompletableFuture<List<S>> allDone;
    final Set<PreparableReloadListener> preparingListeners;
    private final int listenerCount;
    private int startedReloads;
    private int finishedReloads;
    private final AtomicInteger startedTaskCounter = new AtomicInteger();
    private final AtomicInteger doneTaskCounter = new AtomicInteger();

    public static SimpleReloadInstance<Void> of(ResourceManager manager, List<PreparableReloadListener> reloaders, Executor prepareExecutor, Executor applyExecutor, CompletableFuture<Unit> initialStage) {
        return new SimpleReloadInstance<Void>(prepareExecutor, applyExecutor, manager, reloaders, (synchronizer, resourceManager, reloader, prepare, apply) -> reloader.reload(synchronizer, resourceManager, InactiveProfiler.INSTANCE, InactiveProfiler.INSTANCE, prepareExecutor, apply), initialStage);
    }

    protected SimpleReloadInstance(Executor prepareExecutor, final Executor applyExecutor, ResourceManager manager, List<PreparableReloadListener> reloaders, StateFactory<S> factory, CompletableFuture<Unit> initialStage) {
        this.listenerCount = reloaders.size();
        this.startedTaskCounter.incrementAndGet();
        initialStage.thenRun(this.doneTaskCounter::incrementAndGet);
        ArrayList list = Lists.newArrayList();
        CompletableFuture<Unit> completableFuture = initialStage;
        this.preparingListeners = Sets.newHashSet(reloaders);
        for (final PreparableReloadListener preparableReloadListener : reloaders) {
            final CompletableFuture<Unit> completableFuture2 = completableFuture;
            CompletableFuture<S> completableFuture3 = factory.create(new PreparableReloadListener.PreparationBarrier(){

                @Override
                @Override
                public <T> CompletableFuture<T> wait(T preparedObject) {
                    applyExecutor.execute(() -> {
                        SimpleReloadInstance.this.preparingListeners.remove(preparableReloadListener);
                        if (SimpleReloadInstance.this.preparingListeners.isEmpty()) {
                            SimpleReloadInstance.this.allPreparations.complete(Unit.INSTANCE);
                        }
                    });
                    return SimpleReloadInstance.this.allPreparations.thenCombine((CompletionStage)completableFuture2, (unit, object2) -> preparedObject);
                }
            }, manager, preparableReloadListener, preparation -> {
                this.startedTaskCounter.incrementAndGet();
                prepareExecutor.execute(() -> {
                    preparation.run();
                    this.doneTaskCounter.incrementAndGet();
                });
            }, application -> {
                ++this.startedReloads;
                applyExecutor.execute(() -> {
                    application.run();
                    ++this.finishedReloads;
                });
            });
            list.add(completableFuture3);
            completableFuture = completableFuture3;
        }
        this.allDone = Util.sequenceFailFast(list);
    }

    @Override
    @Override
    public CompletableFuture<?> done() {
        return this.allDone;
    }

    @Override
    @Override
    public float getActualProgress() {
        int i = this.listenerCount - this.preparingListeners.size();
        float f = this.doneTaskCounter.get() * 2 + this.finishedReloads * 2 + i * 1;
        float g = this.startedTaskCounter.get() * 2 + this.startedReloads * 2 + this.listenerCount * 1;
        return f / g;
    }

    public static ReloadInstance create(ResourceManager manager, List<PreparableReloadListener> reloaders, Executor prepareExecutor, Executor applyExecutor, CompletableFuture<Unit> initialStage, boolean profiled) {
        if (profiled) {
            return new ProfiledReloadInstance(manager, reloaders, prepareExecutor, applyExecutor, initialStage);
        }
        return SimpleReloadInstance.of(manager, reloaders, prepareExecutor, applyExecutor, initialStage);
    }

    protected static interface StateFactory<S> {
        public CompletableFuture<S> create(PreparableReloadListener.PreparationBarrier var1, ResourceManager var2, PreparableReloadListener var3, Executor var4, Executor var5);
    }
}

