/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.players;

import com.destroystokyo.paper.exception.ServerInternalException;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.ProfileLookupCallback;
import com.mojang.authlib.yggdrasil.ProfileNotFoundException;
import com.mojang.logging.LogUtils;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.util.StacktraceDeobfuscator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.players.BanListEntry;
import net.minecraft.server.players.IpBanList;
import net.minecraft.server.players.IpBanListEntry;
import net.minecraft.server.players.PlayerList;
import net.minecraft.server.players.ServerOpList;
import net.minecraft.server.players.ServerOpListEntry;
import net.minecraft.server.players.UserBanList;
import net.minecraft.server.players.UserBanListEntry;
import net.minecraft.server.players.UserWhiteList;
import net.minecraft.server.players.UserWhiteListEntry;
import net.minecraft.util.StringUtil;
import net.minecraft.world.level.storage.LevelResource;
import org.slf4j.Logger;

public class OldUsersConverter {
    static final Logger LOGGER = LogUtils.getLogger();
    public static final File OLD_IPBANLIST = new File("banned-ips.txt");
    public static final File OLD_USERBANLIST = new File("banned-players.txt");
    public static final File OLD_OPLIST = new File("ops.txt");
    public static final File OLD_WHITELIST = new File("white-list.txt");

    static List<String> readOldListFormat(File file, Map<String, String[]> valueMap) throws IOException {
        List list = Files.readLines((File)file, (Charset)StandardCharsets.UTF_8);
        for (String s : list) {
            if ((s = s.trim()).startsWith("#") || s.length() < 1) continue;
            String[] astring = s.split("\\|");
            valueMap.put(astring[0].toLowerCase(Locale.ROOT), astring);
        }
        return list;
    }

    private static void lookupPlayers(MinecraftServer server, Collection<String> bannedPlayers, ProfileLookupCallback callback) {
        String[] astring = (String[])bannedPlayers.stream().filter(s -> !StringUtil.isNullOrEmpty(s)).toArray(String[]::new);
        if (server.usesAuthentication() || GlobalConfiguration.get().proxies.isProxyOnlineMode()) {
            server.getProfileRepository().findProfilesByNames(astring, callback);
        } else {
            String[] astring1 = astring;
            int i = astring.length;
            for (int j = 0; j < i; ++j) {
                String s2 = astring1[j];
                callback.onProfileLookupSucceeded(UUIDUtil.createOfflineProfile(s2));
            }
        }
    }

    public static boolean convertUserBanlist(final MinecraftServer server) {
        final UserBanList gameprofilebanlist = new UserBanList(PlayerList.USERBANLIST_FILE);
        if (OLD_USERBANLIST.exists() && OLD_USERBANLIST.isFile()) {
            if (gameprofilebanlist.getFile().exists()) {
                try {
                    gameprofilebanlist.load();
                }
                catch (IOException ioexception) {
                    LOGGER.warn("Could not load existing file {}", (Object)gameprofilebanlist.getFile().getName());
                }
            }
            try {
                final HashMap map = Maps.newHashMap();
                OldUsersConverter.readOldListFormat(OLD_USERBANLIST, map);
                ProfileLookupCallback profilelookupcallback = new ProfileLookupCallback(){

                    public void onProfileLookupSucceeded(GameProfile gameprofile) {
                        server.getProfileCache().add(gameprofile);
                        String[] astring = (String[])map.get(gameprofile.getName().toLowerCase(Locale.ROOT));
                        if (astring == null) {
                            LOGGER.warn("Could not convert user banlist entry for {}", (Object)gameprofile.getName());
                            throw new ConversionError("Profile not in the conversionlist");
                        }
                        Date date = astring.length > 1 ? OldUsersConverter.parseDate(astring[1], null) : null;
                        String s = astring.length > 2 ? astring[2] : null;
                        Date date1 = astring.length > 3 ? OldUsersConverter.parseDate(astring[3], null) : null;
                        String s1 = astring.length > 4 ? astring[4] : null;
                        gameprofilebanlist.add(new UserBanListEntry(gameprofile, date, s, date1, s1));
                    }

                    public void onProfileLookupFailed(String s, Exception exception) {
                        LOGGER.warn("Could not lookup user banlist entry for {}", (Object)s, (Object)exception);
                        if (!(exception instanceof ProfileNotFoundException)) {
                            throw new ConversionError("Could not request user " + s + " from backend systems", exception);
                        }
                    }
                };
                OldUsersConverter.lookupPlayers(server, map.keySet(), profilelookupcallback);
                gameprofilebanlist.save();
                OldUsersConverter.renameOldFile(OLD_USERBANLIST);
                return true;
            }
            catch (IOException ioexception1) {
                LOGGER.warn("Could not read old user banlist to convert it!", (Throwable)ioexception1);
                return false;
            }
            catch (ConversionError namereferencingfileconverter_fileconversionexception) {
                LOGGER.error("Conversion failed, please try again later", (Throwable)namereferencingfileconverter_fileconversionexception);
                return false;
            }
        }
        return true;
    }

    public static boolean convertIpBanlist(MinecraftServer server) {
        IpBanList ipbanlist = new IpBanList(PlayerList.IPBANLIST_FILE);
        if (OLD_IPBANLIST.exists() && OLD_IPBANLIST.isFile()) {
            if (ipbanlist.getFile().exists()) {
                try {
                    ipbanlist.load();
                }
                catch (IOException ioexception) {
                    LOGGER.warn("Could not load existing file {}", (Object)ipbanlist.getFile().getName());
                }
            }
            try {
                HashMap map = Maps.newHashMap();
                OldUsersConverter.readOldListFormat(OLD_IPBANLIST, map);
                for (String s : map.keySet()) {
                    String[] astring = (String[])map.get(s);
                    Date date = astring.length > 1 ? OldUsersConverter.parseDate(astring[1], null) : null;
                    String s1 = astring.length > 2 ? astring[2] : null;
                    Date date1 = astring.length > 3 ? OldUsersConverter.parseDate(astring[3], null) : null;
                    String s2 = astring.length > 4 ? astring[4] : null;
                    ipbanlist.add(new IpBanListEntry(s, date, s1, date1, s2));
                }
                ipbanlist.save();
                OldUsersConverter.renameOldFile(OLD_IPBANLIST);
                return true;
            }
            catch (IOException ioexception1) {
                LOGGER.warn("Could not parse old ip banlist to convert it!", (Throwable)ioexception1);
                return false;
            }
        }
        return true;
    }

    public static boolean convertOpsList(final MinecraftServer server) {
        final ServerOpList oplist = new ServerOpList(PlayerList.OPLIST_FILE);
        if (OLD_OPLIST.exists() && OLD_OPLIST.isFile()) {
            if (oplist.getFile().exists()) {
                try {
                    oplist.load();
                }
                catch (IOException ioexception) {
                    LOGGER.warn("Could not load existing file {}", (Object)oplist.getFile().getName());
                }
            }
            try {
                List list = Files.readLines((File)OLD_OPLIST, (Charset)StandardCharsets.UTF_8);
                ProfileLookupCallback profilelookupcallback = new ProfileLookupCallback(){

                    public void onProfileLookupSucceeded(GameProfile gameprofile) {
                        server.getProfileCache().add(gameprofile);
                        oplist.add(new ServerOpListEntry(gameprofile, server.getOperatorUserPermissionLevel(), false));
                    }

                    public void onProfileLookupFailed(String s, Exception exception) {
                        LOGGER.warn("Could not lookup oplist entry for {}", (Object)s, (Object)exception);
                        if (!(exception instanceof ProfileNotFoundException)) {
                            throw new ConversionError("Could not request user " + s + " from backend systems", exception);
                        }
                    }
                };
                OldUsersConverter.lookupPlayers(server, list, profilelookupcallback);
                oplist.save();
                OldUsersConverter.renameOldFile(OLD_OPLIST);
                return true;
            }
            catch (IOException ioexception1) {
                LOGGER.warn("Could not read old oplist to convert it!", (Throwable)ioexception1);
                return false;
            }
            catch (ConversionError namereferencingfileconverter_fileconversionexception) {
                LOGGER.error("Conversion failed, please try again later", (Throwable)namereferencingfileconverter_fileconversionexception);
                return false;
            }
        }
        return true;
    }

    public static boolean convertWhiteList(final MinecraftServer server) {
        final UserWhiteList whitelist = new UserWhiteList(PlayerList.WHITELIST_FILE);
        if (OLD_WHITELIST.exists() && OLD_WHITELIST.isFile()) {
            if (whitelist.getFile().exists()) {
                try {
                    whitelist.load();
                }
                catch (IOException ioexception) {
                    LOGGER.warn("Could not load existing file {}", (Object)whitelist.getFile().getName());
                }
            }
            try {
                List list = Files.readLines((File)OLD_WHITELIST, (Charset)StandardCharsets.UTF_8);
                ProfileLookupCallback profilelookupcallback = new ProfileLookupCallback(){

                    public void onProfileLookupSucceeded(GameProfile gameprofile) {
                        server.getProfileCache().add(gameprofile);
                        whitelist.add(new UserWhiteListEntry(gameprofile));
                    }

                    public void onProfileLookupFailed(String s, Exception exception) {
                        LOGGER.warn("Could not lookup user whitelist entry for {}", (Object)s, (Object)exception);
                        if (!(exception instanceof ProfileNotFoundException)) {
                            throw new ConversionError("Could not request user " + s + " from backend systems", exception);
                        }
                    }
                };
                OldUsersConverter.lookupPlayers(server, list, profilelookupcallback);
                whitelist.save();
                OldUsersConverter.renameOldFile(OLD_WHITELIST);
                return true;
            }
            catch (IOException ioexception1) {
                LOGGER.warn("Could not read old whitelist to convert it!", (Throwable)ioexception1);
                return false;
            }
            catch (ConversionError namereferencingfileconverter_fileconversionexception) {
                LOGGER.error("Conversion failed, please try again later", (Throwable)namereferencingfileconverter_fileconversionexception);
                return false;
            }
        }
        return true;
    }

    @Nullable
    public static UUID convertMobOwnerIfNecessary(final MinecraftServer server, String name) {
        if (!StringUtil.isNullOrEmpty(name) && name.length() <= 16) {
            Optional<UUID> optional = server.getProfileCache().get(name).map(GameProfile::getId);
            if (optional.isPresent()) {
                return optional.get();
            }
            if (!server.isSingleplayer() && server.usesAuthentication()) {
                final ArrayList list = Lists.newArrayList();
                ProfileLookupCallback profilelookupcallback = new ProfileLookupCallback(){

                    public void onProfileLookupSucceeded(GameProfile gameprofile) {
                        server.getProfileCache().add(gameprofile);
                        list.add(gameprofile);
                    }

                    public void onProfileLookupFailed(String s1, Exception exception) {
                        LOGGER.warn("Could not lookup user whitelist entry for {}", (Object)s1, (Object)exception);
                    }
                };
                OldUsersConverter.lookupPlayers(server, Lists.newArrayList((Object[])new String[]{name}), profilelookupcallback);
                return !list.isEmpty() ? ((GameProfile)list.get(0)).getId() : null;
            }
            return UUIDUtil.createOfflinePlayerUUID(name);
        }
        try {
            return UUID.fromString(name);
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return null;
        }
    }

    public static boolean convertPlayers(final DedicatedServer minecraftServer) {
        final File file = OldUsersConverter.getWorldPlayersDirectory(minecraftServer);
        final File file1 = new File(file.getParentFile(), "playerdata");
        final File file2 = new File(file.getParentFile(), "unknownplayers");
        if (file.exists() && file.isDirectory()) {
            File[] afile = file.listFiles();
            ArrayList list = Lists.newArrayList();
            File[] afile1 = afile;
            int i = afile.length;
            for (int j = 0; j < i; ++j) {
                String s1;
                File file3 = afile1[j];
                String s = file3.getName();
                if (!s.toLowerCase(Locale.ROOT).endsWith(".dat") || (s1 = s.substring(0, s.length() - ".dat".length())).isEmpty()) continue;
                list.add(s1);
            }
            try {
                Object[] astring = list.toArray(new String[list.size()]);
                ProfileLookupCallback profilelookupcallback = new ProfileLookupCallback(){
                    final /* synthetic */ String[] val$astring;
                    {
                        this.val$astring = stringArray;
                    }

                    public void onProfileLookupSucceeded(GameProfile gameprofile) {
                        minecraftServer.getProfileCache().add(gameprofile);
                        UUID uuid = gameprofile.getId();
                        this.movePlayerFile(file1, this.getFileNameForProfile(gameprofile.getName()), uuid.toString());
                    }

                    public void onProfileLookupFailed(String s2, Exception exception) {
                        LOGGER.warn("Could not lookup user uuid for {}", (Object)s2, (Object)exception);
                        if (!(exception instanceof ProfileNotFoundException)) {
                            throw new ConversionError("Could not request user " + s2 + " from backend systems", exception);
                        }
                        String s3 = this.getFileNameForProfile(s2);
                        this.movePlayerFile(file2, s3, s3);
                    }

                    private void movePlayerFile(File playerDataFolder, String fileName, String uuid) {
                        File file5 = new File(file, fileName + ".dat");
                        File file6 = new File(playerDataFolder, uuid + ".dat");
                        CompoundTag root = null;
                        try {
                            root = NbtIo.readCompressed(new FileInputStream(file5), NbtAccounter.unlimitedHeap());
                        }
                        catch (Exception exception) {
                            StacktraceDeobfuscator.INSTANCE.deobfuscateThrowable(exception);
                            exception.printStackTrace();
                            ServerInternalException.reportInternalException((Throwable)exception);
                        }
                        if (root != null) {
                            if (!root.contains("bukkit")) {
                                root.put("bukkit", new CompoundTag());
                            }
                            CompoundTag data = root.getCompound("bukkit");
                            data.putString("lastKnownName", fileName);
                            try {
                                NbtIo.writeCompressed(root, new FileOutputStream(file2));
                            }
                            catch (Exception exception) {
                                StacktraceDeobfuscator.INSTANCE.deobfuscateThrowable(exception);
                                exception.printStackTrace();
                                ServerInternalException.reportInternalException((Throwable)exception);
                            }
                        }
                        OldUsersConverter.ensureDirectoryExists(playerDataFolder);
                        if (!file5.renameTo(file6)) {
                            throw new ConversionError("Could not convert file for " + fileName);
                        }
                    }

                    private String getFileNameForProfile(String s2) {
                        String s3 = null;
                        for (String s4 : this.val$astring) {
                            if (s4 == null || !s4.equalsIgnoreCase(s2)) continue;
                            s3 = s4;
                            break;
                        }
                        if (s3 == null) {
                            throw new ConversionError("Could not find the filename for " + s2 + " anymore");
                        }
                        return s3;
                    }
                };
                OldUsersConverter.lookupPlayers(minecraftServer, Lists.newArrayList((Object[])astring), profilelookupcallback);
                return true;
            }
            catch (ConversionError namereferencingfileconverter_fileconversionexception) {
                LOGGER.error("Conversion failed, please try again later", (Throwable)namereferencingfileconverter_fileconversionexception);
                return false;
            }
        }
        return true;
    }

    static void ensureDirectoryExists(File directory) {
        if (directory.exists() ? !directory.isDirectory() : !directory.mkdirs()) {
            throw new ConversionError("Can't create directory " + directory.getName() + " in world save directory.");
        }
    }

    public static boolean serverReadyAfterUserconversion(MinecraftServer server) {
        boolean flag = OldUsersConverter.areOldUserlistsRemoved();
        flag = flag && OldUsersConverter.areOldPlayersConverted(server);
        return flag;
    }

    private static boolean areOldUserlistsRemoved() {
        boolean flag = false;
        if (OLD_USERBANLIST.exists() && OLD_USERBANLIST.isFile()) {
            flag = true;
        }
        boolean flag1 = false;
        if (OLD_IPBANLIST.exists() && OLD_IPBANLIST.isFile()) {
            flag1 = true;
        }
        boolean flag2 = false;
        if (OLD_OPLIST.exists() && OLD_OPLIST.isFile()) {
            flag2 = true;
        }
        boolean flag3 = false;
        if (OLD_WHITELIST.exists() && OLD_WHITELIST.isFile()) {
            flag3 = true;
        }
        if (!(flag || flag1 || flag2 || flag3)) {
            return true;
        }
        LOGGER.warn("**** FAILED TO START THE SERVER AFTER ACCOUNT CONVERSION!");
        LOGGER.warn("** please remove the following files and restart the server:");
        if (flag) {
            LOGGER.warn("* {}", (Object)OLD_USERBANLIST.getName());
        }
        if (flag1) {
            LOGGER.warn("* {}", (Object)OLD_IPBANLIST.getName());
        }
        if (flag2) {
            LOGGER.warn("* {}", (Object)OLD_OPLIST.getName());
        }
        if (flag3) {
            LOGGER.warn("* {}", (Object)OLD_WHITELIST.getName());
        }
        return false;
    }

    private static boolean areOldPlayersConverted(MinecraftServer server) {
        File file = OldUsersConverter.getWorldPlayersDirectory(server);
        if (file.exists() && file.isDirectory() && (file.list().length > 0 || !file.delete())) {
            LOGGER.warn("**** DETECTED OLD PLAYER DIRECTORY IN THE WORLD SAVE");
            LOGGER.warn("**** THIS USUALLY HAPPENS WHEN THE AUTOMATIC CONVERSION FAILED IN SOME WAY");
            LOGGER.warn("** please restart the server and if the problem persists, remove the directory '{}'", (Object)file.getPath());
            return false;
        }
        return true;
    }

    private static File getWorldPlayersDirectory(MinecraftServer server) {
        return server.getWorldPath(LevelResource.PLAYER_OLD_DATA_DIR).toFile();
    }

    private static void renameOldFile(File file) {
        File file1 = new File(file.getName() + ".converted");
        file.renameTo(file1);
    }

    static Date parseDate(String dateString, Date fallback) {
        Date date1;
        try {
            date1 = BanListEntry.DATE_FORMAT.parse(dateString);
        }
        catch (ParseException parseexception) {
            date1 = fallback;
        }
        return date1;
    }

    private static class ConversionError
    extends RuntimeException {
        ConversionError(String message, Throwable cause) {
            super(message, cause);
        }

        ConversionError(String message) {
            super(message);
        }
    }
}

