/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.players;

import com.destroystokyo.paper.console.TerminalConsoleCommandSender;
import com.destroystokyo.paper.event.player.PlayerInitialSpawnEvent;
import com.destroystokyo.paper.event.player.PlayerPostRespawnEvent;
import com.destroystokyo.paper.event.player.PlayerSetSpawnEvent;
import com.destroystokyo.paper.event.profile.ProfileWhitelistVerifyEvent;
import com.destroystokyo.paper.event.server.WhitelistToggleEvent;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.util.MCUtil;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.minecraft.BlockUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.FileUtil;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.OutgoingChatMessage;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundUpdateTagsPacket;
import net.minecraft.network.protocol.game.ClientboundChangeDifficultyPacket;
import net.minecraft.network.protocol.game.ClientboundDisguisedChatPacket;
import net.minecraft.network.protocol.game.ClientboundEntityEventPacket;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.network.protocol.game.ClientboundInitializeBorderPacket;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.network.protocol.game.ClientboundLoginPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerAbilitiesPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundRespawnPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderCenterPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderLerpSizePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderSizePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDelayPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDistancePacket;
import net.minecraft.network.protocol.game.ClientboundSetCarriedItemPacket;
import net.minecraft.network.protocol.game.ClientboundSetChunkCacheRadiusPacket;
import net.minecraft.network.protocol.game.ClientboundSetDefaultSpawnPositionPacket;
import net.minecraft.network.protocol.game.ClientboundSetExperiencePacket;
import net.minecraft.network.protocol.game.ClientboundSetPlayerTeamPacket;
import net.minecraft.network.protocol.game.ClientboundSetSimulationDistancePacket;
import net.minecraft.network.protocol.game.ClientboundSetTimePacket;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateRecipesPacket;
import net.minecraft.network.protocol.game.GameProtocols;
import net.minecraft.network.protocol.status.ServerStatus;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.server.network.ServerLoginPacketListenerImpl;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.server.players.IpBanList;
import net.minecraft.server.players.IpBanListEntry;
import net.minecraft.server.players.ServerOpList;
import net.minecraft.server.players.ServerOpListEntry;
import net.minecraft.server.players.UserBanList;
import net.minecraft.server.players.UserBanListEntry;
import net.minecraft.server.players.UserWhiteList;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.ServerStatsCounter;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagNetworkSerialization;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RespawnAnchorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.BorderChangeListener;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.EmptyLevelChunk;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.PlayerDataStorage;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.DisplaySlot;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Scoreboard;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.WeatherType;
import org.bukkit.World;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.craftbukkit.util.CraftLocation;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.leavesmc.leaves.LeavesConfig;
import org.leavesmc.leaves.bot.ServerBot;
import org.leavesmc.leaves.entity.CraftPhotographer;
import org.leavesmc.leaves.protocol.XaeroMapProtocol;
import org.leavesmc.leaves.protocol.core.LeavesProtocolManager;
import org.leavesmc.leaves.replay.ServerPhotographer;
import org.leavesmc.leaves.util.ReturnPortalManager;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public abstract class PlayerList {
    public static final File USERBANLIST_FILE = new File("banned-players.json");
    public static final File IPBANLIST_FILE = new File("banned-ips.json");
    public static final File OPLIST_FILE = new File("ops.json");
    public static final File WHITELIST_FILE = new File("whitelist.json");
    public static final net.minecraft.network.chat.Component CHAT_FILTERED_FULL = net.minecraft.network.chat.Component.translatable("chat.filtered_full");
    public static final net.minecraft.network.chat.Component DUPLICATE_LOGIN_DISCONNECT_MESSAGE = net.minecraft.network.chat.Component.translatable("multiplayer.disconnect.duplicate_login");
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int SEND_PLAYER_INFO_INTERVAL = 600;
    private static final SimpleDateFormat BAN_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd 'at' HH:mm:ss z");
    private final MinecraftServer server;
    public final List<ServerPlayer> players = new CopyOnWriteArrayList<ServerPlayer>();
    private final Map<UUID, ServerPlayer> playersByUUID = Maps.newHashMap();
    private final UserBanList bans;
    private final IpBanList ipBans;
    private final ServerOpList ops;
    private final UserWhiteList whitelist;
    public final PlayerDataStorage playerIo;
    private boolean doWhiteList;
    private final LayeredRegistryAccess<RegistryLayer> registries;
    public int maxPlayers;
    private int viewDistance;
    private int simulationDistance;
    private boolean allowCommandsForAllPlayers;
    private static final boolean ALLOW_LOGOUTIVATOR = false;
    private int sendAllPlayerInfoIn;
    public final List<ServerPlayer> realPlayers = new CopyOnWriteArrayList<ServerPlayer>();
    private CraftServer cserver;
    private final Map<String, ServerPlayer> playersByName = new HashMap<String, ServerPlayer>();
    @Nullable
    public String collideRuleTeamName;

    public PlayerList(MinecraftServer server, LayeredRegistryAccess<RegistryLayer> registryManager, PlayerDataStorage saveHandler, int maxPlayers) {
        this.cserver = server.server = new CraftServer((DedicatedServer)server, this);
        server.console = new TerminalConsoleCommandSender();
        this.bans = new UserBanList(USERBANLIST_FILE);
        this.ipBans = new IpBanList(IPBANLIST_FILE);
        this.ops = new ServerOpList(OPLIST_FILE);
        this.whitelist = new UserWhiteList(WHITELIST_FILE);
        this.server = server;
        this.registries = registryManager;
        this.maxPlayers = maxPlayers;
        this.playerIo = saveHandler;
    }

    public abstract void loadAndSaveFiles();

    public void placeNewPhotographer(Connection connection, ServerPhotographer player, ServerLevel worldserver, Location location) {
        player.isRealPlayer = true;
        player.loginTime = System.currentTimeMillis();
        ServerLevel worldserver1 = worldserver;
        player.setServerLevel(worldserver1);
        player.spawnIn(worldserver1);
        player.gameMode.setLevel((ServerLevel)player.level());
        LevelData worlddata = worldserver1.getLevelData();
        player.loadGameTypes(null);
        ServerGamePacketListenerImpl playerconnection = new ServerGamePacketListenerImpl(this.server, connection, player, CommonListenerCookie.createInitial(player.gameProfile, false));
        GameRules gamerules = worldserver1.getGameRules();
        boolean flag = gamerules.getBoolean(GameRules.RULE_DO_IMMEDIATE_RESPAWN);
        boolean flag1 = gamerules.getBoolean(GameRules.RULE_REDUCEDDEBUGINFO);
        boolean flag2 = gamerules.getBoolean(GameRules.RULE_LIMITED_CRAFTING);
        playerconnection.send(new ClientboundLoginPacket(player.getId(), worlddata.isHardcore(), this.server.levelKeys(), this.getMaxPlayers(), worldserver1.getWorld().getSendViewDistance(), worldserver1.getWorld().getSimulationDistance(), flag1, !flag, flag2, player.createCommonSpawnInfo(worldserver1), this.server.enforceSecureProfile()));
        player.getBukkitEntity().sendSupportedChannels();
        playerconnection.send(new ClientboundChangeDifficultyPacket(worlddata.getDifficulty(), worlddata.isDifficultyLocked()));
        playerconnection.send(new ClientboundPlayerAbilitiesPacket(player.getAbilities()));
        playerconnection.send(new ClientboundSetCarriedItemPacket(player.getInventory().selected));
        playerconnection.send(new ClientboundUpdateRecipesPacket(this.server.getRecipeManager().getRecipes()));
        this.sendPlayerPermissionLevel(player);
        player.getStats().markAllDirty();
        player.getRecipeBook().sendInitialRecipeBook(player);
        this.updateEntireScoreboard(worldserver1.getScoreboard(), player);
        this.server.invalidateStatus();
        playerconnection.teleport(player.getX(), player.getY(), player.getZ(), player.getYRot(), player.getXRot());
        ServerStatus serverping = this.server.getStatus();
        if (serverping != null) {
            player.sendServerStatus(serverping);
        }
        this.players.add(player);
        this.playersByName.put(player.getScoreboardName().toLowerCase(Locale.ROOT), player);
        this.playersByUUID.put(player.getUUID(), player);
        player.supressTrackerForLogin = true;
        worldserver1.addNewPlayer(player);
        this.server.getCustomBossEvents().onPlayerConnect(player);
        this.mountSavedVehicle(player, worldserver1, Optional.empty());
        CraftPhotographer bukkitPlayer = player.getBukkitEntity();
        player.containerMenu.transferTo(player.containerMenu, bukkitPlayer);
        if (!player.connection.isAcceptingMessages()) {
            return;
        }
        if (LeavesConfig.fakeplayerSupport) {
            ServerBot bot = ServerBot.getBot(player.getScoreboardName().toLowerCase(Locale.ROOT));
            if (bot != null) {
                bot.die(bot.damageSources().fellOutOfWorld());
                this.playersByName.put(player.getScoreboardName().toLowerCase(Locale.ROOT), player);
                this.playersByUUID.put(player.getUUID(), player);
            }
            ServerBot.getBots().forEach(bot1 -> {
                bot1.sendPlayerInfo(player);
                bot1.sendFakeDataIfNeed(player, true);
            });
        }
        ArrayList onlinePlayers = Lists.newArrayListWithExpectedSize((int)(this.players.size() - 1));
        for (int i = 0; i < this.players.size(); ++i) {
            ServerPlayer entityplayer1 = this.players.get(i);
            if (entityplayer1 == player || !bukkitPlayer.canSee(entityplayer1.getBukkitEntity())) continue;
            onlinePlayers.add(entityplayer1);
        }
        if (!onlinePlayers.isEmpty()) {
            player.connection.send(ClientboundPlayerInfoUpdatePacket.createPlayerInitializing(onlinePlayers, player));
        }
        player.sentListPacket = true;
        player.supressTrackerForLogin = false;
        ((ServerLevel)player.level()).getChunkSource().chunkMap.addEntity(player);
        this.sendLevelInfo(player, worldserver1);
        if (player.level() == worldserver1 && !worldserver1.players().contains(player)) {
            worldserver1.addNewPlayer(player);
            this.server.getCustomBossEvents().onPlayerConnect(player);
        }
        worldserver1 = player.serverLevel();
        for (MobEffectInstance mobeffect : player.getActiveEffects()) {
            playerconnection.send(new ClientboundUpdateMobEffectPacket(player.getId(), mobeffect, false));
        }
        if (player.isDeadOrDying()) {
            Holder.Reference<Biome> plains = worldserver1.registryAccess().registryOrThrow(Registries.BIOME).getHolderOrThrow(Biomes.PLAINS);
            player.connection.send(new ClientboundLevelChunkWithLightPacket(new EmptyLevelChunk((Level)worldserver1, player.chunkPosition(), plains), worldserver1.getLightEngine(), null, null, false));
        }
    }

    public void placeNewPlayer(Connection connection, ServerPlayer player, CommonListenerCookie clientData) {
        Component jm;
        ServerLevel worldserver1;
        ServerLevel worldserver;
        boolean[] invalidPlayerWorld;
        ResourceKey<Level> resourcekey;
        String s;
        Optional<Object> optional;
        block27: {
            World bWorld;
            block29: {
                block28: {
                    CompoundTag nbttagcompound2;
                    player.isRealPlayer = true;
                    player.loginTime = System.currentTimeMillis();
                    GameProfile gameprofile = player.getGameProfile();
                    GameProfileCache usercache = this.server.getProfileCache();
                    if (usercache != null) {
                        optional = usercache.get(gameprofile.getId());
                        s = optional.map(GameProfile::getName).orElse(gameprofile.getName());
                        usercache.add(gameprofile);
                    } else {
                        s = gameprofile.getName();
                    }
                    optional = this.load(player);
                    resourcekey = null;
                    if (optional.isPresent() && (nbttagcompound2 = (CompoundTag)optional.get()).contains("bukkit")) {
                        CompoundTag bukkit = nbttagcompound2.getCompound("bukkit");
                        s = bukkit.contains("lastKnownName", 8) ? bukkit.getString("lastKnownName") : s;
                    }
                    invalidPlayerWorld = new boolean[]{false};
                    if (!optional.isPresent()) break block27;
                    if (!((CompoundTag)optional.get()).contains("WorldUUIDMost") || !((CompoundTag)optional.get()).contains("WorldUUIDLeast")) break block28;
                    bWorld = Bukkit.getServer().getWorld(new UUID(((CompoundTag)optional.get()).getLong("WorldUUIDMost"), ((CompoundTag)optional.get()).getLong("WorldUUIDLeast")));
                    break block29;
                }
                if (!((CompoundTag)optional.get()).contains("world", 8)) break block27;
                bWorld = Bukkit.getServer().getWorld(((CompoundTag)optional.get()).getString("world"));
            }
            if (bWorld != null) {
                resourcekey = ((CraftWorld)bWorld).getHandle().dimension();
            } else {
                resourcekey = Level.OVERWORLD;
                invalidPlayerWorld[0] = true;
            }
        }
        if (resourcekey == null) {
            resourcekey = optional.flatMap(nbttagcompound -> {
                DataResult<ResourceKey<Level>> dataresult = DimensionType.parseLegacy(new Dynamic<Tag>(NbtOps.INSTANCE, nbttagcompound.get("Dimension")));
                Logger logger = LOGGER;
                Objects.requireNonNull(logger);
                Optional result = dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0));
                invalidPlayerWorld[0] = result.isEmpty();
                return result;
            }).orElse(Level.OVERWORLD);
        }
        if ((worldserver = this.server.getLevel(resourcekey)) == null) {
            LOGGER.warn("Unknown respawn dimension {}, defaulting to overworld", resourcekey);
            worldserver1 = this.server.overworld();
            invalidPlayerWorld[0] = true;
        } else {
            worldserver1 = worldserver;
        }
        if (optional.isEmpty()) {
            player.spawnReason = CreatureSpawnEvent.SpawnReason.DEFAULT;
        }
        if (optional.isEmpty() || invalidPlayerWorld[0]) {
            player.fudgeSpawnLocation(worldserver1);
        }
        player.setServerLevel(worldserver1);
        String s1 = connection.getLoggableAddress(this.server.logIPs());
        CraftPlayer spawnPlayer = player.getBukkitEntity();
        PlayerInitialSpawnEvent ev = new PlayerInitialSpawnEvent((org.bukkit.entity.Player)spawnPlayer, spawnPlayer.getLocation());
        this.cserver.getPluginManager().callEvent((Event)ev);
        Location loc = ev.getSpawnLocation();
        worldserver1 = ((CraftWorld)loc.getWorld()).getHandle();
        player.spawnIn(worldserver1);
        player.gameMode.setLevel((ServerLevel)player.level());
        player.setPosRaw(loc.getX(), loc.getY(), loc.getZ());
        player.setRot(loc.getYaw(), loc.getPitch());
        LevelData worlddata = worldserver1.getLevelData();
        player.loadGameTypes(optional.orElse(null));
        ServerGamePacketListenerImpl playerconnection = new ServerGamePacketListenerImpl(this.server, connection, player, clientData);
        connection.setupInboundProtocol(GameProtocols.SERVERBOUND.bind(RegistryFriendlyByteBuf.decorator(this.server.registryAccess())), playerconnection);
        GameRules gamerules = worldserver1.getGameRules();
        boolean flag = gamerules.getBoolean(GameRules.RULE_DO_IMMEDIATE_RESPAWN);
        boolean flag1 = gamerules.getBoolean(GameRules.RULE_REDUCEDDEBUGINFO);
        boolean flag2 = gamerules.getBoolean(GameRules.RULE_LIMITED_CRAFTING);
        playerconnection.send(new ClientboundLoginPacket(player.getId(), worlddata.isHardcore(), this.server.levelKeys(), this.getMaxPlayers(), worldserver1.getWorld().getSendViewDistance(), worldserver1.getWorld().getSimulationDistance(), flag1, !flag, flag2, player.createCommonSpawnInfo(worldserver1), this.server.enforceSecureProfile()));
        player.getBukkitEntity().sendSupportedChannels();
        playerconnection.send(new ClientboundChangeDifficultyPacket(worlddata.getDifficulty(), worlddata.isDifficultyLocked()));
        playerconnection.send(new ClientboundPlayerAbilitiesPacket(player.getAbilities()));
        playerconnection.send(new ClientboundSetCarriedItemPacket(player.getInventory().selected));
        playerconnection.send(new ClientboundUpdateRecipesPacket(this.server.getRecipeManager().getOrderedRecipes()));
        this.sendPlayerPermissionLevel(player);
        player.getStats().markAllDirty();
        player.getRecipeBook().sendInitialRecipeBook(player);
        this.updateEntireScoreboard(worldserver1.getScoreboard(), player);
        this.server.invalidateStatus();
        MutableComponent ichatmutablecomponent = player.getGameProfile().getName().equalsIgnoreCase(s) ? net.minecraft.network.chat.Component.translatable("multiplayer.player.joined", player.getDisplayName()) : net.minecraft.network.chat.Component.translatable("multiplayer.player.joined.renamed", player.getDisplayName(), s);
        ichatmutablecomponent.withStyle(ChatFormatting.YELLOW);
        net.minecraft.network.chat.Component joinMessage = ichatmutablecomponent;
        playerconnection.teleport(player.getX(), player.getY(), player.getZ(), player.getYRot(), player.getXRot());
        ServerStatus serverping = this.server.getStatus();
        if (serverping != null && !clientData.transferred()) {
            player.sendServerStatus(serverping);
        }
        this.players.add(player);
        this.realPlayers.add(player);
        this.playersByName.put(player.getScoreboardName().toLowerCase(Locale.ROOT), player);
        this.playersByUUID.put(player.getUUID(), player);
        player.supressTrackerForLogin = true;
        worldserver1.addNewPlayer(player);
        this.server.getCustomBossEvents().onPlayerConnect(player);
        this.mountSavedVehicle(player, worldserver1, optional);
        CraftPlayer bukkitPlayer = player.getBukkitEntity();
        player.containerMenu.transferTo(player.containerMenu, bukkitPlayer);
        PlayerJoinEvent playerJoinEvent = new PlayerJoinEvent((org.bukkit.entity.Player)bukkitPlayer, PaperAdventure.asAdventure(ichatmutablecomponent));
        this.cserver.getPluginManager().callEvent((Event)playerJoinEvent);
        if (!player.connection.isAcceptingMessages()) {
            return;
        }
        if (!(player instanceof ServerBot)) {
            this.cserver.getBytebufHandler().injectPlayer(player);
        }
        LeavesProtocolManager.handlePlayerJoin(player);
        if (LeavesConfig.fakeplayerSupport) {
            ServerBot bot = ServerBot.getBot(player.getScoreboardName().toLowerCase(Locale.ROOT));
            if (bot != null) {
                bot.die(bot.damageSources().fellOutOfWorld());
                this.playersByName.put(player.getScoreboardName().toLowerCase(Locale.ROOT), player);
                this.playersByUUID.put(player.getUUID(), player);
            }
            ServerBot.getBots().forEach(bot1 -> {
                bot1.sendPlayerInfo(player);
                bot1.sendFakeDataIfNeed(player, true);
            });
        }
        if ((jm = playerJoinEvent.joinMessage()) != null && !jm.equals((Object)Component.empty())) {
            joinMessage = PaperAdventure.asVanilla(jm);
            this.server.getPlayerList().broadcastSystemMessage(joinMessage, false);
        }
        ClientboundPlayerInfoUpdatePacket packet = ClientboundPlayerInfoUpdatePacket.createPlayerInitializing(List.of(player));
        ArrayList onlinePlayers = Lists.newArrayListWithExpectedSize((int)(this.players.size() - 1));
        for (int i = 0; i < this.players.size(); ++i) {
            ServerPlayer entityplayer1 = this.players.get(i);
            if (entityplayer1.getBukkitEntity().canSee(bukkitPlayer)) {
                if (entityplayer1.getBukkitEntity().isListed(bukkitPlayer)) {
                    entityplayer1.connection.send(packet);
                } else {
                    entityplayer1.connection.send(ClientboundPlayerInfoUpdatePacket.createSinglePlayerInitializing(player, false));
                }
            }
            if (entityplayer1 == player || !bukkitPlayer.canSee(entityplayer1.getBukkitEntity()) || entityplayer1 instanceof ServerPhotographer) continue;
            onlinePlayers.add(entityplayer1);
        }
        if (!onlinePlayers.isEmpty()) {
            player.connection.send(ClientboundPlayerInfoUpdatePacket.createPlayerInitializing(onlinePlayers, player));
        }
        player.sentListPacket = true;
        player.supressTrackerForLogin = false;
        ((ServerLevel)player.level()).getChunkSource().chunkMap.addEntity(player);
        this.sendLevelInfo(player, worldserver1);
        if (player.level() == worldserver1 && !worldserver1.players().contains(player)) {
            worldserver1.addNewPlayer(player);
            this.server.getCustomBossEvents().onPlayerConnect(player);
        }
        worldserver1 = player.serverLevel();
        for (MobEffectInstance mobeffect : player.getActiveEffects()) {
            playerconnection.send(new ClientboundUpdateMobEffectPacket(player.getId(), mobeffect, false));
        }
        this.onPlayerJoinFinish(player, worldserver1, s1);
        if (player.isDeadOrDying()) {
            Holder.Reference<Biome> plains = worldserver1.registryAccess().registryOrThrow(Registries.BIOME).getHolderOrThrow(Biomes.PLAINS);
            player.connection.send(new ClientboundLevelChunkWithLightPacket(new EmptyLevelChunk((Level)worldserver1, player.chunkPosition(), plains), worldserver1.getLightEngine(), null, null, true));
        }
    }

    private void mountSavedVehicle(ServerPlayer player, ServerLevel worldserver1, Optional<CompoundTag> optional) {
        if (optional.isPresent() && optional.get().contains("RootVehicle", 10)) {
            CompoundTag nbttagcompound = optional.get().getCompound("RootVehicle");
            ServerLevel finalWorldServer = worldserver1;
            Entity entity = EntityType.loadEntityRecursive(nbttagcompound.getCompound("Entity"), worldserver1, entity1 -> !finalWorldServer.addWithUUID((Entity)entity1, CreatureSpawnEvent.SpawnReason.MOUNT) ? null : entity1);
            if (entity != null) {
                UUID uuid = nbttagcompound.hasUUID("Attach") ? nbttagcompound.getUUID("Attach") : null;
                if (entity.getUUID().equals(uuid)) {
                    player.startRiding(entity, true);
                } else {
                    for (Entity entity12 : entity.getIndirectPassengers()) {
                        if (!entity12.getUUID().equals(uuid)) continue;
                        player.startRiding(entity12, true);
                        break;
                    }
                }
                if (!player.isPassenger()) {
                    LOGGER.warn("Couldn't reattach entity to player");
                    entity.discard(null);
                    for (Entity entity12 : entity.getIndirectPassengers()) {
                        entity12.discard(null);
                    }
                }
            }
        }
    }

    public void onPlayerJoinFinish(ServerPlayer player, ServerLevel worldserver1, String s1) {
        player.initInventoryMenu();
        ServerScoreboard scoreboard = this.getServer().getLevel(Level.OVERWORLD).getScoreboard();
        PlayerTeam collideRuleTeam = scoreboard.getPlayerTeam(this.collideRuleTeamName);
        if (this.collideRuleTeamName != null && collideRuleTeam != null && player.getTeam() == null) {
            ((Scoreboard)scoreboard).addPlayerToTeam(player.getScoreboardName(), collideRuleTeam);
        }
        LOGGER.info("{}[{}] logged in with entity id {} at ([{}]{}, {}, {})", new Object[]{player.getName().getString(), s1, player.getId(), worldserver1.serverLevelData.getLevelName(), player.getX(), player.getY(), player.getZ()});
    }

    public void updateEntireScoreboard(ServerScoreboard scoreboard, ServerPlayer player) {
        HashSet set = Sets.newHashSet();
        for (PlayerTeam scoreboardteam : scoreboard.getPlayerTeams()) {
            player.connection.send(ClientboundSetPlayerTeamPacket.createAddOrModifyPacket(scoreboardteam, true));
        }
        for (DisplaySlot displayslot : DisplaySlot.values()) {
            Objective scoreboardobjective = scoreboard.getDisplayObjective(displayslot);
            if (scoreboardobjective == null || set.contains(scoreboardobjective)) continue;
            List<Packet<?>> list = scoreboard.getStartTrackingPackets(scoreboardobjective);
            for (Packet<?> packet : list) {
                player.connection.send(packet);
            }
            set.add(scoreboardobjective);
        }
    }

    public void addWorldborderListener(ServerLevel world) {
        if (this.playerIo != null) {
            return;
        }
        world.getWorldBorder().addListener(new BorderChangeListener(){

            @Override
            public void onBorderSizeSet(WorldBorder border, double size) {
                PlayerList.this.broadcastAll((Packet)new ClientboundSetBorderSizePacket(border), border.world);
            }

            @Override
            public void onBorderSizeLerping(WorldBorder border, double fromSize, double toSize, long time) {
                PlayerList.this.broadcastAll((Packet)new ClientboundSetBorderLerpSizePacket(border), border.world);
            }

            @Override
            public void onBorderCenterSet(WorldBorder border, double centerX, double centerZ) {
                PlayerList.this.broadcastAll((Packet)new ClientboundSetBorderCenterPacket(border), border.world);
            }

            @Override
            public void onBorderSetWarningTime(WorldBorder border, int warningTime) {
                PlayerList.this.broadcastAll((Packet)new ClientboundSetBorderWarningDelayPacket(border), border.world);
            }

            @Override
            public void onBorderSetWarningBlocks(WorldBorder border, int warningBlockDistance) {
                PlayerList.this.broadcastAll((Packet)new ClientboundSetBorderWarningDistancePacket(border), border.world);
            }

            @Override
            public void onBorderSetDamagePerBlock(WorldBorder border, double damagePerBlock) {
            }

            @Override
            public void onBorderSetDamageSafeZOne(WorldBorder border, double safeZoneRadius) {
            }
        });
    }

    public Optional<CompoundTag> load(ServerPlayer player) {
        Optional<CompoundTag> optional;
        CompoundTag nbttagcompound = this.server.getWorldData().getLoadedPlayerTag();
        if (this.server.isSingleplayerOwner(player.getGameProfile()) && nbttagcompound != null) {
            optional = Optional.of(nbttagcompound);
            player.load(nbttagcompound);
            LOGGER.debug("loading single player");
        } else {
            optional = this.playerIo.load(player);
        }
        return optional;
    }

    protected void save(ServerPlayer player) {
        PlayerAdvancements advancementdataplayer;
        if (!player.getBukkitEntity().isPersistent()) {
            return;
        }
        player.lastSave = MinecraftServer.currentTick;
        this.playerIo.save(player);
        ServerStatsCounter serverstatisticmanager = player.getStats();
        if (serverstatisticmanager != null) {
            serverstatisticmanager.save();
        }
        if ((advancementdataplayer = player.getAdvancements()) != null) {
            advancementdataplayer.save();
        }
    }

    public void removePhotographer(ServerPhotographer entityplayer) {
        ServerLevel worldserver = entityplayer.serverLevel();
        entityplayer.awardStat(Stats.LEAVE_GAME);
        if (entityplayer.containerMenu != entityplayer.inventoryMenu) {
            entityplayer.closeContainer(InventoryCloseEvent.Reason.DISCONNECT);
        }
        if (this.server.isSameThread()) {
            entityplayer.doTick();
        }
        if (this.collideRuleTeamName != null) {
            ServerScoreboard scoreBoard = this.server.getLevel(Level.OVERWORLD).getScoreboard();
            PlayerTeam team = scoreBoard.getPlayersTeam(this.collideRuleTeamName);
            if (entityplayer.getTeam() == team && team != null) {
                ((Scoreboard)scoreBoard).removePlayerFromTeam(entityplayer.getScoreboardName(), team);
            }
        }
        worldserver.removePlayerImmediately(entityplayer, Entity.RemovalReason.UNLOADED_WITH_PLAYER);
        entityplayer.retireScheduler();
        entityplayer.getAdvancements().stopListening();
        this.players.remove(entityplayer);
        this.playersByName.remove(entityplayer.getScoreboardName().toLowerCase(Locale.ROOT));
        this.server.getCustomBossEvents().onPlayerDisconnect(entityplayer);
        UUID uuid = entityplayer.getUUID();
        ServerPlayer entityplayer1 = this.playersByUUID.get(uuid);
        if (entityplayer1 == entityplayer) {
            this.playersByUUID.remove(uuid);
        }
        this.cserver.getScoreboardManager().removePlayer(entityplayer.getBukkitEntity());
    }

    public Component remove(ServerPlayer entityplayer) {
        return this.remove(entityplayer, (Component)Component.translatable((String)"multiplayer.player.left", (TextColor)NamedTextColor.YELLOW, (ComponentLike[])new ComponentLike[]{GlobalConfiguration.get().messages.useDisplayNameInQuitMessage ? entityplayer.getBukkitEntity().displayName() : PaperAdventure.asAdventure(entityplayer.getDisplayName())}));
    }

    public Component remove(ServerPlayer entityplayer, Component leaveMessage) {
        Entity entity;
        LeavesProtocolManager.handlePlayerLeave(entityplayer);
        ServerLevel worldserver = entityplayer.serverLevel();
        entityplayer.awardStat(Stats.LEAVE_GAME);
        if (entityplayer.containerMenu != entityplayer.inventoryMenu) {
            entityplayer.closeContainer(InventoryCloseEvent.Reason.DISCONNECT);
        }
        PlayerQuitEvent playerQuitEvent = new PlayerQuitEvent((org.bukkit.entity.Player)entityplayer.getBukkitEntity(), (Component)Component.translatable((String)"multiplayer.player.left", (TextColor)NamedTextColor.YELLOW, (ComponentLike[])new ComponentLike[]{GlobalConfiguration.get().messages.useDisplayNameInQuitMessage ? entityplayer.getBukkitEntity().displayName() : PaperAdventure.asAdventure(entityplayer.getDisplayName())}), entityplayer.quitReason);
        this.cserver.getPluginManager().callEvent((Event)playerQuitEvent);
        entityplayer.getBukkitEntity().disconnect(playerQuitEvent.getQuitMessage());
        if (this.server.isSameThread()) {
            entityplayer.doTick();
        }
        if (this.collideRuleTeamName != null) {
            ServerScoreboard scoreBoard = this.server.getLevel(Level.OVERWORLD).getScoreboard();
            PlayerTeam team = scoreBoard.getPlayersTeam(this.collideRuleTeamName);
            if (entityplayer.getTeam() == team && team != null) {
                ((Scoreboard)scoreBoard).removePlayerFromTeam(entityplayer.getScoreboardName(), team);
            }
        }
        if (!entityplayer.containerMenu.getCarried().isEmpty()) {
            ItemStack carried = entityplayer.containerMenu.getCarried();
            entityplayer.containerMenu.setCarried(ItemStack.EMPTY);
            entityplayer.drop(carried, false);
        }
        this.save(entityplayer);
        if (entityplayer.isPassenger() && (entity = entityplayer.getRootVehicle()).hasExactlyOnePlayerPassenger()) {
            LOGGER.debug("Removing player mount");
            entityplayer.stopRiding();
            entity.getPassengersAndSelf().forEach(entity1 -> {
                AbstractVillager villager;
                Player human;
                if (entity1 instanceof AbstractVillager && (human = (villager = (AbstractVillager)entity1).getTradingPlayer()) != null) {
                    villager.setTradingPlayer(null);
                }
                entity1.setRemoved(Entity.RemovalReason.UNLOADED_WITH_PLAYER, EntityRemoveEvent.Cause.PLAYER_QUIT);
            });
        }
        entityplayer.unRide();
        worldserver.removePlayerImmediately(entityplayer, Entity.RemovalReason.UNLOADED_WITH_PLAYER);
        entityplayer.retireScheduler();
        entityplayer.getAdvancements().stopListening();
        this.players.remove(entityplayer);
        this.realPlayers.remove(entityplayer);
        this.playersByName.remove(entityplayer.getScoreboardName().toLowerCase(Locale.ROOT));
        this.server.getCustomBossEvents().onPlayerDisconnect(entityplayer);
        UUID uuid = entityplayer.getUUID();
        ServerPlayer entityplayer1 = this.playersByUUID.get(uuid);
        if (entityplayer1 == entityplayer) {
            this.playersByUUID.remove(uuid);
        }
        ClientboundPlayerInfoRemovePacket packet = new ClientboundPlayerInfoRemovePacket(List.of(entityplayer.getUUID()));
        for (int i = 0; i < this.players.size(); ++i) {
            ServerPlayer entityplayer2 = this.players.get(i);
            if (entityplayer2.getBukkitEntity().canSee(entityplayer.getBukkitEntity())) {
                entityplayer2.connection.send(packet);
                continue;
            }
            entityplayer2.getBukkitEntity().onEntityRemove(entityplayer);
        }
        this.cserver.getScoreboardManager().removePlayer(entityplayer.getBukkitEntity());
        return playerQuitEvent.quitMessage();
    }

    public ServerPlayer canPlayerLogin(ServerLoginPacketListenerImpl loginlistener, GameProfile gameprofile) {
        UserBanListEntry gameprofilebanentry;
        UUID uuid = gameprofile.getId();
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < this.players.size(); ++i) {
            ServerPlayer entityplayer = this.players.get(i);
            if (!entityplayer.getUUID().equals(uuid) && (!GlobalConfiguration.get().proxies.isProxyOnlineMode() || !entityplayer.getGameProfile().getName().equalsIgnoreCase(gameprofile.getName()))) continue;
            list.add(entityplayer);
        }
        for (ServerPlayer entityplayer : list) {
            this.save(entityplayer);
            entityplayer.connection.disconnect(net.minecraft.network.chat.Component.translatable("multiplayer.disconnect.duplicate_login"), PlayerKickEvent.Cause.DUPLICATE_LOGIN);
        }
        SocketAddress socketaddress = loginlistener.connection.getRemoteAddress();
        ServerPlayer entity = new ServerPlayer(this.server, this.server.getLevel(Level.OVERWORLD), gameprofile, ClientInformation.createDefault());
        entity.transferCookieConnection = loginlistener;
        CraftPlayer player = entity.getBukkitEntity();
        PlayerLoginEvent event = new PlayerLoginEvent((org.bukkit.entity.Player)player, loginlistener.connection.hostname, ((InetSocketAddress)socketaddress).getAddress(), ((InetSocketAddress)loginlistener.connection.channel.remoteAddress()).getAddress());
        if (this.bans.isBanned(gameprofile) && (gameprofilebanentry = (UserBanListEntry)this.bans.get(gameprofile)) != null) {
            MutableComponent ichatmutablecomponent = net.minecraft.network.chat.Component.translatable("multiplayer.disconnect.banned.reason", gameprofilebanentry.getReason());
            if (gameprofilebanentry.getExpires() != null) {
                ichatmutablecomponent.append(net.minecraft.network.chat.Component.translatable("multiplayer.disconnect.banned.expiration", BAN_DATE_FORMAT.format(gameprofilebanentry.getExpires())));
            }
            event.disallow(PlayerLoginEvent.Result.KICK_BANNED, PaperAdventure.asAdventure(ichatmutablecomponent));
        } else if (this.isWhiteListed(gameprofile, event)) {
            if (this.getIpBans().isBanned(socketaddress) && this.getIpBans().get(socketaddress) != null && !this.getIpBans().get(socketaddress).hasExpired()) {
                IpBanListEntry ipbanentry = this.ipBans.get(socketaddress);
                MutableComponent ichatmutablecomponent = net.minecraft.network.chat.Component.translatable("multiplayer.disconnect.banned_ip.reason", ipbanentry.getReason());
                if (ipbanentry.getExpires() != null) {
                    ichatmutablecomponent.append(net.minecraft.network.chat.Component.translatable("multiplayer.disconnect.banned_ip.expiration", BAN_DATE_FORMAT.format(ipbanentry.getExpires())));
                }
                event.disallow(PlayerLoginEvent.Result.KICK_BANNED, PaperAdventure.asAdventure(ichatmutablecomponent));
            } else if (this.realPlayers.size() >= this.maxPlayers && !this.canBypassPlayerLimit(gameprofile)) {
                event.disallow(PlayerLoginEvent.Result.KICK_FULL, (Component)LegacyComponentSerializer.legacySection().deserialize(SpigotConfig.serverFullMessage));
            }
        }
        this.cserver.getPluginManager().callEvent((Event)event);
        if (event.getResult() != PlayerLoginEvent.Result.ALLOWED) {
            loginlistener.disconnect(PaperAdventure.asVanilla(event.kickMessage()));
            return null;
        }
        return entity;
    }

    public ServerPlayer getPlayerForLogin(GameProfile gameprofile, ClientInformation clientinformation, ServerPlayer player) {
        player.updateOptions(clientinformation);
        return player;
    }

    public boolean disconnectAllPlayersWithProfile(GameProfile gameprofile, ServerPlayer player) {
        return player == null;
    }

    public ServerPlayer respawn(ServerPlayer entityplayer, boolean flag, PlayerRespawnEvent.RespawnReason reason) {
        return this.respawn(entityplayer, this.server.getLevel(entityplayer.getRespawnDimension()), flag, null, true, reason);
    }

    public ServerPlayer respawn(ServerPlayer entityplayer, ServerLevel worldserver, boolean flag, Location location, boolean avoidSuffocation, PlayerRespawnEvent.RespawnReason reason) {
        return this.respawn(entityplayer, worldserver, flag, location, avoidSuffocation, reason, new PlayerRespawnEvent.RespawnFlag[0]);
    }

    public ServerPlayer respawn(ServerPlayer entityplayer, ServerLevel worldserver, boolean flag, Location location, boolean avoidSuffocation, PlayerRespawnEvent.RespawnReason reason, PlayerRespawnEvent.RespawnFlag ... respawnFlags) {
        ServerLevel worldserver1;
        entityplayer.stopRiding();
        this.players.remove(entityplayer);
        this.playersByName.remove(entityplayer.getScoreboardName().toLowerCase(Locale.ROOT));
        entityplayer.serverLevel().removePlayerImmediately(entityplayer, Entity.RemovalReason.DISCARDED);
        BlockPos blockposition = entityplayer.getRespawnPosition();
        float f = entityplayer.getRespawnAngle();
        boolean flag1 = entityplayer.isRespawnForced();
        ServerPlayer entityplayer1 = entityplayer;
        World fromWorld = entityplayer.getBukkitEntity().getWorld();
        entityplayer.wonGame = false;
        entityplayer1.connection = entityplayer.connection;
        entityplayer1.restoreFrom(entityplayer, flag);
        entityplayer1.setId(entityplayer.getId());
        entityplayer1.setMainArm(entityplayer.getMainArm());
        for (String s : entityplayer.getTags()) {
            entityplayer1.addTag(s);
        }
        boolean flag2 = false;
        boolean isBedSpawn = false;
        boolean isAnchorSpawn = false;
        boolean isRespawn = false;
        boolean isLocAltered = false;
        if (location == null) {
            worldserver1 = this.server.getLevel(entityplayer.getRespawnDimension());
            if (worldserver1 != null) {
                Optional<Object> optional = blockposition != null ? Player.findRespawnPositionAndUseSpawnBlock(worldserver1, blockposition, f, flag1, true) : Optional.empty();
                if (optional.isPresent()) {
                    float f1;
                    boolean flag3;
                    BlockState iblockdata = worldserver1.getBlockState(blockposition);
                    isAnchorSpawn = flag3 = iblockdata.is(Blocks.RESPAWN_ANCHOR);
                    Vec3 vec3d = (Vec3)optional.get();
                    if (!iblockdata.is(BlockTags.BEDS) && !flag3) {
                        f1 = f;
                    } else {
                        Vec3 vec3d1 = Vec3.atBottomCenterOf(blockposition).subtract(vec3d).normalize();
                        f1 = (float)Mth.wrapDegrees(Mth.atan2(vec3d1.z, vec3d1.x) * 57.2957763671875 - 90.0);
                    }
                    flag2 = !flag && flag3;
                    isBedSpawn = true;
                    location = CraftLocation.toBukkit(vec3d, (World)worldserver1.getWorld(), f1, 0.0f);
                } else if (blockposition != null) {
                    entityplayer1.connection.send(new ClientboundGameEventPacket(ClientboundGameEventPacket.NO_RESPAWN_BLOCK_AVAILABLE, 0.0f));
                    entityplayer1.setRespawnPosition(null, null, 0.0f, false, false, PlayerSetSpawnEvent.Cause.PLAYER_RESPAWN);
                }
            }
            if (location == null) {
                worldserver1 = this.server.getLevel(Level.OVERWORLD);
                blockposition = entityplayer1.getSpawnPoint(worldserver1);
                location = CraftLocation.toBukkit(blockposition, (World)worldserver1.getWorld(), worldserver1.levelData.getSpawnAngle(), 0.0f).add(0.5, (double)0.1f, 0.5);
            }
            CraftPlayer respawnPlayer = entityplayer1.getBukkitEntity();
            PlayerRespawnEvent respawnEvent = new PlayerRespawnEvent((org.bukkit.entity.Player)respawnPlayer, location, isBedSpawn && !isAnchorSpawn, isAnchorSpawn, reason, ImmutableSet.builder().add((Object[])respawnFlags));
            this.cserver.getPluginManager().callEvent((Event)respawnEvent);
            if (entityplayer.connection.isDisconnected()) {
                return entityplayer;
            }
            if (!location.equals((Object)respawnEvent.getRespawnLocation())) {
                location = respawnEvent.getRespawnLocation();
                isLocAltered = true;
            }
            if (!flag) {
                entityplayer.reset();
            }
            isRespawn = true;
        } else {
            location.setWorld((World)worldserver.getWorld());
        }
        worldserver1 = ((CraftWorld)location.getWorld()).getHandle();
        entityplayer1.spawnIn(worldserver1);
        entityplayer1.unsetRemoved();
        entityplayer1.setShiftKeyDown(false);
        entityplayer1.forceSetPositionRotation(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        worldserver1.getChunkSource().addRegionTicket(TicketType.POST_TELEPORT, new ChunkPos(location.getBlockX() >> 4, location.getBlockZ() >> 4), 1, entityplayer.getId());
        while (avoidSuffocation && !worldserver1.noCollision(entityplayer1, entityplayer1.getBoundingBox(), true) && entityplayer1.getY() < (double)worldserver1.getMaxBuildHeight()) {
            entityplayer1.setPos(entityplayer1.getX(), entityplayer1.getY() + 1.0, entityplayer1.getZ());
        }
        boolean i = flag;
        ServerLevel worldserver2 = entityplayer1.serverLevel();
        LevelData worlddata = worldserver2.getLevelData();
        entityplayer1.connection.send(new ClientboundRespawnPacket(entityplayer1.createCommonSpawnInfo(worldserver2), (byte)(i ? 1 : 0)));
        entityplayer1.connection.send(new ClientboundSetChunkCacheRadiusPacket(worldserver1.getWorld().getSendViewDistance()));
        entityplayer1.connection.send(new ClientboundSetSimulationDistancePacket(worldserver1.getWorld().getSimulationDistance()));
        entityplayer1.connection.teleport(CraftLocation.toBukkit(entityplayer1.position(), (World)worldserver2.getWorld(), entityplayer1.getYRot(), entityplayer1.getXRot()));
        entityplayer1.connection.send(new ClientboundSetDefaultSpawnPositionPacket(worldserver1.getSharedSpawnPos(), worldserver1.getSharedSpawnAngle()));
        entityplayer1.connection.send(new ClientboundChangeDifficultyPacket(worlddata.getDifficulty(), worlddata.isDifficultyLocked()));
        entityplayer1.connection.send(new ClientboundSetExperiencePacket(entityplayer1.experienceProgress, entityplayer1.totalExperience, entityplayer1.experienceLevel));
        this.sendLevelInfo(entityplayer1, worldserver1);
        this.sendPlayerPermissionLevel(entityplayer1);
        if (!entityplayer.connection.isDisconnected()) {
            worldserver1.addRespawnedPlayer(entityplayer1);
            this.players.add(entityplayer1);
            this.playersByName.put(entityplayer1.getScoreboardName().toLowerCase(Locale.ROOT), entityplayer1);
            this.playersByUUID.put(entityplayer1.getUUID(), entityplayer1);
        }
        entityplayer1.setHealth(entityplayer1.getHealth());
        if (flag2 && !isLocAltered) {
            if (!flag1) {
                BlockState data = worldserver1.getBlockState(blockposition);
                worldserver1.setBlock(blockposition, (BlockState)data.setValue(RespawnAnchorBlock.CHARGE, data.getValue(RespawnAnchorBlock.CHARGE) - 1), 3);
            }
            entityplayer1.connection.send(new ClientboundSoundPacket(SoundEvents.RESPAWN_ANCHOR_DEPLETE, SoundSource.BLOCKS, location.getX(), location.getY(), location.getZ(), 1.0f, 1.0f, worldserver1.getRandom().nextLong()));
        }
        this.sendAllPlayerInfo(entityplayer);
        entityplayer.onUpdateAbilities();
        for (MobEffectInstance mobEffect : entityplayer.getActiveEffects()) {
            entityplayer.connection.send(new ClientboundUpdateMobEffectPacket(entityplayer.getId(), mobEffect, false));
        }
        entityplayer.triggerDimensionChangeTriggers(((CraftWorld)fromWorld).getHandle());
        if (fromWorld != location.getWorld()) {
            PlayerChangedWorldEvent event = new PlayerChangedWorldEvent((org.bukkit.entity.Player)entityplayer.getBukkitEntity(), fromWorld);
            this.server.server.getPluginManager().callEvent((Event)event);
            if (LeavesConfig.netherPortalFix) {
                BlockPos lastPos;
                ResourceKey<Level> fromDim = entityplayer.level().dimension();
                ResourceKey<Level> toDim = entityplayer1.level().dimension();
                ResourceKey<Level> OVERWORLD = Level.OVERWORLD;
                ResourceKey<Level> THE_NETHER = Level.NETHER;
                if ((fromDim == OVERWORLD && toDim == THE_NETHER || fromDim == THE_NETHER && toDim == OVERWORLD) && (lastPos = entityplayer1.lastPos) != null) {
                    BlockUtil.FoundRectangle fromPortal = ReturnPortalManager.findPortalAt(entityplayer1, fromDim, lastPos);
                    BlockPos toPos = entityplayer1.blockPosition();
                    if (fromPortal != null) {
                        ReturnPortalManager.storeReturnPortal(entityplayer1, toDim, toPos, fromPortal);
                    }
                }
            }
        }
        if (entityplayer.connection.isDisconnected()) {
            this.save(entityplayer);
        }
        if (isRespawn) {
            this.cserver.getPluginManager().callEvent((Event)new PlayerPostRespawnEvent((org.bukkit.entity.Player)entityplayer.getBukkitEntity(), location, isBedSpawn));
        }
        if (LeavesConfig.fakeplayerSupport) {
            ServerBot.getBots().forEach(bot1 -> bot1.sendFakeDataIfNeed(entityplayer1, true));
        }
        return entityplayer1;
    }

    public void sendPlayerPermissionLevel(ServerPlayer player) {
        this.sendPlayerPermissionLevel(player, true);
    }

    public void sendPlayerPermissionLevel(ServerPlayer player, boolean recalculatePermissions) {
        GameProfile gameprofile = player.getGameProfile();
        int i = this.server.getProfilePermissions(gameprofile);
        this.sendPlayerPermissionLevel(player, i, recalculatePermissions);
    }

    public void tick() {
        if (++this.sendAllPlayerInfoIn > 600) {
            for (int i = 0; i < this.players.size(); ++i) {
                final ServerPlayer target = this.players.get(i);
                target.connection.send(new ClientboundPlayerInfoUpdatePacket(EnumSet.of(ClientboundPlayerInfoUpdatePacket.Action.UPDATE_LATENCY), this.players.stream().filter(new Predicate<ServerPlayer>(){

                    @Override
                    public boolean test(ServerPlayer input) {
                        return target.getBukkitEntity().canSee(input.getBukkitEntity());
                    }
                }).collect(Collectors.toList())));
            }
            this.sendAllPlayerInfoIn = 0;
        }
    }

    public void broadcastAll(Packet<?> packet) {
        for (ServerPlayer entityplayer : this.players) {
            entityplayer.connection.send(packet);
        }
    }

    public void broadcastAll(Packet packet, Player entityhuman) {
        for (int i = 0; i < this.players.size(); ++i) {
            ServerPlayer entityplayer = this.players.get(i);
            if (entityhuman != null && !entityplayer.getBukkitEntity().canSee(entityhuman.getBukkitEntity())) continue;
            this.players.get((int)i).connection.send(packet);
        }
    }

    public void broadcastAll(Packet packet, Level world) {
        for (int i = 0; i < world.players().size(); ++i) {
            ((ServerPlayer)world.players().get((int)i)).connection.send(packet);
        }
    }

    public void broadcastAll(Packet<?> packet, ResourceKey<Level> dimension) {
        for (ServerPlayer entityplayer : this.players) {
            if (entityplayer.level().dimension() != dimension) continue;
            entityplayer.connection.send(packet);
        }
    }

    public void broadcastSystemToTeam(Player source, net.minecraft.network.chat.Component message) {
        PlayerTeam scoreboardteam = source.getTeam();
        if (scoreboardteam != null) {
            Collection<String> collection = scoreboardteam.getPlayers();
            for (String s : collection) {
                ServerPlayer entityplayer = this.getPlayerByName(s);
                if (entityplayer == null || entityplayer == source) continue;
                entityplayer.sendSystemMessage(message);
            }
        }
    }

    public void broadcastSystemToAllExceptTeam(Player source, net.minecraft.network.chat.Component message) {
        PlayerTeam scoreboardteam = source.getTeam();
        if (scoreboardteam == null) {
            this.broadcastSystemMessage(message, false);
        } else {
            for (int i = 0; i < this.players.size(); ++i) {
                ServerPlayer entityplayer = this.players.get(i);
                if (entityplayer.getTeam() == scoreboardteam) continue;
                entityplayer.sendSystemMessage(message);
            }
        }
    }

    public String[] getPlayerNamesArray() {
        int i;
        String[] astring = new String[this.players.size() + ServerBot.getBots().size()];
        for (i = 0; i < this.players.size(); ++i) {
            astring[i] = this.players.get(i).getGameProfile().getName();
        }
        for (i = this.players.size(); i < astring.length; ++i) {
            astring[i] = ((ServerPlayer)ServerBot.getBots().get(i - this.players.size())).getGameProfile().getName();
        }
        return astring;
    }

    public UserBanList getBans() {
        return this.bans;
    }

    public IpBanList getIpBans() {
        return this.ipBans;
    }

    public void op(GameProfile profile) {
        this.ops.add(new ServerOpListEntry(profile, this.server.getOperatorUserPermissionLevel(), this.ops.canBypassPlayerLimit(profile)));
        ServerPlayer entityplayer = this.getPlayer(profile.getId());
        if (entityplayer != null) {
            this.sendPlayerPermissionLevel(entityplayer);
        }
    }

    public void deop(GameProfile profile) {
        this.ops.remove(profile);
        ServerPlayer entityplayer = this.getPlayer(profile.getId());
        if (entityplayer != null) {
            this.sendPlayerPermissionLevel(entityplayer);
        }
    }

    private void sendPlayerPermissionLevel(ServerPlayer player, int permissionLevel) {
        this.sendPlayerPermissionLevel(player, permissionLevel, true);
    }

    public void sendPlayerPermissionLevel(ServerPlayer player, int permissionLevel, boolean recalculatePermissions) {
        if (player.connection != null) {
            byte b0 = permissionLevel <= 0 ? (byte)24 : (permissionLevel >= 4 ? (byte)28 : (byte)((byte)(24 + permissionLevel)));
            player.connection.send(new ClientboundEntityEventPacket(player, b0));
        }
        if (recalculatePermissions) {
            player.getBukkitEntity().recalculatePermissions();
            this.server.getCommands().sendCommands(player);
        }
    }

    public boolean isWhiteListed(GameProfile profile) {
        return this.isWhiteListed(profile, null);
    }

    public boolean isWhiteListed(GameProfile gameprofile, PlayerLoginEvent loginEvent) {
        boolean isOp = this.ops.contains(gameprofile);
        boolean isWhitelisted = !this.doWhiteList || isOp || this.whitelist.contains(gameprofile);
        ProfileWhitelistVerifyEvent event = new ProfileWhitelistVerifyEvent(MCUtil.toBukkit(gameprofile), this.doWhiteList, isWhitelisted, isOp, SpigotConfig.whitelistMessage);
        event.callEvent();
        if (!event.isWhitelisted()) {
            if (loginEvent != null) {
                loginEvent.disallow(PlayerLoginEvent.Result.KICK_WHITELIST, (Component)LegacyComponentSerializer.legacySection().deserialize(event.getKickMessage() == null ? SpigotConfig.whitelistMessage : event.getKickMessage()));
            }
            return false;
        }
        return true;
    }

    public boolean isOp(GameProfile profile) {
        return this.ops.contains(profile) || this.server.isSingleplayerOwner(profile) && this.server.getWorldData().isAllowCommands() || this.allowCommandsForAllPlayers;
    }

    @Nullable
    public ServerPlayer getPlayerByName(String name) {
        return this.playersByName.get(name.toLowerCase(Locale.ROOT));
    }

    public void broadcast(@Nullable Player player, double x, double y, double z, double distance, ResourceKey<Level> worldKey, Packet<?> packet) {
        for (int i = 0; i < this.players.size(); ++i) {
            double d6;
            double d5;
            double d4;
            ServerPlayer entityplayer = this.players.get(i);
            if (player != null && !entityplayer.getBukkitEntity().canSee(player.getBukkitEntity()) || entityplayer == player || entityplayer.level().dimension() != worldKey || !((d4 = x - entityplayer.getX()) * d4 + (d5 = y - entityplayer.getY()) * d5 + (d6 = z - entityplayer.getZ()) * d6 < distance * distance)) continue;
            entityplayer.connection.send(packet);
        }
    }

    public void saveAll() {
        this.saveAll(-1);
    }

    public void saveAll(int interval) {
        MCUtil.ensureMain("Save Players", () -> {
            int numSaved = 0;
            long now = MinecraftServer.currentTick;
            for (int i = 0; i < this.players.size(); ++i) {
                ServerPlayer entityplayer = this.players.get(i);
                if (interval != -1 && now - entityplayer.lastSave < (long)interval) continue;
                this.save(entityplayer);
                if (interval != -1 && ++numSaved >= GlobalConfiguration.get().playerAutoSave.maxPerTick()) break;
            }
            return null;
        });
    }

    public UserWhiteList getWhiteList() {
        return this.whitelist;
    }

    public String[] getWhiteListNames() {
        return this.whitelist.getUserList();
    }

    public ServerOpList getOps() {
        return this.ops;
    }

    public String[] getOpNames() {
        return this.ops.getUserList();
    }

    public void reloadWhiteList() {
    }

    public void sendLevelInfo(ServerPlayer player, ServerLevel world) {
        WorldBorder worldborder = player.level().getWorldBorder();
        player.connection.send(new ClientboundInitializeBorderPacket(worldborder));
        player.connection.send(new ClientboundSetTimePacket(world.getGameTime(), world.getDayTime(), world.getGameRules().getBoolean(GameRules.RULE_DAYLIGHT)));
        player.connection.send(new ClientboundSetDefaultSpawnPositionPacket(world.getSharedSpawnPos(), world.getSharedSpawnAngle()));
        XaeroMapProtocol.onSendWorldInfo(player);
        if (world.isRaining()) {
            player.setPlayerWeather(WeatherType.DOWNFALL, false);
            player.updateWeather(-world.rainLevel, world.rainLevel, -world.thunderLevel, world.thunderLevel);
        }
        player.connection.send(new ClientboundGameEventPacket(ClientboundGameEventPacket.LEVEL_CHUNKS_LOAD_START, 0.0f));
        this.server.tickRateManager().updateJoiningPlayer(player);
    }

    public void sendAllPlayerInfo(ServerPlayer player) {
        player.inventoryMenu.sendAllDataToRemote();
        player.getBukkitEntity().updateScaledHealth();
        player.refreshEntityData(player);
        player.connection.send(new ClientboundSetCarriedItemPacket(player.getInventory().selected));
        int i = player.level().getGameRules().getBoolean(GameRules.RULE_REDUCEDDEBUGINFO) ? 22 : 23;
        player.connection.send(new ClientboundEntityEventPacket(player, (byte)i));
        float immediateRespawn = player.level().getGameRules().getBoolean(GameRules.RULE_DO_IMMEDIATE_RESPAWN) ? 1.0f : 0.0f;
        player.connection.send(new ClientboundGameEventPacket(ClientboundGameEventPacket.IMMEDIATE_RESPAWN, immediateRespawn));
    }

    public int getPlayerCount() {
        return this.players.size();
    }

    public int getMaxPlayers() {
        return this.maxPlayers;
    }

    public boolean isUsingWhitelist() {
        return this.doWhiteList;
    }

    public void setUsingWhiteList(boolean whitelistEnabled) {
        new WhitelistToggleEvent(whitelistEnabled).callEvent();
        this.doWhiteList = whitelistEnabled;
    }

    public List<ServerPlayer> getPlayersWithAddress(String ip) {
        ArrayList list = Lists.newArrayList();
        for (ServerPlayer entityplayer : this.players) {
            if (!entityplayer.getIpAddress().equals(ip)) continue;
            list.add(entityplayer);
        }
        return list;
    }

    public int getViewDistance() {
        return this.viewDistance;
    }

    public int getSimulationDistance() {
        return this.simulationDistance;
    }

    public MinecraftServer getServer() {
        return this.server;
    }

    @Nullable
    public CompoundTag getSingleplayerData() {
        return null;
    }

    public void setAllowCommandsForAllPlayers(boolean cheatsAllowed) {
        this.allowCommandsForAllPlayers = cheatsAllowed;
    }

    public void removeAll() {
        this.removeAll(false);
    }

    public void removeAll(boolean isRestarting) {
        ServerScoreboard scoreboard;
        PlayerTeam team;
        for (ServerPlayer player : this.players) {
            if (isRestarting) {
                player.connection.disconnect(SpigotConfig.restartMessage, PlayerKickEvent.Cause.UNKNOWN);
                continue;
            }
            player.connection.disconnect(this.server.server.shutdownMessage(), PlayerKickEvent.Cause.UNKNOWN);
        }
        if (this.collideRuleTeamName != null && (team = (scoreboard = this.getServer().getLevel(Level.OVERWORLD).getScoreboard()).getPlayersTeam(this.collideRuleTeamName)) != null) {
            scoreboard.removePlayerTeam(team);
        }
    }

    public void broadcastMessage(net.minecraft.network.chat.Component[] iChatBaseComponents) {
        for (net.minecraft.network.chat.Component component : iChatBaseComponents) {
            this.broadcastSystemMessage(component, false);
        }
    }

    public void broadcastSystemMessage(net.minecraft.network.chat.Component message, boolean overlay) {
        this.broadcastSystemMessage(message, entityplayer -> message, overlay);
    }

    public void broadcastSystemMessage(net.minecraft.network.chat.Component message, Function<ServerPlayer, net.minecraft.network.chat.Component> playerMessageFactory, boolean overlay) {
        this.server.sendSystemMessage(message);
        for (ServerPlayer entityplayer : this.players) {
            net.minecraft.network.chat.Component ichatbasecomponent1 = playerMessageFactory.apply(entityplayer);
            if (ichatbasecomponent1 == null) continue;
            entityplayer.sendSystemMessage(ichatbasecomponent1, overlay);
        }
    }

    public void broadcastChatMessage(PlayerChatMessage message, CommandSourceStack source, ChatType.Bound params) {
        Objects.requireNonNull(source);
        this.broadcastChatMessage(message, source::shouldFilterMessageTo, source.getPlayer(), params);
    }

    public void broadcastChatMessage(PlayerChatMessage message, ServerPlayer sender, ChatType.Bound params) {
        this.broadcastChatMessage(message, sender, params, null);
    }

    public void broadcastChatMessage(PlayerChatMessage message, ServerPlayer sender, ChatType.Bound params, @Nullable Function<Audience, net.minecraft.network.chat.Component> unsignedFunction) {
        Objects.requireNonNull(sender);
        this.broadcastChatMessage(message, sender::shouldFilterMessageTo, sender, params, unsignedFunction);
    }

    private void broadcastChatMessage(PlayerChatMessage message, Predicate<ServerPlayer> shouldSendFiltered, @Nullable ServerPlayer sender, ChatType.Bound params) {
        this.broadcastChatMessage(message, shouldSendFiltered, sender, params, null);
    }

    public void broadcastChatMessage(PlayerChatMessage message, Predicate<ServerPlayer> shouldSendFiltered, @Nullable ServerPlayer sender, ChatType.Bound params, @Nullable Function<Audience, net.minecraft.network.chat.Component> unsignedFunction) {
        boolean flag = this.verifyChatTrusted(message);
        this.server.logChatMessage(unsignedFunction == null ? message.decoratedContent() : unsignedFunction.apply((Audience)this.server.console), params, flag ? null : "Not Secure");
        OutgoingChatMessage outgoingchatmessage = OutgoingChatMessage.create(message);
        boolean flag1 = false;
        ClientboundDisguisedChatPacket disguised = sender != null && unsignedFunction == null ? new ClientboundDisguisedChatPacket(outgoingchatmessage.content(), params) : null;
        for (ServerPlayer entityplayer1 : this.players) {
            boolean flag2 = shouldSendFiltered.test(entityplayer1);
            if (sender != null && !entityplayer1.getBukkitEntity().canSee(sender.getBukkitEntity())) {
                entityplayer1.connection.send(unsignedFunction != null ? new ClientboundDisguisedChatPacket(unsignedFunction.apply((Audience)entityplayer1.getBukkitEntity()), params) : disguised);
            } else {
                entityplayer1.sendChatMessage(outgoingchatmessage, flag2, params, unsignedFunction == null ? null : unsignedFunction.apply((Audience)entityplayer1.getBukkitEntity()));
            }
            flag1 |= flag2 && message.isFullyFiltered();
        }
        if (flag1 && sender != null) {
            sender.sendSystemMessage(CHAT_FILTERED_FULL);
        }
    }

    public boolean verifyChatTrusted(PlayerChatMessage message) {
        return LeavesConfig.noChatSign || message.hasSignature() && !message.hasExpiredServer(Instant.now());
    }

    public ServerStatsCounter getPlayerStats(ServerPlayer entityhuman) {
        ServerStatsCounter serverstatisticmanager = entityhuman.getStats();
        return serverstatisticmanager == null ? this.getPlayerStats(entityhuman.getUUID(), entityhuman.getGameProfile().getName()) : serverstatisticmanager;
    }

    public ServerStatsCounter getPlayerStats(UUID uuid, String displayName) {
        ServerStatsCounter serverstatisticmanager;
        ServerPlayer entityhuman = this.getPlayer(uuid);
        ServerStatsCounter serverStatsCounter = serverstatisticmanager = entityhuman == null ? null : entityhuman.getStats();
        if (serverstatisticmanager == null) {
            File file2;
            Path path;
            File file = this.server.getWorldPath(LevelResource.PLAYER_STATS_DIR).toFile();
            File file1 = new File(file, String.valueOf(uuid) + ".json");
            if (!file1.exists() && FileUtil.isPathNormalized(path = (file2 = new File(file, displayName + ".json")).toPath()) && FileUtil.isPathPortable(path) && path.startsWith(file.getPath()) && file2.isFile()) {
                file2.renameTo(file1);
            }
            serverstatisticmanager = new ServerStatsCounter(this.server, file1);
        }
        return serverstatisticmanager;
    }

    public PlayerAdvancements getPlayerAdvancements(ServerPlayer player) {
        UUID uuid = player.getUUID();
        PlayerAdvancements advancementdataplayer = player.getAdvancements();
        if (advancementdataplayer == null) {
            Path path = this.server.getWorldPath(LevelResource.PLAYER_ADVANCEMENTS_DIR).resolve(String.valueOf(uuid) + ".json");
            advancementdataplayer = new PlayerAdvancements(this.server.getFixerUpper(), this, this.server.getAdvancements(), path, player);
        }
        advancementdataplayer.setPlayer(player);
        return advancementdataplayer;
    }

    public void setViewDistance(int viewDistance) {
        this.viewDistance = viewDistance;
        for (ServerLevel worldserver : this.server.getAllLevels()) {
            if (worldserver == null) continue;
            worldserver.getChunkSource().setViewDistance(viewDistance);
        }
    }

    public void setSimulationDistance(int simulationDistance) {
        this.simulationDistance = simulationDistance;
        for (ServerLevel worldserver : this.server.getAllLevels()) {
            if (worldserver == null) continue;
            worldserver.getChunkSource().setSimulationDistance(simulationDistance);
        }
    }

    public List<ServerPlayer> getPlayers() {
        return this.players;
    }

    @Nullable
    public ServerPlayer getPlayer(UUID uuid) {
        return this.playersByUUID.get(uuid);
    }

    public boolean canBypassPlayerLimit(GameProfile profile) {
        return false;
    }

    public void reloadResources() {
        this.reloadAdvancementData();
        this.reloadTagData();
        this.reloadRecipeData();
    }

    public void reloadAdvancementData() {
        for (ServerPlayer player : this.players) {
            player.getAdvancements().reload(this.server.getAdvancements());
            player.getAdvancements().flushDirty(player);
        }
    }

    public void reloadTagData() {
        this.broadcastAll(new ClientboundUpdateTagsPacket(TagNetworkSerialization.serializeTagsToNetwork(this.registries)));
    }

    public void reloadRecipeData() {
        ClientboundUpdateRecipesPacket packetplayoutrecipeupdate = new ClientboundUpdateRecipesPacket(this.server.getRecipeManager().getOrderedRecipes());
        for (ServerPlayer entityplayer : this.players) {
            entityplayer.connection.send(packetplayoutrecipeupdate);
            entityplayer.getRecipeBook().sendInitialRecipeBook(entityplayer);
        }
    }

    public boolean isAllowCommandsForAllPlayers() {
        return this.allowCommandsForAllPlayers;
    }

    public void addNewBot(ServerBot bot) {
        this.playersByName.put(bot.getScoreboardName().toLowerCase(Locale.ROOT), bot);
        this.playersByUUID.put(bot.getUUID(), bot);
    }

    public void removeBot(ServerBot bot) {
        this.playersByName.remove(bot.getScoreboardName().toLowerCase(Locale.ROOT));
        this.playersByUUID.remove(bot.getUUID());
    }
}

