/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.players;

import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.server.players.StoredUserEntry;

public class ServerOpListEntry
extends StoredUserEntry<GameProfile> {
    private final int level;
    private final boolean bypassesPlayerLimit;

    public ServerOpListEntry(GameProfile profile, int permissionLevel, boolean bypassPlayerLimit) {
        super(profile);
        this.level = permissionLevel;
        this.bypassesPlayerLimit = bypassPlayerLimit;
    }

    public ServerOpListEntry(JsonObject json) {
        super(ServerOpListEntry.createGameProfile(json));
        this.level = json.has("level") ? json.get("level").getAsInt() : 0;
        this.bypassesPlayerLimit = json.has("bypassesPlayerLimit") && json.get("bypassesPlayerLimit").getAsBoolean();
    }

    public int getLevel() {
        return this.level;
    }

    public boolean getBypassesPlayerLimit() {
        return this.bypassesPlayerLimit;
    }

    @Override
    @Override
    protected void serialize(JsonObject json) {
        if (this.getUser() == null) {
            return;
        }
        json.addProperty("uuid", ((GameProfile)this.getUser()).getId().toString());
        json.addProperty("name", ((GameProfile)this.getUser()).getName());
        json.addProperty("level", (Number)this.level);
        json.addProperty("bypassesPlayerLimit", Boolean.valueOf(this.bypassesPlayerLimit));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    private static GameProfile createGameProfile(JsonObject json) {
        void uUID2;
        if (!json.has("uuid") || !json.has("name")) {
            return null;
        }
        String string = json.get("uuid").getAsString();
        try {
            UUID uUID = UUID.fromString(string);
        }
        catch (Throwable throwable) {
            return null;
        }
        return new GameProfile((UUID)uUID2, json.get("name").getAsString());
    }
}

