/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.players;

import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import java.util.UUID;
import net.minecraft.server.players.StoredUserEntry;

public class UserWhiteListEntry
extends StoredUserEntry<GameProfile> {
    public UserWhiteListEntry(GameProfile profile) {
        super(profile);
    }

    public UserWhiteListEntry(JsonObject json) {
        super(UserWhiteListEntry.createGameProfile(json));
    }

    @Override
    @Override
    protected void serialize(JsonObject json) {
        if (this.getUser() == null) {
            return;
        }
        json.addProperty("uuid", ((GameProfile)this.getUser()).getId() == null ? "" : ((GameProfile)this.getUser()).getId().toString());
        json.addProperty("name", ((GameProfile)this.getUser()).getName());
    }

    /*
     * WARNING - void declaration
     */
    private static GameProfile createGameProfile(JsonObject json) {
        void uUID2;
        if (!json.has("uuid") || !json.has("name")) {
            return null;
        }
        String string = json.get("uuid").getAsString();
        try {
            UUID uUID = UUID.fromString(string);
        }
        catch (Throwable throwable) {
            return null;
        }
        return new GameProfile((UUID)uUID2, json.get("name").getAsString());
    }
}

