/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.annotations.VisibleForTesting;
import java.util.AbstractList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.SequencedCollection;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.util.ListAndDeque;

public class ArrayListDeque<T>
extends AbstractList<T>
implements ListAndDeque<T> {
    private static final int MIN_GROWTH = 1;
    private Object[] contents;
    private int head;
    private int size;

    public ArrayListDeque() {
        this(1);
    }

    public ArrayListDeque(int size) {
        this.contents = new Object[size];
        this.head = 0;
        this.size = 0;
    }

    @Override
    @Override
    public int size() {
        return this.size;
    }

    @VisibleForTesting
    public int capacity() {
        return this.contents.length;
    }

    private int getIndex(int index) {
        return (index + this.head) % this.contents.length;
    }

    @Override
    @Override
    public T get(int i) {
        this.verifyIndexInRange(i);
        return this.getInner(this.getIndex(i));
    }

    private static void verifyIndexInRange(int start, int end) {
        if (start < 0 || start >= end) {
            throw new IndexOutOfBoundsException(start);
        }
    }

    private void verifyIndexInRange(int index) {
        ArrayListDeque.verifyIndexInRange(index, this.size);
    }

    private T getInner(int index) {
        return (T)this.contents[index];
    }

    @Override
    @Override
    public T set(int i, T object) {
        this.verifyIndexInRange(i);
        Objects.requireNonNull(object);
        int j = this.getIndex(i);
        T object2 = this.getInner(j);
        this.contents[j] = object;
        return object2;
    }

    @Override
    @Override
    public void add(int i, T object) {
        ArrayListDeque.verifyIndexInRange(i, this.size + 1);
        Objects.requireNonNull(object);
        if (this.size == this.contents.length) {
            this.grow();
        }
        int j = this.getIndex(i);
        if (i == this.size) {
            this.contents[j] = object;
        } else if (i == 0) {
            --this.head;
            if (this.head < 0) {
                this.head += this.contents.length;
            }
            this.contents[this.getIndex((int)0)] = object;
        } else {
            for (int k = this.size - 1; k >= i; --k) {
                this.contents[this.getIndex((int)(k + 1))] = this.contents[this.getIndex(k)];
            }
            this.contents[j] = object;
        }
        ++this.modCount;
        ++this.size;
    }

    private void grow() {
        int i = this.contents.length + Math.max(this.contents.length >> 1, 1);
        Object[] objects = new Object[i];
        this.copyCount(objects, this.size);
        this.head = 0;
        this.contents = objects;
    }

    @Override
    @Override
    public T remove(int i) {
        this.verifyIndexInRange(i);
        int j = this.getIndex(i);
        T object = this.getInner(j);
        if (i == 0) {
            this.contents[j] = null;
            ++this.head;
        } else if (i == this.size - 1) {
            this.contents[j] = null;
        } else {
            for (int k = i + 1; k < this.size; ++k) {
                this.contents[this.getIndex((int)(k - 1))] = this.get(k);
            }
            this.contents[this.getIndex((int)(this.size - 1))] = null;
        }
        ++this.modCount;
        --this.size;
        return object;
    }

    @Override
    @Override
    public boolean removeIf(Predicate<? super T> predicate) {
        int i = 0;
        for (int j = 0; j < this.size; ++j) {
            T object = this.get(j);
            if (predicate.test(object)) {
                ++i;
                continue;
            }
            if (i == 0) continue;
            this.contents[this.getIndex((int)(j - i))] = object;
            this.contents[this.getIndex((int)j)] = null;
        }
        this.modCount += i;
        this.size -= i;
        return i != 0;
    }

    private void copyCount(Object[] array, int size) {
        for (int i = 0; i < size; ++i) {
            array[i] = this.get(i);
        }
    }

    @Override
    @Override
    public void replaceAll(UnaryOperator<T> unaryOperator) {
        for (int i = 0; i < this.size; ++i) {
            int j = this.getIndex(i);
            this.contents[j] = Objects.requireNonNull(unaryOperator.apply(this.getInner(i)));
        }
    }

    @Override
    @Override
    public void forEach(Consumer<? super T> consumer) {
        for (int i = 0; i < this.size; ++i) {
            consumer.accept(this.get(i));
        }
    }

    @Override
    @Override
    public void addFirst(T object) {
        this.add(0, object);
    }

    @Override
    @Override
    public void addLast(T object) {
        this.add(this.size, object);
    }

    @Override
    @Override
    public boolean offerFirst(T object) {
        this.addFirst(object);
        return true;
    }

    @Override
    @Override
    public boolean offerLast(T object) {
        this.addLast(object);
        return true;
    }

    @Override
    @Override
    public T removeFirst() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.remove(0);
    }

    @Override
    @Override
    public T removeLast() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.remove(this.size - 1);
    }

    @Override
    @Override
    public ListAndDeque<T> reversed() {
        return new ReversedView(this);
    }

    @Override
    @Nullable
    @Override
    public T pollFirst() {
        if (this.size == 0) {
            return null;
        }
        return this.removeFirst();
    }

    @Override
    @Nullable
    @Override
    public T pollLast() {
        if (this.size == 0) {
            return null;
        }
        return this.removeLast();
    }

    @Override
    @Override
    public T getFirst() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.get(0);
    }

    @Override
    @Override
    public T getLast() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.get(this.size - 1);
    }

    @Override
    @Nullable
    @Override
    public T peekFirst() {
        if (this.size == 0) {
            return null;
        }
        return this.getFirst();
    }

    @Override
    @Nullable
    @Override
    public T peekLast() {
        if (this.size == 0) {
            return null;
        }
        return this.getLast();
    }

    @Override
    @Override
    public boolean removeFirstOccurrence(Object object) {
        for (int i = 0; i < this.size; ++i) {
            T object2 = this.get(i);
            if (!Objects.equals(object, object2)) continue;
            this.remove(i);
            return true;
        }
        return false;
    }

    @Override
    @Override
    public boolean removeLastOccurrence(Object object) {
        for (int i = this.size - 1; i >= 0; --i) {
            T object2 = this.get(i);
            if (!Objects.equals(object, object2)) continue;
            this.remove(i);
            return true;
        }
        return false;
    }

    @Override
    @Override
    public Iterator<T> descendingIterator() {
        return new DescendingIterator();
    }

    @Override
    public /* synthetic */ List reversed() {
        return this.reversed();
    }

    @Override
    public /* synthetic */ SequencedCollection reversed() {
        return this.reversed();
    }

    @Override
    public /* synthetic */ Deque reversed() {
        return this.reversed();
    }

    class ReversedView
    extends AbstractList<T>
    implements ListAndDeque<T> {
        private final ArrayListDeque<T> source;

        public ReversedView(ArrayListDeque<T> original) {
            this.source = original;
        }

        @Override
        @Override
        public ListAndDeque<T> reversed() {
            return this.source;
        }

        @Override
        @Override
        public T getFirst() {
            return this.source.getLast();
        }

        @Override
        @Override
        public T getLast() {
            return this.source.getFirst();
        }

        @Override
        @Override
        public void addFirst(T object) {
            this.source.addLast(object);
        }

        @Override
        @Override
        public void addLast(T object) {
            this.source.addFirst(object);
        }

        @Override
        @Override
        public boolean offerFirst(T object) {
            return this.source.offerLast(object);
        }

        @Override
        @Override
        public boolean offerLast(T object) {
            return this.source.offerFirst(object);
        }

        @Override
        @Override
        public T pollFirst() {
            return this.source.pollLast();
        }

        @Override
        @Override
        public T pollLast() {
            return this.source.pollFirst();
        }

        @Override
        @Override
        public T peekFirst() {
            return this.source.peekLast();
        }

        @Override
        @Override
        public T peekLast() {
            return this.source.peekFirst();
        }

        @Override
        @Override
        public T removeFirst() {
            return this.source.removeLast();
        }

        @Override
        @Override
        public T removeLast() {
            return this.source.removeFirst();
        }

        @Override
        @Override
        public boolean removeFirstOccurrence(Object object) {
            return this.source.removeLastOccurrence(object);
        }

        @Override
        @Override
        public boolean removeLastOccurrence(Object object) {
            return this.source.removeFirstOccurrence(object);
        }

        @Override
        @Override
        public Iterator<T> descendingIterator() {
            return this.source.iterator();
        }

        @Override
        @Override
        public int size() {
            return this.source.size();
        }

        @Override
        @Override
        public boolean isEmpty() {
            return this.source.isEmpty();
        }

        @Override
        @Override
        public boolean contains(Object object) {
            return this.source.contains(object);
        }

        @Override
        @Override
        public T get(int i) {
            return this.source.get(this.reverseIndex(i));
        }

        @Override
        @Override
        public T set(int i, T object) {
            return this.source.set(this.reverseIndex(i), object);
        }

        @Override
        @Override
        public void add(int i, T object) {
            this.source.add(this.reverseIndex(i) + 1, object);
        }

        @Override
        @Override
        public T remove(int i) {
            return this.source.remove(this.reverseIndex(i));
        }

        @Override
        @Override
        public int indexOf(Object object) {
            return this.reverseIndex(this.source.lastIndexOf(object));
        }

        @Override
        @Override
        public int lastIndexOf(Object object) {
            return this.reverseIndex(this.source.indexOf(object));
        }

        @Override
        @Override
        public List<T> subList(int i, int j) {
            return this.source.subList(this.reverseIndex(j) + 1, this.reverseIndex(i) + 1).reversed();
        }

        @Override
        @Override
        public Iterator<T> iterator() {
            return this.source.descendingIterator();
        }

        @Override
        @Override
        public void clear() {
            this.source.clear();
        }

        private int reverseIndex(int index) {
            return index == -1 ? -1 : this.source.size() - 1 - index;
        }

        @Override
        public /* synthetic */ List reversed() {
            return this.reversed();
        }

        @Override
        public /* synthetic */ SequencedCollection reversed() {
            return this.reversed();
        }

        @Override
        public /* synthetic */ Deque reversed() {
            return this.reversed();
        }
    }

    class DescendingIterator
    implements Iterator<T> {
        private int index;

        public DescendingIterator() {
            this.index = ArrayListDeque.this.size() - 1;
        }

        @Override
        @Override
        public boolean hasNext() {
            return this.index >= 0;
        }

        @Override
        @Override
        public T next() {
            return ArrayListDeque.this.get(this.index--);
        }

        @Override
        @Override
        public void remove() {
            ArrayListDeque.this.remove(this.index + 1);
        }
    }
}

