/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Contract;

public class GsonHelper {
    private static final Gson GSON = new GsonBuilder().create();

    public static boolean isStringValue(JsonObject object, String element) {
        if (!GsonHelper.isValidPrimitive(object, element)) {
            return false;
        }
        return object.getAsJsonPrimitive(element).isString();
    }

    public static boolean isStringValue(JsonElement element) {
        if (!element.isJsonPrimitive()) {
            return false;
        }
        return element.getAsJsonPrimitive().isString();
    }

    public static boolean isNumberValue(JsonObject object, String element) {
        if (!GsonHelper.isValidPrimitive(object, element)) {
            return false;
        }
        return object.getAsJsonPrimitive(element).isNumber();
    }

    public static boolean isNumberValue(JsonElement element) {
        if (!element.isJsonPrimitive()) {
            return false;
        }
        return element.getAsJsonPrimitive().isNumber();
    }

    public static boolean isBooleanValue(JsonObject object, String element) {
        if (!GsonHelper.isValidPrimitive(object, element)) {
            return false;
        }
        return object.getAsJsonPrimitive(element).isBoolean();
    }

    public static boolean isBooleanValue(JsonElement object) {
        if (!object.isJsonPrimitive()) {
            return false;
        }
        return object.getAsJsonPrimitive().isBoolean();
    }

    public static boolean isArrayNode(JsonObject object, String element) {
        if (!GsonHelper.isValidNode(object, element)) {
            return false;
        }
        return object.get(element).isJsonArray();
    }

    public static boolean isObjectNode(JsonObject object, String element) {
        if (!GsonHelper.isValidNode(object, element)) {
            return false;
        }
        return object.get(element).isJsonObject();
    }

    public static boolean isValidPrimitive(JsonObject object, String element) {
        if (!GsonHelper.isValidNode(object, element)) {
            return false;
        }
        return object.get(element).isJsonPrimitive();
    }

    public static boolean isValidNode(@Nullable JsonObject object, String element) {
        if (object == null) {
            return false;
        }
        return object.get(element) != null;
    }

    public static JsonElement getNonNull(JsonObject object, String name) {
        JsonElement jsonElement = object.get(name);
        if (jsonElement == null || jsonElement.isJsonNull()) {
            throw new JsonSyntaxException("Missing field " + name);
        }
        return jsonElement;
    }

    public static String convertToString(JsonElement element, String name) {
        if (element.isJsonPrimitive()) {
            return element.getAsString();
        }
        throw new JsonSyntaxException("Expected " + name + " to be a string, was " + GsonHelper.getType(element));
    }

    public static String getAsString(JsonObject object, String element) {
        if (object.has(element)) {
            return GsonHelper.convertToString(object.get(element), element);
        }
        throw new JsonSyntaxException("Missing " + element + ", expected to find a string");
    }

    @Nullable
    @Contract(value="_,_,!null->!null;_,_,null->_")
    public static String getAsString(JsonObject object, String element, @Nullable String defaultStr) {
        if (object.has(element)) {
            return GsonHelper.convertToString(object.get(element), element);
        }
        return defaultStr;
    }

    public static Holder<Item> convertToItem(JsonElement element, String name) {
        if (element.isJsonPrimitive()) {
            String string = element.getAsString();
            return BuiltInRegistries.ITEM.getHolder(new ResourceLocation(string)).orElseThrow(() -> new JsonSyntaxException("Expected " + name + " to be an item, was unknown string '" + string + "'"));
        }
        throw new JsonSyntaxException("Expected " + name + " to be an item, was " + GsonHelper.getType(element));
    }

    public static Holder<Item> getAsItem(JsonObject object, String key) {
        if (object.has(key)) {
            return GsonHelper.convertToItem(object.get(key), key);
        }
        throw new JsonSyntaxException("Missing " + key + ", expected to find an item");
    }

    @Nullable
    @Contract(value="_,_,!null->!null;_,_,null->_")
    public static Holder<Item> getAsItem(JsonObject object, String key, @Nullable Holder<Item> defaultValue) {
        if (object.has(key)) {
            return GsonHelper.convertToItem(object.get(key), key);
        }
        return defaultValue;
    }

    public static boolean convertToBoolean(JsonElement element, String name) {
        if (element.isJsonPrimitive()) {
            return element.getAsBoolean();
        }
        throw new JsonSyntaxException("Expected " + name + " to be a Boolean, was " + GsonHelper.getType(element));
    }

    public static boolean getAsBoolean(JsonObject object, String element) {
        if (object.has(element)) {
            return GsonHelper.convertToBoolean(object.get(element), element);
        }
        throw new JsonSyntaxException("Missing " + element + ", expected to find a Boolean");
    }

    public static boolean getAsBoolean(JsonObject object, String element, boolean defaultBoolean) {
        if (object.has(element)) {
            return GsonHelper.convertToBoolean(object.get(element), element);
        }
        return defaultBoolean;
    }

    public static double convertToDouble(JsonElement object, String name) {
        if (object.isJsonPrimitive() && object.getAsJsonPrimitive().isNumber()) {
            return object.getAsDouble();
        }
        throw new JsonSyntaxException("Expected " + name + " to be a Double, was " + GsonHelper.getType(object));
    }

    public static double getAsDouble(JsonObject object, String element) {
        if (object.has(element)) {
            return GsonHelper.convertToDouble(object.get(element), element);
        }
        throw new JsonSyntaxException("Missing " + element + ", expected to find a Double");
    }

    public static double getAsDouble(JsonObject object, String element, double defaultDouble) {
        if (object.has(element)) {
            return GsonHelper.convertToDouble(object.get(element), element);
        }
        return defaultDouble;
    }

    public static float convertToFloat(JsonElement element, String name) {
        if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isNumber()) {
            return element.getAsFloat();
        }
        throw new JsonSyntaxException("Expected " + name + " to be a Float, was " + GsonHelper.getType(element));
    }

    public static float getAsFloat(JsonObject object, String element) {
        if (object.has(element)) {
            return GsonHelper.convertToFloat(object.get(element), element);
        }
        throw new JsonSyntaxException("Missing " + element + ", expected to find a Float");
    }

    public static float getAsFloat(JsonObject object, String element, float defaultFloat) {
        if (object.has(element)) {
            return GsonHelper.convertToFloat(object.get(element), element);
        }
        return defaultFloat;
    }

    public static long convertToLong(JsonElement element, String name) {
        if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isNumber()) {
            return element.getAsLong();
        }
        throw new JsonSyntaxException("Expected " + name + " to be a Long, was " + GsonHelper.getType(element));
    }

    public static long getAsLong(JsonObject object, String name) {
        if (object.has(name)) {
            return GsonHelper.convertToLong(object.get(name), name);
        }
        throw new JsonSyntaxException("Missing " + name + ", expected to find a Long");
    }

    public static long getAsLong(JsonObject object, String element, long defaultLong) {
        if (object.has(element)) {
            return GsonHelper.convertToLong(object.get(element), element);
        }
        return defaultLong;
    }

    public static int convertToInt(JsonElement element, String name) {
        if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isNumber()) {
            return element.getAsInt();
        }
        throw new JsonSyntaxException("Expected " + name + " to be a Int, was " + GsonHelper.getType(element));
    }

    public static int getAsInt(JsonObject object, String element) {
        if (object.has(element)) {
            return GsonHelper.convertToInt(object.get(element), element);
        }
        throw new JsonSyntaxException("Missing " + element + ", expected to find a Int");
    }

    public static int getAsInt(JsonObject object, String element, int defaultInt) {
        if (object.has(element)) {
            return GsonHelper.convertToInt(object.get(element), element);
        }
        return defaultInt;
    }

    public static byte convertToByte(JsonElement element, String name) {
        if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isNumber()) {
            return element.getAsByte();
        }
        throw new JsonSyntaxException("Expected " + name + " to be a Byte, was " + GsonHelper.getType(element));
    }

    public static byte getAsByte(JsonObject object, String element) {
        if (object.has(element)) {
            return GsonHelper.convertToByte(object.get(element), element);
        }
        throw new JsonSyntaxException("Missing " + element + ", expected to find a Byte");
    }

    public static byte getAsByte(JsonObject object, String element, byte defaultByte) {
        if (object.has(element)) {
            return GsonHelper.convertToByte(object.get(element), element);
        }
        return defaultByte;
    }

    public static char convertToCharacter(JsonElement element, String name) {
        if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isNumber()) {
            return element.getAsCharacter();
        }
        throw new JsonSyntaxException("Expected " + name + " to be a Character, was " + GsonHelper.getType(element));
    }

    public static char getAsCharacter(JsonObject object, String element) {
        if (object.has(element)) {
            return GsonHelper.convertToCharacter(object.get(element), element);
        }
        throw new JsonSyntaxException("Missing " + element + ", expected to find a Character");
    }

    public static char getAsCharacter(JsonObject object, String element, char defaultChar) {
        if (object.has(element)) {
            return GsonHelper.convertToCharacter(object.get(element), element);
        }
        return defaultChar;
    }

    public static BigDecimal convertToBigDecimal(JsonElement element, String name) {
        if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isNumber()) {
            return element.getAsBigDecimal();
        }
        throw new JsonSyntaxException("Expected " + name + " to be a BigDecimal, was " + GsonHelper.getType(element));
    }

    public static BigDecimal getAsBigDecimal(JsonObject object, String element) {
        if (object.has(element)) {
            return GsonHelper.convertToBigDecimal(object.get(element), element);
        }
        throw new JsonSyntaxException("Missing " + element + ", expected to find a BigDecimal");
    }

    public static BigDecimal getAsBigDecimal(JsonObject object, String element, BigDecimal defaultBigDecimal) {
        if (object.has(element)) {
            return GsonHelper.convertToBigDecimal(object.get(element), element);
        }
        return defaultBigDecimal;
    }

    public static BigInteger convertToBigInteger(JsonElement element, String name) {
        if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isNumber()) {
            return element.getAsBigInteger();
        }
        throw new JsonSyntaxException("Expected " + name + " to be a BigInteger, was " + GsonHelper.getType(element));
    }

    public static BigInteger getAsBigInteger(JsonObject object, String element) {
        if (object.has(element)) {
            return GsonHelper.convertToBigInteger(object.get(element), element);
        }
        throw new JsonSyntaxException("Missing " + element + ", expected to find a BigInteger");
    }

    public static BigInteger getAsBigInteger(JsonObject object, String element, BigInteger defaultBigInteger) {
        if (object.has(element)) {
            return GsonHelper.convertToBigInteger(object.get(element), element);
        }
        return defaultBigInteger;
    }

    public static short convertToShort(JsonElement element, String name) {
        if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isNumber()) {
            return element.getAsShort();
        }
        throw new JsonSyntaxException("Expected " + name + " to be a Short, was " + GsonHelper.getType(element));
    }

    public static short getAsShort(JsonObject object, String element) {
        if (object.has(element)) {
            return GsonHelper.convertToShort(object.get(element), element);
        }
        throw new JsonSyntaxException("Missing " + element + ", expected to find a Short");
    }

    public static short getAsShort(JsonObject object, String element, short defaultShort) {
        if (object.has(element)) {
            return GsonHelper.convertToShort(object.get(element), element);
        }
        return defaultShort;
    }

    public static JsonObject convertToJsonObject(JsonElement element, String name) {
        if (element.isJsonObject()) {
            return element.getAsJsonObject();
        }
        throw new JsonSyntaxException("Expected " + name + " to be a JsonObject, was " + GsonHelper.getType(element));
    }

    public static JsonObject getAsJsonObject(JsonObject object, String element) {
        if (object.has(element)) {
            return GsonHelper.convertToJsonObject(object.get(element), element);
        }
        throw new JsonSyntaxException("Missing " + element + ", expected to find a JsonObject");
    }

    @Nullable
    @Contract(value="_,_,!null->!null;_,_,null->_")
    public static JsonObject getAsJsonObject(JsonObject object, String element, @Nullable JsonObject defaultObject) {
        if (object.has(element)) {
            return GsonHelper.convertToJsonObject(object.get(element), element);
        }
        return defaultObject;
    }

    public static JsonArray convertToJsonArray(JsonElement element, String name) {
        if (element.isJsonArray()) {
            return element.getAsJsonArray();
        }
        throw new JsonSyntaxException("Expected " + name + " to be a JsonArray, was " + GsonHelper.getType(element));
    }

    public static JsonArray getAsJsonArray(JsonObject object, String element) {
        if (object.has(element)) {
            return GsonHelper.convertToJsonArray(object.get(element), element);
        }
        throw new JsonSyntaxException("Missing " + element + ", expected to find a JsonArray");
    }

    @Nullable
    @Contract(value="_,_,!null->!null;_,_,null->_")
    public static JsonArray getAsJsonArray(JsonObject object, String name, @Nullable JsonArray defaultArray) {
        if (object.has(name)) {
            return GsonHelper.convertToJsonArray(object.get(name), name);
        }
        return defaultArray;
    }

    public static <T> T convertToObject(@Nullable JsonElement element, String name, JsonDeserializationContext context, Class<? extends T> type) {
        if (element != null) {
            return (T)context.deserialize(element, type);
        }
        throw new JsonSyntaxException("Missing " + name);
    }

    public static <T> T getAsObject(JsonObject object, String element, JsonDeserializationContext context, Class<? extends T> type) {
        if (object.has(element)) {
            return GsonHelper.convertToObject(object.get(element), element, context, type);
        }
        throw new JsonSyntaxException("Missing " + element);
    }

    @Nullable
    @Contract(value="_,_,!null,_,_->!null;_,_,null,_,_->_")
    public static <T> T getAsObject(JsonObject object, String element, @Nullable T defaultValue, JsonDeserializationContext context, Class<? extends T> type) {
        if (object.has(element)) {
            return GsonHelper.convertToObject(object.get(element), element, context, type);
        }
        return defaultValue;
    }

    public static String getType(@Nullable JsonElement element) {
        String string = StringUtils.abbreviateMiddle((String)String.valueOf(element), (String)"...", (int)10);
        if (element == null) {
            return "null (missing)";
        }
        if (element.isJsonNull()) {
            return "null (json)";
        }
        if (element.isJsonArray()) {
            return "an array (" + string + ")";
        }
        if (element.isJsonObject()) {
            return "an object (" + string + ")";
        }
        if (element.isJsonPrimitive()) {
            JsonPrimitive jsonPrimitive = element.getAsJsonPrimitive();
            if (jsonPrimitive.isNumber()) {
                return "a number (" + string + ")";
            }
            if (jsonPrimitive.isBoolean()) {
                return "a boolean (" + string + ")";
            }
        }
        return string;
    }

    @Nullable
    public static <T> T fromNullableJson(Gson gson, Reader reader, Class<T> type, boolean lenient) {
        try {
            JsonReader jsonReader = new JsonReader(reader);
            jsonReader.setLenient(lenient);
            return (T)gson.getAdapter(type).read(jsonReader);
        }
        catch (IOException iOException) {
            throw new JsonParseException((Throwable)iOException);
        }
    }

    public static <T> T fromJson(Gson gson, Reader reader, Class<T> type, boolean lenient) {
        T object = GsonHelper.fromNullableJson(gson, reader, type, lenient);
        if (object == null) {
            throw new JsonParseException("JSON data was null or empty");
        }
        return object;
    }

    @Nullable
    public static <T> T fromNullableJson(Gson gson, Reader reader, TypeToken<T> typeToken, boolean lenient) {
        try {
            JsonReader jsonReader = new JsonReader(reader);
            jsonReader.setLenient(lenient);
            return (T)gson.getAdapter(typeToken).read(jsonReader);
        }
        catch (IOException iOException) {
            throw new JsonParseException((Throwable)iOException);
        }
    }

    public static <T> T fromJson(Gson gson, Reader reader, TypeToken<T> typeToken, boolean lenient) {
        T object = GsonHelper.fromNullableJson(gson, reader, typeToken, lenient);
        if (object == null) {
            throw new JsonParseException("JSON data was null or empty");
        }
        return object;
    }

    @Nullable
    public static <T> T fromNullableJson(Gson gson, String content, TypeToken<T> typeToken, boolean lenient) {
        return GsonHelper.fromNullableJson(gson, (Reader)new StringReader(content), typeToken, lenient);
    }

    public static <T> T fromJson(Gson gson, String content, Class<T> type, boolean lenient) {
        return GsonHelper.fromJson(gson, (Reader)new StringReader(content), type, lenient);
    }

    @Nullable
    public static <T> T fromNullableJson(Gson gson, String content, Class<T> type, boolean lenient) {
        return GsonHelper.fromNullableJson(gson, (Reader)new StringReader(content), type, lenient);
    }

    public static <T> T fromJson(Gson gson, Reader reader, TypeToken<T> typeToken) {
        return GsonHelper.fromJson(gson, reader, typeToken, false);
    }

    @Nullable
    public static <T> T fromNullableJson(Gson gson, String content, TypeToken<T> typeToken) {
        return GsonHelper.fromNullableJson(gson, content, typeToken, false);
    }

    public static <T> T fromJson(Gson gson, Reader reader, Class<T> type) {
        return GsonHelper.fromJson(gson, reader, type, false);
    }

    public static <T> T fromJson(Gson gson, String content, Class<T> type) {
        return GsonHelper.fromJson(gson, content, type, false);
    }

    public static JsonObject parse(String content, boolean lenient) {
        return GsonHelper.parse(new StringReader(content), lenient);
    }

    public static JsonObject parse(Reader reader, boolean lenient) {
        return GsonHelper.fromJson(GSON, reader, JsonObject.class, lenient);
    }

    public static JsonObject parse(String content) {
        return GsonHelper.parse(content, false);
    }

    public static JsonObject parse(Reader reader) {
        return GsonHelper.parse(reader, false);
    }

    public static JsonArray parseArray(String content) {
        return GsonHelper.parseArray(new StringReader(content));
    }

    public static JsonArray parseArray(Reader reader) {
        return GsonHelper.fromJson(GSON, reader, JsonArray.class, false);
    }

    public static String toStableString(JsonElement json) {
        StringWriter stringWriter = new StringWriter();
        JsonWriter jsonWriter = new JsonWriter((Writer)stringWriter);
        try {
            GsonHelper.writeValue(jsonWriter, json, Comparator.naturalOrder());
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
        return stringWriter.toString();
    }

    public static void writeValue(JsonWriter writer, @Nullable JsonElement json, @Nullable Comparator<String> comparator) throws IOException {
        if (json == null || json.isJsonNull()) {
            writer.nullValue();
        } else if (json.isJsonPrimitive()) {
            JsonPrimitive jsonPrimitive = json.getAsJsonPrimitive();
            if (jsonPrimitive.isNumber()) {
                writer.value(jsonPrimitive.getAsNumber());
            } else if (jsonPrimitive.isBoolean()) {
                writer.value(jsonPrimitive.getAsBoolean());
            } else {
                writer.value(jsonPrimitive.getAsString());
            }
        } else if (json.isJsonArray()) {
            writer.beginArray();
            for (JsonElement jsonElement : json.getAsJsonArray()) {
                GsonHelper.writeValue(writer, jsonElement, comparator);
            }
            writer.endArray();
        } else if (json.isJsonObject()) {
            writer.beginObject();
            for (Map.Entry<String, JsonElement> entry : GsonHelper.sortByKeyIfNeeded(json.getAsJsonObject().entrySet(), comparator)) {
                writer.name(entry.getKey());
                GsonHelper.writeValue(writer, entry.getValue(), comparator);
            }
            writer.endObject();
        } else {
            throw new IllegalArgumentException("Couldn't write " + String.valueOf(json.getClass()));
        }
    }

    private static Collection<Map.Entry<String, JsonElement>> sortByKeyIfNeeded(Collection<Map.Entry<String, JsonElement>> entries, @Nullable Comparator<String> comparator) {
        if (comparator == null) {
            return entries;
        }
        ArrayList<Map.Entry<String, JsonElement>> list = new ArrayList<Map.Entry<String, JsonElement>>(entries);
        list.sort(Map.Entry.comparingByKey(comparator));
        return list;
    }
}

