/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import java.util.function.IntConsumer;
import javax.annotation.Nullable;
import net.minecraft.util.BitStorage;
import net.minecraft.world.level.chunk.Palette;
import org.apache.commons.lang3.Validate;

public class SimpleBitStorage
implements BitStorage {
    private static final int[] MAGIC = new int[]{-1, -1, 0, Integer.MIN_VALUE, 0, 0, 0x55555555, 0x55555555, 0, Integer.MIN_VALUE, 0, 1, 0x33333333, 0x33333333, 0, 0x2AAAAAAA, 0x2AAAAAAA, 0, 0x24924924, 0x24924924, 0, Integer.MIN_VALUE, 0, 2, 0x1C71C71C, 0x1C71C71C, 0, 0x19999999, 0x19999999, 0, 390451572, 390451572, 0, 0x15555555, 0x15555555, 0, 0x13B13B13, 0x13B13B13, 0, 306783378, 306783378, 0, 0x11111111, 0x11111111, 0, Integer.MIN_VALUE, 0, 3, 0xF0F0F0F, 0xF0F0F0F, 0, 0xE38E38E, 0xE38E38E, 0, 226050910, 226050910, 0, 0xCCCCCCC, 0xCCCCCCC, 0, 0xC30C30C, 0xC30C30C, 0, 195225786, 195225786, 0, 186737708, 186737708, 0, 0xAAAAAAA, 0xAAAAAAA, 0, 171798691, 171798691, 0, 0x9D89D89, 0x9D89D89, 0, 159072862, 159072862, 0, 0x9249249, 0x9249249, 0, 148102320, 148102320, 0, 0x8888888, 0x8888888, 0, 138547332, 138547332, 0, Integer.MIN_VALUE, 0, 4, 130150524, 130150524, 0, 0x7878787, 0x7878787, 0, 0x7507507, 0x7507507, 0, 0x71C71C7, 0x71C71C7, 0, 116080197, 116080197, 0, 113025455, 113025455, 0, 0x6906906, 0x6906906, 0, 0x6666666, 0x6666666, 0, 104755299, 104755299, 0, 0x6186186, 0x6186186, 0, 99882960, 99882960, 0, 97612893, 97612893, 0, 0x5B05B05, 0x5B05B05, 0, 93368854, 93368854, 0, 91382282, 91382282, 0, 0x5555555, 0x5555555, 0, 87652393, 87652393, 0, 85899345, 85899345, 0, 0x5050505, 0x5050505, 0, 0x4EC4EC4, 0x4EC4EC4, 0, 81037118, 81037118, 0, 79536431, 79536431, 0, 78090314, 78090314, 0, 0x4924924, 0x4924924, 0, 75350303, 75350303, 0, 74051160, 74051160, 0, 72796055, 72796055, 0, 0x4444444, 0x4444444, 0, 70409299, 70409299, 0, 69273666, 69273666, 0, 0x4104104, 0x4104104, 0, Integer.MIN_VALUE, 0, 5};
    private final long[] data;
    private final int bits;
    private final long mask;
    private final int size;
    private final int valuesPerLong;
    private final int divideMul;
    private final long divideMulUnsigned;
    private final int divideAdd;
    private final long divideAddUnsigned;
    private final int divideShift;

    public SimpleBitStorage(int elementBits, int size, int[] data) {
        this(elementBits, size);
        int j;
        int i = 0;
        for (j = 0; j <= size - this.valuesPerLong; j += this.valuesPerLong) {
            long l = 0L;
            for (int k = this.valuesPerLong - 1; k >= 0; --k) {
                l <<= elementBits;
                l |= (long)data[j + k] & this.mask;
            }
            this.data[i++] = l;
        }
        int m = size - j;
        if (m > 0) {
            long n = 0L;
            for (int o = m - 1; o >= 0; --o) {
                n <<= elementBits;
                n |= (long)data[j + o] & this.mask;
            }
            this.data[i] = n;
        }
    }

    public SimpleBitStorage(int elementBits, int size) {
        this(elementBits, size, (long[])null);
    }

    public SimpleBitStorage(int elementBits, int size, @Nullable long[] data) {
        Validate.inclusiveBetween((long)1L, (long)32L, (long)elementBits);
        this.size = size;
        this.bits = elementBits;
        this.mask = (1L << elementBits) - 1L;
        this.valuesPerLong = (char)(64 / elementBits);
        int i = 3 * (this.valuesPerLong - 1);
        this.divideMul = MAGIC[i + 0];
        this.divideMulUnsigned = Integer.toUnsignedLong(this.divideMul);
        this.divideAdd = MAGIC[i + 1];
        this.divideAddUnsigned = Integer.toUnsignedLong(this.divideAdd);
        this.divideShift = MAGIC[i + 2];
        int j = (size + this.valuesPerLong - 1) / this.valuesPerLong;
        if (data != null) {
            if (data.length != j) {
                throw new InitializationException("Invalid length given for storage, got: " + data.length + " but expected: " + j);
            }
            this.data = data;
        } else {
            this.data = new long[j];
        }
    }

    private int cellIndex(int index) {
        return (int)((long)index * this.divideMulUnsigned + this.divideAddUnsigned >> 32 >> this.divideShift);
    }

    @Override
    public final int getAndSet(int index, int value) {
        int i = this.cellIndex(index);
        long l = this.data[i];
        int j = (index - i * this.valuesPerLong) * this.bits;
        int k = (int)(l >> j & this.mask);
        this.data[i] = l & (this.mask << j ^ 0xFFFFFFFFFFFFFFFFL) | ((long)value & this.mask) << j;
        return k;
    }

    @Override
    public final void set(int index, int value) {
        int i = this.cellIndex(index);
        long l = this.data[i];
        int j = (index - i * this.valuesPerLong) * this.bits;
        this.data[i] = l & (this.mask << j ^ 0xFFFFFFFFFFFFFFFFL) | ((long)value & this.mask) << j;
    }

    @Override
    public final int get(int index) {
        int i = this.cellIndex(index);
        long l = this.data[i];
        int j = (index - i * this.valuesPerLong) * this.bits;
        return (int)(l >> j & this.mask);
    }

    @Override
    public long[] getRaw() {
        return this.data;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public int getBits() {
        return this.bits;
    }

    @Override
    public final void forEach(BitStorage.DataBitConsumer consumer) {
        int i = 0;
        for (long l : this.data) {
            for (int i1 = 0; i1 < this.valuesPerLong; ++i1) {
                consumer.accept(i, (int)(l & this.mask));
                l >>= this.bits;
                if (++i < this.size) continue;
                return;
            }
        }
    }

    @Override
    public void getAll(IntConsumer action) {
        int i = 0;
        for (long l : this.data) {
            for (int j = 0; j < this.valuesPerLong; ++j) {
                action.accept((int)(l & this.mask));
                l >>= this.bits;
                if (++i < this.size) continue;
                return;
            }
        }
    }

    @Override
    public void unpack(int[] out) {
        int i = this.data.length;
        int j = 0;
        for (int k = 0; k < i - 1; ++k) {
            long l = this.data[k];
            for (int m = 0; m < this.valuesPerLong; ++m) {
                out[j + m] = (int)(l & this.mask);
                l >>= this.bits;
            }
            j += this.valuesPerLong;
        }
        int n = this.size - j;
        if (n > 0) {
            long o = this.data[i - 1];
            for (int p = 0; p < n; ++p) {
                out[j + p] = (int)(o & this.mask);
                o >>= this.bits;
            }
        }
    }

    @Override
    public BitStorage copy() {
        return new SimpleBitStorage(this.bits, this.size, (long[])this.data.clone());
    }

    @Override
    public <T> void compact(Palette<T> srcPalette, Palette<T> dstPalette, short[] out) {
        if (this.size >= Short.MAX_VALUE) {
            throw new IllegalStateException("Array too large");
        }
        if (this.size != out.length) {
            throw new IllegalStateException("Array size mismatch");
        }
        short[] mappings = new short[(int)(this.mask + 1L)];
        int idx = 0;
        long[] lArray = this.data;
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            long word;
            long bits = word = lArray[i];
            for (int elementIdx = 0; elementIdx < this.valuesPerLong; ++elementIdx) {
                int value = (int)(bits & this.mask);
                int remappedId = mappings[value];
                if (remappedId == 0) {
                    remappedId = dstPalette.idFor(srcPalette.valueFor(value)) + 1;
                    mappings[value] = (short)remappedId;
                }
                out[idx] = (short)(remappedId - 1);
                bits >>= this.bits;
                if (++idx < this.size) continue;
                return;
            }
        }
    }

    public static class InitializationException
    extends RuntimeException {
        InitializationException(String message) {
            super(message);
        }
    }
}

