/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import java.util.Arrays;
import java.util.function.IntConsumer;
import net.minecraft.util.BitStorage;
import net.minecraft.world.level.chunk.Palette;
import org.leavesmc.leaves.util.ArrayConstants;

public class ZeroBitStorage
implements BitStorage {
    public static final long[] RAW = ArrayConstants.emptyLongArray;
    private final int size;

    public ZeroBitStorage(int size) {
        this.size = size;
    }

    @Override
    public final int getAndSet(int index, int value) {
        return 0;
    }

    @Override
    public final void set(int index, int value) {
    }

    @Override
    public final int get(int index) {
        return 0;
    }

    @Override
    public long[] getRaw() {
        return RAW;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public int getBits() {
        return 0;
    }

    @Override
    public void forEach(BitStorage.DataBitConsumer consumer) {
        for (int i = 0; i < this.size; ++i) {
            consumer.accept(i, 0);
        }
    }

    @Override
    public void getAll(IntConsumer action) {
        for (int i = 0; i < this.size; ++i) {
            action.accept(0);
        }
    }

    @Override
    public void unpack(int[] out) {
        Arrays.fill(out, 0, this.size, 0);
    }

    @Override
    public BitStorage copy() {
        return this;
    }

    @Override
    public <T> void compact(Palette<T> srcPalette, Palette<T> dstPalette, short[] out) {
    }
}

