/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import java.util.Arrays;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;

public abstract class AbstractUUIDFix
extends DataFix {
    protected DSL.TypeReference typeReference;

    public AbstractUUIDFix(Schema outputSchema, DSL.TypeReference typeReference) {
        super(outputSchema, false);
        this.typeReference = typeReference;
    }

    protected Typed<?> updateNamedChoice(Typed<?> typed2, String name, Function<Dynamic<?>, Dynamic<?>> updater) {
        Type type = this.getInputSchema().getChoiceType(this.typeReference, name);
        Type type2 = this.getOutputSchema().getChoiceType(this.typeReference, name);
        return typed2.updateTyped(DSL.namedChoice((String)name, (Type)type), type2, typed -> typed.update(DSL.remainderFinder(), updater));
    }

    protected static Optional<Dynamic<?>> replaceUUIDString(Dynamic<?> dynamic, String oldKey, String newKey) {
        return AbstractUUIDFix.createUUIDFromString(dynamic, oldKey).map(dynamic2 -> dynamic.remove(oldKey).set(newKey, (Dynamic<?>)((Object)dynamic2)));
    }

    protected static Optional<Dynamic<?>> replaceUUIDMLTag(Dynamic<?> dynamic, String oldKey, String newKey) {
        return dynamic.get(oldKey).result().flatMap(AbstractUUIDFix::createUUIDFromML).map(dynamic2 -> dynamic.remove(oldKey).set(newKey, (Dynamic<?>)((Object)dynamic2)));
    }

    protected static Optional<Dynamic<?>> replaceUUIDLeastMost(Dynamic<?> dynamic, String oldKey, String newKey) {
        String string = oldKey + "Most";
        String string2 = oldKey + "Least";
        return AbstractUUIDFix.createUUIDFromLongs(dynamic, string, string2).map(dynamic2 -> dynamic.remove(string).remove(string2).set(newKey, (Dynamic<?>)((Object)dynamic2)));
    }

    protected static Optional<Dynamic<?>> createUUIDFromString(Dynamic<?> dynamic, String key) {
        return dynamic.get(key).result().flatMap(dynamic2 -> {
            String string = dynamic2.asString(null);
            if (string != null) {
                try {
                    UUID uUID = UUID.fromString(string);
                    return AbstractUUIDFix.createUUIDTag(dynamic, uUID.getMostSignificantBits(), uUID.getLeastSignificantBits());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            return Optional.empty();
        });
    }

    protected static Optional<Dynamic<?>> createUUIDFromML(Dynamic<?> dynamic) {
        return AbstractUUIDFix.createUUIDFromLongs(dynamic, "M", "L");
    }

    protected static Optional<Dynamic<?>> createUUIDFromLongs(Dynamic<?> dynamic, String mostBitsKey, String leastBitsKey) {
        long l = dynamic.get(mostBitsKey).asLong(0L);
        long m = dynamic.get(leastBitsKey).asLong(0L);
        if (l == 0L || m == 0L) {
            return Optional.empty();
        }
        return AbstractUUIDFix.createUUIDTag(dynamic, l, m);
    }

    protected static Optional<Dynamic<?>> createUUIDTag(Dynamic<?> dynamic, long mostBits, long leastBits) {
        return Optional.of(dynamic.createIntList(Arrays.stream(new int[]{(int)(mostBits >> 32), (int)mostBits, (int)(leastBits >> 32), (int)leastBits})));
    }
}

