/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.Streams;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.serialization.Dynamic;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.util.datafix.ComponentDataFixUtils;
import net.minecraft.util.datafix.fixes.NamedEntityFix;
import net.minecraft.util.datafix.fixes.References;

public class DropInvalidSignDataFix
extends NamedEntityFix {
    private static final String[] FIELDS_TO_DROP = new String[]{"Text1", "Text2", "Text3", "Text4", "FilteredText1", "FilteredText2", "FilteredText3", "FilteredText4", "Color", "GlowingText"};

    public DropInvalidSignDataFix(Schema outputSchema, String name, String blockEntityId) {
        super(outputSchema, false, name, References.BLOCK_ENTITY, blockEntityId);
    }

    private static <T> Dynamic<T> fix(Dynamic<T> blockEntityData) {
        blockEntityData = blockEntityData.update("front_text", DropInvalidSignDataFix::fixText);
        blockEntityData = blockEntityData.update("back_text", DropInvalidSignDataFix::fixText);
        for (String string : FIELDS_TO_DROP) {
            blockEntityData = blockEntityData.remove(string);
        }
        return blockEntityData;
    }

    private static <T> Dynamic<T> fixText(Dynamic<T> textData) {
        boolean bl = textData.get("_filtered_correct").asBoolean(false);
        if (bl) {
            return textData.remove("_filtered_correct");
        }
        Optional optional = textData.get("filtered_messages").asStreamOpt().result();
        if (optional.isEmpty()) {
            return textData;
        }
        Dynamic dynamic = ComponentDataFixUtils.createEmptyComponent(textData.getOps());
        List<Dynamic> list = textData.get("messages").asStreamOpt().result().orElse(Stream.of(new Dynamic[0])).toList();
        List list2 = Streams.mapWithIndex((Stream)((Stream)optional.get()), (message, index) -> {
            Dynamic dynamic2 = index < (long)list.size() ? (Dynamic)((Object)((Object)list.get((int)index))) : dynamic;
            return message.equals((Object)dynamic) ? dynamic2 : message;
        }).toList();
        if (list2.stream().allMatch(message -> message.equals((Object)dynamic))) {
            return textData.remove("filtered_messages");
        }
        return textData.set("filtered_messages", textData.createList(list2.stream()));
    }

    @Override
    @Override
    protected Typed<?> fix(Typed<?> inputType) {
        return inputType.update(DSL.remainderFinder(), DropInvalidSignDataFix::fix);
    }
}

