/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.util.datafix.fixes.EntityRenameFix;
import net.minecraft.util.datafix.fixes.References;

public class EntityZombieSplitFix
extends EntityRenameFix {
    private final Supplier<Type<?>> zombieVillagerType = Suppliers.memoize(() -> this.getOutputSchema().getChoiceType(References.ENTITY, "ZombieVillager"));

    public EntityZombieSplitFix(Schema outputSchema) {
        super("EntityZombieSplitFix", outputSchema, true);
    }

    @Override
    @Override
    protected Pair<String, Typed<?>> fix(String choice, Typed<?> typed) {
        Typed<?> typed4;
        String string3;
        if (!choice.equals("Zombie")) {
            return Pair.of((Object)choice, typed);
        }
        Dynamic dynamic2 = (Dynamic)((Object)typed.getOptional(DSL.remainderFinder()).orElseThrow());
        int i = dynamic2.get("ZombieType").asInt(0);
        switch (i) {
            default: {
                String string = "Zombie";
                Typed<?> typed2 = typed;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                String string2 = "ZombieVillager";
                Typed<?> typed3 = this.changeSchemaToZombieVillager(typed, i - 1);
                break;
            }
            case 6: {
                string3 = "Husk";
                typed4 = typed;
            }
        }
        return Pair.of((Object)string3, (Object)typed4.update(DSL.remainderFinder(), dynamic -> dynamic.remove("ZombieType")));
    }

    private Typed<?> changeSchemaToZombieVillager(Typed<?> typed, int i) {
        return Util.writeAndReadTypedOrThrow(typed, this.zombieVillagerType.get(), dynamic -> dynamic.set("Profession", dynamic.createInt(i)));
    }
}

