/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.serialization.Dynamic;
import java.util.Map;
import java.util.Optional;
import net.minecraft.util.datafix.fixes.NamedEntityFix;
import net.minecraft.util.datafix.fixes.References;

public class VillagerDataFix
extends NamedEntityFix {
    public VillagerDataFix(Schema outputSchema, String entity) {
        super(outputSchema, false, "Villager profession data fix (" + entity + ")", References.ENTITY, entity);
    }

    @Override
    @Override
    protected Typed<?> fix(Typed<?> inputType) {
        Dynamic dynamic = (Dynamic)((Object)inputType.get(DSL.remainderFinder()));
        return inputType.set(DSL.remainderFinder(), dynamic.remove("Profession").remove("Career").remove("CareerLevel").set("VillagerData", dynamic.createMap((Map)ImmutableMap.of((Object)((Object)dynamic.createString("type")), (Object)((Object)dynamic.createString("minecraft:plains")), (Object)((Object)dynamic.createString("profession")), (Object)((Object)dynamic.createString(VillagerDataFix.upgradeData(dynamic.get("Profession").asInt(0), dynamic.get("Career").asInt(0)))), (Object)((Object)dynamic.createString("level")), (Object)((Object)((Dynamic)((Object)DataFixUtils.orElse((Optional)dynamic.get("CareerLevel").result(), (Object)((Object)dynamic.createInt(1))))))))));
    }

    private static String upgradeData(int professionId, int careerId) {
        if (professionId == 0) {
            if (careerId == 2) {
                return "minecraft:fisherman";
            }
            if (careerId == 3) {
                return "minecraft:shepherd";
            }
            if (careerId == 4) {
                return "minecraft:fletcher";
            }
            return "minecraft:farmer";
        }
        if (professionId == 1) {
            if (careerId == 2) {
                return "minecraft:cartographer";
            }
            return "minecraft:librarian";
        }
        if (professionId == 2) {
            return "minecraft:cleric";
        }
        if (professionId == 3) {
            if (careerId == 2) {
                return "minecraft:weaponsmith";
            }
            if (careerId == 3) {
                return "minecraft:toolsmith";
            }
            return "minecraft:armorer";
        }
        if (professionId == 4) {
            if (careerId == 2) {
                return "minecraft:leatherworker";
            }
            return "minecraft:butcher";
        }
        if (professionId == 5) {
            return "minecraft:nitwit";
        }
        return "minecraft:none";
    }
}

