/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.parsing.packrat.commands;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.parsing.packrat.ParseState;
import net.minecraft.util.parsing.packrat.Rule;

public class ResourceLocationParseRule
implements Rule<StringReader, ResourceLocation> {
    public static final Rule<StringReader, ResourceLocation> INSTANCE = new ResourceLocationParseRule();

    private ResourceLocationParseRule() {
    }

    @Override
    @Override
    public Optional<ResourceLocation> parse(ParseState<StringReader> state) {
        state.input().skipWhitespace();
        try {
            return Optional.of(ResourceLocation.readNonEmpty(state.input()));
        }
        catch (CommandSyntaxException commandSyntaxException) {
            return Optional.empty();
        }
    }
}

