/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.profiling;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongMaps;
import java.io.BufferedWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.util.profiling.ProfileResults;
import net.minecraft.util.profiling.ProfilerPathEntry;
import net.minecraft.util.profiling.ResultField;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;

public class FilledProfileResults
implements ProfileResults {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final ProfilerPathEntry EMPTY = new ProfilerPathEntry(){

        @Override
        @Override
        public long getDuration() {
            return 0L;
        }

        @Override
        @Override
        public long getMaxDuration() {
            return 0L;
        }

        @Override
        @Override
        public long getCount() {
            return 0L;
        }

        @Override
        @Override
        public Object2LongMap<String> getCounters() {
            return Object2LongMaps.emptyMap();
        }
    };
    private static final Splitter SPLITTER = Splitter.on((char)'\u001e');
    private static final Comparator<Map.Entry<String, CounterCollector>> COUNTER_ENTRY_COMPARATOR = Map.Entry.comparingByValue(Comparator.comparingLong(counterCollector -> counterCollector.totalValue)).reversed();
    private final Map<String, ? extends ProfilerPathEntry> entries;
    private final long startTimeNano;
    private final int startTimeTicks;
    private final long endTimeNano;
    private final int endTimeTicks;
    private final int tickDuration;

    public FilledProfileResults(Map<String, ? extends ProfilerPathEntry> locationInfos, long startTime, int startTick, long endTime, int endTick) {
        this.entries = locationInfos;
        this.startTimeNano = startTime;
        this.startTimeTicks = startTick;
        this.endTimeNano = endTime;
        this.endTimeTicks = endTick;
        this.tickDuration = endTick - startTick;
    }

    private ProfilerPathEntry getEntry(String path) {
        ProfilerPathEntry profilerPathEntry = this.entries.get(path);
        return profilerPathEntry != null ? profilerPathEntry : EMPTY;
    }

    @Override
    @Override
    public List<ResultField> getTimes(String parentPath) {
        String string = parentPath;
        ProfilerPathEntry profilerPathEntry = this.getEntry("root");
        long l = profilerPathEntry.getDuration();
        ProfilerPathEntry profilerPathEntry2 = this.getEntry((String)parentPath);
        long m = profilerPathEntry2.getDuration();
        long n = profilerPathEntry2.getCount();
        ArrayList list = Lists.newArrayList();
        if (!((String)parentPath).isEmpty()) {
            parentPath = (String)parentPath + "\u001e";
        }
        long o = 0L;
        for (String string2 : this.entries.keySet()) {
            if (!FilledProfileResults.isDirectChild((String)parentPath, string2)) continue;
            o += this.getEntry(string2).getDuration();
        }
        float f = o;
        if (o < m) {
            o = m;
        }
        if (l < o) {
            l = o;
        }
        for (String string3 : this.entries.keySet()) {
            if (!FilledProfileResults.isDirectChild((String)parentPath, string3)) continue;
            ProfilerPathEntry profilerPathEntry3 = this.getEntry(string3);
            long p = profilerPathEntry3.getDuration();
            double d = (double)p * 100.0 / (double)o;
            double e = (double)p * 100.0 / (double)l;
            String string4 = string3.substring(((String)parentPath).length());
            list.add(new ResultField(string4, d, e, profilerPathEntry3.getCount()));
        }
        if ((float)o > f) {
            list.add(new ResultField("unspecified", (double)((float)o - f) * 100.0 / (double)o, (double)((float)o - f) * 100.0 / (double)l, n));
        }
        Collections.sort(list);
        list.add(0, new ResultField(string, 100.0, (double)o * 100.0 / (double)l, n));
        return list;
    }

    private static boolean isDirectChild(String parent, String path) {
        return path.length() > parent.length() && path.startsWith(parent) && path.indexOf(30, parent.length() + 1) < 0;
    }

    private Map<String, CounterCollector> getCounterValues() {
        TreeMap map = Maps.newTreeMap();
        this.entries.forEach((location, info) -> {
            Object2LongMap<String> object2LongMap = info.getCounters();
            if (!object2LongMap.isEmpty()) {
                List list = SPLITTER.splitToList((CharSequence)location);
                object2LongMap.forEach((marker, count) -> map.computeIfAbsent(marker, k -> new CounterCollector()).addValue(list.iterator(), (long)count));
            }
        });
        return map;
    }

    @Override
    @Override
    public long getStartTimeNano() {
        return this.startTimeNano;
    }

    @Override
    @Override
    public int getStartTimeTicks() {
        return this.startTimeTicks;
    }

    @Override
    @Override
    public long getEndTimeNano() {
        return this.endTimeNano;
    }

    @Override
    @Override
    public int getEndTimeTicks() {
        return this.endTimeTicks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Override
    public boolean saveResults(Path path) {
        boolean bl;
        BufferedWriter writer = null;
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            writer = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);
            writer.write(this.getProfilerResults(this.getNanoDuration(), this.getTickDuration()));
            bl = true;
        }
        catch (Throwable throwable) {
            boolean bl2;
            try {
                LOGGER.error("Could not save profiler results to {}", (Object)path, (Object)throwable);
                bl2 = false;
            }
            catch (Throwable throwable2) {
                IOUtils.closeQuietly(writer);
                throw throwable2;
            }
            IOUtils.closeQuietly((Writer)writer);
            return bl2;
        }
        IOUtils.closeQuietly((Writer)writer);
        return bl;
    }

    protected String getProfilerResults(long timeSpan, int tickSpan) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("---- Minecraft Profiler Results ----\n");
        stringBuilder.append("// ");
        stringBuilder.append(FilledProfileResults.getComment());
        stringBuilder.append("\n\n");
        stringBuilder.append("Version: ").append(SharedConstants.getCurrentVersion().getId()).append('\n');
        stringBuilder.append("Time span: ").append(timeSpan / 1000000L).append(" ms\n");
        stringBuilder.append("Tick span: ").append(tickSpan).append(" ticks\n");
        stringBuilder.append("// This is approximately ").append(String.format(Locale.ROOT, "%.2f", Float.valueOf((float)tickSpan / ((float)timeSpan / 1.0E9f)))).append(" ticks per second. It should be ").append(20).append(" ticks per second\n\n");
        stringBuilder.append("--- BEGIN PROFILE DUMP ---\n\n");
        this.appendProfilerResults(0, "root", stringBuilder);
        stringBuilder.append("--- END PROFILE DUMP ---\n\n");
        Map<String, CounterCollector> map = this.getCounterValues();
        if (!map.isEmpty()) {
            stringBuilder.append("--- BEGIN COUNTER DUMP ---\n\n");
            this.appendCounters(map, stringBuilder, tickSpan);
            stringBuilder.append("--- END COUNTER DUMP ---\n\n");
        }
        return stringBuilder.toString();
    }

    @Override
    @Override
    public String getProfilerResults() {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendProfilerResults(0, "root", stringBuilder);
        return stringBuilder.toString();
    }

    private static StringBuilder indentLine(StringBuilder sb, int size) {
        sb.append(String.format(Locale.ROOT, "[%02d] ", size));
        for (int i = 0; i < size; ++i) {
            sb.append("|   ");
        }
        return sb;
    }

    private void appendProfilerResults(int level, String name, StringBuilder sb) {
        List<ResultField> list = this.getTimes(name);
        Object2LongMap<String> object2LongMap = ((ProfilerPathEntry)ObjectUtils.firstNonNull((Object[])new ProfilerPathEntry[]{this.entries.get(name), EMPTY})).getCounters();
        object2LongMap.forEach((marker, count) -> FilledProfileResults.indentLine(sb, level).append('#').append((String)marker).append(' ').append(count).append('/').append(count / (long)this.tickDuration).append('\n'));
        if (list.size() < 3) {
            return;
        }
        for (int i = 1; i < list.size(); ++i) {
            ResultField resultField = list.get(i);
            FilledProfileResults.indentLine(sb, level).append(resultField.name).append('(').append(resultField.count).append('/').append(String.format(Locale.ROOT, "%.0f", Float.valueOf((float)resultField.count / (float)this.tickDuration))).append(')').append(" - ").append(String.format(Locale.ROOT, "%.2f", resultField.percentage)).append("%/").append(String.format(Locale.ROOT, "%.2f", resultField.globalPercentage)).append("%\n");
            if ("unspecified".equals(resultField.name)) continue;
            try {
                this.appendProfilerResults(level + 1, name + "\u001e" + resultField.name, sb);
                continue;
            }
            catch (Exception exception) {
                sb.append("[[ EXCEPTION ").append(exception).append(" ]]");
            }
        }
    }

    private void appendCounterResults(int depth, String name, CounterCollector info, int tickSpan, StringBuilder sb) {
        FilledProfileResults.indentLine(sb, depth).append(name).append(" total:").append(info.selfValue).append('/').append(info.totalValue).append(" average: ").append(info.selfValue / (long)tickSpan).append('/').append(info.totalValue / (long)tickSpan).append('\n');
        info.children.entrySet().stream().sorted(COUNTER_ENTRY_COMPARATOR).forEach(entry -> this.appendCounterResults(depth + 1, (String)entry.getKey(), (CounterCollector)entry.getValue(), tickSpan, sb));
    }

    private void appendCounters(Map<String, CounterCollector> counters, StringBuilder sb, int tickSpan) {
        counters.forEach((name, info) -> {
            sb.append("-- Counter: ").append((String)name).append(" --\n");
            this.appendCounterResults(0, "root", info.children.get("root"), tickSpan, sb);
            sb.append("\n\n");
        });
    }

    private static String getComment() {
        String[] strings = new String[]{"I'd Rather Be Surfing", "Shiny numbers!", "Am I not running fast enough? :(", "I'm working as hard as I can!", "Will I ever be good enough for you? :(", "Speedy. Zoooooom!", "Hello world", "40% better than a crash report.", "Now with extra numbers", "Now with less numbers", "Now with the same numbers", "You should add flames to things, it makes them go faster!", "Do you feel the need for... optimization?", "*cracks redstone whip*", "Maybe if you treated it better then it'll have more motivation to work faster! Poor server."};
        try {
            return strings[(int)(Util.getNanos() % (long)strings.length)];
        }
        catch (Throwable throwable) {
            return "Witty comment unavailable :(";
        }
    }

    @Override
    @Override
    public int getTickDuration() {
        return this.tickDuration;
    }

    static class CounterCollector {
        long selfValue;
        long totalValue;
        final Map<String, CounterCollector> children = Maps.newHashMap();

        CounterCollector() {
        }

        public void addValue(Iterator<String> pathIterator, long time) {
            this.totalValue += time;
            if (!pathIterator.hasNext()) {
                this.selfValue += time;
            } else {
                this.children.computeIfAbsent(pathIterator.next(), k -> new CounterCollector()).addValue(pathIterator, time);
            }
        }
    }
}

