/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import io.papermc.paper.adventure.PaperAdventure;
import java.util.UUID;
import net.kyori.adventure.bossbar.BossBar;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;

public abstract class BossEvent {
    private final UUID id;
    public Component name;
    protected float progress;
    public BossBarColor color;
    public BossBarOverlay overlay;
    protected boolean darkenScreen;
    protected boolean playBossMusic;
    protected boolean createWorldFog;
    public BossBar adventure;

    public BossEvent(UUID uuid, Component name, BossBarColor color, BossBarOverlay style) {
        this.id = uuid;
        this.name = name;
        this.color = color;
        this.overlay = style;
        this.progress = 1.0f;
    }

    public UUID getId() {
        return this.id;
    }

    public Component getName() {
        if (this.adventure != null) {
            return PaperAdventure.asVanilla(this.adventure.name());
        }
        return this.name;
    }

    public void setName(Component name) {
        if (this.adventure != null) {
            this.adventure.name(PaperAdventure.asAdventure(name));
        }
        this.name = name;
    }

    public float getProgress() {
        if (this.adventure != null) {
            return this.adventure.progress();
        }
        return this.progress;
    }

    public void setProgress(float percent) {
        if (this.adventure != null) {
            this.adventure.progress(percent);
        }
        this.progress = percent;
    }

    public BossBarColor getColor() {
        if (this.adventure != null) {
            return PaperAdventure.asVanilla(this.adventure.color());
        }
        return this.color;
    }

    public void setColor(BossBarColor color) {
        if (this.adventure != null) {
            this.adventure.color(PaperAdventure.asAdventure(color));
        }
        this.color = color;
    }

    public BossBarOverlay getOverlay() {
        if (this.adventure != null) {
            return PaperAdventure.asVanilla(this.adventure.overlay());
        }
        return this.overlay;
    }

    public void setOverlay(BossBarOverlay style) {
        if (this.adventure != null) {
            this.adventure.overlay(PaperAdventure.asAdventure(style));
        }
        this.overlay = style;
    }

    public boolean shouldDarkenScreen() {
        if (this.adventure != null) {
            return this.adventure.hasFlag(BossBar.Flag.DARKEN_SCREEN);
        }
        return this.darkenScreen;
    }

    public BossEvent setDarkenScreen(boolean darkenSky) {
        if (this.adventure != null) {
            PaperAdventure.setFlag(this.adventure, BossBar.Flag.DARKEN_SCREEN, darkenSky);
        }
        this.darkenScreen = darkenSky;
        return this;
    }

    public boolean shouldPlayBossMusic() {
        if (this.adventure != null) {
            return this.adventure.hasFlag(BossBar.Flag.PLAY_BOSS_MUSIC);
        }
        return this.playBossMusic;
    }

    public BossEvent setPlayBossMusic(boolean dragonMusic) {
        if (this.adventure != null) {
            PaperAdventure.setFlag(this.adventure, BossBar.Flag.PLAY_BOSS_MUSIC, dragonMusic);
        }
        this.playBossMusic = dragonMusic;
        return this;
    }

    public BossEvent setCreateWorldFog(boolean thickenFog) {
        if (this.adventure != null) {
            PaperAdventure.setFlag(this.adventure, BossBar.Flag.CREATE_WORLD_FOG, thickenFog);
        }
        this.createWorldFog = thickenFog;
        return this;
    }

    public boolean shouldCreateWorldFog() {
        if (this.adventure != null) {
            return this.adventure.hasFlag(BossBar.Flag.CREATE_WORLD_FOG);
        }
        return this.createWorldFog;
    }

    public static enum BossBarColor {
        PINK("pink", ChatFormatting.RED),
        BLUE("blue", ChatFormatting.BLUE),
        RED("red", ChatFormatting.DARK_RED),
        GREEN("green", ChatFormatting.GREEN),
        YELLOW("yellow", ChatFormatting.YELLOW),
        PURPLE("purple", ChatFormatting.DARK_BLUE),
        WHITE("white", ChatFormatting.WHITE);

        private final String name;
        private final ChatFormatting formatting;

        private BossBarColor(String name, ChatFormatting format) {
            this.name = name;
            this.formatting = format;
        }

        public ChatFormatting getFormatting() {
            return this.formatting;
        }

        public String getName() {
            return this.name;
        }

        public static BossBarColor byName(String name) {
            for (BossBarColor bossBarColor : BossBarColor.values()) {
                if (!bossBarColor.name.equals(name)) continue;
                return bossBarColor;
            }
            return WHITE;
        }
    }

    public static enum BossBarOverlay {
        PROGRESS("progress"),
        NOTCHED_6("notched_6"),
        NOTCHED_10("notched_10"),
        NOTCHED_12("notched_12"),
        NOTCHED_20("notched_20");

        private final String name;

        private BossBarOverlay(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static BossBarOverlay byName(String name) {
            for (BossBarOverlay bossBarOverlay : BossBarOverlay.values()) {
                if (!bossBarOverlay.name.equals(name)) continue;
                return bossBarOverlay;
            }
            return PROGRESS;
        }
    }
}

