/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import net.minecraft.world.InteractionResult;

public class InteractionResultHolder<T> {
    private final InteractionResult result;
    private final T object;

    public InteractionResultHolder(InteractionResult result, T value) {
        this.result = result;
        this.object = value;
    }

    public InteractionResult getResult() {
        return this.result;
    }

    public T getObject() {
        return this.object;
    }

    public static <T> InteractionResultHolder<T> success(T data) {
        return new InteractionResultHolder<T>(InteractionResult.SUCCESS, data);
    }

    public static <T> InteractionResultHolder<T> consume(T data) {
        return new InteractionResultHolder<T>(InteractionResult.CONSUME, data);
    }

    public static <T> InteractionResultHolder<T> pass(T data) {
        return new InteractionResultHolder<T>(InteractionResult.PASS, data);
    }

    public static <T> InteractionResultHolder<T> fail(T data) {
        return new InteractionResultHolder<T>(InteractionResult.FAIL, data);
    }

    public static <T> InteractionResultHolder<T> sidedSuccess(T data, boolean swingHand) {
        return swingHand ? InteractionResultHolder.success(data) : InteractionResultHolder.consume(data);
    }
}

