/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.effect;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.flag.FeatureFlags;

class BadOmenMobEffect
extends MobEffect {
    protected BadOmenMobEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    @Override
    @Override
    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }

    @Override
    @Override
    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        ServerPlayer serverPlayer;
        if (entity instanceof ServerPlayer && !(serverPlayer = (ServerPlayer)entity).isSpectator()) {
            Raid raid;
            ServerLevel serverLevel = serverPlayer.serverLevel();
            if (!serverLevel.enabledFeatures().contains(FeatureFlags.UPDATE_1_21)) {
                return this.legacyApplyEffectTick(serverPlayer, serverLevel);
            }
            if (serverLevel.getDifficulty() != Difficulty.PEACEFUL && serverLevel.isVillage(serverPlayer.blockPosition()) && ((raid = serverLevel.getRaidAt(serverPlayer.blockPosition())) == null || raid.getRaidOmenLevel() < raid.getMaxRaidOmenLevel())) {
                serverPlayer.addEffect(new MobEffectInstance(MobEffects.RAID_OMEN, 600, amplifier));
                serverPlayer.setRaidOmenPosition(serverPlayer.blockPosition());
                return false;
            }
        }
        return true;
    }

    private boolean legacyApplyEffectTick(ServerPlayer player, ServerLevel world) {
        BlockPos blockPos = player.blockPosition();
        if (world.getDifficulty() != Difficulty.PEACEFUL && world.isVillage(blockPos)) {
            return world.getRaids().createOrExtendRaid(player, blockPos) == null;
        }
        return true;
    }
}

