/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.effect;

import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.AbsorptionMobEffect;
import net.minecraft.world.effect.BadOmenMobEffect;
import net.minecraft.world.effect.HealOrHarmMobEffect;
import net.minecraft.world.effect.HungerMobEffect;
import net.minecraft.world.effect.InfestedMobEffect;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.OozingMobEffect;
import net.minecraft.world.effect.PoisonMobEffect;
import net.minecraft.world.effect.RaidOmenMobEffect;
import net.minecraft.world.effect.RegenerationMobEffect;
import net.minecraft.world.effect.SaturationMobEffect;
import net.minecraft.world.effect.WeavingMobEffect;
import net.minecraft.world.effect.WindChargedMobEffect;
import net.minecraft.world.effect.WitherMobEffect;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.flag.FeatureFlags;

public class MobEffects {
    private static final int DARKNESS_EFFECT_FACTOR_PADDING_DURATION_TICKS = 22;
    public static final Holder<MobEffect> MOVEMENT_SPEED = MobEffects.register("speed", new MobEffect(MobEffectCategory.BENEFICIAL, 3402751).addAttributeModifier(Attributes.MOVEMENT_SPEED, "91AEAA56-376B-4498-935B-2F7F68070635", 0.2f, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
    public static final Holder<MobEffect> MOVEMENT_SLOWDOWN = MobEffects.register("slowness", new MobEffect(MobEffectCategory.HARMFUL, 9154528).addAttributeModifier(Attributes.MOVEMENT_SPEED, "7107DE5E-7CE8-4030-940E-514C1F160890", -0.15f, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
    public static final Holder<MobEffect> DIG_SPEED = MobEffects.register("haste", new MobEffect(MobEffectCategory.BENEFICIAL, 14270531).addAttributeModifier(Attributes.ATTACK_SPEED, "AF8B6E3F-3328-4C0A-AA36-5BA2BB9DBEF3", 0.1f, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
    public static final Holder<MobEffect> DIG_SLOWDOWN = MobEffects.register("mining_fatigue", new MobEffect(MobEffectCategory.HARMFUL, 4866583).addAttributeModifier(Attributes.ATTACK_SPEED, "55FCED67-E92A-486E-9800-B47F202C4386", -0.1f, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
    public static final Holder<MobEffect> DAMAGE_BOOST = MobEffects.register("strength", new MobEffect(MobEffectCategory.BENEFICIAL, 16762624).addAttributeModifier(Attributes.ATTACK_DAMAGE, "648D7064-6A60-4F59-8ABE-C2C23A6DD7A9", 3.0, AttributeModifier.Operation.ADD_VALUE));
    public static final Holder<MobEffect> HEAL = MobEffects.register("instant_health", new HealOrHarmMobEffect(MobEffectCategory.BENEFICIAL, 16262179, false));
    public static final Holder<MobEffect> HARM = MobEffects.register("instant_damage", new HealOrHarmMobEffect(MobEffectCategory.HARMFUL, 11101546, true));
    public static final Holder<MobEffect> JUMP = MobEffects.register("jump_boost", new MobEffect(MobEffectCategory.BENEFICIAL, 16646020).addAttributeModifier(Attributes.SAFE_FALL_DISTANCE, "C0105BF3-AEF8-46B0-9EBC-92943757CCBE", 1.0, AttributeModifier.Operation.ADD_VALUE));
    public static final Holder<MobEffect> CONFUSION = MobEffects.register("nausea", new MobEffect(MobEffectCategory.HARMFUL, 5578058));
    public static final Holder<MobEffect> REGENERATION = MobEffects.register("regeneration", new RegenerationMobEffect(MobEffectCategory.BENEFICIAL, 13458603));
    public static final Holder<MobEffect> DAMAGE_RESISTANCE = MobEffects.register("resistance", new MobEffect(MobEffectCategory.BENEFICIAL, 9520880));
    public static final Holder<MobEffect> FIRE_RESISTANCE = MobEffects.register("fire_resistance", new MobEffect(MobEffectCategory.BENEFICIAL, 0xFF9900));
    public static final Holder<MobEffect> WATER_BREATHING = MobEffects.register("water_breathing", new MobEffect(MobEffectCategory.BENEFICIAL, 10017472));
    public static final Holder<MobEffect> INVISIBILITY = MobEffects.register("invisibility", new MobEffect(MobEffectCategory.BENEFICIAL, 0xF6F6F6));
    public static final Holder<MobEffect> BLINDNESS = MobEffects.register("blindness", new MobEffect(MobEffectCategory.HARMFUL, 2039587));
    public static final Holder<MobEffect> NIGHT_VISION = MobEffects.register("night_vision", new MobEffect(MobEffectCategory.BENEFICIAL, 12779366));
    public static final Holder<MobEffect> HUNGER = MobEffects.register("hunger", new HungerMobEffect(MobEffectCategory.HARMFUL, 5797459));
    public static final Holder<MobEffect> WEAKNESS = MobEffects.register("weakness", new MobEffect(MobEffectCategory.HARMFUL, 0x484D48).addAttributeModifier(Attributes.ATTACK_DAMAGE, "22653B89-116E-49DC-9B6B-9971489B5BE5", -4.0, AttributeModifier.Operation.ADD_VALUE));
    public static final Holder<MobEffect> POISON = MobEffects.register("poison", new PoisonMobEffect(MobEffectCategory.HARMFUL, 8889187));
    public static final Holder<MobEffect> WITHER = MobEffects.register("wither", new WitherMobEffect(MobEffectCategory.HARMFUL, 7561558));
    public static final Holder<MobEffect> HEALTH_BOOST = MobEffects.register("health_boost", new MobEffect(MobEffectCategory.BENEFICIAL, 16284963).addAttributeModifier(Attributes.MAX_HEALTH, "5D6F0BA2-1186-46AC-B896-C61C5CEE99CC", 4.0, AttributeModifier.Operation.ADD_VALUE));
    public static final Holder<MobEffect> ABSORPTION = MobEffects.register("absorption", new AbsorptionMobEffect(MobEffectCategory.BENEFICIAL, 0x2552A5).addAttributeModifier(Attributes.MAX_ABSORPTION, "EAE29CF0-701E-4ED6-883A-96F798F3DAB5", 4.0, AttributeModifier.Operation.ADD_VALUE));
    public static final Holder<MobEffect> SATURATION = MobEffects.register("saturation", new SaturationMobEffect(MobEffectCategory.BENEFICIAL, 16262179));
    public static final Holder<MobEffect> GLOWING = MobEffects.register("glowing", new MobEffect(MobEffectCategory.NEUTRAL, 9740385));
    public static final Holder<MobEffect> LEVITATION = MobEffects.register("levitation", new MobEffect(MobEffectCategory.HARMFUL, 0xCEFFFF));
    public static final Holder<MobEffect> LUCK = MobEffects.register("luck", new MobEffect(MobEffectCategory.BENEFICIAL, 5882118).addAttributeModifier(Attributes.LUCK, "03C3C89D-7037-4B42-869F-B146BCB64D2E", 1.0, AttributeModifier.Operation.ADD_VALUE));
    public static final Holder<MobEffect> UNLUCK = MobEffects.register("unluck", new MobEffect(MobEffectCategory.HARMFUL, 12624973).addAttributeModifier(Attributes.LUCK, "CC5AF142-2BD2-4215-B636-2605AED11727", -1.0, AttributeModifier.Operation.ADD_VALUE));
    public static final Holder<MobEffect> SLOW_FALLING = MobEffects.register("slow_falling", new MobEffect(MobEffectCategory.BENEFICIAL, 15978425));
    public static final Holder<MobEffect> CONDUIT_POWER = MobEffects.register("conduit_power", new MobEffect(MobEffectCategory.BENEFICIAL, 1950417));
    public static final Holder<MobEffect> DOLPHINS_GRACE = MobEffects.register("dolphins_grace", new MobEffect(MobEffectCategory.BENEFICIAL, 8954814));
    public static final Holder<MobEffect> BAD_OMEN = MobEffects.register("bad_omen", new BadOmenMobEffect(MobEffectCategory.NEUTRAL, 745784).withSoundOnAdded(SoundEvents.APPLY_EFFECT_BAD_OMEN));
    public static final Holder<MobEffect> HERO_OF_THE_VILLAGE = MobEffects.register("hero_of_the_village", new MobEffect(MobEffectCategory.BENEFICIAL, 0x44FF44));
    public static final Holder<MobEffect> DARKNESS = MobEffects.register("darkness", new MobEffect(MobEffectCategory.HARMFUL, 2696993).setBlendDuration(22));
    public static final Holder<MobEffect> TRIAL_OMEN = MobEffects.register("trial_omen", new MobEffect(MobEffectCategory.NEUTRAL, 0x16A6A6, ParticleTypes.TRIAL_OMEN).withSoundOnAdded(SoundEvents.APPLY_EFFECT_TRIAL_OMEN).requiredFeatures(FeatureFlags.UPDATE_1_21));
    public static final Holder<MobEffect> RAID_OMEN = MobEffects.register("raid_omen", new RaidOmenMobEffect(MobEffectCategory.NEUTRAL, 14565464, ParticleTypes.RAID_OMEN).withSoundOnAdded(SoundEvents.APPLY_EFFECT_RAID_OMEN).requiredFeatures(FeatureFlags.UPDATE_1_21));
    public static final Holder<MobEffect> WIND_CHARGED = MobEffects.register("wind_charged", new WindChargedMobEffect(MobEffectCategory.HARMFUL, 12438015).requiredFeatures(FeatureFlags.UPDATE_1_21));
    public static final Holder<MobEffect> WEAVING = MobEffects.register("weaving", new WeavingMobEffect(MobEffectCategory.HARMFUL, 7891290, random -> Mth.randomBetweenInclusive(random, 2, 3)).requiredFeatures(FeatureFlags.UPDATE_1_21));
    public static final Holder<MobEffect> OOZING = MobEffects.register("oozing", new OozingMobEffect(MobEffectCategory.HARMFUL, 10092451, random -> 2).requiredFeatures(FeatureFlags.UPDATE_1_21));
    public static final Holder<MobEffect> INFESTED = MobEffects.register("infested", new InfestedMobEffect(MobEffectCategory.HARMFUL, 9214860, 0.1f, random -> Mth.randomBetweenInclusive(random, 1, 2)).requiredFeatures(FeatureFlags.UPDATE_1_21));

    private static Holder<MobEffect> register(String id, MobEffect statusEffect) {
        return Registry.registerForHolder(BuiltInRegistries.MOB_EFFECT, new ResourceLocation(id), statusEffect);
    }

    public static Holder<MobEffect> bootstrap(Registry<MobEffect> registry) {
        return MOVEMENT_SPEED;
    }
}

