/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.effect;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.function.ToIntFunction;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;

class OozingMobEffect
extends MobEffect {
    private static final int RADIUS_TO_CHECK_SLIMES = 2;
    public static final int SLIME_SIZE = 2;
    private final ToIntFunction<RandomSource> spawnedCount;

    protected OozingMobEffect(MobEffectCategory category, int color, ToIntFunction<RandomSource> slimeCountFunction) {
        super(category, color, ParticleTypes.ITEM_SLIME);
        this.spawnedCount = slimeCountFunction;
    }

    @VisibleForTesting
    protected static int numberOfSlimesToSpawn(int maxEntityCramming, int nearbySlimes, int potentialSlimes) {
        return Mth.clamp(0, maxEntityCramming - nearbySlimes, potentialSlimes);
    }

    @Override
    @Override
    public void onMobRemoved(LivingEntity entity, int amplifier, Entity.RemovalReason reason) {
        if (reason != Entity.RemovalReason.KILLED) {
            return;
        }
        int i = this.spawnedCount.applyAsInt(entity.getRandom());
        Level level = entity.level();
        int j = level.getGameRules().getInt(GameRules.RULE_MAX_ENTITY_CRAMMING);
        ArrayList list = new ArrayList();
        level.getEntities(EntityType.SLIME, entity.getBoundingBox().inflate(2.0), entityx -> entityx != entity, list, j);
        int k = OozingMobEffect.numberOfSlimesToSpawn(j, list.size(), i);
        for (int l = 0; l < k; ++l) {
            this.spawnSlimeOffspring(entity.level(), entity.getX(), entity.getY() + 0.5, entity.getZ());
        }
    }

    private void spawnSlimeOffspring(Level world, double x, double y, double z) {
        Slime slime = EntityType.SLIME.create(world);
        if (slime == null) {
            return;
        }
        slime.setSize(2, true);
        slime.moveTo(x, y, z, world.getRandom().nextFloat() * 360.0f, 0.0f);
        world.addFreshEntity(slime);
    }
}

