/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.LightningRodBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.event.entity.EntityRemoveEvent;

public class LightningBolt
extends Entity {
    private static final int START_LIFE = 2;
    private static final double DAMAGE_RADIUS = 3.0;
    private static final double DETECTION_RADIUS = 15.0;
    public int life;
    public long seed;
    public int flashes;
    public boolean visualOnly;
    @Nullable
    private ServerPlayer cause;
    private final Set<Entity> hitEntities = Sets.newHashSet();
    private int blocksSetOnFire;
    public boolean isEffect;

    public LightningBolt(EntityType<? extends LightningBolt> type, Level world) {
        super(type, world);
        this.noCulling = true;
        this.life = 2;
        this.seed = this.random.nextLong();
        this.flashes = this.random.nextInt(3) + 1;
    }

    public void setVisualOnly(boolean cosmetic) {
        this.visualOnly = cosmetic;
    }

    @Override
    public SoundSource getSoundSource() {
        return SoundSource.WEATHER;
    }

    @Nullable
    public ServerPlayer getCause() {
        return this.cause;
    }

    public void setCause(@Nullable ServerPlayer channeler) {
        this.cause = channeler;
    }

    private void powerLightningRod() {
        BlockPos blockposition = this.getStrikePosition();
        BlockState iblockdata = this.level().getBlockState(blockposition);
        if (iblockdata.is(Blocks.LIGHTNING_ROD)) {
            ((LightningRodBlock)iblockdata.getBlock()).onLightningStrike(iblockdata, this.level(), blockposition);
        }
    }

    @Override
    public void tick() {
        List<Entity> list;
        super.tick();
        if (!this.isEffect && this.life == 2) {
            if (this.level().isClientSide()) {
                this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEvents.LIGHTNING_BOLT_THUNDER, SoundSource.WEATHER, 10000.0f, 0.8f + this.random.nextFloat() * 0.2f, false);
                this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEvents.LIGHTNING_BOLT_IMPACT, SoundSource.WEATHER, 2.0f, 0.5f + this.random.nextFloat() * 0.2f, false);
            } else {
                Difficulty enumdifficulty = this.level().getDifficulty();
                if (enumdifficulty == Difficulty.NORMAL || enumdifficulty == Difficulty.HARD) {
                    this.spawnFire(4);
                }
                this.powerLightningRod();
                LightningBolt.clearCopperOnLightningStrike(this.level(), this.getStrikePosition(), this);
                this.gameEvent(GameEvent.LIGHTNING_STRIKE);
            }
        }
        --this.life;
        if (this.life < 0) {
            if (this.flashes == 0) {
                if (this.level() instanceof ServerLevel) {
                    list = this.level().getEntities(this, new AABB(this.getX() - 15.0, this.getY() - 15.0, this.getZ() - 15.0, this.getX() + 15.0, this.getY() + 6.0 + 15.0, this.getZ() + 15.0), entity -> entity.isAlive() && !this.hitEntities.contains(entity));
                    for (ServerPlayer entityplayer2 : ((ServerLevel)this.level()).getPlayers(entityplayer -> entityplayer.distanceTo(this) < 256.0f)) {
                        CriteriaTriggers.LIGHTNING_STRIKE.trigger(entityplayer2, this, list);
                    }
                }
                this.discard(EntityRemoveEvent.Cause.DESPAWN);
            } else if (this.life < -this.random.nextInt(10)) {
                --this.flashes;
                this.life = 1;
                this.seed = this.random.nextLong();
                this.spawnFire(0);
            }
        }
        if (this.life >= 0 && !this.isEffect) {
            if (!(this.level() instanceof ServerLevel)) {
                this.level().setSkyFlashTime(2);
            } else if (!this.visualOnly) {
                list = this.level().getEntities(this, new AABB(this.getX() - 3.0, this.getY() - 3.0, this.getZ() - 3.0, this.getX() + 3.0, this.getY() + 6.0 + 3.0, this.getZ() + 3.0), Entity::isAlive);
                for (Entity entity2 : list) {
                    entity2.thunderHit((ServerLevel)this.level(), this);
                }
                this.hitEntities.addAll(list);
                if (this.cause != null) {
                    CriteriaTriggers.CHANNELED_LIGHTNING.trigger(this.cause, list);
                }
            }
        }
    }

    private BlockPos getStrikePosition() {
        Vec3 vec3d = this.position();
        return BlockPos.containing(vec3d.x, vec3d.y - 1.0E-6, vec3d.z);
    }

    private void spawnFire(int spreadAttempts) {
        if (!this.visualOnly && !this.isEffect && !this.level().isClientSide && this.level().getGameRules().getBoolean(GameRules.RULE_DOFIRETICK)) {
            BlockPos blockposition = this.blockPosition();
            BlockState iblockdata = BaseFireBlock.getState(this.level(), blockposition);
            if (this.level().getBlockState(blockposition).isAir() && iblockdata.canSurvive(this.level(), blockposition) && !this.visualOnly && !CraftEventFactory.callBlockIgniteEvent(this.level(), blockposition, this).isCancelled()) {
                this.level().setBlockAndUpdate(blockposition, iblockdata);
                ++this.blocksSetOnFire;
            }
            for (int j = 0; j < spreadAttempts; ++j) {
                BlockPos blockposition1 = blockposition.offset(this.random.nextInt(3) - 1, this.random.nextInt(3) - 1, this.random.nextInt(3) - 1);
                iblockdata = BaseFireBlock.getState(this.level(), blockposition1);
                if (!this.level().getBlockState(blockposition1).isAir() || !iblockdata.canSurvive(this.level(), blockposition1) || this.visualOnly || CraftEventFactory.callBlockIgniteEvent(this.level(), blockposition1, this).isCancelled()) continue;
                this.level().setBlockAndUpdate(blockposition1, iblockdata);
                ++this.blocksSetOnFire;
            }
        }
    }

    private static void clearCopperOnLightningStrike(Level world, BlockPos pos, Entity lightning) {
        BlockState iblockdata1;
        BlockPos blockposition1;
        BlockState iblockdata = world.getBlockState(pos);
        if (iblockdata.is(Blocks.LIGHTNING_ROD)) {
            blockposition1 = pos.relative(iblockdata.getValue(DirectionalBlock.FACING).getOpposite());
            iblockdata1 = world.getBlockState(blockposition1);
        } else {
            blockposition1 = pos;
            iblockdata1 = iblockdata;
        }
        if (iblockdata1.getBlock() instanceof WeatheringCopper) {
            BlockState newBlock = WeatheringCopper.getFirst(world.getBlockState(blockposition1));
            if (CraftEventFactory.callEntityChangeBlockEvent(lightning, blockposition1, newBlock)) {
                world.setBlockAndUpdate(blockposition1, newBlock);
            }
            BlockPos.MutableBlockPos blockposition_mutableblockposition = pos.mutable();
            int i = world.random.nextInt(3) + 3;
            for (int j = 0; j < i; ++j) {
                int k = world.random.nextInt(8) + 1;
                LightningBolt.randomWalkCleaningCopper(world, blockposition1, blockposition_mutableblockposition, k, lightning);
            }
        }
    }

    private static void randomWalkCleaningCopper(Level world, BlockPos pos, BlockPos.MutableBlockPos mutablePos, int count, Entity lightning) {
        Optional<BlockPos> optional;
        mutablePos.set(pos);
        for (int j = 0; j < count && !(optional = LightningBolt.randomStepCleaningCopper(world, mutablePos, lightning)).isEmpty(); ++j) {
            mutablePos.set(optional.get());
        }
    }

    private static Optional<BlockPos> randomStepCleaningCopper(Level world, BlockPos pos, Entity lightning) {
        BlockPos blockposition1;
        BlockState iblockdata;
        Iterator<BlockPos> iterator = BlockPos.randomInCube(world.random, 10, pos, 1).iterator();
        do {
            if (iterator.hasNext()) continue;
            return Optional.empty();
        } while (!((iblockdata = world.getBlockState(blockposition1 = iterator.next())).getBlock() instanceof WeatheringCopper));
        BlockPos blockposition1Final = blockposition1;
        WeatheringCopper.getPrevious(iblockdata).ifPresent(iblockdata1 -> {
            if (CraftEventFactory.callEntityChangeBlockEvent(lightning, blockposition1Final, iblockdata1)) {
                world.setBlockAndUpdate(blockposition1Final, (BlockState)iblockdata1);
            }
        });
        world.levelEvent(3002, blockposition1, -1);
        return Optional.of(blockposition1);
    }

    @Override
    public boolean shouldRenderAtSqrDistance(double distance) {
        double d1 = 64.0 * LightningBolt.getViewScale();
        return distance < d1 * d1;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag nbt) {
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag nbt) {
    }

    public int getBlocksSetOnFire() {
        return this.blocksSetOnFire;
    }

    public Stream<Entity> getHitEntities() {
        return this.hitEntities.stream().filter(Entity::isAlive);
    }
}

