/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnPlacementType;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;

public interface SpawnPlacementTypes {
    public static final SpawnPlacementType NO_RESTRICTIONS = (world, pos, entityType) -> true;
    public static final SpawnPlacementType IN_WATER = (world, pos, entityType) -> {
        if (entityType == null || !world.getWorldBorder().isWithinBounds(pos)) {
            return false;
        }
        BlockPos blockPos = pos.above();
        return world.getFluidState(pos).is(FluidTags.WATER) && !world.getBlockState(blockPos).isRedstoneConductor(world, blockPos);
    };
    public static final SpawnPlacementType IN_LAVA = (world, pos, entityType) -> {
        if (entityType == null || !world.getWorldBorder().isWithinBounds(pos)) {
            return false;
        }
        return world.getFluidState(pos).is(FluidTags.LAVA);
    };
    public static final SpawnPlacementType ON_GROUND = new SpawnPlacementType(){

        @Override
        @Override
        public boolean isSpawnPositionOk(LevelReader world, BlockPos pos, @Nullable EntityType<?> entityType) {
            if (entityType == null || !world.getWorldBorder().isWithinBounds(pos)) {
                return false;
            }
            BlockPos blockPos = pos.above();
            BlockPos blockPos2 = pos.below();
            BlockState blockState = world.getBlockState(blockPos2);
            if (!blockState.isValidSpawn(world, blockPos2, entityType)) {
                return false;
            }
            return this.isValidEmptySpawnBlock(world, pos, entityType) && this.isValidEmptySpawnBlock(world, blockPos, entityType);
        }

        private boolean isValidEmptySpawnBlock(LevelReader world, BlockPos pos, EntityType<?> entityType) {
            BlockState blockState = world.getBlockState(pos);
            return NaturalSpawner.isValidEmptySpawnBlock(world, pos, blockState, blockState.getFluidState(), entityType);
        }

        @Override
        @Override
        public BlockPos adjustSpawnPosition(LevelReader world, BlockPos pos) {
            BlockPos blockPos = pos.below();
            if (world.getBlockState(blockPos).isPathfindable(PathComputationType.LAND)) {
                return blockPos;
            }
            return pos;
        }
    };
}

