/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.attributes;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import org.leavesmc.leaves.LeavesConfig;
import org.slf4j.Logger;

public class AttributeMap {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Map<Holder<Attribute>, AttributeInstance> attributes = new Object2ObjectOpenHashMap();
    private final Set<AttributeInstance> dirtyAttributes = new ObjectOpenHashSet();
    private final AttributeSupplier supplier;
    private final Function<Holder<Attribute>, AttributeInstance> createInstance;

    public AttributeMap(AttributeSupplier defaultAttributes) {
        this.supplier = defaultAttributes;
        this.createInstance = attribute -> this.supplier.createInstance(this::onAttributeModified, (Holder<Attribute>)attribute);
    }

    private void onAttributeModified(AttributeInstance instance) {
        if (instance.getAttribute().value().isClientSyncable()) {
            this.dirtyAttributes.add(instance);
        }
    }

    public Set<AttributeInstance> getDirtyAttributes() {
        return this.dirtyAttributes;
    }

    public Collection<AttributeInstance> getSyncableAttributes() {
        return this.attributes.values().stream().filter(attribute -> attribute.getAttribute().value().isClientSyncable()).collect(Collectors.toList());
    }

    @Nullable
    public AttributeInstance getInstance(Holder<Attribute> attribute) {
        if (LeavesConfig.reduceEntityAllocations) {
            return this.attributes.computeIfAbsent(attribute, this.createInstance);
        }
        return this.attributes.computeIfAbsent(attribute, attributex -> this.supplier.createInstance(this::onAttributeModified, (Holder<Attribute>)attributex));
    }

    public boolean hasAttribute(Holder<Attribute> attribute) {
        return this.attributes.get(attribute) != null || this.supplier.hasAttribute(attribute);
    }

    public boolean hasModifier(Holder<Attribute> attribute, UUID uuid) {
        AttributeInstance attributeInstance = this.attributes.get(attribute);
        return attributeInstance != null ? attributeInstance.getModifier(uuid) != null : this.supplier.hasModifier(attribute, uuid);
    }

    public double getValue(Holder<Attribute> attribute) {
        AttributeInstance attributeInstance = this.attributes.get(attribute);
        return attributeInstance != null ? attributeInstance.getValue() : this.supplier.getValue(attribute);
    }

    public double getBaseValue(Holder<Attribute> attribute) {
        AttributeInstance attributeInstance = this.attributes.get(attribute);
        return attributeInstance != null ? attributeInstance.getBaseValue() : this.supplier.getBaseValue(attribute);
    }

    public double getModifierValue(Holder<Attribute> attribute, UUID uuid) {
        AttributeInstance attributeInstance = this.attributes.get(attribute);
        return attributeInstance != null ? attributeInstance.getModifier(uuid).amount() : this.supplier.getModifierValue(attribute, uuid);
    }

    public void assignValues(AttributeMap other) {
        other.attributes.values().forEach(attributeInstance -> {
            AttributeInstance attributeInstance2 = this.getInstance(attributeInstance.getAttribute());
            if (attributeInstance2 != null) {
                attributeInstance2.replaceFrom((AttributeInstance)attributeInstance);
            }
        });
    }

    public ListTag save() {
        ListTag listTag = new ListTag();
        for (AttributeInstance attributeInstance : this.attributes.values()) {
            listTag.add(attributeInstance.save());
        }
        return listTag;
    }

    public void load(ListTag nbt) {
        for (int i = 0; i < nbt.size(); ++i) {
            CompoundTag compoundTag = nbt.getCompound(i);
            String string = compoundTag.getString("Name");
            ResourceLocation resourceLocation = ResourceLocation.tryParse(string);
            if (resourceLocation != null) {
                Util.ifElse(BuiltInRegistries.ATTRIBUTE.getHolder(resourceLocation), attribute -> {
                    AttributeInstance attributeInstance = this.getInstance((Holder<Attribute>)attribute);
                    if (attributeInstance != null) {
                        attributeInstance.load(compoundTag);
                    }
                }, () -> LOGGER.warn("Ignoring unknown attribute '{}'", (Object)resourceLocation));
                continue;
            }
            LOGGER.warn("Ignoring malformed attribute '{}'", (Object)string);
        }
    }

    public void registerAttribute(Holder<Attribute> attributeBase) {
        AttributeInstance attributeModifiable = new AttributeInstance(attributeBase, AttributeInstance::getAttribute);
        this.attributes.put(attributeBase, attributeModifiable);
    }
}

