/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.Vec3;

public class AnimalPanic<E extends PathfinderMob>
extends Behavior<E> {
    private static final int PANIC_MIN_DURATION = 100;
    private static final int PANIC_MAX_DURATION = 120;
    private static final int PANIC_DISTANCE_HORIZONTAL = 5;
    private static final int PANIC_DISTANCE_VERTICAL = 4;
    private static final Predicate<PathfinderMob> DEFAULT_SHOULD_PANIC_PREDICATE = entity -> entity.getLastHurtByMob() != null || entity.isFreezing() || entity.isOnFire();
    private final float speedMultiplier;
    private final Predicate<E> shouldPanic;

    public AnimalPanic(float speed) {
        this(speed, DEFAULT_SHOULD_PANIC_PREDICATE::test);
    }

    public AnimalPanic(float speed, Predicate<E> predicate) {
        super(Map.of(MemoryModuleType.IS_PANICKING, MemoryStatus.REGISTERED, MemoryModuleType.HURT_BY, MemoryStatus.REGISTERED), 100, 120);
        this.speedMultiplier = speed;
        this.shouldPanic = predicate;
    }

    @Override
    @Override
    protected boolean checkExtraStartConditions(ServerLevel world, E entity) {
        return this.shouldPanic.test(entity) && (((LivingEntity)entity).getBrain().hasMemoryValue(MemoryModuleType.HURT_BY) || ((LivingEntity)entity).getBrain().hasMemoryValue(MemoryModuleType.IS_PANICKING));
    }

    @Override
    @Override
    protected boolean canStillUse(ServerLevel world, E entity, long time) {
        return true;
    }

    @Override
    @Override
    protected void start(ServerLevel serverLevel, E pathfinderMob, long l) {
        ((LivingEntity)pathfinderMob).getBrain().setMemory(MemoryModuleType.IS_PANICKING, true);
        ((LivingEntity)pathfinderMob).getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
    }

    @Override
    @Override
    protected void stop(ServerLevel serverLevel, E pathfinderMob, long l) {
        Brain<?> brain = ((LivingEntity)pathfinderMob).getBrain();
        brain.eraseMemory(MemoryModuleType.IS_PANICKING);
    }

    @Override
    @Override
    protected void tick(ServerLevel serverLevel, E pathfinderMob, long l) {
        Vec3 vec3;
        if (((Mob)pathfinderMob).getNavigation().isDone() && (vec3 = this.getPanicPos(pathfinderMob, serverLevel)) != null) {
            ((LivingEntity)pathfinderMob).getBrain().setMemory(MemoryModuleType.WALK_TARGET, new WalkTarget(vec3, this.speedMultiplier, 0));
        }
    }

    @Nullable
    private Vec3 getPanicPos(E entity, ServerLevel world) {
        Optional<Vec3> optional;
        if (((Entity)entity).isOnFire() && (optional = this.lookForWater(world, (Entity)entity).map(Vec3::atBottomCenterOf)).isPresent()) {
            return optional.get();
        }
        return LandRandomPos.getPos(entity, 5, 4);
    }

    private Optional<BlockPos> lookForWater(BlockGetter world, Entity entity) {
        Predicate<BlockPos> predicate2;
        BlockPos blockPos = entity.blockPosition();
        if (!world.getBlockState(blockPos).getCollisionShape(world, blockPos).isEmpty()) {
            return Optional.empty();
        }
        if (Mth.ceil(entity.getBbWidth()) == 2) {
            Predicate<BlockPos> predicate = pos -> BlockPos.squareOutSouthEast(pos).allMatch(posx -> world.getFluidState((BlockPos)posx).is(FluidTags.WATER));
        } else {
            predicate2 = pos -> world.getFluidState((BlockPos)pos).is(FluidTags.WATER);
        }
        return BlockPos.findClosestMatch(blockPos, 5, 1, predicate2);
    }

    @Override
    protected /* synthetic */ void stop(ServerLevel world, LivingEntity entity, long time) {
        this.stop(world, (E)((PathfinderMob)entity), time);
    }

    @Override
    protected /* synthetic */ void tick(ServerLevel world, LivingEntity entity, long time) {
        this.tick(world, (E)((PathfinderMob)entity), time);
    }

    @Override
    protected /* synthetic */ void start(ServerLevel world, LivingEntity entity, long time) {
        this.start(world, (E)((PathfinderMob)entity), time);
    }
}

