/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ChargedProjectiles;

public class CrossbowAttack<E extends Mob, T extends LivingEntity>
extends Behavior<E> {
    private static final int TIMEOUT = 1200;
    private int attackDelay;
    private CrossbowState crossbowState = CrossbowState.UNCHARGED;

    public CrossbowAttack() {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.LOOK_TARGET, (Object)((Object)MemoryStatus.REGISTERED), MemoryModuleType.ATTACK_TARGET, (Object)((Object)MemoryStatus.VALUE_PRESENT)), 1200);
    }

    @Override
    @Override
    protected boolean checkExtraStartConditions(ServerLevel world, E entity) {
        LivingEntity livingEntity = CrossbowAttack.getAttackTarget(entity);
        return ((LivingEntity)entity).isHolding(Items.CROSSBOW) && BehaviorUtils.canSee(entity, livingEntity) && BehaviorUtils.isWithinAttackRange(entity, livingEntity, 0);
    }

    @Override
    @Override
    protected boolean canStillUse(ServerLevel world, E entity, long time) {
        return ((LivingEntity)entity).getBrain().hasMemoryValue(MemoryModuleType.ATTACK_TARGET) && this.checkExtraStartConditions(world, entity);
    }

    @Override
    @Override
    protected void tick(ServerLevel serverLevel, E mob, long l) {
        LivingEntity livingEntity = CrossbowAttack.getAttackTarget(mob);
        this.lookAtTarget((Mob)mob, livingEntity);
        this.crossbowAttack(mob, livingEntity);
    }

    @Override
    @Override
    protected void stop(ServerLevel serverLevel, E mob, long l) {
        if (((LivingEntity)mob).isUsingItem()) {
            ((LivingEntity)mob).stopUsingItem();
        }
        if (((LivingEntity)mob).isHolding(Items.CROSSBOW)) {
            ((CrossbowAttackMob)mob).setChargingCrossbow(false);
            ((LivingEntity)mob).getUseItem().set(DataComponents.CHARGED_PROJECTILES, ChargedProjectiles.EMPTY);
        }
    }

    private void crossbowAttack(E entity, LivingEntity target) {
        if (this.crossbowState == CrossbowState.UNCHARGED) {
            ((LivingEntity)entity).startUsingItem(ProjectileUtil.getWeaponHoldingHand(entity, Items.CROSSBOW));
            this.crossbowState = CrossbowState.CHARGING;
            ((CrossbowAttackMob)entity).setChargingCrossbow(true);
        } else if (this.crossbowState == CrossbowState.CHARGING) {
            ItemStack itemStack;
            int i;
            if (!((LivingEntity)entity).isUsingItem()) {
                this.crossbowState = CrossbowState.UNCHARGED;
            }
            if ((i = ((LivingEntity)entity).getTicksUsingItem()) >= CrossbowItem.getChargeDuration(itemStack = ((LivingEntity)entity).getUseItem())) {
                ((LivingEntity)entity).releaseUsingItem();
                this.crossbowState = CrossbowState.CHARGED;
                this.attackDelay = 20 + ((LivingEntity)entity).getRandom().nextInt(20);
                ((CrossbowAttackMob)entity).setChargingCrossbow(false);
            }
        } else if (this.crossbowState == CrossbowState.CHARGED) {
            --this.attackDelay;
            if (this.attackDelay == 0) {
                this.crossbowState = CrossbowState.READY_TO_ATTACK;
            }
        } else if (this.crossbowState == CrossbowState.READY_TO_ATTACK) {
            ((RangedAttackMob)entity).performRangedAttack(target, 1.0f);
            this.crossbowState = CrossbowState.UNCHARGED;
        }
    }

    private void lookAtTarget(Mob entity, LivingEntity target) {
        entity.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, new EntityTracker(target, true));
    }

    private static LivingEntity getAttackTarget(LivingEntity entity) {
        return entity.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).get();
    }

    @Override
    protected /* synthetic */ void stop(ServerLevel world, LivingEntity entity, long time) {
        this.stop(world, (E)((Mob)entity), time);
    }

    @Override
    protected /* synthetic */ void tick(ServerLevel world, LivingEntity entity, long time) {
        this.tick(world, (E)((Mob)entity), time);
    }

    static enum CrossbowState {
        UNCHARGED,
        CHARGING,
        CHARGED,
        READY_TO_ATTACK;

    }
}

