/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.mojang.datafixers.kinds.Applicative;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;

public class PoiCompetitorScan {
    public static BehaviorControl<Villager> create() {
        return BehaviorBuilder.create(context -> context.group(context.present(MemoryModuleType.JOB_SITE), context.present(MemoryModuleType.NEAREST_LIVING_ENTITIES)).apply((Applicative)context, (jobSite, mobs) -> (world, entity, time) -> {
            GlobalPos globalPos = (GlobalPos)context.get(jobSite);
            world.getPoiManager().getType(globalPos.pos()).ifPresent(poiType -> ((List)context.get(mobs)).stream().filter(mob -> mob instanceof Villager && mob != entity).map(villager -> (Villager)villager).filter(LivingEntity::isAlive).filter(villager -> PoiCompetitorScan.competesForSameJobsite(globalPos, poiType, villager)).reduce((Villager)entity, PoiCompetitorScan::selectWinner));
            return true;
        }));
    }

    private static Villager selectWinner(Villager first, Villager second) {
        Villager villager4;
        Villager villager3;
        if (first.getVillagerXp() > second.getVillagerXp()) {
            Villager villager = first;
            Villager villager2 = second;
        } else {
            villager3 = second;
            villager4 = first;
        }
        villager4.getBrain().eraseMemory(MemoryModuleType.JOB_SITE);
        return villager3;
    }

    private static boolean competesForSameJobsite(GlobalPos pos, Holder<PoiType> poiType, Villager villager) {
        Optional<GlobalPos> optional = villager.getBrain().getMemory(MemoryModuleType.JOB_SITE);
        return optional.isPresent() && pos.equals(optional.get()) && PoiCompetitorScan.hasMatchingProfession(poiType, villager.getVillagerData().getProfession());
    }

    private static boolean hasMatchingProfession(Holder<PoiType> poiType, VillagerProfession profession) {
        return profession.heldJobSite().test(poiType);
    }
}

