/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.mojang.datafixers.kinds.Applicative;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import org.apache.commons.lang3.mutable.MutableInt;

public class SetHiddenState {
    private static final int HIDE_TIMEOUT = 300;

    public static BehaviorControl<LivingEntity> create(int maxHiddenSeconds, int distance) {
        int i = maxHiddenSeconds * 20;
        MutableInt mutableInt = new MutableInt(0);
        return BehaviorBuilder.create(context -> context.group(context.present(MemoryModuleType.HIDING_PLACE), context.present(MemoryModuleType.HEARD_BELL_TIME)).apply((Applicative)context, (hidingPlace, heardBellTime) -> (world, entity, time) -> {
            boolean bl;
            long l = (Long)context.get(heardBellTime);
            boolean bl2 = bl = l + 300L <= time;
            if (mutableInt.getValue() > i || bl) {
                heardBellTime.erase();
                hidingPlace.erase();
                entity.getBrain().updateActivityFromSchedule(world.getDayTime(), world.getGameTime());
                mutableInt.setValue(0);
                return true;
            }
            BlockPos blockPos = ((GlobalPos)context.get(hidingPlace)).pos();
            if (blockPos.closerThan(entity.blockPosition(), distance)) {
                mutableInt.increment();
            }
            return true;
        }));
    }
}

