/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.mojang.datafixers.kinds.Applicative;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.memory.WalkTarget;

public class SetWalkTargetFromAttackTargetIfTargetOutOfReach {
    private static final int PROJECTILE_ATTACK_RANGE_BUFFER = 1;

    public static BehaviorControl<Mob> create(float speed) {
        return SetWalkTargetFromAttackTargetIfTargetOutOfReach.create(entity -> Float.valueOf(speed));
    }

    public static BehaviorControl<Mob> create(Function<LivingEntity, Float> speed) {
        return BehaviorBuilder.create((BehaviorBuilder.Instance<E> context) -> context.group(context.registered(MemoryModuleType.WALK_TARGET), context.registered(MemoryModuleType.LOOK_TARGET), context.present(MemoryModuleType.ATTACK_TARGET), context.registered(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES)).apply((Applicative)context, (walkTarget, lookTarget, attackTarget, visibleMobs) -> (world, entity, time) -> {
            LivingEntity livingEntity = (LivingEntity)context.get(attackTarget);
            Optional optional = context.tryGet(visibleMobs);
            if (optional.isPresent() && ((NearestVisibleLivingEntities)optional.get()).contains(livingEntity) && BehaviorUtils.isWithinAttackRange(entity, livingEntity, 1)) {
                walkTarget.erase();
            } else {
                lookTarget.set(new EntityTracker(livingEntity, true));
                walkTarget.set(new WalkTarget(new EntityTracker(livingEntity, false), ((Float)speed.apply(entity)).floatValue(), 0));
            }
            return true;
        }));
    }
}

