/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.mojang.datafixers.kinds.Applicative;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;

public class StopAttackingIfTargetInvalid {
    private static final int TIMEOUT_TO_GET_WITHIN_ATTACK_RANGE = 200;

    public static <E extends Mob> BehaviorControl<E> create(BiConsumer<E, LivingEntity> forgetCallback) {
        return StopAttackingIfTargetInvalid.create(entityliving -> false, forgetCallback, true);
    }

    public static <E extends Mob> BehaviorControl<E> create(Predicate<LivingEntity> alternativeCondition) {
        return StopAttackingIfTargetInvalid.create(alternativeCondition, (entityinsentient, entityliving) -> {}, true);
    }

    public static <E extends Mob> BehaviorControl<E> create() {
        return StopAttackingIfTargetInvalid.create(entityliving -> false, (entityinsentient, entityliving) -> {}, true);
    }

    public static <E extends Mob> BehaviorControl<E> create(Predicate<LivingEntity> alternativeCondition, BiConsumer<E, LivingEntity> forgetCallback, boolean shouldForgetIfTargetUnreachable) {
        return BehaviorBuilder.create((BehaviorBuilder.Instance<E> behaviorbuilder_b) -> behaviorbuilder_b.group(behaviorbuilder_b.present(MemoryModuleType.ATTACK_TARGET), behaviorbuilder_b.registered(MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE)).apply((Applicative)behaviorbuilder_b, (memoryaccessor, memoryaccessor1) -> (worldserver, entityinsentient, i) -> {
            LivingEntity entityliving = (LivingEntity)behaviorbuilder_b.get(memoryaccessor);
            if (!(!entityinsentient.canAttack(entityliving) || shouldForgetIfTargetUnreachable && StopAttackingIfTargetInvalid.isTiredOfTryingToReachTarget(entityinsentient, behaviorbuilder_b.tryGet(memoryaccessor1)) || !entityliving.isAlive() || entityliving.level() != entityinsentient.level() || alternativeCondition.test(entityliving))) {
                return true;
            }
            EntityTargetEvent.TargetReason reason = !entityinsentient.canAttack(entityliving) ? EntityTargetEvent.TargetReason.TARGET_INVALID : (shouldForgetIfTargetUnreachable && StopAttackingIfTargetInvalid.isTiredOfTryingToReachTarget(entityinsentient, behaviorbuilder_b.tryGet(memoryaccessor1)) ? EntityTargetEvent.TargetReason.FORGOT_TARGET : (!entityliving.isAlive() ? EntityTargetEvent.TargetReason.TARGET_DIED : (entityliving.level() != entityinsentient.level() ? EntityTargetEvent.TargetReason.TARGET_OTHER_LEVEL : EntityTargetEvent.TargetReason.TARGET_INVALID)));
            EntityTargetLivingEntityEvent event = CraftEventFactory.callEntityTargetLivingEvent(entityinsentient, null, reason);
            if (event.isCancelled()) {
                return false;
            }
            forgetCallback.accept(entityinsentient, entityliving);
            memoryaccessor.erase();
            return true;
        }));
    }

    private static boolean isTiredOfTryingToReachTarget(LivingEntity entityliving, Optional<Long> optional) {
        return optional.isPresent() && entityliving.level().getGameTime() - optional.get() > 200L;
    }
}

