/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.mojang.datafixers.util.Pair;
import java.util.Iterator;
import java.util.List;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.GateBehavior;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.ShufflingList;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.behavior.declarative.Trigger;

public class TriggerGate {
    public static <E extends LivingEntity> OneShot<E> triggerOneShuffled(List<Pair<? extends Trigger<? super E>, Integer>> weightedTasks) {
        return TriggerGate.triggerGate(weightedTasks, GateBehavior.OrderPolicy.SHUFFLED, GateBehavior.RunningPolicy.RUN_ONE);
    }

    public static <E extends LivingEntity> OneShot<E> triggerGate(List<Pair<? extends Trigger<? super E>, Integer>> weightedTasks, GateBehavior.OrderPolicy order, GateBehavior.RunningPolicy runMode) {
        ShufflingList shufflingList = new ShufflingList();
        weightedTasks.forEach(task -> shufflingList.add((Trigger)task.getFirst(), (Integer)task.getSecond()));
        return BehaviorBuilder.create(context -> context.point((world, entity, time) -> {
            Trigger trigger;
            if (order == GateBehavior.OrderPolicy.SHUFFLED) {
                shufflingList.shuffle();
            }
            Iterator iterator = shufflingList.iterator();
            while (iterator.hasNext() && (!(trigger = (Trigger)iterator.next()).trigger(world, entity, time) || runMode != GateBehavior.RunningPolicy.RUN_ONE)) {
            }
            return true;
        }));
    }
}

