/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal;

import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.DoorInteractGoal;

public class OpenDoorGoal
extends DoorInteractGoal {
    private final boolean closeDoor;
    private int forgetTime;

    public OpenDoorGoal(Mob mob, boolean delayedClose) {
        super(mob);
        this.mob = mob;
        this.closeDoor = delayedClose;
    }

    @Override
    @Override
    public boolean canContinueToUse() {
        return this.closeDoor && this.forgetTime > 0 && super.canContinueToUse();
    }

    @Override
    @Override
    public void start() {
        this.forgetTime = 20;
        this.setOpen(true);
    }

    @Override
    @Override
    public void stop() {
        this.setOpen(false);
    }

    @Override
    @Override
    public void tick() {
        --this.forgetTime;
        super.tick();
    }
}

