/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal;

import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;

public class RandomStandGoal
extends Goal {
    private final AbstractHorse horse;
    private int nextStand;

    public RandomStandGoal(AbstractHorse entity) {
        this.horse = entity;
        this.resetStandInterval(entity);
    }

    @Override
    @Override
    public void start() {
        this.horse.standIfPossible();
        this.playStandSound();
    }

    private void playStandSound() {
        SoundEvent soundEvent = this.horse.getAmbientStandSound();
        if (soundEvent != null) {
            this.horse.playSound(soundEvent);
        }
    }

    @Override
    @Override
    public boolean canContinueToUse() {
        return false;
    }

    @Override
    @Override
    public boolean canUse() {
        ++this.nextStand;
        if (this.nextStand > 0 && this.horse.getRandom().nextInt(1000) < this.nextStand) {
            this.resetStandInterval(this.horse);
            return !this.horse.isImmobile() && this.horse.getRandom().nextInt(10) == 0;
        }
        return false;
    }

    private void resetStandInterval(AbstractHorse entity) {
        this.nextStand = -entity.getAmbientStandInterval();
    }

    @Override
    @Override
    public boolean requiresUpdateEveryTick() {
        return true;
    }
}

