/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.gossip;

import com.mojang.serialization.Codec;
import net.minecraft.util.StringRepresentable;

public enum GossipType implements StringRepresentable
{
    MAJOR_NEGATIVE("major_negative", -5, 100, 10, 10),
    MINOR_NEGATIVE("minor_negative", -1, 200, 20, 20),
    MINOR_POSITIVE("minor_positive", 1, 25, 1, 5),
    MAJOR_POSITIVE("major_positive", 5, 20, 0, 20),
    TRADING("trading", 1, 25, 2, 20);

    public static final int REPUTATION_CHANGE_PER_EVENT = 25;
    public static final int REPUTATION_CHANGE_PER_EVERLASTING_MEMORY = 20;
    public static final int REPUTATION_CHANGE_PER_TRADE = 2;
    public final String id;
    public final int weight;
    public int max;
    public final int decayPerDay;
    public int decayPerTransfer;
    public static final Codec<GossipType> CODEC;

    private GossipType(String key, int multiplier, int maxReputation, int decay, int shareDecrement) {
        this.id = key;
        this.weight = multiplier;
        this.max = maxReputation;
        this.decayPerDay = decay;
        this.decayPerTransfer = shareDecrement;
    }

    @Override
    public String getSerializedName() {
        return this.id;
    }

    static {
        CODEC = StringRepresentable.fromEnum(GossipType::values);
    }
}

