/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.item;

import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.kyori.adventure.util.TriState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerAttemptPickupItemEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.leavesmc.leaves.LeavesConfig;
import org.leavesmc.leaves.util.ShulkerBoxUtils;

public class ItemEntity
extends Entity
implements TraceableEntity {
    private static final EntityDataAccessor<ItemStack> DATA_ITEM = SynchedEntityData.defineId(ItemEntity.class, EntityDataSerializers.ITEM_STACK);
    private static final float FLOAT_HEIGHT = 0.1f;
    public static final float EYE_HEIGHT = 0.2125f;
    private static final int LIFETIME = 6000;
    private static final int INFINITE_PICKUP_DELAY = Short.MAX_VALUE;
    private static final int INFINITE_LIFETIME = Short.MIN_VALUE;
    public int age;
    public int pickupDelay;
    public int health = 5;
    @Nullable
    public UUID thrower;
    @Nullable
    private Entity cachedThrower;
    @Nullable
    public UUID target;
    public final float bobOffs;
    private int lastTick = MinecraftServer.currentTick - 1;
    public boolean canMobPickup = true;
    private int despawnRate = -1;
    public TriState frictionState = TriState.NOT_SET;

    public ItemEntity(EntityType<? extends ItemEntity> type, Level world) {
        super(type, world);
        this.bobOffs = this.random.nextFloat() * (float)Math.PI * 2.0f;
        this.setYRot(this.random.nextFloat() * 360.0f);
    }

    public ItemEntity(Level world, double x, double y, double z, ItemStack stack) {
        this((EntityType<? extends ItemEntity>)EntityType.ITEM, world);
        BlockItem bi;
        Item item;
        this.setPos(x, y, z);
        if (LeavesConfig.useVanillaRandom) {
            this.setDeltaMovement(world.random.nextDouble() * 0.2 - 0.1, 0.2, world.random.nextDouble() * 0.2 - 0.1);
        } else {
            this.setDeltaMovement(this.random.nextDouble() * 0.2 - 0.1, 0.2, this.random.nextDouble() * 0.2 - 0.1);
        }
        this.setItem(stack);
        if (LeavesConfig.shulkerBoxStackSize > 1 && (item = stack.getItem()) instanceof BlockItem && (bi = (BlockItem)item).getBlock() instanceof ShulkerBoxBlock) {
            ShulkerBoxUtils.cleanUpShulkerBoxTag(stack);
        }
    }

    public ItemEntity(Level world, double x, double y, double z, ItemStack stack, double velocityX, double velocityY, double velocityZ) {
        this((EntityType<? extends ItemEntity>)EntityType.ITEM, world);
        this.setPos(x, y, z);
        this.setDeltaMovement(velocityX, velocityY, velocityZ);
        this.setItem(stack);
    }

    private ItemEntity(ItemEntity entity) {
        super(entity.getType(), entity.level());
        this.setItem(entity.getItem().copy());
        this.copyPosition(entity);
        this.age = entity.age;
        this.bobOffs = entity.bobOffs;
    }

    @Override
    public boolean dampensVibrations() {
        return this.getItem().is(ItemTags.DAMPENS_VIBRATIONS);
    }

    @Override
    @Nullable
    public Entity getOwner() {
        Level world;
        if (this.cachedThrower != null && !this.cachedThrower.isRemoved()) {
            return this.cachedThrower;
        }
        if (this.thrower != null && (world = this.level()) instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            this.cachedThrower = worldserver.getEntity(this.thrower);
            return this.cachedThrower;
        }
        return null;
    }

    @Override
    public void restoreFrom(Entity original) {
        super.restoreFrom(original);
        if (original instanceof ItemEntity) {
            ItemEntity entityitem = (ItemEntity)original;
            this.cachedThrower = entityitem.cachedThrower;
        }
    }

    @Override
    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_ITEM, ItemStack.EMPTY);
    }

    @Override
    protected double getDefaultGravity() {
        return 0.04;
    }

    @Override
    public void tick() {
        if (this.getItem().isEmpty()) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        } else {
            double d0;
            int i;
            super.tick();
            int elapsedTicks = MinecraftServer.currentTick - this.lastTick;
            if (this.pickupDelay != Short.MAX_VALUE) {
                this.pickupDelay -= elapsedTicks;
            }
            this.pickupDelay = Math.max(0, this.pickupDelay);
            if (this.age != Short.MIN_VALUE) {
                this.age += elapsedTicks;
            }
            this.lastTick = MinecraftServer.currentTick;
            this.xo = this.getX();
            this.yo = this.getY();
            this.zo = this.getZ();
            Vec3 vec3d = this.getDeltaMovement();
            if (this.isInWater() && this.getFluidHeight(FluidTags.WATER) > (double)0.1f) {
                this.setUnderwaterMovement();
            } else if (this.isInLava() && this.getFluidHeight(FluidTags.LAVA) > (double)0.1f) {
                this.setUnderLavaMovement();
            } else {
                this.applyGravity();
            }
            if (this.level().isClientSide) {
                this.noPhysics = false;
            } else {
                boolean bl = this.noPhysics = !this.level().noCollision(this, this.getBoundingBox().deflate(1.0E-7));
                if (this.noPhysics) {
                    this.moveTowardsClosestSpace(this.getX(), (this.getBoundingBox().minY + this.getBoundingBox().maxY) / 2.0, this.getZ());
                }
            }
            if (!this.onGround() || this.getDeltaMovement().horizontalDistanceSqr() > (double)1.0E-5f || (this.tickCount + this.getId()) % 4 == 0) {
                this.move(MoverType.SELF, this.getDeltaMovement());
                float f = 0.98f;
                if (this.frictionState == TriState.FALSE) {
                    f = 1.0f;
                } else if (this.onGround()) {
                    f = this.level().getBlockState(this.getBlockPosBelowThatAffectsMyMovement()).getBlock().getFriction() * 0.98f;
                }
                this.setDeltaMovement(this.getDeltaMovement().multiply(f, 0.98, f));
                if (this.onGround()) {
                    Vec3 vec3d1 = this.getDeltaMovement();
                    if (vec3d1.y < 0.0) {
                        this.setDeltaMovement(vec3d1.multiply(1.0, -0.5, 1.0));
                    }
                }
            }
            boolean flag = Mth.floor(this.xo) != Mth.floor(this.getX()) || Mth.floor(this.yo) != Mth.floor(this.getY()) || Mth.floor(this.zo) != Mth.floor(this.getZ());
            int n = i = flag ? 2 : 40;
            if (this.tickCount % i == 0 && !this.level().isClientSide && this.isMergable()) {
                this.mergeWithNeighbours();
            }
            this.hasImpulse |= this.updateInWaterStateAndDoFluidPushing();
            if (!this.level().isClientSide && (d0 = this.getDeltaMovement().subtract(vec3d).lengthSqr()) > 0.01) {
                this.hasImpulse = true;
            }
            if (!this.level().isClientSide && this.age >= this.despawnRate) {
                if (CraftEventFactory.callItemDespawnEvent(this).isCancelled()) {
                    this.age = 0;
                    return;
                }
                this.discard(EntityRemoveEvent.Cause.DESPAWN);
            }
        }
    }

    @Override
    public void inactiveTick() {
        this.tick();
    }

    @Override
    protected BlockPos getBlockPosBelowThatAffectsMyMovement() {
        return this.getOnPos(0.999999f);
    }

    private void setUnderwaterMovement() {
        Vec3 vec3d = this.getDeltaMovement();
        this.setDeltaMovement(vec3d.x * (double)0.99f, vec3d.y + (double)(vec3d.y < (double)0.06f ? 5.0E-4f : 0.0f), vec3d.z * (double)0.99f);
    }

    private void setUnderLavaMovement() {
        Vec3 vec3d = this.getDeltaMovement();
        this.setDeltaMovement(vec3d.x * (double)0.95f, vec3d.y + (double)(vec3d.y < (double)0.06f ? 5.0E-4f : 0.0f), vec3d.z * (double)0.95f);
    }

    private void mergeWithNeighbours() {
        if (this.isMergable()) {
            double radius = this.level().spigotConfig.itemMerge;
            List<ItemEntity> list = this.level().getEntitiesOfClass(ItemEntity.class, this.getBoundingBox().inflate(radius, radius - 0.5, radius), entityitem -> entityitem != this && entityitem.isMergable());
            for (ItemEntity entityitem2 : list) {
                if (!entityitem2.isMergable() || this.level().paperConfig().fixes.fixItemsMergingThroughWalls && this.level().clipDirect(this.position(), entityitem2.position(), CollisionContext.of(this)) == HitResult.Type.BLOCK) continue;
                this.tryToMerge(entityitem2);
                if (!this.isRemoved()) continue;
                break;
            }
        }
    }

    private boolean isMergable() {
        ItemStack itemstack = this.getItem();
        return this.isAlive() && this.pickupDelay != Short.MAX_VALUE && this.age != Short.MIN_VALUE && this.age < this.despawnRate && itemstack.getCount() < ShulkerBoxUtils.getItemStackMaxCount(itemstack);
    }

    private boolean tryStackShulkerBoxes(ItemEntity other) {
        BlockItem bi;
        Item item;
        ItemStack selfStack = this.getItem();
        if (LeavesConfig.shulkerBoxStackSize == 1 || !((item = selfStack.getItem()) instanceof BlockItem) || !((bi = (BlockItem)item).getBlock() instanceof ShulkerBoxBlock)) {
            return false;
        }
        ItemStack otherStack = other.getItem();
        if (selfStack.getItem() == otherStack.getItem() && !ShulkerBoxUtils.shulkerBoxHasItems(selfStack) && !ShulkerBoxUtils.shulkerBoxHasItems(otherStack) && Objects.equals(selfStack.getComponents(), otherStack.getComponents()) && selfStack.getCount() != LeavesConfig.shulkerBoxStackSize) {
            int amount = Math.min(otherStack.getCount(), LeavesConfig.shulkerBoxStackSize - selfStack.getCount());
            selfStack.grow(amount);
            this.setItem(selfStack);
            this.pickupDelay = Math.max(other.pickupDelay, this.pickupDelay);
            this.age = Math.min(other.getAge(), this.age);
            otherStack.shrink(amount);
            if (otherStack.isEmpty()) {
                other.discard();
            } else {
                other.setItem(otherStack);
            }
            return true;
        }
        return false;
    }

    private void tryToMerge(ItemEntity other) {
        if (this.tryStackShulkerBoxes(other)) {
            return;
        }
        ItemStack itemstack = this.getItem();
        ItemStack itemstack1 = other.getItem();
        if (Objects.equals(this.target, other.target) && ItemEntity.areMergable(itemstack, itemstack1)) {
            ItemEntity.merge(this, itemstack, other, itemstack1);
        }
    }

    public static boolean areMergable(ItemStack stack1, ItemStack stack2) {
        return stack2.getCount() + stack1.getCount() > stack2.getMaxStackSize() ? false : ItemStack.isSameItemSameComponents(stack1, stack2);
    }

    public static ItemStack merge(ItemStack stack1, ItemStack stack2, int maxCount) {
        int j = Math.min(Math.min(stack1.getMaxStackSize(), maxCount) - stack1.getCount(), stack2.getCount());
        ItemStack itemstack2 = stack1.copyWithCount(stack1.getCount() + j);
        stack2.shrink(j);
        return itemstack2;
    }

    private static void merge(ItemEntity targetEntity, ItemStack stack1, ItemStack stack2) {
        ItemStack itemstack2 = ItemEntity.merge(stack1, stack2, 64);
        targetEntity.setItem(itemstack2);
    }

    private static void merge(ItemEntity targetEntity, ItemStack targetStack, ItemEntity sourceEntity, ItemStack sourceStack) {
        if (!CraftEventFactory.callItemMergeEvent(sourceEntity, targetEntity)) {
            return;
        }
        ItemEntity.merge(targetEntity, targetStack, sourceStack);
        targetEntity.pickupDelay = Math.max(targetEntity.pickupDelay, sourceEntity.pickupDelay);
        targetEntity.age = Math.min(targetEntity.age, sourceEntity.age);
        if (sourceStack.isEmpty()) {
            sourceEntity.discard(EntityRemoveEvent.Cause.MERGE);
        }
    }

    @Override
    public boolean fireImmune() {
        return this.getItem().has(DataComponents.FIRE_RESISTANT) || super.fireImmune();
    }

    @Override
    public boolean hurt(DamageSource source, float amount) {
        if (this.isInvulnerableTo(source)) {
            return false;
        }
        if (!this.getItem().isEmpty() && this.getItem().is(Items.NETHER_STAR) && source.is(DamageTypeTags.IS_EXPLOSION)) {
            return false;
        }
        if (!this.getItem().canBeHurtBy(source)) {
            return false;
        }
        if (this.level().isClientSide) {
            return true;
        }
        if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, source, amount)) {
            return false;
        }
        this.markHurt();
        this.health = (int)((float)this.health - amount);
        this.gameEvent(GameEvent.ENTITY_DAMAGE, source.getEntity());
        if (this.health <= 0) {
            this.getItem().onDestroyed(this);
            this.discard(EntityRemoveEvent.Cause.DEATH);
        }
        return true;
    }

    @Override
    public void addAdditionalSaveData(CompoundTag nbt) {
        if (this.frictionState != TriState.NOT_SET) {
            nbt.putString("Paper.FrictionState", this.frictionState.toString());
        }
        nbt.putShort("Health", (short)this.health);
        nbt.putShort("Age", (short)this.age);
        nbt.putShort("PickupDelay", (short)this.pickupDelay);
        if (this.thrower != null) {
            nbt.putUUID("Thrower", this.thrower);
        }
        if (this.target != null) {
            nbt.putUUID("Owner", this.target);
        }
        if (!this.getItem().isEmpty()) {
            nbt.put("Item", this.getItem().save(this.registryAccess()));
        }
    }

    @Override
    public void readAdditionalSaveData(CompoundTag nbt) {
        this.health = nbt.getShort("Health");
        this.age = nbt.getShort("Age");
        if (nbt.contains("PickupDelay")) {
            this.pickupDelay = nbt.getShort("PickupDelay");
        }
        if (nbt.hasUUID("Owner")) {
            this.target = nbt.getUUID("Owner");
        }
        if (nbt.hasUUID("Thrower")) {
            this.thrower = nbt.getUUID("Thrower");
            this.cachedThrower = null;
        }
        if (nbt.contains("Item", 10)) {
            CompoundTag nbttagcompound1 = nbt.getCompound("Item");
            this.setItem(ItemStack.parse(this.registryAccess(), nbttagcompound1).orElse(ItemStack.EMPTY));
        } else {
            this.setItem(ItemStack.EMPTY);
        }
        if (nbt.contains("Paper.FrictionState")) {
            String fs = nbt.getString("Paper.FrictionState");
            try {
                this.frictionState = TriState.valueOf((String)fs);
            }
            catch (Exception ignored) {
                LogUtils.getLogger().error("Unknown friction state " + fs + " for " + String.valueOf(this));
            }
        }
        if (this.getItem().isEmpty()) {
            this.discard(null);
        }
    }

    @Override
    public void playerTouch(Player player) {
        if (!this.level().isClientSide) {
            ItemStack itemstack = this.getItem();
            Item item = itemstack.getItem();
            int i = itemstack.getCount();
            int canHold = player.getInventory().canHold(itemstack);
            int remaining = i - canHold;
            boolean flyAtPlayer = false;
            if (this.pickupDelay <= 0) {
                PlayerAttemptPickupItemEvent attemptEvent = new PlayerAttemptPickupItemEvent((org.bukkit.entity.Player)player.getBukkitEntity(), (org.bukkit.entity.Item)this.getBukkitEntity(), remaining);
                this.level().getCraftServer().getPluginManager().callEvent((Event)attemptEvent);
                flyAtPlayer = attemptEvent.getFlyAtPlayer();
                if (attemptEvent.isCancelled()) {
                    if (flyAtPlayer) {
                        player.take(this, i);
                    }
                    return;
                }
            }
            if (this.pickupDelay <= 0 && canHold > 0) {
                EntityPickupItemEvent entityEvent;
                itemstack.setCount(canHold);
                PlayerPickupItemEvent playerEvent = new PlayerPickupItemEvent((org.bukkit.entity.Player)player.getBukkitEntity(), (org.bukkit.entity.Item)this.getBukkitEntity(), remaining);
                playerEvent.setCancelled(!playerEvent.getPlayer().getCanPickupItems());
                this.level().getCraftServer().getPluginManager().callEvent((Event)playerEvent);
                flyAtPlayer = playerEvent.getFlyAtPlayer();
                if (playerEvent.isCancelled()) {
                    itemstack.setCount(i);
                    if (flyAtPlayer) {
                        player.take(this, i);
                    }
                    return;
                }
                entityEvent.setCancelled(!(entityEvent = new EntityPickupItemEvent((LivingEntity)((org.bukkit.entity.Player)player.getBukkitEntity()), (org.bukkit.entity.Item)this.getBukkitEntity(), remaining)).getEntity().getCanPickupItems());
                this.level().getCraftServer().getPluginManager().callEvent((Event)entityEvent);
                if (entityEvent.isCancelled()) {
                    itemstack.setCount(i);
                    return;
                }
                ItemStack current = this.getItem();
                if (!itemstack.equals(current)) {
                    itemstack = current;
                } else {
                    itemstack.setCount(canHold + remaining);
                }
                this.pickupDelay = 0;
            } else if (this.pickupDelay == 0) {
                this.pickupDelay = -1;
            }
            if (this.pickupDelay == 0 && (this.target == null || this.target.equals(player.getUUID())) && player.getInventory().add(itemstack)) {
                if (flyAtPlayer) {
                    player.take(this, i);
                }
                if (itemstack.isEmpty()) {
                    this.discard(EntityRemoveEvent.Cause.PICKUP);
                    itemstack.setCount(i);
                }
                player.awardStat(Stats.ITEM_PICKED_UP.get(item), i);
                player.onItemPickup(this);
            }
        }
    }

    @Override
    public Component getName() {
        Component ichatbasecomponent = this.getCustomName();
        return ichatbasecomponent != null ? ichatbasecomponent : Component.translatable(this.getItem().getDescriptionId());
    }

    @Override
    public boolean isAttackable() {
        return false;
    }

    @Override
    @Nullable
    public Entity changeDimension(ServerLevel destination) {
        Entity entity = super.changeDimension(destination);
        if (!this.level().isClientSide && entity instanceof ItemEntity) {
            ((ItemEntity)entity).mergeWithNeighbours();
        }
        return entity;
    }

    public ItemStack getItem() {
        return this.getEntityData().get(DATA_ITEM);
    }

    public void setItem(ItemStack stack) {
        this.getEntityData().set(DATA_ITEM, stack);
        this.despawnRate = this.level().paperConfig().entities.spawning.altItemDespawnRate.enabled ? this.level().paperConfig().entities.spawning.altItemDespawnRate.items.getOrDefault((Object)stack.getItem(), this.level().spigotConfig.itemDespawnRate) : this.level().spigotConfig.itemDespawnRate;
    }

    @Override
    public void onSyncedDataUpdated(EntityDataAccessor<?> data) {
        super.onSyncedDataUpdated(data);
        if (DATA_ITEM.equals(data)) {
            this.getItem().setEntityRepresentation(this);
        }
    }

    public void setTarget(@Nullable UUID owner) {
        this.target = owner;
    }

    public void setThrower(Entity thrower) {
        this.thrower = thrower.getUUID();
        this.cachedThrower = thrower;
    }

    public int getAge() {
        return this.age;
    }

    public void setDefaultPickUpDelay() {
        this.pickupDelay = 10;
    }

    public void setNoPickUpDelay() {
        this.pickupDelay = 0;
    }

    public void setNeverPickUp() {
        this.pickupDelay = Short.MAX_VALUE;
    }

    public void setPickUpDelay(int pickupDelay) {
        this.pickupDelay = pickupDelay;
    }

    public boolean hasPickUpDelay() {
        return this.pickupDelay > 0;
    }

    public void setUnlimitedLifetime() {
        this.age = Short.MIN_VALUE;
    }

    public void setExtendedLifetime() {
        this.age = -6000;
    }

    public void makeFakeItem() {
        this.setNeverPickUp();
        this.age = this.despawnRate - 1;
    }

    public float getSpin(float tickDelta) {
        return ((float)this.getAge() + tickDelta) / 20.0f + this.bobOffs;
    }

    public ItemEntity copy() {
        return new ItemEntity(this);
    }

    @Override
    public SoundSource getSoundSource() {
        return SoundSource.AMBIENT;
    }

    @Override
    public float getVisualRotationYInDegrees() {
        return 180.0f - this.getSpin(0.5f) / ((float)Math.PI * 2) * 360.0f;
    }

    @Override
    public SlotAccess getSlot(int mappedIndex) {
        return mappedIndex == 0 ? SlotAccess.of(this::getItem, this::setItem) : super.getSlot(mappedIndex);
    }
}

