/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.npc;

import javax.annotation.Nullable;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;

public class ClientSideMerchant
implements Merchant {
    private final Player source;
    private MerchantOffers offers = new MerchantOffers();
    private int xp;

    public ClientSideMerchant(Player player) {
        this.source = player;
    }

    @Override
    @Override
    public Player getTradingPlayer() {
        return this.source;
    }

    @Override
    @Override
    public void setTradingPlayer(@Nullable Player customer) {
    }

    @Override
    @Override
    public MerchantOffers getOffers() {
        return this.offers;
    }

    @Override
    @Override
    public void overrideOffers(MerchantOffers offers) {
        this.offers = offers;
    }

    @Override
    @Override
    public void notifyTrade(MerchantOffer offer) {
        offer.increaseUses();
    }

    @Override
    @Override
    public void notifyTradeUpdated(ItemStack stack) {
    }

    @Override
    @Override
    public boolean isClientSide() {
        return this.source.level().isClientSide;
    }

    @Override
    @Override
    public int getVillagerXp() {
        return this.xp;
    }

    @Override
    @Override
    public void overrideXp(int experience) {
        this.xp = experience;
    }

    @Override
    @Override
    public boolean showProgressBar() {
        return true;
    }

    @Override
    @Override
    public SoundEvent getNotifyTradeSound() {
        return SoundEvents.VILLAGER_YES;
    }
}

