/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.bukkit.event.entity.EntityRemoveEvent;

public abstract class AbstractHurtingProjectile
extends Projectile {
    public static final double ATTACK_DEFLECTION_SCALE = 0.1;
    public static final double BOUNCE_DEFLECTION_SCALE = 0.05;
    public double xPower;
    public double yPower;
    public double zPower;
    public float bukkitYield = 1.0f;
    public boolean isIncendiary = true;

    protected AbstractHurtingProjectile(EntityType<? extends AbstractHurtingProjectile> type, Level world) {
        super((EntityType<? extends Projectile>)type, world);
    }

    protected AbstractHurtingProjectile(EntityType<? extends AbstractHurtingProjectile> type, double x, double y, double z, Level world) {
        this(type, world);
        this.setPos(x, y, z);
    }

    public AbstractHurtingProjectile(EntityType<? extends AbstractHurtingProjectile> type, double x, double y, double z, double directionX, double directionY, double directionZ, Level world) {
        this(type, world);
        this.moveTo(x, y, z, this.getYRot(), this.getXRot());
        this.reapplyPosition();
        this.assignPower(directionX, directionY, directionZ);
    }

    public AbstractHurtingProjectile(EntityType<? extends AbstractHurtingProjectile> type, LivingEntity owner, double directionX, double directionY, double directionZ, Level world) {
        this(type, owner.getX(), owner.getY(), owner.getZ(), directionX, directionY, directionZ, world);
        this.setOwner(owner);
        this.setRot(owner.getYRot(), owner.getXRot());
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    @Override
    public boolean shouldRenderAtSqrDistance(double distance) {
        double d1 = this.getBoundingBox().getSize() * 4.0;
        if (Double.isNaN(d1)) {
            d1 = 4.0;
        }
        return distance < (d1 *= 64.0) * d1;
    }

    protected ClipContext.Block getClipType() {
        return ClipContext.Block.COLLIDER;
    }

    @Override
    public void tick() {
        Entity entity = this.getOwner();
        if (!this.level().isClientSide && (entity != null && entity.isRemoved() || !this.level().hasChunkAt(this.blockPosition()))) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        } else {
            float f;
            HitResult movingobjectposition;
            super.tick();
            if (this.shouldBurn()) {
                this.igniteForSeconds(1);
            }
            if ((movingobjectposition = ProjectileUtil.getHitResultOnMoveVector(this, this::canHitEntity, this.getClipType())).getType() != HitResult.Type.MISS) {
                this.preHitTargetOrDeflectSelf(movingobjectposition);
                if (this.isRemoved()) {
                    // empty if block
                }
            }
            this.checkInsideBlocks();
            Vec3 vec3d = this.getDeltaMovement();
            double d0 = this.getX() + vec3d.x;
            double d1 = this.getY() + vec3d.y;
            double d2 = this.getZ() + vec3d.z;
            ProjectileUtil.rotateTowardsMovement(this, 0.2f);
            if (this.isInWater()) {
                for (int i = 0; i < 4; ++i) {
                    float f1 = 0.25f;
                    this.level().addParticle(ParticleTypes.BUBBLE, d0 - vec3d.x * 0.25, d1 - vec3d.y * 0.25, d2 - vec3d.z * 0.25, vec3d.x, vec3d.y, vec3d.z);
                }
                f = this.getLiquidInertia();
            } else {
                f = this.getInertia();
            }
            this.setDeltaMovement(vec3d.add(this.xPower, this.yPower, this.zPower).scale(f));
            ParticleOptions particleparam = this.getTrailParticle();
            if (particleparam != null) {
                this.level().addParticle(particleparam, d0, d1 + 0.5, d2, 0.0, 0.0, 0.0);
            }
            this.setPos(d0, d1, d2);
        }
    }

    @Override
    public boolean hurt(DamageSource source, float amount) {
        return !this.isInvulnerableTo(source);
    }

    @Override
    public boolean canHitEntity(Entity entity) {
        return super.canHitEntity(entity) && !entity.noPhysics;
    }

    protected boolean shouldBurn() {
        return true;
    }

    @Nullable
    protected ParticleOptions getTrailParticle() {
        return ParticleTypes.SMOKE;
    }

    protected float getInertia() {
        return 0.95f;
    }

    protected float getLiquidInertia() {
        return 0.8f;
    }

    @Override
    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.put("power", this.newDoubleList(this.xPower, this.yPower, this.zPower));
    }

    @Override
    public void readAdditionalSaveData(CompoundTag nbt) {
        ListTag nbttaglist;
        super.readAdditionalSaveData(nbt);
        if (nbt.contains("power", 9) && (nbttaglist = nbt.getList("power", 6)).size() == 3) {
            this.xPower = nbttaglist.getDouble(0);
            this.yPower = nbttaglist.getDouble(1);
            this.zPower = nbttaglist.getDouble(2);
        }
    }

    @Override
    public float getLightLevelDependentMagicValue() {
        return 1.0f;
    }

    @Override
    public Packet<ClientGamePacketListener> getAddEntityPacket() {
        Entity entity = this.getOwner();
        int i = entity == null ? 0 : entity.getId();
        return new ClientboundAddEntityPacket(this.getId(), this.getUUID(), this.getX(), this.getY(), this.getZ(), this.getXRot(), this.getYRot(), this.getType(), i, new Vec3(this.xPower, this.yPower, this.zPower), 0.0);
    }

    @Override
    public void recreateFromPacket(ClientboundAddEntityPacket packet) {
        super.recreateFromPacket(packet);
        double d0 = packet.getXa();
        double d1 = packet.getYa();
        double d2 = packet.getZa();
        this.assignPower(d0, d1, d2);
    }

    public void assignPower(double velocityX, double velocityY, double velocityZ) {
        double d3 = Math.sqrt(velocityX * velocityX + velocityY * velocityY + velocityZ * velocityZ);
        if (d3 != 0.0) {
            this.xPower = velocityX / d3 * 0.1;
            this.yPower = velocityY / d3 * 0.1;
            this.zPower = velocityZ / d3 * 0.1;
        }
    }

    @Override
    protected void onDeflection(@Nullable Entity deflector, boolean fromAttack) {
        super.onDeflection(deflector, fromAttack);
        if (fromAttack) {
            this.xPower = this.getDeltaMovement().x * 0.1;
            this.yPower = this.getDeltaMovement().y * 0.1;
            this.zPower = this.getDeltaMovement().z * 0.1;
        } else {
            this.xPower = this.getDeltaMovement().x * 0.05;
            this.yPower = this.getDeltaMovement().y * 0.05;
            this.zPower = this.getDeltaMovement().z * 0.05;
        }
    }
}

