/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import io.papermc.paper.event.entity.WaterBottleSplashEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.bukkit.craftbukkit.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.LingeringPotionSplashEvent;
import org.bukkit.event.entity.PotionSplashEvent;

public class ThrownPotion
extends ThrowableItemProjectile
implements ItemSupplier {
    public static final double SPLASH_RANGE = 4.0;
    private static final double SPLASH_RANGE_SQ = 16.0;
    public static final Predicate<LivingEntity> WATER_SENSITIVE_OR_ON_FIRE = entityliving -> entityliving.isSensitiveToWater() || entityliving.isOnFire();
    private static final Predicate<LivingEntity> APPLY_WATER_GET_ENTITIES_PREDICATE = WATER_SENSITIVE_OR_ON_FIRE.or(Axolotl.class::isInstance);

    public ThrownPotion(EntityType<? extends ThrownPotion> type, Level world) {
        super((EntityType<? extends ThrowableItemProjectile>)type, world);
    }

    public ThrownPotion(Level world, LivingEntity owner) {
        super((EntityType<? extends ThrowableItemProjectile>)EntityType.POTION, owner, world);
    }

    public ThrownPotion(Level world, double x, double y, double z) {
        super((EntityType<? extends ThrowableItemProjectile>)EntityType.POTION, x, y, z, world);
    }

    @Override
    protected Item getDefaultItem() {
        return Items.SPLASH_POTION;
    }

    @Override
    protected double getDefaultGravity() {
        return 0.05;
    }

    @Override
    protected void onHitBlock(BlockHitResult blockHitResult) {
        super.onHitBlock(blockHitResult);
        if (!this.level().isClientSide) {
            ItemStack itemstack = this.getItem();
            Direction enumdirection = blockHitResult.getDirection();
            BlockPos blockposition = blockHitResult.getBlockPos();
            BlockPos blockposition1 = blockposition.relative(enumdirection);
            PotionContents potioncontents = itemstack.getOrDefault(DataComponents.POTION_CONTENTS, PotionContents.EMPTY);
            if (potioncontents.is(Potions.WATER)) {
                this.dowseFire(blockposition1);
                this.dowseFire(blockposition1.relative(enumdirection.getOpposite()));
                for (Direction enumdirection1 : Direction.Plane.HORIZONTAL) {
                    this.dowseFire(blockposition1.relative(enumdirection1));
                }
            }
        }
    }

    @Override
    protected void onHit(HitResult hitResult) {
        super.onHit(hitResult);
        this.splash(hitResult);
    }

    public void splash(@Nullable HitResult hitResult) {
        if (!this.level().isClientSide) {
            ItemStack itemstack = this.getItem();
            PotionContents potioncontents = itemstack.getOrDefault(DataComponents.POTION_CONTENTS, PotionContents.EMPTY);
            boolean showParticles = true;
            showParticles = potioncontents.is(Potions.WATER) ? this.applyWater(hitResult) : (this.isLingering() ? this.makeAreaOfEffectCloud(potioncontents, hitResult) : this.applySplash(potioncontents.getAllEffects(), hitResult != null && hitResult.getType() == HitResult.Type.ENTITY ? ((EntityHitResult)hitResult).getEntity() : null, hitResult));
            if (showParticles) {
                int i = potioncontents.potion().isPresent() && potioncontents.potion().get().value().hasInstantEffects() ? 2007 : 2002;
                this.level().levelEvent(i, this.blockPosition(), potioncontents.getColor());
            }
            this.discard(EntityRemoveEvent.Cause.HIT);
        }
    }

    private boolean applyWater(@Nullable HitResult hitResult) {
        AABB axisalignedbb = this.getBoundingBox().inflate(4.0, 2.0, 4.0);
        List<LivingEntity> list = this.level().getEntitiesOfClass(LivingEntity.class, axisalignedbb, APPLY_WATER_GET_ENTITIES_PREDICATE);
        HashMap<org.bukkit.entity.LivingEntity, Double> affected = new HashMap<org.bukkit.entity.LivingEntity, Double>();
        HashSet<org.bukkit.entity.LivingEntity> rehydrate = new HashSet<org.bukkit.entity.LivingEntity>();
        HashSet<org.bukkit.entity.LivingEntity> extinguish = new HashSet<org.bukkit.entity.LivingEntity>();
        for (LivingEntity entityliving : list) {
            double d0;
            if (entityliving instanceof Axolotl) {
                Axolotl axolotl = (Axolotl)entityliving;
                rehydrate.add((org.bukkit.entity.LivingEntity)((org.bukkit.entity.Axolotl)axolotl.getBukkitEntity()));
            }
            if (!((d0 = this.distanceToSqr(entityliving)) < 16.0)) continue;
            if (entityliving.isSensitiveToWater()) {
                affected.put(entityliving.getBukkitLivingEntity(), 1.0);
            }
            if (!entityliving.isOnFire() || !entityliving.isAlive()) continue;
            extinguish.add(entityliving.getBukkitLivingEntity());
        }
        WaterBottleSplashEvent event = CraftEventFactory.callWaterBottleSplashEvent(this, hitResult, affected, rehydrate, extinguish);
        if (!event.isCancelled()) {
            for (org.bukkit.entity.LivingEntity affectedEntity : event.getToDamage()) {
                ((CraftLivingEntity)affectedEntity).getHandle().hurt(this.damageSources().indirectMagic(this, this.getOwner()), 1.0f);
            }
            for (org.bukkit.entity.LivingEntity toExtinguish : event.getToExtinguish()) {
                ((CraftLivingEntity)toExtinguish).getHandle().extinguishFire();
            }
            for (org.bukkit.entity.LivingEntity toRehydrate : event.getToRehydrate()) {
                LivingEntity livingEntity = ((CraftLivingEntity)toRehydrate).getHandle();
                if (!(livingEntity instanceof Axolotl)) continue;
                Axolotl axolotl = (Axolotl)livingEntity;
                axolotl.rehydrate();
            }
        }
        return !event.isCancelled();
    }

    private boolean applySplash(Iterable<MobEffectInstance> iterable, @Nullable Entity entity, @Nullable HitResult position) {
        PotionSplashEvent event;
        double d1;
        AABB axisalignedbb = this.getBoundingBox().inflate(4.0, 2.0, 4.0);
        List<LivingEntity> list = this.level().getEntitiesOfClass(LivingEntity.class, axisalignedbb);
        HashMap<org.bukkit.entity.LivingEntity, Double> affected = new HashMap<org.bukkit.entity.LivingEntity, Double>();
        if (!list.isEmpty()) {
            Entity entity1 = this.getEffectSource();
            for (LivingEntity entityliving : list) {
                double d0;
                if (!entityliving.isAffectedByPotions() || !((d0 = this.distanceToSqr(entityliving)) < 16.0)) continue;
                d1 = entityliving == entity ? 1.0 : 1.0 - Math.sqrt(d0) / 4.0;
                affected.put((org.bukkit.entity.LivingEntity)entityliving.getBukkitEntity(), d1);
            }
        }
        if (!(event = CraftEventFactory.callPotionSplashEvent(this, position, affected)).isCancelled() && list != null && !list.isEmpty()) {
            Entity entity1 = this.getEffectSource();
            for (org.bukkit.entity.LivingEntity victim : event.getAffectedEntities()) {
                if (!(victim instanceof CraftLivingEntity)) continue;
                LivingEntity entityliving = ((CraftLivingEntity)victim).getHandle();
                d1 = event.getIntensity(victim);
                for (MobEffectInstance mobeffect : iterable) {
                    MobEffect mobeffectlist;
                    Holder<MobEffect> holder = mobeffect.getEffect();
                    if (!this.level().pvpMode && this.getOwner() instanceof ServerPlayer && entityliving instanceof ServerPlayer && entityliving != this.getOwner() && ((mobeffectlist = holder.value()) == MobEffects.MOVEMENT_SLOWDOWN || mobeffectlist == MobEffects.DIG_SLOWDOWN || mobeffectlist == MobEffects.HARM || mobeffectlist == MobEffects.BLINDNESS || mobeffectlist == MobEffects.HUNGER || mobeffectlist == MobEffects.WEAKNESS || mobeffectlist == MobEffects.POISON)) continue;
                    if (holder.value().isInstantenous()) {
                        holder.value().applyInstantenousEffect(this, this.getOwner(), entityliving, mobeffect.getAmplifier(), d1);
                        continue;
                    }
                    int i = mobeffect.mapDuration(j -> (int)(d1 * (double)j + 0.5));
                    MobEffectInstance mobeffect1 = new MobEffectInstance(holder, i, mobeffect.getAmplifier(), mobeffect.isAmbient(), mobeffect.isVisible());
                    if (mobeffect1.endsWithin(20)) continue;
                    entityliving.addEffect(mobeffect1, entity1, EntityPotionEffectEvent.Cause.POTION_SPLASH);
                }
            }
        }
        return !event.isCancelled();
    }

    private boolean makeAreaOfEffectCloud(PotionContents potioncontents, @Nullable HitResult position) {
        AreaEffectCloud entityareaeffectcloud = new AreaEffectCloud(this.level(), this.getX(), this.getY(), this.getZ());
        Entity entity = this.getOwner();
        if (entity instanceof LivingEntity) {
            LivingEntity entityliving = (LivingEntity)entity;
            entityareaeffectcloud.setOwner(entityliving);
        }
        entityareaeffectcloud.setRadius(3.0f);
        entityareaeffectcloud.setRadiusOnUse(-0.5f);
        entityareaeffectcloud.setWaitTime(10);
        entityareaeffectcloud.setRadiusPerTick(-entityareaeffectcloud.getRadius() / (float)entityareaeffectcloud.getDuration());
        entityareaeffectcloud.setPotionContents(potioncontents);
        boolean noEffects = potioncontents.hasEffects();
        LingeringPotionSplashEvent event = CraftEventFactory.callLingeringPotionSplashEvent(this, position, entityareaeffectcloud);
        if (!(event.isCancelled() || entityareaeffectcloud.isRemoved() || !event.allowsEmptyCreation() && noEffects && !entityareaeffectcloud.potionContents.hasEffects())) {
            this.level().addFreshEntity(entityareaeffectcloud);
        } else {
            entityareaeffectcloud.discard(null);
        }
        return !event.isCancelled();
    }

    public boolean isLingering() {
        return this.getItem().is(Items.LINGERING_POTION);
    }

    private void dowseFire(BlockPos pos) {
        BlockState iblockdata = this.level().getBlockState(pos);
        if (iblockdata.is(BlockTags.FIRE)) {
            if (CraftEventFactory.callEntityChangeBlockEvent(this, pos, iblockdata.getFluidState().createLegacyBlock())) {
                this.level().destroyBlock(pos, false, this);
            }
        } else if (AbstractCandleBlock.isLit(iblockdata)) {
            if (CraftEventFactory.callEntityChangeBlockEvent(this, pos, (BlockState)iblockdata.setValue(AbstractCandleBlock.LIT, false))) {
                AbstractCandleBlock.extinguish(null, iblockdata, this.level(), pos);
            }
        } else if (CampfireBlock.isLitCampfire(iblockdata) && CraftEventFactory.callEntityChangeBlockEvent(this, pos, (BlockState)iblockdata.setValue(CampfireBlock.LIT, false))) {
            this.level().levelEvent(null, 1009, pos, 0);
            CampfireBlock.dowse(this.getOwner(), this.level(), pos, iblockdata);
            this.level().setBlockAndUpdate(pos, (BlockState)iblockdata.setValue(CampfireBlock.LIT, false));
        }
    }
}

