/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.raid;

import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.PoiTypeTags;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.event.CraftEventFactory;

public class Raids
extends SavedData {
    private static final String RAID_FILE_ID = "raids";
    public final Map<Integer, Raid> raidMap = Maps.newHashMap();
    private final ServerLevel level;
    private int nextAvailableID;
    private int tick;

    public static SavedData.Factory<Raids> factory(ServerLevel world) {
        return new SavedData.Factory<Raids>(() -> new Raids(world), (nbttagcompound, holderlookup_a) -> Raids.load(world, nbttagcompound), DataFixTypes.SAVED_DATA_RAIDS);
    }

    public Raids(ServerLevel world) {
        this.level = world;
        this.nextAvailableID = 1;
        this.setDirty();
    }

    public Raid get(int id) {
        return this.raidMap.get(id);
    }

    public void tick() {
        ++this.tick;
        Iterator<Raid> iterator = this.raidMap.values().iterator();
        while (iterator.hasNext()) {
            Raid raid = iterator.next();
            if (this.level.getGameRules().getBoolean(GameRules.RULE_DISABLE_RAIDS)) {
                raid.stop();
            }
            if (raid.isStopped()) {
                iterator.remove();
                this.setDirty();
                continue;
            }
            raid.tick();
        }
        if (this.tick % 200 == 0) {
            this.setDirty();
        }
        DebugPackets.sendRaids(this.level, this.raidMap.values());
    }

    public static boolean canJoinRaid(Raider raider, Raid raid) {
        return raider != null && raid != null && raid.getLevel() != null ? raider.isAlive() && raider.canJoinRaid() && raider.getNoActionTime() <= 2400 && raider.level().dimensionType() == raid.getLevel().dimensionType() : false;
    }

    @Nullable
    public Raid createOrExtendRaid(ServerPlayer player, BlockPos pos) {
        BlockPos blockposition2;
        if (player.isSpectator()) {
            return null;
        }
        if (this.level.getGameRules().getBoolean(GameRules.RULE_DISABLE_RAIDS)) {
            return null;
        }
        DimensionType dimensionmanager = player.level().dimensionType();
        if (!dimensionmanager.hasRaids()) {
            return null;
        }
        List<PoiRecord> list = this.level.getPoiManager().getInRange(holder -> holder.is(PoiTypeTags.VILLAGE), pos, 64, PoiManager.Occupancy.IS_OCCUPIED).toList();
        int i = 0;
        Vec3 vec3d = Vec3.ZERO;
        for (PoiRecord villageplacerecord : list) {
            BlockPos blockposition1 = villageplacerecord.getPos();
            vec3d = vec3d.add(blockposition1.getX(), blockposition1.getY(), blockposition1.getZ());
            ++i;
        }
        if (i > 0) {
            vec3d = vec3d.scale(1.0 / (double)i);
            blockposition2 = BlockPos.containing(vec3d);
        } else {
            blockposition2 = pos;
        }
        Raid raid = this.getOrCreateRaid(player.serverLevel(), blockposition2);
        if (!raid.isStarted() || raid.isInProgress() && raid.getRaidOmenLevel() < raid.getMaxRaidOmenLevel()) {
            if (!CraftEventFactory.callRaidTriggerEvent(raid, player)) {
                player.removeEffect(MobEffects.RAID_OMEN);
                return null;
            }
            if (!raid.isStarted() && !this.raidMap.containsKey(raid.getId())) {
                this.raidMap.put(raid.getId(), raid);
            }
            raid.absorbRaidOmen(player);
        }
        this.setDirty();
        return raid;
    }

    private Raid getOrCreateRaid(ServerLevel world, BlockPos pos) {
        Raid raid = world.getRaidAt(pos);
        return raid != null ? raid : new Raid(this.getUniqueId(), world, pos);
    }

    public static Raids load(ServerLevel world, CompoundTag nbt) {
        Raids persistentraid = new Raids(world);
        persistentraid.nextAvailableID = nbt.getInt("NextAvailableID");
        persistentraid.tick = nbt.getInt("Tick");
        ListTag nbttaglist = nbt.getList("Raids", 10);
        for (int i = 0; i < nbttaglist.size(); ++i) {
            CompoundTag nbttagcompound1 = nbttaglist.getCompound(i);
            Raid raid = new Raid(world, nbttagcompound1);
            persistentraid.raidMap.put(raid.getId(), raid);
        }
        return persistentraid;
    }

    @Override
    public CompoundTag save(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        nbt.putInt("NextAvailableID", this.nextAvailableID);
        nbt.putInt("Tick", this.tick);
        ListTag nbttaglist = new ListTag();
        for (Raid raid : this.raidMap.values()) {
            CompoundTag nbttagcompound1 = new CompoundTag();
            raid.save(nbttagcompound1);
            nbttaglist.add(nbttagcompound1);
        }
        nbt.put("Raids", nbttaglist);
        return nbt;
    }

    public static String getFileId(Holder<DimensionType> dimensionTypeEntry) {
        return dimensionTypeEntry.is(BuiltinDimensionTypes.END) ? "raids_end" : RAID_FILE_ID;
    }

    private int getUniqueId() {
        return ++this.nextAvailableID;
    }

    @Nullable
    public Raid getNearbyRaid(BlockPos pos, int searchDistance) {
        Raid raid = null;
        double d0 = searchDistance;
        for (Raid raid1 : this.raidMap.values()) {
            double d1 = raid1.getCenter().distSqr(pos);
            if (!raid1.isActive() || !(d1 < d0)) continue;
            raid = raid1;
            d0 = d1;
        }
        return raid;
    }
}

