/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.schedule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.Int2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectSortedMap;
import java.util.Collection;
import java.util.List;
import net.minecraft.world.entity.schedule.Keyframe;

public class Timeline {
    private final List<Keyframe> keyframes = Lists.newArrayList();
    private int previousIndex;

    public ImmutableList<Keyframe> getKeyframes() {
        return ImmutableList.copyOf(this.keyframes);
    }

    public Timeline addKeyframe(int startTime, float priority) {
        this.keyframes.add(new Keyframe(startTime, priority));
        this.sortAndDeduplicateKeyframes();
        return this;
    }

    public Timeline addKeyframes(Collection<Keyframe> entries) {
        this.keyframes.addAll(entries);
        this.sortAndDeduplicateKeyframes();
        return this;
    }

    private void sortAndDeduplicateKeyframes() {
        Int2ObjectAVLTreeMap int2ObjectSortedMap = new Int2ObjectAVLTreeMap();
        this.keyframes.forEach(arg_0 -> Timeline.lambda$sortAndDeduplicateKeyframes$0((Int2ObjectSortedMap)int2ObjectSortedMap, arg_0));
        this.keyframes.clear();
        this.keyframes.addAll((Collection<Keyframe>)int2ObjectSortedMap.values());
        this.previousIndex = 0;
    }

    public float getValueAt(int time) {
        Keyframe keyframe3;
        if (this.keyframes.size() <= 0) {
            return 0.0f;
        }
        Keyframe keyframe = this.keyframes.get(this.previousIndex);
        Keyframe keyframe2 = this.keyframes.get(this.keyframes.size() - 1);
        boolean bl = time < keyframe.getTimeStamp();
        int i = bl ? 0 : this.previousIndex;
        float f = bl ? keyframe2.getValue() : keyframe.getValue();
        int j = i;
        while (j < this.keyframes.size() && (keyframe3 = this.keyframes.get(j)).getTimeStamp() <= time) {
            this.previousIndex = j++;
            f = keyframe3.getValue();
        }
        return f;
    }

    private static /* synthetic */ void lambda$sortAndDeduplicateKeyframes$0(Int2ObjectSortedMap entry, Keyframe keyframe) {
        entry.put(keyframe.getTimeStamp(), (Object)keyframe);
    }
}

