/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;

public class MinecartTNT
extends AbstractMinecart {
    private static final byte EVENT_PRIME = 10;
    public int fuse = -1;

    public MinecartTNT(EntityType<? extends MinecartTNT> type, Level world) {
        super(type, world);
    }

    public MinecartTNT(Level world, double x, double y, double z) {
        super(EntityType.TNT_MINECART, world, x, y, z);
    }

    @Override
    public AbstractMinecart.Type getMinecartType() {
        return AbstractMinecart.Type.TNT;
    }

    @Override
    public BlockState getDefaultDisplayBlockState() {
        return Blocks.TNT.defaultBlockState();
    }

    @Override
    public void tick() {
        double d0;
        super.tick();
        if (this.fuse > 0) {
            if (this.level().paperConfig().fixes.tntEntityHeightNerf.test(v -> this.getY() > (double)v)) {
                this.discard(EntityRemoveEvent.Cause.OUT_OF_WORLD);
                return;
            }
            --this.fuse;
            this.level().addParticle(ParticleTypes.SMOKE, this.getX(), this.getY() + 0.5, this.getZ(), 0.0, 0.0, 0.0);
        } else if (this.fuse == 0) {
            this.explode(this.getDeltaMovement().horizontalDistanceSqr());
        }
        if (this.horizontalCollision && (d0 = this.getDeltaMovement().horizontalDistanceSqr()) >= (double)0.01f) {
            this.explode(d0);
        }
    }

    @Override
    public boolean hurt(DamageSource source, float amount) {
        AbstractArrow entityarrow;
        Entity entity = source.getDirectEntity();
        if (entity instanceof AbstractArrow && (entityarrow = (AbstractArrow)entity).isOnFire()) {
            DamageSource damagesource1 = this.damageSources().explosion(this, source.getEntity());
            this.explode(damagesource1, entityarrow.getDeltaMovement().lengthSqr());
        }
        return super.hurt(source, amount);
    }

    @Override
    public void destroy(DamageSource source) {
        double d0 = this.getDeltaMovement().horizontalDistanceSqr();
        if (!MinecartTNT.damageSourceIgnitesTnt(source) && d0 < (double)0.01f) {
            this.destroy(this.getDropItem());
        } else if (this.fuse < 0) {
            this.primeFuse();
            this.fuse = this.random.nextInt(20) + this.random.nextInt(20);
        }
    }

    @Override
    protected Item getDropItem() {
        return Items.TNT_MINECART;
    }

    public void explode(double power) {
        this.explode(null, power);
    }

    protected void explode(@Nullable DamageSource damageSource, double power) {
        if (!this.level().isClientSide) {
            double d1 = Math.sqrt(power);
            if (d1 > 5.0) {
                d1 = 5.0;
            }
            ExplosionPrimeEvent event = new ExplosionPrimeEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (float)(4.0 + this.random.nextDouble() * 1.5 * d1), false);
            this.level().getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                this.fuse = -1;
                return;
            }
            this.level().explode(this, damageSource, null, this.getX(), this.getY(), this.getZ(), event.getRadius(), event.getFire(), Level.ExplosionInteraction.TNT);
            this.discard(EntityRemoveEvent.Cause.EXPLODE);
        }
    }

    @Override
    public boolean causeFallDamage(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        if (fallDistance >= 3.0f) {
            float f2 = fallDistance / 10.0f;
            this.explode(f2 * f2);
        }
        return super.causeFallDamage(fallDistance, damageMultiplier, damageSource);
    }

    @Override
    public void activateMinecart(int x, int y, int z, boolean powered) {
        if (powered && this.fuse < 0) {
            this.primeFuse();
        }
    }

    @Override
    public void handleEntityEvent(byte status) {
        if (status == 10) {
            this.primeFuse();
        } else {
            super.handleEntityEvent(status);
        }
    }

    public void primeFuse() {
        this.fuse = 80;
        if (!this.level().isClientSide) {
            this.level().broadcastEntityEvent(this, (byte)10);
            if (!this.isSilent()) {
                this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.TNT_PRIMED, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    public int getFuse() {
        return this.fuse;
    }

    public boolean isPrimed() {
        return this.fuse > -1;
    }

    @Override
    public float getBlockExplosionResistance(Explosion explosion, BlockGetter world, BlockPos pos, BlockState blockState, FluidState fluidState, float max) {
        return this.isPrimed() && (blockState.is(BlockTags.RAILS) || world.getBlockState(pos.above()).is(BlockTags.RAILS)) ? 0.0f : super.getBlockExplosionResistance(explosion, world, pos, blockState, fluidState, max);
    }

    @Override
    public boolean shouldBlockExplode(Explosion explosion, BlockGetter world, BlockPos pos, BlockState state, float explosionPower) {
        return this.isPrimed() && (state.is(BlockTags.RAILS) || world.getBlockState(pos.above()).is(BlockTags.RAILS)) ? false : super.shouldBlockExplode(explosion, world, pos, state, explosionPower);
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        if (nbt.contains("TNTFuse", 99)) {
            this.fuse = nbt.getInt("TNTFuse");
        }
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putInt("TNTFuse", this.fuse);
    }

    @Override
    boolean shouldSourceDestroy(DamageSource source) {
        return MinecartTNT.damageSourceIgnitesTnt(source);
    }

    private static boolean damageSourceIgnitesTnt(DamageSource source) {
        return source.is(DamageTypeTags.IS_FIRE) || source.is(DamageTypeTags.IS_EXPLOSION);
    }
}

