/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.ContainerSynchronizer;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.bukkit.Material;
import org.bukkit.craftbukkit.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.inventory.CraftInventory;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.BlockInventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.leavesmc.leaves.util.ShulkerBoxUtils;
import org.slf4j.Logger;

public abstract class AbstractContainerMenu {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final int SLOT_CLICKED_OUTSIDE = -999;
    public static final int QUICKCRAFT_TYPE_CHARITABLE = 0;
    public static final int QUICKCRAFT_TYPE_GREEDY = 1;
    public static final int QUICKCRAFT_TYPE_CLONE = 2;
    public static final int QUICKCRAFT_HEADER_START = 0;
    public static final int QUICKCRAFT_HEADER_CONTINUE = 1;
    public static final int QUICKCRAFT_HEADER_END = 2;
    public static final int CARRIED_SLOT_SIZE = Integer.MAX_VALUE;
    public NonNullList<net.minecraft.world.item.ItemStack> lastSlots = NonNullList.create();
    public NonNullList<Slot> slots = NonNullList.create();
    public List<DataSlot> dataSlots = Lists.newArrayList();
    private net.minecraft.world.item.ItemStack carried = net.minecraft.world.item.ItemStack.EMPTY;
    public NonNullList<net.minecraft.world.item.ItemStack> remoteSlots = NonNullList.create();
    public IntList remoteDataSlots = new IntArrayList();
    private net.minecraft.world.item.ItemStack remoteCarried = net.minecraft.world.item.ItemStack.EMPTY;
    private int stateId;
    @Nullable
    private final MenuType<?> menuType;
    public final int containerId;
    private int quickcraftType = -1;
    private int quickcraftStatus;
    private final Set<Slot> quickcraftSlots = Sets.newHashSet();
    private final List<ContainerListener> containerListeners = Lists.newArrayList();
    @Nullable
    private ContainerSynchronizer synchronizer;
    private boolean suppressRemoteUpdates;
    public boolean checkReachable = true;
    private Component title;

    public abstract InventoryView getBukkitView();

    public void transferTo(AbstractContainerMenu other, CraftHumanEntity player) {
        InventoryView source = this.getBukkitView();
        InventoryView destination = other.getBukkitView();
        ((CraftInventory)source.getTopInventory()).getInventory().onClose(player);
        ((CraftInventory)source.getBottomInventory()).getInventory().onClose(player);
        ((CraftInventory)destination.getTopInventory()).getInventory().onOpen(player);
        ((CraftInventory)destination.getBottomInventory()).getInventory().onOpen(player);
    }

    public final Component getTitle() {
        if (this.title == null) {
            return Component.literal("");
        }
        return this.title;
    }

    public final void setTitle(Component title) {
        Preconditions.checkState((this.title == null ? 1 : 0) != 0, (Object)"Title already set");
        this.title = title;
    }

    protected AbstractContainerMenu(@Nullable MenuType<?> type, int syncId) {
        this.menuType = type;
        this.containerId = syncId;
    }

    protected static boolean stillValid(ContainerLevelAccess context, Player player, Block block) {
        return context.evaluate((world, blockposition) -> !world.getBlockState((BlockPos)blockposition).is(block) ? false : player.canInteractWithBlock((BlockPos)blockposition, 4.0), true);
    }

    public MenuType<?> getType() {
        if (this.menuType == null) {
            throw new UnsupportedOperationException("Unable to construct this menu by type");
        }
        return this.menuType;
    }

    protected static void checkContainerSize(Container inventory, int expectedSize) {
        int j = inventory.getContainerSize();
        if (j < expectedSize) {
            throw new IllegalArgumentException("Container size " + j + " is smaller than expected " + expectedSize);
        }
    }

    protected static void checkContainerDataCount(ContainerData data, int expectedCount) {
        int j = data.getCount();
        if (j < expectedCount) {
            throw new IllegalArgumentException("Container data count " + j + " is smaller than expected " + expectedCount);
        }
    }

    public boolean isValidSlotIndex(int slot) {
        return slot == -1 || slot == -999 || slot < this.slots.size();
    }

    protected Slot addSlot(Slot slot) {
        slot.index = this.slots.size();
        this.slots.add(slot);
        this.lastSlots.add(net.minecraft.world.item.ItemStack.EMPTY);
        this.remoteSlots.add(net.minecraft.world.item.ItemStack.EMPTY);
        return slot;
    }

    protected DataSlot addDataSlot(DataSlot property) {
        this.dataSlots.add(property);
        this.remoteDataSlots.add(0);
        return property;
    }

    protected void addDataSlots(ContainerData propertyDelegate) {
        for (int i = 0; i < propertyDelegate.getCount(); ++i) {
            this.addDataSlot(DataSlot.forContainer(propertyDelegate, i));
        }
    }

    public void addSlotListener(ContainerListener listener) {
        if (!this.containerListeners.contains(listener)) {
            this.containerListeners.add(listener);
            this.broadcastChanges();
        }
    }

    public void setSynchronizer(ContainerSynchronizer handler) {
        this.synchronizer = handler;
        this.sendAllDataToRemote();
    }

    public void sendAllDataToRemote() {
        int i;
        int j = this.slots.size();
        for (i = 0; i < j; ++i) {
            this.remoteSlots.set(i, this.slots.get(i).getItem().copy());
        }
        this.remoteCarried = this.getCarried().copy();
        j = this.dataSlots.size();
        for (i = 0; i < j; ++i) {
            this.remoteDataSlots.set(i, this.dataSlots.get(i).get());
        }
        if (this.synchronizer != null) {
            this.synchronizer.sendInitialData(this, this.remoteSlots, this.remoteCarried, this.remoteDataSlots.toIntArray());
            this.synchronizer.sendOffHandSlotChange();
        }
    }

    public void broadcastCarriedItem() {
        this.remoteCarried = this.getCarried().copy();
        if (this.synchronizer != null) {
            this.synchronizer.sendCarriedChange(this, this.remoteCarried);
        }
    }

    public void removeSlotListener(ContainerListener listener) {
        this.containerListeners.remove(listener);
    }

    public NonNullList<net.minecraft.world.item.ItemStack> getItems() {
        NonNullList<net.minecraft.world.item.ItemStack> nonnulllist = NonNullList.create();
        for (Slot slot : this.slots) {
            nonnulllist.add(slot.getItem());
        }
        return nonnulllist;
    }

    public void broadcastChanges() {
        int i;
        for (i = 0; i < this.slots.size(); ++i) {
            net.minecraft.world.item.ItemStack itemstack = this.slots.get(i).getItem();
            Objects.requireNonNull(itemstack);
            com.google.common.base.Supplier supplier = Suppliers.memoize(itemstack::copy);
            this.triggerSlotListeners(i, itemstack, (Supplier<net.minecraft.world.item.ItemStack>)supplier);
            this.synchronizeSlotToRemote(i, itemstack, (Supplier<net.minecraft.world.item.ItemStack>)supplier);
        }
        this.synchronizeCarriedToRemote();
        for (i = 0; i < this.dataSlots.size(); ++i) {
            DataSlot containerproperty = this.dataSlots.get(i);
            int j = containerproperty.get();
            if (containerproperty.checkAndClearUpdateFlag()) {
                this.updateDataSlotListeners(i, j);
            }
            this.synchronizeDataSlotToRemote(i, j);
        }
    }

    public void broadcastFullState() {
        int i;
        for (i = 0; i < this.slots.size(); ++i) {
            net.minecraft.world.item.ItemStack itemstack = this.slots.get(i).getItem();
            Objects.requireNonNull(itemstack);
            this.triggerSlotListeners(i, itemstack, itemstack::copy);
        }
        for (i = 0; i < this.dataSlots.size(); ++i) {
            DataSlot containerproperty = this.dataSlots.get(i);
            if (!containerproperty.checkAndClearUpdateFlag()) continue;
            this.updateDataSlotListeners(i, containerproperty.get());
        }
        this.sendAllDataToRemote();
    }

    private void updateDataSlotListeners(int index, int value) {
        for (ContainerListener icrafting : this.containerListeners) {
            icrafting.dataChanged(this, index, value);
        }
    }

    private void triggerSlotListeners(int slot, net.minecraft.world.item.ItemStack stack, Supplier<net.minecraft.world.item.ItemStack> copySupplier) {
        net.minecraft.world.item.ItemStack itemstack1 = this.lastSlots.get(slot);
        if (!net.minecraft.world.item.ItemStack.matches(itemstack1, stack)) {
            net.minecraft.world.item.ItemStack itemstack2 = copySupplier.get();
            this.lastSlots.set(slot, itemstack2);
            for (ContainerListener icrafting : this.containerListeners) {
                icrafting.slotChanged(this, slot, itemstack1, itemstack2);
            }
        }
    }

    private void synchronizeSlotToRemote(int slot, net.minecraft.world.item.ItemStack stack, Supplier<net.minecraft.world.item.ItemStack> copySupplier) {
        net.minecraft.world.item.ItemStack itemstack1;
        if (!this.suppressRemoteUpdates && !net.minecraft.world.item.ItemStack.matches(itemstack1 = this.remoteSlots.get(slot), stack)) {
            net.minecraft.world.item.ItemStack itemstack2 = copySupplier.get();
            this.remoteSlots.set(slot, itemstack2);
            if (this.synchronizer != null) {
                this.synchronizer.sendSlotChange(this, slot, itemstack2);
            }
        }
    }

    private void synchronizeDataSlotToRemote(int id, int value) {
        int k;
        if (!this.suppressRemoteUpdates && (k = this.remoteDataSlots.getInt(id)) != value) {
            this.remoteDataSlots.set(id, value);
            if (this.synchronizer != null) {
                this.synchronizer.sendDataChange(this, id, value);
            }
        }
    }

    private void synchronizeCarriedToRemote() {
        if (!this.suppressRemoteUpdates && !net.minecraft.world.item.ItemStack.matches(this.getCarried(), this.remoteCarried)) {
            this.remoteCarried = this.getCarried().copy();
            if (this.synchronizer != null) {
                this.synchronizer.sendCarriedChange(this, this.remoteCarried);
            }
        }
    }

    public void setRemoteSlot(int slot, net.minecraft.world.item.ItemStack stack) {
        this.remoteSlots.set(slot, stack.copy());
    }

    public void setRemoteSlotNoCopy(int slot, net.minecraft.world.item.ItemStack stack) {
        if (slot >= 0 && slot < this.remoteSlots.size()) {
            this.remoteSlots.set(slot, stack);
        } else {
            LOGGER.debug("Incorrect slot index: {} available slots: {}", (Object)slot, (Object)this.remoteSlots.size());
        }
    }

    public void setRemoteCarried(net.minecraft.world.item.ItemStack stack) {
        this.remoteCarried = stack.copy();
    }

    public boolean clickMenuButton(Player player, int id) {
        return false;
    }

    public Slot getSlot(int index) {
        return this.slots.get(index);
    }

    public abstract net.minecraft.world.item.ItemStack quickMoveStack(Player var1, int var2);

    public void clicked(int slotIndex, int button, ClickType actionType, Player player) {
        try {
            this.doClick(slotIndex, button, actionType, player);
        }
        catch (Exception exception) {
            CrashReport crashreport = CrashReport.forThrowable(exception, "Container click");
            CrashReportCategory crashreportsystemdetails = crashreport.addCategory("Click info");
            crashreportsystemdetails.setDetail("Menu Type", () -> this.menuType != null ? BuiltInRegistries.MENU.getKey(this.menuType).toString() : "<no type>");
            crashreportsystemdetails.setDetail("Menu Class", () -> this.getClass().getCanonicalName());
            crashreportsystemdetails.setDetail("Slot Count", this.slots.size());
            crashreportsystemdetails.setDetail("Slot", slotIndex);
            crashreportsystemdetails.setDetail("Button", button);
            crashreportsystemdetails.setDetail("Type", (Object)actionType);
            throw new ReportedException(crashreport);
        }
    }

    private void doClick(int slotIndex, int button, ClickType actionType, Player player) {
        block46: {
            block58: {
                block54: {
                    net.minecraft.world.item.ItemStack itemstack;
                    Slot slot;
                    net.minecraft.world.item.ItemStack itemstack42;
                    Inventory playerinventory;
                    block57: {
                        block56: {
                            block55: {
                                block51: {
                                    ClickAction clickaction;
                                    block53: {
                                        block52: {
                                            block50: {
                                                block44: {
                                                    block49: {
                                                        net.minecraft.world.item.ItemStack itemstack2;
                                                        block48: {
                                                            block47: {
                                                                block45: {
                                                                    playerinventory = player.getInventory();
                                                                    if (!this.doClickCheck(slotIndex, button, actionType, player)) {
                                                                        return;
                                                                    }
                                                                    if (actionType != ClickType.QUICK_CRAFT) break block44;
                                                                    int i1 = this.quickcraftStatus;
                                                                    this.quickcraftStatus = AbstractContainerMenu.getQuickcraftHeader(button);
                                                                    if (i1 == 1 && this.quickcraftStatus == 2 || i1 == this.quickcraftStatus) break block45;
                                                                    this.resetQuickCraft();
                                                                    break block46;
                                                                }
                                                                if (!this.getCarried().isEmpty()) break block47;
                                                                this.resetQuickCraft();
                                                                break block46;
                                                            }
                                                            if (this.quickcraftStatus != 0) break block48;
                                                            this.quickcraftType = AbstractContainerMenu.getQuickcraftType(button);
                                                            if (AbstractContainerMenu.isValidQuickcraftType(this.quickcraftType, player)) {
                                                                this.quickcraftStatus = 1;
                                                                this.quickcraftSlots.clear();
                                                            } else {
                                                                this.resetQuickCraft();
                                                            }
                                                            break block46;
                                                        }
                                                        if (this.quickcraftStatus != 1) break block49;
                                                        if (slotIndex < 0) {
                                                            return;
                                                        }
                                                        Slot slot2 = this.slots.get(slotIndex);
                                                        if (!AbstractContainerMenu.canItemQuickReplace(slot2, itemstack2 = this.getCarried(), true) || !slot2.mayPlace(itemstack2) || this.quickcraftType != 2 && itemstack2.getCount() <= this.quickcraftSlots.size() || !this.canDragTo(slot2)) break block46;
                                                        this.quickcraftSlots.add(slot2);
                                                        break block46;
                                                    }
                                                    if (this.quickcraftStatus == 2) {
                                                        if (!this.quickcraftSlots.isEmpty()) {
                                                            boolean needsUpdate;
                                                            net.minecraft.world.item.ItemStack itemstack1 = this.getCarried().copy();
                                                            if (itemstack1.isEmpty()) {
                                                                this.resetQuickCraft();
                                                                return;
                                                            }
                                                            int l = this.getCarried().getCount();
                                                            Iterator<Slot> iterator = this.quickcraftSlots.iterator();
                                                            HashMap<Integer, net.minecraft.world.item.ItemStack> draggedSlots = new HashMap<Integer, net.minecraft.world.item.ItemStack>();
                                                            while (iterator.hasNext()) {
                                                                Slot slot1 = iterator.next();
                                                                net.minecraft.world.item.ItemStack itemstack2 = this.getCarried();
                                                                if (slot1 == null || !AbstractContainerMenu.canItemQuickReplace(slot1, itemstack2, true) || !slot1.mayPlace(itemstack2) || this.quickcraftType != 2 && itemstack2.getCount() < this.quickcraftSlots.size() || !this.canDragTo(slot1)) continue;
                                                                int j1 = slot1.hasItem() ? slot1.getItem().getCount() : 0;
                                                                int k1 = Math.min(ShulkerBoxUtils.getItemStackMaxCount(itemstack1), slot1.getMaxStackSize(itemstack1));
                                                                int l1 = Math.min(AbstractContainerMenu.getQuickCraftPlaceCount(this.quickcraftSlots, this.quickcraftType, itemstack1) + j1, k1);
                                                                l -= l1 - j1;
                                                                draggedSlots.put(slot1.index, itemstack1.copyWithCount(l1));
                                                            }
                                                            InventoryView view = this.getBukkitView();
                                                            CraftItemStack newcursor = CraftItemStack.asCraftMirror(itemstack1);
                                                            newcursor.setAmount(l);
                                                            HashMap<Integer, ItemStack> eventmap = new HashMap<Integer, ItemStack>();
                                                            for (Map.Entry ditem : draggedSlots.entrySet()) {
                                                                eventmap.put((Integer)ditem.getKey(), CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)ditem.getValue()));
                                                            }
                                                            net.minecraft.world.item.ItemStack oldCursor = this.getCarried();
                                                            this.setCarried(CraftItemStack.asNMSCopy(newcursor));
                                                            InventoryDragEvent event = new InventoryDragEvent(view, (ItemStack)(newcursor.getType() != Material.AIR ? newcursor : null), CraftItemStack.asBukkitCopy(oldCursor), this.quickcraftType == 1, eventmap);
                                                            player.level().getCraftServer().getPluginManager().callEvent((Event)event);
                                                            boolean bl = needsUpdate = event.getResult() != Event.Result.DEFAULT;
                                                            if (event.getResult() != Event.Result.DENY) {
                                                                for (Map.Entry dslot : draggedSlots.entrySet()) {
                                                                    view.setItem(((Integer)dslot.getKey()).intValue(), CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)dslot.getValue()));
                                                                }
                                                                if (this.getCarried() != null) {
                                                                    this.setCarried(CraftItemStack.asNMSCopy(event.getCursor()));
                                                                    needsUpdate = true;
                                                                }
                                                            } else {
                                                                this.setCarried(oldCursor);
                                                            }
                                                            if (needsUpdate && player instanceof ServerPlayer) {
                                                                this.sendAllDataToRemote();
                                                            }
                                                        }
                                                        this.resetQuickCraft();
                                                    } else {
                                                        this.resetQuickCraft();
                                                    }
                                                    break block46;
                                                }
                                                if (this.quickcraftStatus == 0) break block50;
                                                this.resetQuickCraft();
                                                break block46;
                                            }
                                            if (actionType != ClickType.PICKUP && actionType != ClickType.QUICK_MOVE || button != 0 && button != 1) break block51;
                                            ClickAction clickAction = clickaction = button == 0 ? ClickAction.PRIMARY : ClickAction.SECONDARY;
                                            if (slotIndex != -999) break block52;
                                            if (this.getCarried().isEmpty()) break block46;
                                            if (clickaction == ClickAction.PRIMARY) {
                                                net.minecraft.world.item.ItemStack carried = this.getCarried();
                                                this.setCarried(net.minecraft.world.item.ItemStack.EMPTY);
                                                player.drop(carried, true);
                                            } else {
                                                player.drop(this.getCarried().split(1), true);
                                            }
                                            break block46;
                                        }
                                        if (actionType != ClickType.QUICK_MOVE) break block53;
                                        if (slotIndex < 0) {
                                            return;
                                        }
                                        Slot slot3 = this.slots.get(slotIndex);
                                        if (!slot3.mayPickup(player)) {
                                            return;
                                        }
                                        net.minecraft.world.item.ItemStack itemstack3 = this.quickMoveStack(player, slotIndex);
                                        while (!itemstack3.isEmpty() && net.minecraft.world.item.ItemStack.isSameItem(slot3.getItem(), itemstack3)) {
                                            itemstack3 = this.quickMoveStack(player, slotIndex);
                                        }
                                        break block46;
                                    }
                                    if (slotIndex < 0) {
                                        return;
                                    }
                                    Slot slot4 = this.slots.get(slotIndex);
                                    net.minecraft.world.item.ItemStack itemstack5 = slot4.getItem();
                                    net.minecraft.world.item.ItemStack itemstack3 = this.getCarried();
                                    player.updateTutorialInventoryAction(itemstack3, slot4.getItem(), clickaction);
                                    if (!this.tryItemClickBehaviourOverride(player, clickaction, slot4, itemstack5, itemstack3)) {
                                        if (itemstack5.isEmpty()) {
                                            if (!itemstack3.isEmpty()) {
                                                int i2 = clickaction == ClickAction.PRIMARY ? itemstack3.getCount() : 1;
                                                this.setCarried(slot4.safeInsert(itemstack3, i2));
                                            }
                                        } else if (slot4.mayPickup(player)) {
                                            if (itemstack3.isEmpty()) {
                                                int i2 = clickaction == ClickAction.PRIMARY ? itemstack5.getCount() : (itemstack5.getCount() + 1) / 2;
                                                Optional<net.minecraft.world.item.ItemStack> optional = slot4.tryRemove(i2, Integer.MAX_VALUE, player);
                                                optional.ifPresent(itemstack4 -> {
                                                    this.setCarried((net.minecraft.world.item.ItemStack)itemstack4);
                                                    slot4.onTake(player, (net.minecraft.world.item.ItemStack)itemstack4);
                                                });
                                            } else if (slot4.mayPlace(itemstack3)) {
                                                if (net.minecraft.world.item.ItemStack.isSameItemSameComponents(itemstack5, itemstack3)) {
                                                    int i2 = clickaction == ClickAction.PRIMARY ? itemstack3.getCount() : 1;
                                                    this.setCarried(slot4.safeInsert(itemstack3, i2));
                                                } else if (itemstack3.getCount() <= slot4.getMaxStackSize(itemstack3)) {
                                                    this.setCarried(itemstack5);
                                                    slot4.setByPlayer(itemstack3);
                                                }
                                            } else if (net.minecraft.world.item.ItemStack.isSameItemSameComponents(itemstack5, itemstack3)) {
                                                Optional<net.minecraft.world.item.ItemStack> optional1 = slot4.tryRemove(itemstack5.getCount(), ShulkerBoxUtils.getItemStackMaxCount(itemstack3) - itemstack3.getCount(), player);
                                                optional1.ifPresent(itemstack4 -> {
                                                    itemstack3.grow(itemstack4.getCount());
                                                    slot4.onTake(player, (net.minecraft.world.item.ItemStack)itemstack4);
                                                });
                                            }
                                        }
                                    }
                                    slot4.setChanged();
                                    if (!(player instanceof ServerPlayer) || slot4.getMaxStackSize() == 64) break block46;
                                    ((ServerPlayer)player).connection.send(new ClientboundContainerSetSlotPacket(this.containerId, this.incrementStateId(), slot4.index, slot4.getItem()));
                                    if (this.getBukkitView().getType() == InventoryType.WORKBENCH || this.getBukkitView().getType() == InventoryType.CRAFTING) {
                                        ((ServerPlayer)player).connection.send(new ClientboundContainerSetSlotPacket(this.containerId, this.incrementStateId(), 0, this.getSlot(0).getItem()));
                                    }
                                    break block46;
                                }
                                if (actionType != ClickType.SWAP || (button < 0 || button >= 9) && button != 40) break block54;
                                if (slotIndex < 0) {
                                    return;
                                }
                                itemstack42 = playerinventory.getItem(button);
                                slot = this.slots.get(slotIndex);
                                itemstack = slot.getItem();
                                if (itemstack42.isEmpty() && itemstack.isEmpty()) break block46;
                                if (!itemstack42.isEmpty()) break block55;
                                if (!slot.mayPickup(player)) break block46;
                                playerinventory.setItem(button, itemstack);
                                slot.onSwapCraft(itemstack.getCount());
                                slot.setByPlayer(net.minecraft.world.item.ItemStack.EMPTY);
                                slot.onTake(player, itemstack);
                                break block46;
                            }
                            if (!itemstack.isEmpty()) break block56;
                            if (!slot.mayPlace(itemstack42)) break block46;
                            int j2 = slot.getMaxStackSize(itemstack42);
                            if (itemstack42.getCount() > j2) {
                                slot.setByPlayer(itemstack42.split(j2));
                            } else {
                                playerinventory.setItem(button, net.minecraft.world.item.ItemStack.EMPTY);
                                slot.setByPlayer(itemstack42);
                            }
                            break block46;
                        }
                        if (!slot.mayPickup(player) || !slot.mayPlace(itemstack42)) break block46;
                        int j2 = slot.getMaxStackSize(itemstack42);
                        if (itemstack42.getCount() <= j2) break block57;
                        slot.setByPlayer(itemstack42.split(j2));
                        slot.onTake(player, itemstack);
                        if (playerinventory.add(itemstack)) break block46;
                        player.drop(itemstack, true);
                        break block46;
                    }
                    playerinventory.setItem(button, itemstack);
                    slot.setByPlayer(itemstack42);
                    slot.onTake(player, itemstack);
                    break block46;
                }
                if (actionType != ClickType.CLONE || !player.hasInfiniteMaterials() || !this.getCarried().isEmpty() || slotIndex < 0) break block58;
                Slot slot2 = this.slots.get(slotIndex);
                if (!slot2.hasItem()) break block46;
                net.minecraft.world.item.ItemStack itemstack1 = slot2.getItem();
                this.setCarried(itemstack1.copyWithCount(ShulkerBoxUtils.getItemStackMaxCount(itemstack1)));
                break block46;
            }
            if (actionType == ClickType.THROW && this.getCarried().isEmpty() && slotIndex >= 0) {
                Slot slot2 = this.slots.get(slotIndex);
                int k = button == 0 ? 1 : slot2.getItem().getCount();
                net.minecraft.world.item.ItemStack itemstack = slot2.safeTake(k, Integer.MAX_VALUE, player);
                player.drop(itemstack, true);
            } else if (actionType == ClickType.PICKUP_ALL && slotIndex >= 0) {
                Slot slot2 = this.slots.get(slotIndex);
                net.minecraft.world.item.ItemStack itemstack1 = this.getCarried();
                if (!(itemstack1.isEmpty() || slot2.hasItem() && slot2.mayPickup(player))) {
                    int l = button == 0 ? 0 : this.slots.size() - 1;
                    int j2 = button == 0 ? 1 : -1;
                    for (int i2 = 0; i2 < 2; ++i2) {
                        for (int k2 = l; k2 >= 0 && k2 < this.slots.size() && itemstack1.getCount() < ShulkerBoxUtils.getItemStackMaxCount(itemstack1); k2 += j2) {
                            Slot slot3 = this.slots.get(k2);
                            if (!slot3.hasItem() || !AbstractContainerMenu.canItemQuickReplace(slot3, itemstack1, true) || !slot3.mayPickup(player) || !this.canTakeItemForPickAll(itemstack1, slot3)) continue;
                            net.minecraft.world.item.ItemStack itemstack5 = slot3.getItem();
                            if (i2 == 0 && itemstack5.getCount() == ShulkerBoxUtils.getItemStackMaxCount(itemstack5)) continue;
                            net.minecraft.world.item.ItemStack itemstack6 = slot3.safeTake(itemstack5.getCount(), itemstack1.getMaxStackSize() - itemstack1.getCount(), player);
                            itemstack1.grow(itemstack6.getCount());
                        }
                    }
                }
            }
        }
    }

    private boolean doClickCheck(int slotIndex, int button, ClickType actionType, Player player) {
        if (slotIndex < 0) {
            return true;
        }
        Slot slot = this.getSlot(slotIndex);
        net.minecraft.world.item.ItemStack itemStack = slot.getItem();
        CustomData customData = itemStack.get(DataComponents.CUSTOM_DATA);
        if (customData != null && customData.contains("Leaves.Gui.Placeholder")) {
            return !customData.copyTag().getBoolean("Leaves.Gui.Placeholder");
        }
        return true;
    }

    private boolean tryItemClickBehaviourOverride(Player player, ClickAction clickType, Slot slot, net.minecraft.world.item.ItemStack stack, net.minecraft.world.item.ItemStack cursorStack) {
        FeatureFlagSet featureflagset = player.level().enabledFeatures();
        return cursorStack.isItemEnabled(featureflagset) && cursorStack.overrideStackedOnOther(slot, clickType, player) ? true : stack.isItemEnabled(featureflagset) && stack.overrideOtherStackedOnMe(cursorStack, slot, clickType, player, this.createCarriedSlotAccess());
    }

    private SlotAccess createCarriedSlotAccess() {
        return new SlotAccess(){

            @Override
            public net.minecraft.world.item.ItemStack get() {
                return AbstractContainerMenu.this.getCarried();
            }

            @Override
            public boolean set(net.minecraft.world.item.ItemStack stack) {
                AbstractContainerMenu.this.setCarried(stack);
                return true;
            }
        };
    }

    public boolean canTakeItemForPickAll(net.minecraft.world.item.ItemStack stack, Slot slot) {
        return true;
    }

    public void removed(Player player) {
        net.minecraft.world.item.ItemStack itemstack;
        if (player instanceof ServerPlayer && !(itemstack = this.getCarried()).isEmpty()) {
            this.setCarried(net.minecraft.world.item.ItemStack.EMPTY);
            if (player.isAlive() && !((ServerPlayer)player).hasDisconnected()) {
                player.getInventory().placeItemBackInInventory(itemstack);
            } else {
                player.drop(itemstack, false);
            }
        }
    }

    protected void clearContainer(Player player, Container inventory) {
        if (!(!player.isAlive() || player instanceof ServerPlayer && ((ServerPlayer)player).hasDisconnected())) {
            for (int i = 0; i < inventory.getContainerSize(); ++i) {
                Inventory playerinventory = player.getInventory();
                if (!(playerinventory.player instanceof ServerPlayer)) continue;
                playerinventory.placeItemBackInInventory(inventory.removeItemNoUpdate(i));
            }
        } else {
            for (int i = 0; i < inventory.getContainerSize(); ++i) {
                player.drop(inventory.removeItemNoUpdate(i), false);
            }
        }
    }

    public void slotsChanged(Container inventory) {
        this.broadcastChanges();
    }

    public void setItem(int slot, int revision, net.minecraft.world.item.ItemStack stack) {
        this.getSlot(slot).set(stack);
        this.stateId = revision;
    }

    public void initializeContents(int revision, List<net.minecraft.world.item.ItemStack> stacks, net.minecraft.world.item.ItemStack cursorStack) {
        for (int j = 0; j < stacks.size(); ++j) {
            this.getSlot(j).set(stacks.get(j));
        }
        this.carried = cursorStack;
        this.stateId = revision;
    }

    public void setData(int id, int value) {
        this.dataSlots.get(id).set(value);
    }

    public abstract boolean stillValid(Player var1);

    protected boolean moveItemStackTo(net.minecraft.world.item.ItemStack stack, int startIndex, int endIndex, boolean fromLast) {
        return this.moveItemStackTo(stack, startIndex, endIndex, fromLast, false);
    }

    protected boolean moveItemStackTo(net.minecraft.world.item.ItemStack stack, int startIndex, int endIndex, boolean fromLast, boolean isCheck) {
        int l;
        net.minecraft.world.item.ItemStack itemstack1;
        Slot slot;
        if (isCheck) {
            stack = stack.copy();
        }
        boolean flag1 = false;
        int k = startIndex;
        if (fromLast) {
            k = endIndex - 1;
        }
        if (ShulkerBoxUtils.isStackable(stack)) {
            while (!stack.isEmpty() && !(fromLast ? k < startIndex : k >= endIndex)) {
                slot = this.slots.get(k);
                itemstack1 = slot.getItem();
                if (isCheck) {
                    itemstack1 = itemstack1.copy();
                }
                if (!itemstack1.isEmpty() && net.minecraft.world.item.ItemStack.isSameItemSameComponents(stack, itemstack1)) {
                    int i1;
                    l = itemstack1.getCount() + stack.getCount();
                    if (l <= (i1 = ShulkerBoxUtils.getItemStackMaxCount(itemstack1))) {
                        stack.setCount(0);
                        itemstack1.setCount(l);
                        if (!isCheck) {
                            slot.setChanged();
                        }
                        flag1 = true;
                    } else if (itemstack1.getCount() < i1) {
                        stack.shrink(i1 - itemstack1.getCount());
                        itemstack1.setCount(i1);
                        if (!isCheck) {
                            slot.setChanged();
                        }
                        flag1 = true;
                    }
                }
                if (fromLast) {
                    --k;
                    continue;
                }
                ++k;
            }
        }
        if (!stack.isEmpty()) {
            k = fromLast ? endIndex - 1 : startIndex;
            while (!(fromLast ? k < startIndex : k >= endIndex)) {
                slot = this.slots.get(k);
                itemstack1 = slot.getItem();
                if (isCheck) {
                    itemstack1 = itemstack1.copy();
                }
                if (itemstack1.isEmpty() && slot.mayPlace(stack)) {
                    l = slot.getMaxStackSize(stack);
                    if (isCheck) {
                        stack.shrink(Math.min(stack.getCount(), l));
                    } else {
                        slot.setByPlayer(stack.split(Math.min(stack.getCount(), l)));
                        slot.setChanged();
                    }
                    flag1 = true;
                    break;
                }
                if (fromLast) {
                    --k;
                    continue;
                }
                ++k;
            }
        }
        return flag1;
    }

    public static int getQuickcraftType(int quickCraftData) {
        return quickCraftData >> 2 & 3;
    }

    public static int getQuickcraftHeader(int quickCraftData) {
        return quickCraftData & 3;
    }

    public static int getQuickcraftMask(int quickCraftStage, int buttonId) {
        return quickCraftStage & 3 | (buttonId & 3) << 2;
    }

    public static boolean isValidQuickcraftType(int stage, Player player) {
        return stage == 0 ? true : (stage == 1 ? true : stage == 2 && player.hasInfiniteMaterials());
    }

    protected void resetQuickCraft() {
        this.quickcraftStatus = 0;
        this.quickcraftSlots.clear();
    }

    public static boolean canItemQuickReplace(@Nullable Slot slot, net.minecraft.world.item.ItemStack stack, boolean allowOverflow) {
        boolean flag1;
        boolean bl = flag1 = slot == null || !slot.hasItem();
        return !flag1 && net.minecraft.world.item.ItemStack.isSameItemSameComponents(stack, slot.getItem()) ? slot.getItem().getCount() + (allowOverflow ? 0 : stack.getCount()) <= stack.getMaxStackSize() : flag1;
    }

    public static int getQuickCraftPlaceCount(Set<Slot> slots, int mode, net.minecraft.world.item.ItemStack stack) {
        return switch (mode) {
            case 0 -> Mth.floor((float)stack.getCount() / (float)slots.size());
            case 1 -> 1;
            case 2 -> stack.getMaxStackSize();
            default -> stack.getCount();
        };
    }

    public boolean canDragTo(Slot slot) {
        return true;
    }

    public static int getRedstoneSignalFromBlockEntity(@Nullable BlockEntity entity) {
        return entity instanceof Container ? AbstractContainerMenu.getRedstoneSignalFromContainer((Container)((Object)entity)) : 0;
    }

    public static int getRedstoneSignalFromContainer(@Nullable Container inventory) {
        if (inventory == null) {
            return 0;
        }
        float f = 0.0f;
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            net.minecraft.world.item.ItemStack itemstack = inventory.getItem(i);
            if (itemstack.isEmpty()) continue;
            f += (float)itemstack.getCount() / (float)inventory.getMaxStackSize(itemstack);
        }
        return Mth.lerpDiscrete(f /= (float)inventory.getContainerSize(), 0, 15);
    }

    public void setCarried(net.minecraft.world.item.ItemStack stack) {
        this.carried = stack;
    }

    public net.minecraft.world.item.ItemStack getCarried() {
        if (this.carried.isEmpty()) {
            this.setCarried(net.minecraft.world.item.ItemStack.EMPTY);
        }
        return this.carried;
    }

    public void suppressRemoteUpdates() {
        this.suppressRemoteUpdates = true;
    }

    public void resumeRemoteUpdates() {
        this.suppressRemoteUpdates = false;
    }

    public void transferState(AbstractContainerMenu handler) {
        Slot slot;
        int i;
        HashBasedTable table = HashBasedTable.create();
        for (i = 0; i < handler.slots.size(); ++i) {
            slot = handler.slots.get(i);
            table.put((Object)slot.container, (Object)slot.getContainerSlot(), (Object)i);
        }
        for (i = 0; i < this.slots.size(); ++i) {
            slot = this.slots.get(i);
            Integer integer = (Integer)table.get((Object)slot.container, (Object)slot.getContainerSlot());
            if (integer == null) continue;
            this.lastSlots.set(i, handler.lastSlots.get(integer));
            this.remoteSlots.set(i, handler.remoteSlots.get(integer));
        }
    }

    public OptionalInt findSlot(Container inventory, int index) {
        for (int j = 0; j < this.slots.size(); ++j) {
            Slot slot = this.slots.get(j);
            if (slot.container != inventory || index != slot.getContainerSlot()) continue;
            return OptionalInt.of(j);
        }
        return OptionalInt.empty();
    }

    public int getStateId() {
        return this.stateId;
    }

    public int incrementStateId() {
        this.stateId = this.stateId + 1 & Short.MAX_VALUE;
        return this.stateId;
    }

    protected final Supplier<BlockInventoryHolder> createBlockHolder(ContainerLevelAccess context) {
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)"context was null");
        return () -> context.createBlockHolder(this);
    }
}

