/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.inventory.CraftBlockInventoryHolder;
import org.bukkit.inventory.BlockInventoryHolder;
import org.jetbrains.annotations.Nullable;

public interface ContainerLevelAccess {
    public static final ContainerLevelAccess NULL = new ContainerLevelAccess(){

        @Override
        public <T> Optional<T> evaluate(BiFunction<Level, BlockPos, T> getter) {
            return Optional.empty();
        }

        @Override
        public Location getLocation() {
            return null;
        }
    };

    default public Level getWorld() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    default public BlockPos getPosition() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    default public Location getLocation() {
        return new Location((World)this.getWorld().getWorld(), (double)this.getPosition().getX(), (double)this.getPosition().getY(), (double)this.getPosition().getZ());
    }

    default public boolean isBlock() {
        return false;
    }

    default public @Nullable BlockInventoryHolder createBlockHolder(AbstractContainerMenu menu) {
        if (!this.isBlock()) {
            return null;
        }
        return new CraftBlockInventoryHolder(this, menu.getBukkitView().getTopInventory());
    }

    public static ContainerLevelAccess create(final Level world, final BlockPos pos) {
        return new ContainerLevelAccess(){

            @Override
            public Level getWorld() {
                return world;
            }

            @Override
            public BlockPos getPosition() {
                return pos;
            }

            @Override
            public boolean isBlock() {
                return true;
            }

            @Override
            public <T> Optional<T> evaluate(BiFunction<Level, BlockPos, T> getter) {
                return Optional.of(getter.apply(world, pos));
            }
        };
    }

    public <T> Optional<T> evaluate(BiFunction<Level, BlockPos, T> var1);

    default public <T> T evaluate(BiFunction<Level, BlockPos, T> getter, T defaultValue) {
        return this.evaluate(getter).orElse(defaultValue);
    }

    default public void execute(BiConsumer<Level, BlockPos> function) {
        this.evaluate((world, blockposition) -> {
            function.accept((Level)world, (BlockPos)blockposition);
            return Optional.empty();
        });
    }
}

