/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.PlaceOnWaterBlockItem;
import net.minecraft.world.item.SolidBucketItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.BlockItemStateProperties;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.apache.logging.log4j.LogManager;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.CraftEquipmentSlot;
import org.bukkit.craftbukkit.block.CraftBlock;
import org.bukkit.craftbukkit.block.CraftBlockState;
import org.bukkit.craftbukkit.block.CraftBlockStates;
import org.bukkit.craftbukkit.block.data.CraftBlockData;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockCanBuildEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.leavesmc.leaves.LeavesConfig;
import org.leavesmc.leaves.event.player.PlayerOperationLimitEvent;

public class BlockItem
extends Item {
    @Deprecated
    private final Block block;

    public BlockItem(Block block, Item.Properties settings) {
        super(settings);
        this.block = block;
    }

    @Override
    public InteractionResult useOn(UseOnContext context) {
        InteractionResult enuminteractionresult = this.place(new BlockPlaceContext(context));
        if (!enuminteractionresult.consumesAction() && context.getItemInHand().has(DataComponents.FOOD)) {
            InteractionResult enuminteractionresult1 = super.use(context.getLevel(), context.getPlayer(), context.getHand()).getResult();
            return enuminteractionresult1 == InteractionResult.CONSUME ? InteractionResult.CONSUME_PARTIAL : enuminteractionresult1;
        }
        return enuminteractionresult;
    }

    public InteractionResult place(BlockPlaceContext context) {
        ServerPlayer player;
        CraftBlockState oldBlockstate;
        if (!this.getBlock().isEnabled(context.getLevel().enabledFeatures())) {
            return InteractionResult.FAIL;
        }
        if (!context.canPlace()) {
            return InteractionResult.FAIL;
        }
        BlockPlaceContext blockactioncontext1 = this.updatePlacementContext(context);
        if (blockactioncontext1 == null) {
            return InteractionResult.FAIL;
        }
        BlockState iblockdata = this.getPlacementState(blockactioncontext1);
        CraftBlockState blockstate = null;
        if (this instanceof PlaceOnWaterBlockItem || this instanceof SolidBucketItem) {
            blockstate = CraftBlockStates.getBlockState(blockactioncontext1.getLevel(), blockactioncontext1.getClickedPos());
        }
        CraftBlockState craftBlockState = oldBlockstate = blockstate != null ? blockstate : CraftBlockStates.getBlockState(blockactioncontext1.getLevel(), blockactioncontext1.getClickedPos());
        if (LeavesConfig.playerOperationLimiter && !context.getLevel().isClientSide() && (player = (ServerPlayer)context.getPlayer()) != null && iblockdata != null) {
            player.addPlaceBlockCountPerTick();
            if (!player.allowOperation()) {
                if (blockstate != null) {
                    MinecraftServer.getServer().server.getPluginManager().callEvent((Event)new PlayerOperationLimitEvent((org.bukkit.entity.Player)player.getBukkitEntity(), PlayerOperationLimitEvent.Operation.PLACE, blockstate.getBlock()));
                }
                return InteractionResult.FAIL;
            }
        }
        if (iblockdata == null) {
            return InteractionResult.FAIL;
        }
        if (!this.placeBlock(blockactioncontext1, iblockdata)) {
            return InteractionResult.FAIL;
        }
        BlockPos blockposition = blockactioncontext1.getClickedPos();
        Level world = blockactioncontext1.getLevel();
        Player entityhuman = blockactioncontext1.getPlayer();
        ItemStack itemstack = blockactioncontext1.getItemInHand();
        BlockState iblockdata1 = world.getBlockState(blockposition);
        if (iblockdata1.is(iblockdata.getBlock())) {
            BlockPlaceEvent placeEvent;
            iblockdata1 = this.updateBlockStateFromTag(blockposition, world, itemstack, iblockdata1);
            try {
                this.updateCustomBlockEntityTag(blockposition, world, entityhuman, itemstack, iblockdata1);
                BlockItem.updateBlockEntityComponents(world, blockposition, itemstack);
            }
            catch (Exception e) {
                oldBlockstate.update(true, false);
                if (entityhuman instanceof ServerPlayer) {
                    ServerPlayer player2 = (ServerPlayer)entityhuman;
                    LogManager.getLogger().error("Player {} tried placing invalid block", (Object)player2.getScoreboardName(), (Object)e);
                    player2.getBukkitEntity().kickPlayer("Packet processing error");
                    return InteractionResult.FAIL;
                }
                throw e;
            }
            iblockdata1.getBlock().setPlacedBy(world, blockposition, iblockdata1, entityhuman, itemstack);
            if (blockstate != null && (placeEvent = CraftEventFactory.callBlockPlaceEvent((ServerLevel)world, entityhuman, blockactioncontext1.getHand(), blockstate, blockposition.getX(), blockposition.getY(), blockposition.getZ())) != null && (placeEvent.isCancelled() || !placeEvent.canBuild())) {
                blockstate.update(true, false);
                ((ServerPlayer)entityhuman).getBukkitEntity().updateInventory();
                return InteractionResult.FAIL;
            }
            if (entityhuman instanceof ServerPlayer) {
                CriteriaTriggers.PLACED_BLOCK.trigger((ServerPlayer)entityhuman, blockposition, itemstack);
            }
        }
        SoundType soundeffecttype = iblockdata1.getSoundType();
        if (entityhuman == null) {
            world.playSound(entityhuman, blockposition, this.getPlaceSound(iblockdata1), SoundSource.BLOCKS, (soundeffecttype.getVolume() + 1.0f) / 2.0f, soundeffecttype.getPitch() * 0.8f);
        }
        world.gameEvent(GameEvent.BLOCK_PLACE, blockposition, GameEvent.Context.of(entityhuman, iblockdata1));
        itemstack.consume(1, entityhuman);
        return InteractionResult.sidedSuccess(world.isClientSide);
    }

    protected SoundEvent getPlaceSound(BlockState state) {
        return state.getSoundType().getPlaceSound();
    }

    @Nullable
    public BlockPlaceContext updatePlacementContext(BlockPlaceContext context) {
        return context;
    }

    private static void updateBlockEntityComponents(Level world, BlockPos pos, ItemStack stack) {
        BlockEntity tileentity = world.getBlockEntity(pos);
        if (tileentity != null) {
            tileentity.applyComponentsFromItemStack(stack);
            tileentity.setChanged();
        }
    }

    protected boolean updateCustomBlockEntityTag(BlockPos pos, Level world, @Nullable Player player, ItemStack stack, BlockState state) {
        return BlockItem.updateCustomBlockEntityTag(world, player, pos, stack);
    }

    @Nullable
    protected BlockState getPlacementState(BlockPlaceContext context) {
        BlockState iblockdata = this.getBlock().getRealStateForPlacement(context);
        return iblockdata != null && this.canPlace(context, iblockdata) ? iblockdata : null;
    }

    private BlockState updateBlockStateFromTag(BlockPos pos, Level world, ItemStack stack, BlockState state) {
        BlockItemStateProperties blockitemstateproperties = stack.getOrDefault(DataComponents.BLOCK_STATE, BlockItemStateProperties.EMPTY);
        if (blockitemstateproperties.isEmpty()) {
            return state;
        }
        BlockState iblockdata1 = blockitemstateproperties.apply(state);
        if (iblockdata1 != state) {
            world.setBlock(pos, iblockdata1, 2);
        }
        return iblockdata1;
    }

    protected boolean canPlace(BlockPlaceContext context, BlockState state) {
        Player entityhuman = context.getPlayer();
        CollisionContext voxelshapecollision = entityhuman == null ? CollisionContext.empty() : CollisionContext.of(entityhuman);
        Level world = context.getLevel();
        boolean defaultReturn = (!this.mustSurvive() || state.canSurvive(context.getLevel(), context.getClickedPos())) && (LeavesConfig.creativeNoClip && context.getPlayer() != null ? context.getPlayer().canSpectatingPlace(world, state, context.getClickedPos(), voxelshapecollision) : world.checkEntityCollision(state, entityhuman, voxelshapecollision, context.getClickedPos(), true));
        org.bukkit.entity.Player player = context.getPlayer() instanceof ServerPlayer ? (org.bukkit.entity.Player)context.getPlayer().getBukkitEntity() : null;
        BlockCanBuildEvent event = new BlockCanBuildEvent((org.bukkit.block.Block)CraftBlock.at(context.getLevel(), context.getClickedPos()), player, (BlockData)CraftBlockData.fromData(state), defaultReturn, CraftEquipmentSlot.getHand(context.getHand()));
        context.getLevel().getCraftServer().getPluginManager().callEvent((Event)event);
        return event.isBuildable();
    }

    protected boolean mustSurvive() {
        return true;
    }

    protected boolean placeBlock(BlockPlaceContext context, BlockState state) {
        return context.getLevel().setBlock(context.getClickedPos(), state, 11);
    }

    public static boolean updateCustomBlockEntityTag(Level world, @Nullable Player player, BlockPos pos, ItemStack stack) {
        BlockEntity tileentity;
        MinecraftServer minecraftserver = world.getServer();
        if (minecraftserver == null) {
            return false;
        }
        CustomData customdata = stack.getOrDefault(DataComponents.BLOCK_ENTITY_DATA, CustomData.EMPTY);
        if (!customdata.isEmpty() && (tileentity = world.getBlockEntity(pos)) != null) {
            if (!(world.isClientSide || !tileentity.onlyOpCanSetNbt() || player != null && (player.canUseGameMasterBlocks() || player.getAbilities().instabuild && player.getBukkitEntity().hasPermission("minecraft.nbt.place")))) {
                return false;
            }
            return customdata.loadInto(tileentity, world.registryAccess());
        }
        return false;
    }

    @Override
    public String getDescriptionId() {
        return this.getBlock().getDescriptionId();
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        this.getBlock().appendHoverText(stack, context, tooltip, type);
    }

    public Block getBlock() {
        return this.block;
    }

    public void registerBlocks(Map<Block, Item> map, Item item) {
        map.put(this.getBlock(), item);
    }

    @Override
    public boolean canFitInsideContainerItems() {
        return !(this.getBlock() instanceof ShulkerBoxBlock);
    }

    @Override
    public void onDestroyed(ItemEntity entity) {
        ItemContainerContents itemcontainercontents = entity.getItem().set(DataComponents.CONTAINER, ItemContainerContents.EMPTY);
        if (itemcontainercontents != null) {
            ItemUtils.onContainerDestroyed(entity, itemcontainercontents.nonEmptyItemsCopy());
        }
    }

    public static void setBlockEntityData(ItemStack stack, BlockEntityType<?> type, CompoundTag nbt) {
        nbt.remove("id");
        if (nbt.isEmpty()) {
            stack.remove(DataComponents.BLOCK_ENTITY_DATA);
        } else {
            BlockEntity.addEntityType(nbt, type);
            stack.set(DataComponents.BLOCK_ENTITY_DATA, CustomData.of(nbt));
        }
    }

    @Override
    public FeatureFlagSet requiredFeatures() {
        return this.getBlock().requiredFeatures();
    }
}

